/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef AVAILGROUPS_H
#define AVAILGROUPS_H

#include <kmdichildview.h>
#include <qmap.h>
#include <klineedit.h>
#include <klistview.h>
#include "globals.h"
#include "addform.h"
#include <qdict.h>

class AvailableGroups;



class Group
{
	friend class AvailableGroups;
	friend class GroupList;
	friend class klibido; //for db migration....I know, I know, it sucks.
	
	QString name;
	QString description;
	bool subscribed;
	QMap<int, int> articles;
	QMap<int, bool> serverPresence;
	char *retrieve(char *, QString&);
	char *insert(QString, char*);
	

	public:
		Group(char*, int version = AVAILABLEGROUPSDB_VERSION);
		Group(QString, QString, int, int);
		char *data();
		int size();
		void addHost(int hostId);
		void setArticles(int hostId, int art) {articles[hostId] = art;}
	

}; 
  
class AvailableGroups : public QObject 
 {
 	Q_OBJECT
	KLineEdit *m_filterEdit;
	KListView *m_groupList;
	KMdiChildView *m_view;
// 	int size(Group*);
	
	QString dbName;
	QWidget *parent;
	Db* groupDb;
	DbEnv *dbEnv;
	Servers *servers;
	bool updating;
	QDict<Group> groupsList;
	Group *g;
	
	int Num_Col;
	
	
	public:
		AvailableGroups(DbEnv * dbenv, Servers *_servers, QWidget* p = 0);
		~AvailableGroups();
		void prepareToClose();
		KMdiChildView *view() {return m_view;};
		void loadGroups();
		bool isUpdating () {return updating;};
		void startUpdating() {updating=true;};
		void stopUpdating() {updating=false;};
		Db *getDb() {return groupDb;};
// 		char *saveGroup(Group *);
// 		Group *loadGroup(char *);
	signals:
		void subscribe(Group *);
	protected slots:
		
		void slotSubscribe(QListViewItem*);
		void slotActivateFilter(const QString&);
	public slots:
		void slotUnsubscribe(QString);
		void slotSubscribed(Group *);
		void slotDeleteServer(int);
		
		
};

#endif
