/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "headerlist.h"
#include <kapplication.h>
#include <kmessagebox.h>
#include <klocale.h>
#include "progress.h"
#include <errno.h>
#include <kprogress.h>
#include <qregexp.h>


NewHeaderList::NewHeaderList(NewsGroup *_ng, Servers *_servers, QString caption, QWidget *parent): KMdiChildView (caption, parent), ng(_ng), servers(_servers) 
{
	showFrom=Config().showFrom;
	showDetails=Config().showDetails;
	showDate=Config().showDate;
	allowExpansion=Config().allowExpansion;
	
	
	QVBoxLayout *layout=new QVBoxLayout(this);
	
	QHBoxLayout *filterLayout=new QHBoxLayout(layout);
// 	layout->addLayout(filterWidget);
	m_clearButton=new QToolButton(this);
	m_clearButton->setIconSet(KGlobal::iconLoader()->loadIcon("locationbar_erase", KIcon::Small, 0, false));
	QLabel *label=new QLabel(this);
	label->setText("Filter by subject:");
	m_enterButton=new QToolButton(this);
	m_enterButton->setIconSet(KGlobal::iconLoader()->loadIcon("key_enter", KIcon::Small, 0, false));
	
	regExpCheck = new QCheckBox("Regular expression", this);
	
	
	filterLayout->addWidget(m_clearButton);
	filterLayout->addWidget(label);
	
	filterLayout->setSpacing(4);
	m_filterEdit=new KLineEdit(this);
	filterLayout->addWidget(m_filterEdit);
	filterLayout->addWidget(regExpCheck);
	filterLayout->addWidget(m_enterButton);
	
	
	m_headerList=new KListView(this);
	layout->addWidget(m_headerList);
	m_headerList->addColumn("Subject");
	m_headerList->addColumn("Parts");
	m_headerList->addColumn("KBytes");
// 	m_headerList->addColumn("Lines");
	if (showFrom)
		m_headerList->addColumn("From");
	if (showDate)
		m_headerList->addColumn("Date");
// 	m_headerList->addColumn("From");
	m_headerList->setAllColumnsShowFocus(true);
	m_headerList->setSelectionMode(QListView::Extended);
	
	m_headerList->setItemMargin(3);
	m_headerList->setSorting(Subj_Col);
	m_headerList->setShowSortIndicator(true);
	if (showDetails) {
		Servers::iterator it;
		for (it=servers->begin(); it != servers->end(); ++it) {
			m_headerList->addColumn(it.data()->name);
		}
	} else servers = NULL;
	setIcon(KGlobal::iconLoader()->loadIcon("icon_newsgroup",KIcon::Small, KIcon::SizeSmall, false));
	loadGroup(ng->getDb() );
// 	m_loadGroup(ng->getDb());
// 	connect(m_filterEdit, SIGNAL(returnPressed(const QString &)), this, SLOT(slotActivateFilter(const QString& )));
	connect(m_filterEdit, SIGNAL(returnPressed()), this, SLOT(slotEnterButtonClicked()));
	connect(m_enterButton, SIGNAL(clicked()), this, SLOT(slotEnterButtonClicked()));
	connect(m_headerList, SIGNAL(contextMenuRequested(QListViewItem *, const QPoint &, int)), this, SLOT(slotContextMenu(QListViewItem*, const QPoint& )));
	connect(m_clearButton, SIGNAL(clicked()), this, SLOT(slotClearButtonClicked()));
	//Check if we override global KDE setting
	if (Config().alwaysDoubleClick)
		connect(m_headerList, SIGNAL(doubleClicked(QListViewItem* )), this, SLOT(slotItemExecuted()));
	else connect(m_headerList, SIGNAL(executed(QListViewItem* )), this, SLOT(slotItemExecuted()));
	
	showOnlyNew=ng->onlyUnread();
	showOnlyComplete=ng->onlyComplete();
	if (showOnlyComplete || showOnlyNew)
		filter(m_filterEdit->text());
	m_headerList->setFocus();
	
}




void NewHeaderList::loadGroup( Db * db )
{
	int ret;
    m_headerList->setSorting(-1);
    m_headerList->clear();
	hiddenItems.clear();


	if (allowExpansion)
		m_headerList->setRootIsDecorated(TRUE);
	else m_headerList->setRootIsDecorated(false);
	
    m_headerList->setUpdatesEnabled(FALSE);
	

    Dbt *binkey, *bindata;
    binkey=new Dbt;
    bindata=new Dbt;
	char *binkeymem=new char[KEYMEM_SIZE];
	char *bindatamem=new char[DATAMEM_SIZE];

    binkey->set_flags(DB_DBT_USERMEM);
    binkey->set_ulen(KEYMEM_SIZE);
    binkey->set_data(binkeymem);

    bindata->set_flags(DB_DBT_USERMEM);
    bindata->set_ulen(DATAMEM_SIZE);
    bindata->set_data(bindatamem);
	
	Dbc *cursor;
// 	BinHeader *bh;
	SmallBinHeader *sbh;
	
	db->cursor(NULL, &cursor, DB_WRITECURSOR);
	int count=0;
	
// 	Progress *pd= new Progress(ng->getName(), this);
// 	pd->show();
	
	KProgressDialog *kpd = new KProgressDialog(this , NULL, ng->getName(), i18n("Loading %1...").arg(ng->getName()), true);
	kpd->showCancelButton(false);
	kpd->setAllowCancel(false);
	kpd->setMinimumDuration(1500);
	kpd->show();
	
	QTime current, previous;
	QDateTime hDate;
	QDateTime cDate = QDateTime::currentDateTime();
	previous=QTime::currentTime();
	int deleteOlder = ng->getDeleteOlder();
	
	
	while ((ret=cursor->get(binkey, bindata, DB_NEXT)) != DB_NOTFOUND) {

#if DB_AT_LEAST(4,3)
			if (ret == DB_BUFFER_SMALL) {
#else
			if (ret == ENOMEM) {
#endif

// 			qDebug("Insufficient memory");
			int newSize=bindata->get_size() + 1000;
			delete bindatamem;
			bindatamem=new char[newSize];
			bindata->set_ulen(newSize);
			bindata->set_data(bindatamem);
// 			qDebug("Exiting growing array cycle");
			ret=cursor->get(binkey, bindata, DB_NEXT);
			
		}
		if (ret==0) {
			/*
			bh=new BinHeader((uchar*)bindatamem);
// 			new BHListViewItem(m_headerList, bh, db, servers);
			
			new BHListViewItem(m_headerList, bh, db, showFrom, showDate,  servers);
			count++;
			delete bh;
			
			*/
			int size = bindata->get_size();
			int storedSize;
			memcpy(&storedSize, bindatamem+size-szInt, szInt);
			if (storedSize != size) {
				qDebug("Error! Corruptd db. Storedsize: %d; size: %d", storedSize, size);
				//delete the header from the db!
				
			} else {
				sbh=getSmallBinHeader(bindatamem);
				//Check deleteOlder
				if (deleteOlder > 0) {
					//check and, if needed, delete the header
					hDate = QDateTime::fromString(sbh->date);
					if (hDate.daysTo(cDate) > deleteOlder ) {
// 						qDebug("Current date: %s", (const char *) cDate.toString());
						qDebug("Header date: %s", (const char *) hDate.toString());
						if (sbh->status == BinHeader::bh_new)
							ng->decUnread();
						//dec. total articles..
						ng->decTotal();
						cursor->del(0);
						
						
					} else {
						new BHListViewItem(m_headerList, sbh, db, showFrom, showDate, servers);
						count++;
						
					}
					delete sbh;
					
				} else {
					new BHListViewItem(m_headerList, sbh, db, showFrom, showDate, servers);
					count++;
					delete sbh;
				}
			}
			
			current=QTime::currentTime();
			if (previous.secsTo(current) > 1)  {
// 				pd->setProgress( uint((float(count)/float(ng->getTotal())) * 100));
				kpd->progressBar()->setProgress( uint((float(count)/float(ng->getTotal())) * 100));
				kapp->processEvents();
				
// 				previous=current;
				previous=QTime::currentTime();
			}
		} else qDebug("Error retrieving key the second time: %d", ret);
		
	
	
	}
	kpd->progressBar()->setProgress(100);
	
// 	qDebug("Count: %d", count);
	cursor->close();
	emit sigSaveSettings(ng, showOnlyNew, showOnlyComplete);
	m_headerList->setUpdatesEnabled(TRUE);
	m_headerList->setSorting(0);
	
	m_filterEdit->setEnabled(true);
	delete [] binkeymem;
	delete [] bindatamem;
	delete binkey;
	delete bindata;
	delete kpd;
}





void NewHeaderList::slotContextMenu( QListViewItem *, const QPoint & p )
{
		emit articlePopup(p);
}

void NewHeaderList::slotDownloadSelected(bool first, bool view, QString dir)
{
	
	Dbt *key=new Dbt;
	Dbt *data=new Dbt;
	uchar *keymem=new uchar[KEYMEM_SIZE];
	uchar *datamem=new uchar[DATAMEM_SIZE];
	
	key->set_flags(DB_DBT_USERMEM);
	key->set_data(keymem);
	key->set_ulen(KEYMEM_SIZE);

	data->set_flags(DB_DBT_USERMEM);
	data->set_ulen(DATAMEM_SIZE);
	data->set_data(datamem);
	
	QPtrList<QListViewItem> selection=m_headerList->selectedItems();
	QPtrListIterator<QListViewItem> it(selection);
	if (first)
		it.toLast();
	BHListViewItem *selected;
	
	
	KProgressDialog *kpd = new KProgressDialog(this , NULL, i18n("Please wait..."), i18n("Adding items to download queue"), true);
	kpd->showCancelButton(false);
	kpd->setAllowCancel(false);
	kpd->setMinimumDuration(1000);
	kpd->show();
	
	QTime current, previous;
	previous=QTime::currentTime();
	
	uint total=selection.count();
	uint count=0;
	
	while ((selected=(BHListViewItem*)it.current())) {
		if (first)
			--it;
		else ++it;
		if (selected->depth() == 0 ) {
			int ret;
			count++;
			QString index = selected->getSubject() +selected->getFrom();
			const char *k= (const char *)index;
			memcpy(keymem, k, index.length());
			key->set_size(index.length());
			ret=ng->getDb()->get(NULL, key, data, 0);
#if DB_AT_LEAST(4,3)
			if (ret == DB_BUFFER_SMALL) {
#else
			if (ret == ENOMEM) {
#endif
				//Grow key and repeat the query
				qDebug("Insufficient memory");
				qDebug("Size is: %d", data->get_size());
				uchar *p=datamem;
				datamem=new uchar[data->get_size()+1000];
				data->set_ulen(data->get_size()+1000);
				data->set_data(datamem);
				delete [] p;
				qDebug("Exiting growing array cycle");
				ret=ng->getDb()->get(0,key, data, 0);
				
			}
			if (ret==0) {
				
				BinHeader *bh;
				bh=new BinHeader(datamem);
				if (view)
					emit viewPost(bh, ng);
				else emit downloadPost(bh, ng, first, false, dir);
				
				//Now, mark the header as read, save it and change the appearence...
				if (bh->getStatus() == BinHeader::bh_new)
					ng->decUnread();
				bh->setStatus(BinHeader::bh_downloaded );
				selected->setStatus(BinHeader::bh_downloaded );
				selected->repaint();
				uchar *p=bh->data();
				memcpy(datamem, p, bh->getRecordSize());
				delete [] p;
				data->set_size(bh->getRecordSize());
				ret=ng->getDb()->put(NULL, key, data, 0);
				if (ret!=0)
					qDebug("Error updating record: %d", ret);
				current=QTime::currentTime();
				if (previous.msecsTo(current) > 1000)  {
// 				pd->setProgress( uint((float(count)/float(ng->getTotal())) * 100));
					kpd->progressBar()->setProgress( uint((float(count)/float(total) * 100)));
					kapp->processEvents();
				
// 				previous=current;
					previous=QTime::currentTime();
				}
				
				
// 				delete bh;
					
			}else  kdDebug() << "Error retrieving record: " << ret << endl;
		}
		
		
		

	}
	delete kpd;
	delete [] keymem;
	delete [] datamem;
	delete key;
	delete data;
	emit updateFinished(ng);
}

bool NewHeaderList::prepareToClose( bool confirmation)
{
	if (!confirmation) {
		ng->setView(NULL);
		return true;
	}
	
		
		
	int result=KMessageBox::questionYesNoCancel(this, i18n("Do you want to mark all messages in\n%1\nas read?").arg(ng->name()), i18n("question"));
	switch (result) {
		case KMessageBox::Yes:
			//Mark all messages as read
			markAllAsRead( ng->getDb()  );
			qDebug("Marked all as read");
		case KMessageBox::No:
			//do nothing
			ng->setView(NULL);
			return true;
			break;
		case KMessageBox::Cancel:
			//don't exit (return false?)
			return false;
			break;
	}
	return -1;
	
}

void NewHeaderList::slotDelSelected()
{
	qDebug("Delselected");
	QPtrList<QListViewItem> selection=m_headerList->selectedItems();
	if (selection.isEmpty())
		return;
	
	
	Dbt key;
	memset(&key, 0, sizeof(key));
	
	
	QPtrListIterator<QListViewItem> it(selection);
	BHListViewItem *selected;

	uint count=selection.count();
	uint height=0;
	
	selected=(BHListViewItem*) selection.getFirst();
	QRect rect;
	rect=m_headerList->itemRect(selected);
	//Check if the first item of the selection is outside the viewport. If yes, 
	//we have to scroll the listview...
// 	QListViewItem *first=0;
	if (rect.y() == 0) {
		height=it.current()->height();
// 		first = selection.getLast()->itemBelow();
	}
	while ((selected=(BHListViewItem*)it.current())) {
		
		++it;
		if (selected->depth() == 0) {
			
			int ret;
			QString index = selected->getSubject()+selected->getFrom();
			const char *k= (const char *)index;
			key.set_data((void*)k);
			key.set_size(index.length());
						
			ret=ng->getDb()->del(NULL, &key,0);
			if (ret==0) {
				ng->decTotal();
				if (selected->getStatus() == BinHeader::bh_new)
					ng->decUnread();
				selected->setSelected(false);
				m_headerList->removeItem(selected);
				
					
			}else qDebug("Error retrieving record: %d", ret);
		
			
			
			memset(&key, 0, sizeof(key));
		
		}
		
		
	}
// 	if (first)
// 		m_headerList->ensureItemVisible(first);	
	m_headerList->scrollBy(0, -(count*height));
	m_headerList->adjustColumn(0);
	emit updateFinished(ng);
	
}


void NewHeaderList::markSelectedAs( int what)
{
	
	
	QPtrList<QListViewItem> selection=m_headerList->selectedItems();
	if (selection.isEmpty())
		return;
	
	Dbt key, data;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	
	data.set_flags(DB_DBT_MALLOC);
	key.set_flags(DB_DBT_MALLOC);
	
	
	QPtrListIterator<QListViewItem> it(selection);
	BHListViewItem *selected;

	uint count=selection.count();
	uint height=0;
	
	selected=(BHListViewItem*) selection.getFirst();
	QRect rect;
	rect=m_headerList->itemRect(selected);
	//Check if the first item of the selection is outside the viewport. If yes, 
	//we have to scroll the listview...
// 	QListViewItem *first=0;
	if (rect.y() == 0) {
		height=it.current()->height();
// 		first = selection.getLast()->itemBelow();
	}	
	
	

	
	while ((selected=(BHListViewItem*)it.current())) {
		
		++it;
		if (selected->depth() == 0) {
			
			int ret;
			QString index = selected->getSubject()+selected->getFrom();
			const char *k= (const char *)index;
			key.set_data((void*)k);
			key.set_size(index.length());
						
			ret=ng->getDb()->get(NULL, &key, &data, 0);
			if (ret==0) {
				
				BinHeader *bh;
				bh=new BinHeader((uchar*)data.get_data());
				free(data.get_data());
				memset(&data, 0, sizeof(data));
				//Now, mark the header as read, save it and change the appearence...
				if ( (bh->getStatus() == BinHeader::bh_new) && (what != BinHeader::bh_new) )
					ng->decUnread();
				if ( (what == BinHeader::bh_new ) && (bh->getStatus() != BinHeader::bh_new)) {
// 					qDebug("Increase");
					ng->incUnread();
				}
				bh->setStatus(what);
				selected->setStatus(what);
				uchar *p=bh->data();
				data.set_data(p);
				data.set_size(bh->getRecordSize());
				ret=ng->getDb()->put(NULL, &key, &data, 0);
				
				if (ret!=0)
					qDebug("Error updating record: %d", ret);
				
				delete p;
				delete bh;
				//Take item out of the list...
				if ( (what == BinHeader::bh_read) && showOnlyNew ) {
					selected->setSelected(false);
					hiddenItems.insert(selected->getSubject()+selected->getFrom(), selected);
					
					m_headerList->takeItem(selected);
					

				} else height = 0;
					
			}else qDebug("Error retrieving record: %d", ret);
		
			
			
		memset(&key, 0, sizeof(key));
		key.set_flags(DB_DBT_MALLOC);
		
		
		
		memset(&data, 0, sizeof(data));
		data.set_flags(DB_DBT_MALLOC);
		
		
		}
		
		
	}
// 	if (first)
// 		m_headerList->ensureItemVisible(first);	
	m_headerList->scrollBy(0, -(count*height));
	m_headerList->adjustColumn(0);
	emit updateFinished(ng);
	
	
}

void NewHeaderList::slotMarkSelectedAsRead( )
{
	
	markSelectedAs(BinHeader::bh_read);
}

void NewHeaderList::slotMarkSelectedAsUnread( )
{
	markSelectedAs(BinHeader::bh_new);
}

void NewHeaderList::slotShowOnlyComplete( )
{
	//toggle
	if (showOnlyComplete)
		showOnlyComplete=false;
	else showOnlyComplete=true;
	
	emit sigSaveSettings(ng, showOnlyNew, showOnlyComplete);
	filter(m_filterEdit->text());
	
}

void NewHeaderList::slotShowOnlyNew( )
{
	if (showOnlyNew)
		showOnlyNew=false;
	else showOnlyNew=true;
	emit sigSaveSettings(ng, showOnlyNew, showOnlyComplete);
	filter(m_filterEdit->text());
}

void NewHeaderList::filter( const QRegExp & rx )
{
	m_filterEdit->setEnabled(false);
	m_headerList->setEnabled(false);
	
	
	//for now we check each item against 3 filters: subj, complete, new
	
	BHListViewItem *item=(BHListViewItem*)m_headerList->firstChild();
	while (item) {
		
		if ((item->text(Subj_Col).find(rx, 0) == -1) ||
				   ( showOnlyComplete && (!item->isComplete())) ||
				   (showOnlyNew && (!item->isNew()))) 
		{
			hiddenItems.insert(item->getSubject() + item->getFrom() , item);
			BHListViewItem *temp=(BHListViewItem*)item->nextSibling();
			m_headerList->takeItem(item);
			item=temp;
			
		} else item=(BHListViewItem*)item->nextSibling();
	}
	QDictIterator<BHListViewItem> it(hiddenItems);
	while (it.current()) {
// 		if ((it.currentKey().find(s, 0, false) != -1) &&
		if ((it.current()->getSubject().find(rx,0) != -1) &&
				   (!showOnlyComplete || it.current()->isComplete()) &&
				   (!showOnlyNew || it.current()->isNew()))
			  
		{ //item found!
			m_headerList->insertItem(it.current());
			hiddenItems.remove(it.currentKey());
		} else ++it;
	}
		
	m_headerList->setEnabled(true);
	m_filterEdit->setEnabled(true);
	
}



void NewHeaderList::filter( const QString &s)
{
	m_filterEdit->setEnabled(false);
	m_headerList->setEnabled(false);
	
	
	//for now we check each item against 3 filters: subj, complete, new
	
	BHListViewItem *item=(BHListViewItem*)m_headerList->firstChild();
	while (item) {
		
		if ((item->text(Subj_Col).find(s, 0, FALSE) == -1) ||
				( showOnlyComplete && (!item->isComplete())) ||
				(showOnlyNew && (!item->isNew()))) 
		{
			//put item into the "hidden" list & stop checkin against other filters...
// 			item=hideItem(item);
			hiddenItems.insert(item->getSubject() + item->getFrom() , item);
			BHListViewItem *temp=(BHListViewItem*)item->nextSibling();
			m_headerList->takeItem(item);
			item=temp;
			
		} else item=(BHListViewItem*)item->nextSibling();
		
	}
	QDictIterator<BHListViewItem> it(hiddenItems);
	while (it.current()) {
// 		if ((it.currentKey().find(s, 0, false) != -1) &&
		if ((it.current()->getSubject().find(s, 0, false) != -1) &&
				   (!showOnlyComplete || it.current()->isComplete()) &&
				   (!showOnlyNew || it.current()->isNew()))
			  
		{ //item found!
			m_headerList->insertItem(it.current());
			hiddenItems.remove(it.currentKey());
		} else ++it;
	}
		
	m_headerList->setEnabled(true);
	m_filterEdit->setEnabled(true);
	m_headerList->adjustColumn(0);
	
}


void NewHeaderList::reload( )
{
	
	m_filterEdit->clear();
	hiddenItems.setAutoDelete(true);
	hiddenItems.clear();
	hiddenItems.setAutoDelete(false);
	loadGroup(ng->getDb());
	filter(m_filterEdit->text());
}

void NewHeaderList::markAllAsRead( Db* db)
{
	/*
	Dbt *binkey, *bindata;
    binkey=new Dbt;
    bindata=new Dbt;
	char *binkeymem=new char[KEYMEM_SIZE];
	char *bindatamem=new char[DATAMEM_SIZE];

    binkey->set_flags(DB_DBT_USERMEM);
    binkey->set_ulen(KEYMEM_SIZE);
    binkey->set_data(binkeymem);

    bindata->set_flags(DB_DBT_USERMEM);
    bindata->set_ulen(DATAMEM_SIZE);
    bindata->set_data(bindatamem);
	*/
	
	Dbt key, data;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	key.set_flags(DB_DBT_MALLOC);
	data.set_flags(DB_DBT_MALLOC);
	
	Dbc *cursor;
	db->cursor(NULL, &cursor, DB_WRITECURSOR);
// 	db->cursor(NULL, &cursor, 0);
	
	int ret;
	QTime current, previous;
	previous=QTime::currentTime();
	BinHeader *bh;	
	
	
	while ((ret=cursor->get(&key, &data, DB_NEXT)) != DB_NOTFOUND) {
		
		if (ret==0) {
			bh=new BinHeader((uchar*)data.get_data());
			free(data.get_data());
			//Now, mark the header as read, save it and change the appearence...
			if (bh->getStatus() == BinHeader::bh_new) {
				bh->setStatus(BinHeader::bh_read);
				ng->decUnread();
				uchar *p=bh->data();
				
				memset(&data, 0, sizeof(data));
				data.set_data(p);
				data.set_size(bh->getRecordSize());;
								
				ret=cursor->put(NULL, &data, DB_CURRENT);
				if (ret!=0)
					qDebug("Error updating record: %d", ret);
				delete p;
			}
			
			free(key.get_data());
			memset(&key, 0, sizeof(key));
			memset(&data, 0, sizeof(data));
			key.set_flags(DB_DBT_MALLOC);
			data.set_flags(DB_DBT_MALLOC);		
			delete bh;
			
			
			
			current=QTime::currentTime();
			if (previous.secsTo(current) > 1)  {
				kapp->processEvents();
				previous=QTime::currentTime();
			
			} 
		}else qDebug("Error retrieving key: %d", ret);
		
	
	
	}
	
	
	
	cursor->close();
	ng->setUnread(0);
	emit updateFinished(ng);
	
	
}

void NewHeaderList::slotViewArticle( )
{
		
	slotDownloadSelected(true, true);
}

void NewHeaderList::closeAndMark( )
{
	QCloseEvent *e = new QCloseEvent();
	ng->setView(NULL);
	markGroupAsRead();
	KMdiChildView::closeEvent(e);
	
}

void NewHeaderList::closeAndNoMark( )
{
	QCloseEvent *e = new QCloseEvent();
	ng->setView(NULL);
	KMdiChildView::closeEvent(e);
	
}

void NewHeaderList::closeEvent( QCloseEvent * e )
{
	
	if (ng->isUpdating() || ng->unread() == 0 ) {
		ng->setView(NULL);
		KMdiChildView::closeEvent(e);
	}
	else {
		switch (Config().markOpt) {
			case Configuration::Yes:
				markGroupAsRead();
			case Configuration::No:
				ng->setView(NULL);
				KMdiChildView::closeEvent(e);
				break;
			case Configuration::Ask:
				int result=KMessageBox::questionYesNoCancel(this, i18n("Do you want to mark all messages in\n%1\nas read?").arg(ng->name()), i18n("question"));
				switch (result) {
					case KMessageBox::Yes:
				//Mark all messages as read
	// 				markAllAsRead( ng->getDb()  );
						markGroupAsRead();
					
					case KMessageBox::No:
				//do nothing
						ng->setView(NULL);
						KMdiChildView::closeEvent(e);
						break;
					case KMessageBox::Cancel:
				//don't exit (return false?)
					
						break;
				}
		
		
		}
		
		
			
		
		
	}
	
		
		
	
	
	
}

void NewHeaderList::slotDownloadSelectedFirst( )
{
	slotDownloadSelected(true);
}

void NewHeaderList::slotClearButtonClicked( )
{
	m_filterEdit->clear();
	filter("");
	
}

NewHeaderList::~ NewHeaderList( )
{
// 	qDebug("Destructor");
	hiddenItems.setAutoDelete(true);
	hiddenItems.clear();
	m_headerList->clear();
	ng->setView(NULL);
// 	qDebug("View %s NULLified", (const char *) ng->name());
}

//New version of markAllAsRead(): scan the articles in memory, and mark only the unread articles...

void NewHeaderList::markGroupAsRead( )
{
// 	qDebug("Mark group as read");
	Dbt key, data;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	
	data.set_flags(DB_DBT_MALLOC);
// 	key.set_flags(DB_DBT_MALLOC);
	int ret;
	QString index;
	//First, scan the headerlist...
	BHListViewItem *item=(BHListViewItem*)m_headerList->firstChild();
	while (item) {
		if (item->isNew()) {
			//Grab the db record, mark as read, and save
// 			index=item->text(Subj_Col) + item->text(From_Col);
			index=item->getSubject() + item->getFrom();
			const char *k= (const char *)index;
			key.set_data((void*)k);
			key.set_size(index.length());
						
			ret=ng->getDb()->get(NULL, &key, &data, 0);
			if (ret==0) {
				
				BinHeader *bh;
				bh=new BinHeader((uchar*)data.get_data());
				free(data.get_data());
				memset(&data, 0, sizeof(data));
				ng->decUnread();
				bh->setStatus(BinHeader::bh_read);
				uchar *p=bh->data();
				data.set_data(p);
				data.set_size(bh->getRecordSize());
				ret=ng->getDb()->put(NULL, &key, &data, 0);
				
				if (ret!=0)
					qDebug("Error updating record: %d", ret);
				
				delete p;
				delete bh;
				data.set_flags(DB_DBT_MALLOC);
			} else qDebug("Error retrieving record: %d", ret);
		
		
		
		}
		item=(BHListViewItem*)item->nextSibling();
	}
// 	qDebug("Marked visible items");
	//then, scan the hidden list...
	QDictIterator<BHListViewItem> it(hiddenItems);
	while (it.current()) {
		if (it.current()->isNew()) {
			//Mark as read...
			index=it.currentKey();
			const char *k = (const char *) index;
			key.set_data((void*)k);
			key.set_size(index.length());
			ret=ng->getDb()->get(NULL, &key, &data, 0);
			if (ret==0) {
				
				BinHeader *bh;
				bh=new BinHeader((uchar*)data.get_data());
				free(data.get_data());
				memset(&data, 0, sizeof(data));
				ng->decUnread();
				bh->setStatus(BinHeader::bh_read);
				uchar *p=bh->data();
				data.set_data(p);
				data.set_size(bh->getRecordSize());
				ret=ng->getDb()->put(NULL, &key, &data, 0);
				
				if (ret!=0)
					qDebug("Error updating record: %d", ret);
				
				delete p;
				delete bh;
				data.set_flags(DB_DBT_MALLOC);
			} else qDebug("Error retrieving record: %d", ret);
			
		}
		++it;
	}
	
// 	qDebug("Marked invisible items");
	//Finally, emit the update signal
	emit updateFinished(ng);
}

void NewHeaderList::slotDownloadToDir( )
{
	DownloadSelect *ds=new DownloadSelect(ng->getSaveDir(), this);
	connect(ds, SIGNAL(download(QString, bool )), this, SLOT(slotDownloadToFirst(QString, bool )));
	ds->exec();
	
}

void NewHeaderList::slotDownloadToFirst( QString dir, bool first)
{
	slotDownloadSelected(first, false, dir);
}

void NewHeaderList::slotItemExecuted( )
{
	slotViewArticle();
}

SmallBinHeader * NewHeaderList::getSmallBinHeader( char * p )
{
	char *i=&p[0];
	int szInt=sizeof(int);
	int count;
	memcpy(&count, i, szInt);
// 	kdDebug() << "Count: " << count << endl;
	//Skip serverLowest
	i+=(count*2*szInt+szInt);
	SmallBinHeader *sbh = new SmallBinHeader;
	i=retrieve(i, sbh->subj);
// 	kdDebug() << "Subj: "<< sbh->subj << endl;
	i=retrieve(i, sbh->from);
	i=retrieve(i, sbh->date);
	
	memcpy(&(sbh->parts), i, szInt);
	i+=szInt;
	
	memcpy(&(sbh->missingParts), i, szInt);
	i+=szInt;
	
	memcpy(&(sbh->status), i, szInt);
	//Skip lines
	i+=2*szInt;
	memcpy(&(sbh->size), i, szInt);
	i+=szInt;
	
	int id, parts;
	memcpy(&count, i, szInt);
	i+=szInt;
	for (int j=0; j < count; j++) {
		memcpy(&id, i, szInt);
		i+=szInt;
		memcpy(&parts, i, szInt);
		i+=szInt;
		sbh->serverParts.insert(id, parts);
		
	}
	return sbh;
	
	
}

void NewHeaderList::slotEnterButtonClicked( )
{	
	
	if (regExpCheck->isChecked()) {
		QRegExp rx;
		rx.setPattern(m_filterEdit->text());
		rx.setCaseSensitive(false);
		if (rx.isValid())
			filter(rx);
		else KMessageBox::error(this, i18n("Invalid regular expression!"),i18n("Error") );
				
	} else {
		filter(m_filterEdit->text());
	}
	
}

/*$SPECIALIZATION$*/


#include "headerlist.moc"

