/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef NNTPTHREADSOCKET_H
#define NNTPTHREADSOCKET_H

#include <qthread.h>
#include <qfile.h>
#include <qsocketdevice.h>
#include <ksockaddr.h>
#include <qhostaddress.h>
#include <qdatetime.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <qapplication.h>
#include <db_cxx.h>
#include <header.h>
#include <binheader.h>
#include <kextsock.h>
#include "newsgroup.h"
#include <qregexp.h>
#include "availablegroups.h"

#define NNTPTHREADEVENT 64532




struct Job { //Is it persistent???

	int id;			//assigned by qmgr
	int qItemId;	//assigned by qitem
	int jobType; 	//returned by qitem
	int partId;
	int status;
	int qId;
	int threadId;
	QString mid;
	enum JobTypes {UpdHead, GetPost, GetList};	//Probably will NOT use the getPost...
	enum Status {Queued_Job, Processing_Job, Finished_Job, Failed_Job, Canceled_Job, Paused_Job, Updating_Job};
	QString error;
	int artNum;		//article number, returned by qitem
	int artSize;
	QString fName;
	Db* gdb;		//inserted by qmgr
	AvailableGroups *ag;
	NntpHost *nh; //Not persistent?? Hmmm... 
	NewsGroup *ng;	//returned by qitem
	int tries;
	

	
};



class NntpThreadEvent : public QCustomEvent {

	friend class QMgr;
	friend class NntpThreadSocket;

private:
	
	Job* job;

	uint type;	
    uint m_totalLines;
    uint m_lines;
	uint m_partialLines;
	int err;
	


	
	
public:
	
	NntpThreadEvent(Job* j, uint t, uint lines=0, uint total=0, uint partial=0) : QCustomEvent(NNTPTHREADEVENT), job(j), type(t), m_totalLines(total), m_lines(lines), m_partialLines(partial) {};
	NntpThreadEvent(int serverID, int threadID, int t) : QCustomEvent(NNTPTHREADEVENT), type(t), m_totalLines(serverID), m_partialLines(threadID) {};
	
	
	
};



/**
@author Alessandro Bonometti
*/

//Ok, third try: a synchronous, thread-safe nntp socket...seems to work...sic! So much pain!


class QItem;

/*
Implementation of the thread - trying to make it as authonomous as possible.
*Status:
 - Ready: Idle thread
 - Working: thread is running
 - Paused: the queue manager stopped the thread
 - PausedOnErr: thread paused itself because of an error (tipically a Communication error), a timer will restart it after a proper period of time (see Thread::slotRetryTimeout()
 - DelayedDelete: about to delete the thread (after a "remove thread") 

*controls:
 - cancel: stop current download, but don't stop the thread. After cancel of current item is aknowledged, thread continues -> doesn't change the state.
 - pause: pause the thread -> changes the state 
 controls are resetted (by the thread itself) after their work is done

tStart() starts the thread, but if and only if status == Ready -> if the thread has been paused, it has to be *explicitly* resumed with tResume();
 
*/

class NntpThreadSocket : public QThread {
// 	friend class Thread;
// 	friend class QMgr;
	private:
			
		
		//For locking...
		QMutex *queueLock; //Queue locking, for grabbing jobs
		QMutex statusLock; //Status locking, form modifying/reading status...
		
		//For control...
		volatile bool pause;
		volatile uint status;	//Status of the thread
		volatile bool cancel;
		int *pendingOperations;
		//The queue(s)!
		
		QMap<int, QItem*> *queue;
		QValueList<int> *threadQueue;
		
		
		
		
		uint *curbytes;   //Bytes currently downloaded
		uint lines;		  //Progress lines
		uint step;		  //Step (for message progress)
		uint totalLines;  //Total lines to read from the net
		QWidget *parent;  //where to send the progress/start/finish messages
		
		QSocketDevice *kes;
		long bytes;
		QStringList addrList;
		QHostAddress ha;
		int groupArticles;
		
		Job *job;		  //our job. Should be persistent...check!
		
		// int retries;	//Hmmm
		int error;		//Error status
			//timer...started when I start async ops and restarted every byte received...
		int timeout;
// 		bool *isTimeout; 
		QString fileName;

		int lowWatermark, highWatermark, articles;
		Db *db;	//This points to ng->db

		uint datamemSize;
		
		uchar *keymem, *datamem;
		Dbt *key, *data;
		void reset();
		
		QFile *saveFile;
		
		int dbBinHeaderPut( Db * db, Header * h, NntpHost * nh ); //Puts the header in the db, during download
		int dbGroupPut(Db *db, const char *line, int hostId);
		QString createDateTime( QStringList dateTime);  //Creates a date/time string suitable for QDateTime
		void parse(QStringList);   //Stupid function that parses the xover informazion
		void expire( NewsGroup * ng, int hostId, int lw );   //expire articles under lw on host hostID and Newsgroup ng
		bool myConnect(const QHostAddress & addr, Q_UINT16 port);
		Job *findFreeJob();
		bool m_readLine();
		
		virtual void run();
		
		//and now, from KNntpSocket:
		int lineBufSize;
    	char *line;
		char *buffer, *watermark, *lineEnd;
		int bufferSize, lineSize;

    	int timeoutVal; //timeout in cycles...

		enum CommandType {Cmd_None=0, Cmd_Login=1, Cmd_GetPost=2, Cmd_GetXoverInfo, Cmd_GetXover, Cmd_GetHead};
		enum CommandProgress {Cmd_Username=0, Cmd_Pass=1, Cmd_Group=2, Cmd_Article,  Cmd_Header, Cmd_Xover, Cmd_Connected, Cmd_NoCmd, Cmd_Finished, Cmd_Connect}; //incomplete, just trying...
		enum response { xover=224, user=381, pass=281, article=220, body=222,head=221, group=211, quit=205, ready=200, readyNoPost=201, list=215};
		QString errorString;

		
		bool isLoggedIn;

		ulong xoverStart, xoverEnd;
		
		QString cmd;
		NntpHost *nHost;
		QString newsGroup;
		int artNum;
		int threadId;
		int qId;
		
		//Memebers...
		bool waitLine(); //True if new line exists, false if timeout;
		int m_handleError(int expected, QString received); //Handles line error...
		
		

		bool m_connect(); //Connect & login
    	bool m_disconnect();  //Disconnect
    	bool m_isConnected();	//Is the socket connected & logged in?
		bool getXover(QString group);  //Works
		bool getArticle();  //Works
		bool getListOfGroups();
		bool getBody(QString group, int artnum); //Unimplemented
		bool getHead(QString group, int artnum); //Unimplemented
		int m_getError() {return error;}
    	const char *m_getErrorDesc() {return (const char *) errorString;}
		char * NntpThreadSocket::m_findEndLine( char * start, char * end );
		void setHost(NntpHost *nh);
		bool m_sendCmd( QString& cmd, int response );
		QTime prevTime, currentTime;
		
		
	public:
		enum Status {Ready=0, Working=1, Finished, Paused, PausedOnError, Delayed_Delete, DownloadFinished, DownloadCanceled, Err, NewJob, Start, Cancelling, Canceled, Expiring, DownloadError, StartedWorking }; //ready means "Accepting job"
		enum Error {No_Err, Timeout_Err, Comm_Err, FatalTimeout_Err, TooManyThreads_Err, Auth_Err, Other_Err, Write_Err, NoSuchArticle_Err=423, NoSuchMid_Err=430, NoSuchGroup_Err=411};
		enum Control {Go, Pause};
// 		enum errors {noErr=0, timeoutErr, authErr=502, noSuchArticleErr=423, noSuchGroupErr=411, serverErr=400,commErr, otherErr, cancelErr};
		bool addJob();
// 		void setStatus(int s) {status=s;};
		void closeConnection();
		bool isConnected() {return isLoggedIn;};
		void setQueue(QValueList<int> *tq, QMap<int, QItem*> *q, QMutex *qLock, int *po);
		void setId(int q, int t);
		NntpThreadSocket(QWidget *, uint*);
		~NntpThreadSocket();
		void tCancel();
		void tPause();
		void tResume();
		void tStart();
		
		
		
	
};













#endif
