/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "qmgr.h"
#include "globals.h"
#include <kmdichildfrm.h>
#include "grouplist.h"
#include <kmessagebox.h>
#include <qdom.h>
#include <qfile.h>
#include <qdatetime.h>
#include "nzbform.h"
#include "mylistview.h"


extern bool g_qResume;
extern bool g_qDiscard;


QMgr::QMgr(Servers *_servers, Db *_gdb, QString caption, QWidget* parent) : KMdiChildView(caption,parent), servers(_servers), gdb(_gdb)
{
// 	kdDebug() << "KConstructor\n";
// 	qDebug("QConstructor");
	nextItemId=0;
	nextJobId=0;
	operationsPending=0;
	queueSize=0;
	queueCount=0;
	diskError=0;
	
	(new QHBoxLayout(this))->setAutoAdd(true);

	tabWidget=new KTabWidget(this);
	
// 	queueList=new KListView();
	queueList=new MyListView();
	queueList->addColumn("Id");
	queueList->addColumn("Item");
	queueList->addColumn("Status");
	queueList->addColumn("Info");
	queueList->addColumn("ETA (HH:MM:SS)");
	queueList->setColumnAlignment(4, Qt::AlignRight);
// 	queueList->setIcon(KGlobal::iconLoader()->loadIcon("queue", KIcon::Small, 0, false));
	//Initialize the KListView
	queueList->setRootIsDecorated(true);
	queueList->setSorting(-1);
	queueList->setAcceptDrops(TRUE);
	queueList->setDragEnabled(TRUE);
	queueList->setItemMargin(3);
	queueList->setAllColumnsShowFocus(true);
	queueList->setSelectionMode(QListView::Extended);
	
	tabWidget->addTab(queueList, KGlobal::iconLoader()->loadIcon("queue", KIcon::Small, 0, false), "Queued Items");
	
	doneList=new KListView();
	doneList->addColumn("Id");
	doneList->addColumn("Item");
	doneList->addColumn("Info");
	doneList->setRootIsDecorated(true);
	doneList->setSorting(-1);
	doneList->setAcceptDrops(false);
	doneList->setDragEnabled(false);
	doneList->setItemMargin(3);
	doneList->setAllColumnsShowFocus(true);
	doneList->setSelectionMode(QListView::Extended);
// 	doneList->setIcon(KGlobal::iconLoader()->loadIcon("finish", KIcon::Small, 0, false));
	tabWidget->addTab(doneList,KGlobal::iconLoader()->loadIcon("finish", KIcon::Small, 0, false), "Finished Items");
	
	failedList=new KListView();
	failedList->addColumn("Id");
	failedList->addColumn("Item");
	failedList->addColumn("Info");
	failedList->setRootIsDecorated(true);
	failedList->setSorting(-1);
	failedList->setAcceptDrops(false);
	failedList->setDragEnabled(false);
	failedList->setItemMargin(3);
	failedList->setAllColumnsShowFocus(true);
	failedList->setSelectionMode(QListView::Extended);
	tabWidget->addTab(failedList,KGlobal::iconLoader()->loadIcon("stop", KIcon::Small, 0, false), "Failed Items");
	
	//for every server, create the q, the qinfo and the qthreads...
	QMap<int, NntpHost*>::iterator sit;
	for (sit=servers->begin(); sit != servers->end(); ++sit) {
		
		pendingOperations[sit.key()] = 0;
		addServerQueue(sit.data());
		
		
		
		
		
	}
	
// 	decodeThread=new DecodeThread(this, &decodeListLock, &decodeList);
// 	decodeThread = new SelfDecodeThread (this, &decodeListLock, &decodeList);
	
	if (Config().useUU)
		decodeThread=new DecodeThread(this, &decodeListLock, &decodeList);
	else decodeThread=new SelfDecodeThread (this, &decodeListLock, &decodeList);
	
	decodeThread->setOverWrite(Config().overwriteExisting);
	
	updateDbThread=new UpdateDbThread(this, &updateListLock, &updateJobList);
	

// 	connect(this, SIGNAL(newItem(int)), this, SLOT(slotProcessQ(int)));
	connect(this, SIGNAL(newItem(int )), this, SLOT(startAllThreads(int )));
	connect(this, SIGNAL(threadFinished()), this, SLOT(slotThreadFinished()));
	connect(queueList, SIGNAL(selectionChanged()), this, SLOT(slotSelectionChanged()));
	connect(queueList, SIGNAL(moved(QListViewItem*, QListViewItem*, QListViewItem*)),
			this, SLOT(slotItemMoved(QListViewItem*, QListViewItem*, QListViewItem*)));
// 	connect(queueList, SIGNAL(contextMenuRequested(QListViewItem *, const QPoint &, int)), this, SLOT(slotContextMenu(QListViewItem*, const QPoint& )));
	setIcon(KGlobal::iconLoader()->loadIcon("queue", KIcon::Small, 0, false));
	connect(queueList, SIGNAL(contextMenuRequested(QListViewItem *, const QPoint &, int)), this, SLOT(slotQueueContextMenu(QListViewItem*, const QPoint&)));
	connect(doneList, SIGNAL(contextMenuRequested(QListViewItem *, const QPoint &, int)), this, SLOT(slotFinishedContextMenu(QListViewItem*, const QPoint&)));
	connect(failedList, SIGNAL(contextMenuRequested(QListViewItem *, const QPoint &, int)), this, SLOT(slotFailedContextMenu(QListViewItem*, const QPoint&)));
		
	
		
}

void QMgr::slotAddListItem( AvailableGroups *ag )
{
	nextItemId++;
	queueLock.lock();
	queue.insert(nextItemId, new QListItem(queueList, nextItemId, ag->getDb()));
	queueCount++;
	Part *tPart;
	Job *tJob;
	QMap<int, NntpHost*>::iterator sit;
	queueView.append(nextItemId);
	queueCount++;
	for (sit=servers->begin(); sit != servers->end(); ++sit) {
		nextJobId++;
		tJob=new Job;
		tJob->qId=sit.key();
		tJob->id=nextJobId;
		tJob->jobType=Job::GetList;
		tJob->status=Job::Queued_Job;
		tJob->ag=ag;
		
		tJob->nh=sit.data();
		tJob->qItemId=nextItemId;
		tJob->partId=sit.key();
		
		if (! queue[nextItemId]->queuePresence.contains(sit.key())) {
			queue[nextItemId]->queuePresence[sit.key()]=true;
			queueItems[sit.key()].append(nextItemId);
		}
		
		
		tPart=new Part;
		tPart->desc=sit.data()->name;
		tPart->status=QItem::Queued_Part;
		tPart->jobId=nextJobId;
		tPart->job=tJob;
		tPart->qId=sit.key();
		queue[nextItemId]->addJobPart(nextJobId, sit.key(), tPart);
		
		
	}
	queueLock.unlock();
	emit queueInfo(queueCount, queueSize);
	emit threadFinished();
}
	
	

void QMgr::slotAddUpdItem( NewsGroup * _ng, int headers)
{
	nextItemId++;
	//create the item...
	queueLock.lock();
	queue.insert(nextItemId, new QUpdItem(queueList, nextItemId, _ng));
	
	
		
	
	
	//create the part; create the job; add part/jobs to item...
	Part *tPart;
	Job *tJob;
	
	queueView.append(nextItemId);
	queueCount++;
	QMap<int, NntpHost*>::iterator sit;
	for (sit=servers->begin() ; sit != servers->end() ; ++sit) {
// 		qDebug("Serverid: %d", sit.key());
		queue[nextItemId]->queuePresence[sit.key()] = false;
	}
	
	
	for (sit=servers->begin(); sit != servers->end(); ++sit) {
		if ( (_ng->high.contains(sit.key())) && ( _ng->high[sit.key()] == -1)) {
			continue;
		}
		nextJobId++;
		//Create the job
		tJob=new Job;
		tJob->qId=sit.key();
		tJob->gdb=gdb;
		tJob->id=nextJobId;
		tJob->jobType=Job::UpdHead;
		tJob->status=Job::Queued_Job;
		tJob->fName=Config().tmpDir+ '/' +_ng->ngName + '.' + QString::number(sit.key());
		tJob->ng=_ng;
		tJob->nh=sit.data();
		tJob->qItemId=nextItemId;
		tJob->partId=sit.key(); 
		
		//Warning: using "artsize" to tell the thread how many headers to download...
		tJob->artSize=headers;
		
		if (queue[nextItemId]->queuePresence[sit.key()] == false) {
			queue[nextItemId]->queuePresence[sit.key()]=true;
			queueItems[sit.key()].append(nextItemId);
		}
		
		
		//create the part...
		tPart=new Part;
		tPart->desc=sit.data()->name;
		tPart->status=QItem::Queued_Part;
		tPart->jobId=nextJobId;
		tPart->job=tJob;
		tPart->qId=sit.key();
		queue[nextItemId]->addJobPart(nextJobId, sit.key(), tPart);
// 		queues[sit.key()].insert(nextJobId, tJob);
// 		queues[sit.key()].append(tJob);
		
// 		qDebug("About to process q#%d", sit.key());
// 		processQ(sit.key());
// 		emit newItem(sit.key());
		
		
	}
	
	emit queueInfo(queueCount, queueSize);
	queueLock.unlock();
	emit threadFinished();
// 	qDebug("Ok, q processing finished");
	
}


void QMgr::slotAddPostItem( BinHeader * bh, NewsGroup *ng , bool first, bool view, QString dDir)
{
// 	qDebug("Should add this job: %s", (const char *) bh->getSubj());
	
	//To keep track of the presence of an item in the queue...
	if (diskError)
		return;
	
	nextItemId++;
	//create the item...
		
	QSaveItem *qsi = new QSaveItem;
	
	
	Part *tPart;
	Job *tJob;
	int serverId=0;
// 	KTempFile ktf(ng->saveDir + '/');
	QString tempDir=Config().tmpDir + '/';
	KTempFile ktf(tempDir);
	
	
	
// 	qDebug("Tempfile: %s", (const char *) ktf.name());
	QString rootFName=ktf.name();
// 	ktf.unlink();
	ktf.close();
	queueSize+=bh->getSize();
	queueCount++;
	
	queueLock.lock();
	QString dir = dDir.isNull()? ng->getSaveDir() : dDir;
	
	qsi->tmpDir=tempDir;
	qsi->group=ng->getName();
	qsi->id = nextItemId;
	qsi->type = QSaveItem::QSI_Add;
	
	qsi->index=bh->getSubj() + bh->getFrom();
	qsi->rootFName=rootFName;
	qsi->savePath=dir;
	qsi->curPostLines=0;
	
	
	queue.insert(nextItemId, new QPostItem(queueList, nextItemId, bh, rootFName, dir,  first, view ));
	
	
	
	connect(queue[nextItemId], SIGNAL(decodeMe(QPostItem*)), this, SLOT(addDecodeItem(QPostItem* )));
	
	QMap<int, NntpHost*>::iterator sit; //Server iterator
	for (sit =servers->begin() ; sit != servers->end() ; ++sit)
		queue[nextItemId]->queuePresence[sit.key()] = false;
	
	
	
// 	if (first)
// 		queueView.prepend(nextItemId);
// 	else queueView.append(nextItemId);
	queueView.append(nextItemId);
	
	
	for (bh->pnmit=bh->partNum.begin(); bh->pnmit != bh->partNum.end(); ++(bh->pnmit)) {
		
		nextJobId++;
		tJob=new Job;
		// Choose the right server, based on priority....
		// In the future, will try to balance the queues with the same priority (using qinfo)
		
// 		serverId=chooseServer(bh);
		//New version of chooseServer...
		serverId=chooseServer(bh, bh->pnmit.key());
		(*servers)[serverId]->size+=bh->partSize[bh->pnmit.key()];
		tJob->artSize=bh->partSize[bh->pnmit.key()];
// 		qDebug("Added to serverId %d", serverId);
// 		tJob->artSize=bh->partSize[bh->pnmit.key()];
		tJob->qId=serverId;
		tJob->id=nextJobId;
		tJob->jobType=Job::GetPost;
		tJob->nh=(*servers)[serverId]; //Got to choose the server....
		tJob->ng=ng;
		tJob->qItemId=nextItemId;
		tJob->partId=bh->pnmit.key();
		tJob->status=Job::Queued_Job;
		tJob->artNum=bh->pnmit.data()[serverId];
		tJob->tries=tJob->nh->retries;
		tJob->fName=rootFName + '.' + QString::number(tJob->partId);
		if (bh->partMid.contains(bh->pnmit.key()) ) {
// 			kdDebug() << "Have mid\n";
			tJob->mid=bh->partMid[bh->pnmit.key()];
// 			kdDebug() << "Mid: " << tJob->mid << endl;
			
		} else {
			tJob->mid = QString::null;
// 			kdDebug() << "Have number\n";
		}
		
		if (queue[nextItemId]->queuePresence[serverId] == false) {
			queue[nextItemId]->queuePresence[serverId]=true;
			queueItems[serverId].append(nextItemId);
		}
		
		
// 		
		
		
		tPart=new Part;
		tPart->desc=bh->getSubj() + " " + QString::number(bh->pnmit.key()) + "/" +QString::number(bh->getParts());
		tPart->status=QItem::Queued_Part;
		tPart->jobId=nextJobId;
		tPart->job=tJob;
		tPart->qId=serverId;
		queue[nextItemId]->addJobPart(nextJobId, bh->pnmit.key(), tPart);
// 		queues[serverId].insert(nextJobId, tJob);
		
		//New for queue saving
		qsi->partStatus[bh->pnmit.key()] = QItem::Queued_Part;
		
// 		qDebug("Part: %d, ArtNum: %d, Queue: %d", tJob->partId, tJob->artNum, serverId);
		
		

	}
	
	
	
	if (first) {
		//risky =:-|
		queueLock.unlock();
		slotItemMoved(queue[nextItemId]->listItem, 0,0 );
		queueLock.lock();
		
	}
	
	emit (queueInfo(queueCount, queueSize));
	queueLock.unlock();
	emit threadFinished();
	//Save the item in the queue db...
// 	if (!writeSaveItem(nextItemId, qsi))
// 		writeError();
// 	delete qsi;
	writeSaveItem(qsi);
	
	
	
	
	
// 	qDebug("addpost loop finished");
	
}


int QMgr::chooseServer( BinHeader * bh, int part )
{
	int maxPriority=0;
	unsigned long long maxSize=INT_MAX;
	int serverId=0;
	NntpHost* nh=0;
	
	
	for (bh->snmit=bh->partNum[part].begin(); bh->snmit != bh->partNum[part].end(); ++(bh->snmit)) {
		//For every server, get its priority 
		nh=(*servers)[bh->snmit.key()];
// 		qDebug("ServerId: %d, priority: %d, queueSize: %d", nh->id, nh->priority, nh->size);
		if (nh->size < maxSize && ! (nh->priority < maxPriority) ) {
			maxPriority=nh->priority;
			maxSize=nh->size;
			serverId=nh->id;
		}
		if ( nh->priority > maxPriority) {
			//Found article on a server with higher priority
			maxPriority=nh->priority;
			serverId=nh->id;
			
		}
	}
	if (serverId == 0)
		qDebug("ServerId returned 0!!! Something's seriously fscked!");
// 	qDebug("Chosen: %d", serverId);
	return serverId;
}

/*

int QMgr::findFreeThread( int qId )
{
	//Finds the first free thread of the given queue.
	ThreadMap::iterator tit; //Strange name, but it's a Thread Iterator :)
	for (tit=threads[qId].begin(); tit != threads[qId].end(); ++tit) {
		if (tit.data()->getStatus()==NntpThreadSocket::Ready) { //Is there a free thread?
// 			qDebug("Found free thread: %d in q %d", tit.key(), qId);
			
// 			qDebug("Free thread: %d", tit.key());
			return tit.key(); //return it
			
		} //else qDebug("Thread %d busy in q %d", tit.key(), qId);
	} 
	return 0; //no free threads
	
	
}
*/

//find the next queued job in the queue...
/*
Job *QMgr::findNextJob( int qId )
{
	
	Job *j=0;
	
	for (j=queues[qId].first(); j; j=queues[qId].next()) {

		if (j->status==Job::Queued_Job) {
			
// 			if ((! (j->jobType==Job::UpdHead) || !(j->ng->updating)) && 
			if  (!(j->jobType==Job::GetList) || !(j->ag->isUpdating()) ) {
		
			
				return j; //Returns the job pointer...or returns the key? Hmmmm
			}
		}
	}
	
	return 0;
}*/

Job* QMgr::findNextJob( int qId )
{
	QValueList<int>::iterator it;
	QMap<int, Part*>::iterator pit;
	QItem *item;
	Job *j;
	//For every item...
	for (it = queueItems[qId].begin(); it != queueItems[qId].end(); ++it) {
		//for every part of the item...
		item=queue[*it];
		for (pit=item->parts.begin(); pit != item->parts.end(); ++pit) {
			//check every job of the item...
			j=pit.data()->job;
			if ( (j->status==Job::Queued_Job) && (j->qId == qId) ) {
			
// 			if ((! (j->jobType==Job::UpdHead) || !(j->ng->updating)) && 
				if  (!(j->jobType==Job::GetList) || !(j->ag->isUpdating()) ) {
		
// 					qDebug("Job: %d", j->id);
					/*
					if (j->jobType == Job::GetList) {
						qDebug("Ok, is updating on qId %d", qId);
						j->ag->startUpdating();
				}*/
					return j; //Returns the job pointer...
				}
					
				
			}
		}
	}
	return 0;
	
}



void QMgr::update( Job *j,  int partial, int total, int interval )
{
	queueLock.lock();
		
	queue[j->qItemId]->update(j->partId, partial, total,interval );
	queueLock.unlock();
		
}

void QMgr::start( Job * j )
{

// 	queue[j->qItemId]->parts[j->partId]->listItem->setText(2, "Working...");
// 	queue[j->qItemId]->parts[j->partId]->listItem->setText(3, "0%");
// 	queue[j->qItemId]->workingThreads++;
// 	queue[j->qItemId]->listItem->setText(2, "Processing ("+ QString::number(queue[j->qItemId->workingThreads)+")" );
// 	qDebug("Starting %d, %d", j->qId, j->threadId);
	queueLock.lock();
	queue[j->qItemId]->start(j->partId);
	queueLock.unlock();
	threads[j->qId][j->threadId]->started();
	
	
	
	
}

void QMgr::expiring( Job * j, int start )
{
	queueLock.lock();
	QUpdItem *item = (QUpdItem*) queue[j->qItemId];
	if (start)
		item->startExpiring(j->partId);
	else item->stopExpiring(j->partId);
	queueLock.unlock();
	
}


void QMgr::finished( Job * j )
{
	//This sucks (a little less)
// 	kdDebug() << "finished\n";
	
	threads[j->qId][j->threadId]->resetRetryCounter();
	
	queueLock.lock();
		if (j->jobType==Job::GetPost ) {
		QPostItem *qp = (QPostItem*) queue[j->qItemId];
		qp->finished(j->partId);
		updateSaveItem(j->qItemId, j->partId, QItem::Finished_Part, qp->curPostLines);
		//Remove from the queue...
		(*servers)[j->qId]->size-=j->artSize;
// 		threads[j->qId][j->threadId]->stop();
// 		emit sigThreadFinished(j->qId, j->threadId);
		
// 		emit threadFinished();
		} else if (j->jobType == Job::UpdHead) {
			if (queue[j->qItemId]->parts[j->partId]->status == QItem::Requeue_Part) {
				j->status = Job::Queued_Job;
				kdDebug() << "Requeing!\n";
				queue[j->qItemId]->requeue(j->partId);
			} else if ( queue[j->qItemId]->finished(j->partId) ) {
				queueLock.unlock();
				emit sigUpdateFinished(j->ng);
				queueLock.lock();
				moveItem(queue[j->qItemId]);
			}
		} else if (j->jobType == Job::GetList) {
			if (queue[j->qItemId]->finished(j->partId)) {
				moveItem(queue[j->qItemId]);
			}
			
		}

	queueLock.unlock();
	emit threadFinished();

	
	
	
// 	qDebug("Exiting QMgr::finished()");

}

void QMgr::cancel(Job *j)
{
	
// 	j->status=Job::Canceled_Job;
// 	qDebug("Canceled message received");
	queueLock.lock();
// 	if (j->jobType != Job::UpdHead) 
// 		threads[j->qId][j->threadId]->canceled();
	
// 	emit sigThreadFinished(j->qId,j->threadId);
	emit sigThreadDisconnected(j->qId, j->threadId);
	queue[j->qItemId]->canceled(j->partId);
	if (j->jobType == Job::GetPost)
		(*servers)[j->qId]->size-=j->artSize;
	
	if (queue[j->qItemId]->partsToDo == 0) {
		if (j->jobType==Job::UpdHead) {
			j->ng->stopUpdating();
			queueLock.unlock();
			emit sigUpdateFinished(j->ng);
			queueLock.lock();
		}
		if (j->jobType == Job::GetList)
			j->ag->stopUpdating();
	
		moveCanceledItem(queue[j->qItemId]);
	}
	queueLock.unlock();
	emit threadFinished();
// 	qDebug("exiting QMgr::Canceled");
}


void QMgr::comError( Job * j )
{
	//Release the job, so it's queueble by other threads
	queueLock.lock();
	queue[j->qItemId]->comError(j->partId);
	
	
	//Pause the thread...
// 	threads[j->qId][j->threadId]->comError();
	queueLock.unlock();
	if (j->jobType == Job::UpdHead)
		downloadFinished(j);
	
	emit threadFinished();
	
	
	
}

void QMgr::downloadError( Job *j )
{

	//Only if response == nosuchgroup -> don't update the db!
	//Remove the file and move the item...
	qDebug("Download Error");
	queueLock.lock();
	QFile::remove(j->fName);
	
	switch (queue[j->qItemId]->error(j->partId, j->error)) {
		case QItem::Finished:
			queueLock.unlock();
			emit sigUpdateFinished(j->ng);
			queueLock.lock();
			moveItem(queue[j->qItemId]);
			
			break;
		case QItem::Continue:
			//Do nothing?
			break;
	}
	queueLock.unlock();

	
	
}



void QMgr::upDbErr( Job * j )
{
	QFile::remove(j->fName);
	queueLock.lock();
	j->error="Error updating Db!";
	switch (queue[j->qItemId]->error(j->partId, j->error)) {
		case QItem::Finished:
			queueLock.unlock();
			emit sigUpdateFinished(j->ng);
			queueLock.lock();
			moveItem(queue[j->qItemId]);
			
			break;
		case QItem::Continue:
			//Do nothing?
			break;
	}
	queueLock.unlock();
	
}


void QMgr::error( Job * j )
{
	
	
	threads[j->qId][j->threadId]->resetRetryCounter();
	if (j->jobType== Job::GetPost)
		(*servers)[j->qId]->size-=j->artSize;
	else if (j->jobType == Job::UpdHead)
		QFile::remove(j->fName);
	
	queueLock.lock();
	switch (queue[j->qItemId]->error(j->partId, j->error)) {
		case QItem::Finished:
			//Move item out of the q
			if (j->jobType == Job::UpdHead || j->jobType == Job::GetList ) {

				if (j->jobType == Job::UpdHead) {
					queueLock.unlock();
					emit sigUpdateFinished(j->ng);
					queueLock.lock();
				}
				moveItem(queue[j->qItemId]);
				
			} 
			break;			
		case QItem::Continue:
			//Continue as usual, but save the status of the part...
			if (j->jobType == Job::GetPost)
				updateSaveItem(j->qItemId, j->partId, QItem::Failed_Part, ((QPostItem*) queue[j->qItemId])->curPostLines );
			break;
		case QItem::RequeMe:
			//Delete the item, the job and requeue it...sic!
			kdDebug() << "QMgr::error() : requeue!\n";
			requeue(j);
			break;
		default:
			qDebug("Error: should not be here");
	}
	queueLock.unlock();
	
	emit threadFinished();
}


//when a thread finished, I have to reprocess the queues, to:
//1) process next job in the q where the thread finished...
//2) start a ng updating job (updating jobs are sequential for now, sorry...)

void QMgr::slotThreadFinished( )
{
	//check for thread deletion
	
	
	
// 	qDebug("QMgr::slotThreadFinished()");
// 	QMap<int, Queue>::iterator qit;
	QMap<int, QueueList>::iterator it;
	
	
	
	for (it=queueItems.begin(); it != queueItems.end(); ++it) {
// 		qDebug("thread finished, processing q...");
		if (!queueItems[it.key()].isEmpty())
			emit newItem(it.key()); //This calls slotProcessQueue.
	}
// 	qDebug("Exiting QMgr::slotThreadFinished()");
	
	
	
}

void QMgr::addDecodeItem( QPostItem * item )
{

	decodeListLock.lock();

	decodeList.append(item);

	decodeListLock.unlock();

	
	if (!decodeThread->running())
		decodeThread->start();
}


void QMgr::slotSelectionChanged( )
{
	
	/*
	//Old version, before discovering setSelectable() :)
	bool selected=false;
	QPtrList<QListViewItem> selection=queueList->selectedItems();
	QPtrListIterator<QListViewItem> it(selection);
	
	while (it.current()) {
				
		if (it.current()->depth() != 0) {
			it.current()->setSelected(FALSE);
			
		} else selected=true;
		++it;
		
	}
	emit sigItemsSelected(selected);
	*/
	QPtrList<QListViewItem> selection=queueList->selectedItems();
	
	emit sigItemsSelected(!selection.isEmpty());
	
}


void QMgr::slotItemMoved( QListViewItem *item, QListViewItem* afterFirst, QListViewItem *afterNow ) {
	//Now I have to move only the pointers in the queueList, and not the jobs...pheww! :)
	
	queueLock.lock();
	int itemIndex=item->text(0).toInt();
	QItem *qItem=queue[itemIndex];
	QValueList<int>::iterator it;
	QMap<int, bool>::iterator sit;
	int newItemIndex;
	bool up;
	int qId;
	int afterIndex;
	if (item->depth() != 0)
		return;
	
	if (afterNow) { //Item is not in the first place of the list...
		if (afterNow->depth() != 0) {
			afterNow=afterNow->parent();
			afterNow->takeItem(item);
			queueList->insertItem(item);
			item->moveItem(afterNow);
		}
		
		afterIndex=afterNow->text(0).toInt();
// 		qDebug("Afterindex: %d", afterIndex);
		if (afterFirst) {
			// Find the index to decide if the item has been moved up or down
			int afterFirstIndex=afterFirst->text(0).toInt();
			if (queueView.findIndex(afterFirstIndex) > queueView.findIndex(afterIndex)) {
				//moved up
				up=true;
				qDebug("Moved up");

			} else {
				up=false; //moved down
				qDebug("Moved down");

			}
		} else up=false; //AfterFirst= NULL -> Moved from the top of the list
		
		for (sit=qItem->queuePresence.begin(); sit != qItem->queuePresence.end(); ++sit) {
			if (sit.data() == false)
				continue;
			//ok, now find where the hell I have to put the item....
			qId=sit.key();
			newItemIndex=findIndex(qId, afterIndex ,up);
// 			qDebug("NewItemIndex: %d", newItemIndex);
			
			if(newItemIndex != -1) {
// 				qDebug("Queueindex != 0");
				queueItems[qId].remove(itemIndex);
				it=queueItems[qId].find(afterIndex);
				++it;
				queueItems[qId].insert(it,itemIndex);
// 				qDebug("Queue: %d", qId);
// 				for (it=queueItems[qId].begin(); it != queueItems[qId].end(); ++it)
// 					qDebug("%d", *it);
				
			} else if (up) {
				//Move to the top of the queue....
				
				queueItems[qId].remove(itemIndex);
				queueItems[qId].prepend(itemIndex);
// 				for (it=queueItems[qId].begin(); it != queueItems[qId].end(); ++it)
// 					qDebug("%d", *it);
				
				
			} else {
				//Move to the bottom...
				queueItems[qId].remove(itemIndex);
				queueItems[qId].append(itemIndex);
// 				for (it=queueItems[qId].begin(); it != queueItems[qId].end(); ++it)
// 					qDebug("%d", *it);
			}
			
			
			
			
			
			
		}
		
		queueView.remove(itemIndex);
		it=queueView.find(afterIndex);
		++it;
		queueView.insert(it,1,itemIndex);
		
		
		
		
	} else { //Item is first-in-the-list :)
// 		qDebug("Moved to top");
		
		for (sit=qItem->queuePresence.begin() ; sit != qItem->queuePresence.end() ; ++sit) {
			qId=sit.key();
// 			qDebug("Presence in queue: %d", sit.key());
// 			qDebug("Before moving:");
			if (qItem->queuePresence[qId] == true) {
	// 			for (it=queueItems[qId].begin(); it != queueItems[qId].end(); ++it)
	// 				qDebug("%d", *it);
				queueItems[qId].remove(itemIndex);
				queueItems[qId].prepend(itemIndex);
	// 			qDebug("After moving:");
	// 			qDebug("Queue %d:", sit.key());
	// 			for (it=queueItems[qId].begin(); it != queueItems[qId].end(); ++it)
	// 				qDebug("%d", *it);
			}
			
			
			
		}
		queueView.remove(itemIndex);
		queueView.prepend(itemIndex);
		
		
		
	}
	queueLock.unlock();
	emit threadFinished();
		
	
	
}




int QMgr::findIndex( int qId, int itemAfter, bool up)
{
	if (queueItems[qId].contains(itemAfter)) {
		//
// 		qDebug("Ok, contained");
		return queueItems[qId].findIndex(itemAfter);
		
	} else {
		//Worst case:
		//we have to find the jobs travelling in the queue...
		//1: Find the item
		QValueList<int>::iterator it=queueView.find(itemAfter);
		if (up) {		
			while(it != queueView.begin()) {
				--it;
				if(queueItems[qId].contains(*it)) {
					//FOUND! find last job & return it
					return queueItems[qId].findIndex(*it);
				}
				
			}
		} else {
			while (it != queueView.end()) {
				++it;
				if (queueItems[qId].contains(*it)) {
					return queueItems[qId].findIndex(*it);
				}
			}
		}
		//If I reach this point, no jobs are found->return 0, meaning we got to move
		//The jobs to the top of the q...
		return -1;
		
		
		
		
	}
	
	
}

//Returns the index of the last item's job inside the queue...



QMgr::~QMgr()
{
	if (saveQThread->running())
		saveQThread->wait();
	delete saveQThread;
	qDb->close(0);
	delete qDb;
	
	delete nzbGroup;
	
	ThreadMap::iterator tit;
	QueueThreads::iterator qit;
	for (qit=threads.begin(); qit != threads.end(); ++qit) {
		for (tit=qit.data().begin(); tit != qit.data().end(); ++tit) {
			
				
				tit.data()->kill();
			
				
			
			delete tit.data();
		}
		qit.data().clear();
		
	}
	threads.clear();
	if (decodeThread)
		delete decodeThread;
	
	
	
}

void QMgr::customEvent( QCustomEvent * e)
{
	NntpThreadEvent *nte;
    DecodeThreadEvent *dte;
	UpdateDbThreadEvent *ude;
	SaveQThreadEvent *sqe;
	
	switch (e->type()) {
		case SAVEQTHREADEVENT:
			sqe = (SaveQThreadEvent*) e;
			switch (sqe->event) {
				case SaveQThreadEvent::SQT_DelNZB:
					qDebug("Delete nzb");
					delNzbItem(sqe->nzbIndex);
					break;
				case SaveQThreadEvent::SQT_Error:
					kdDebug() << "Error saving queue!\n";
					qDebug("Error saving queue!");
					writeError(0);
					break;
			}
			break;
		case DECODETHREADEVENT:
			dte=(DecodeThreadEvent*) e;
			if (dte->diskErr)
				writeError();
			else decodeFinished(dte->item, dte->ok, dte->fileName,  dte->error);
			break;
		case UPDATEDBTHREADEVENT:
			ude=(UpdateDbThreadEvent*) e;
			switch(ude->type) {
				case UpdateDbThreadEvent::UpDb_Working:
					update(ude->j, ude->partial, ude->total,0);
					break;
				case UpdateDbThreadEvent::UpDb_startExp:
					startExpiring(ude->j);
// 					qDebug("Start expiring...");
					break;
				case UpdateDbThreadEvent::UpDb_startUpd:
// 					qDebug("Start updating db...");
					startUpdatingDb(ude->j);
					break;
				case UpdateDbThreadEvent::UpDb_stopUpd:
					switch (ude->j->status) {
						case Job::Failed_Job:
							error(ude->j);
							break;
						case Job::Canceled_Job:
							cancel(ude->j);
							break;
						default:
							kdDebug() << "Finished updating\n";
							finished(ude->j);
							break;
					}
					break;
				case UpdateDbThreadEvent::UpDb_Err:
					qDebug("Error updating Db");
					upDbErr(ude->j);
					break;
					
			}
			
			break;

		case NNTPTHREADEVENT:
			nte=(NntpThreadEvent *) e;
				switch (nte->type) {
				case NntpThreadSocket::Working:
	
					update(nte->job, nte->m_lines, nte->m_totalLines, nte->m_partialLines);
					
					break;
				case NntpThreadSocket::Finished:
	
					finished(nte->job);
					break;
				case NntpThreadSocket::Canceled:
					cancel(nte->job);
	
					break;
				case NntpThreadSocket::Delayed_Delete:
					delayedDelete(nte->m_totalLines, nte->m_lines);
					break;	
				case NntpThreadSocket::Err:
// 					qDebug("customEvent(): Error received");
					switch (nte->err) {
						case NntpThreadSocket::NoSuchArticle_Err:
						case NntpThreadSocket::NoSuchGroup_Err:
// 							qDebug("Error: %d", nte->err);
							kdDebug() << "QMgr::customEvent(): no such article error\n";
							error(nte->job);
							
							break;
						case NntpThreadSocket::Write_Err:
							writeError(nte->job);
							break;
						default:
							comError(nte->job);
						 break;
					}
					
					break;
				case NntpThreadSocket::Ready:
					//Stop the threads...
// 					qDebug("QMgr::customEvent(): stop %d,%d received", nte->m_totalLines, nte->m_lines);
					stopped(nte->m_totalLines, nte->m_lines);
					break;
				case NntpThreadSocket::Paused:
// 					qDebug("Paused without error");
					paused(nte->m_totalLines, nte->m_lines, false);
					break;
				case NntpThreadSocket::PausedOnError:
// 					qDebug("Paused on error");
					paused(nte->m_totalLines, nte->m_lines, true);
					break;
				case NntpThreadSocket::StartedWorking:
					started(nte->m_totalLines, nte->m_partialLines);						
					break;
				case NntpThreadSocket::Start:
					
					start(nte->job);
					
					break;
				case NntpThreadSocket::Expiring:
					expiring(nte->job, nte->m_lines);
					break;
				case NntpThreadSocket::DownloadFinished:
					downloadFinished(nte->job);
					break;
				case NntpThreadSocket::DownloadCanceled:
					downloadCanceled(nte->job);
					break;
				case NntpThreadSocket::DownloadError:
					qDebug("download error");
// 					downloadError(nte->job);
					switch (nte->err) {
						case NntpThreadSocket::NoSuchGroup_Err:
							kdDebug() << "Nosuchgroup_err\n";
							downloadError(nte->job);
							break;
						case NntpThreadSocket::Write_Err:
							//Argh...
							qDebug("Write error during header update");
							downloadError(nte->job);
							//Pause the queue...
							writeError();
							break;
						default:
							kdDebug() << "comErr while updating\n";
							comError(nte->job);
						
							

							break;
					}
					break;
				
					
						
				default:
					break;
							
					
			}
			break;
		default:
		break;
	}
	
}

/*
void QMgr::slotThreadSpeedChanged( int serverId, int threadId, int speed)
{
	emit sigSpeedChanged(serverId, threadId, speed);
}*/

void QMgr::slotPauseSelected( )
{
	QPtrList<QListViewItem> selection=queueList->selectedItems();
	QPtrListIterator<QListViewItem> it(selection);
	while(it.current()) {
		queueLock.lock();
		QItem *item=queue[it.current()->text(0).toInt()];
		QMap<int, Part*>::iterator pit;
		item->listItem->setText(2, "Paused");
		for (pit=item->parts.begin(); pit != item->parts.end(); ++pit) {
			
			Part *part=pit.data();
			if (part->job->status==Job::Queued_Job) {
				part->job->status=Job::Paused_Job;
				item->paused(part->job->partId); //ugly
			}
		}
		queueLock.unlock();
		++it;
	}
}

void QMgr::slotResumeSelected( )
{
	QPtrList<QListViewItem> selection=queueList->selectedItems();
	QPtrListIterator<QListViewItem> it(selection);
	while(it.current()) {
		queueLock.lock();
		QItem *item=queue[it.current()->text(0).toInt()];
		if (item->workingThreads==0)
			item->listItem->setText(2, "Queued");
		
		QMap<int, Part*>::iterator pit;
		for (pit=item->parts.begin(); pit != item->parts.end(); ++pit) {
			
			Part *part=pit.data();
			if (part->job->status==Job::Paused_Job) {
				part->job->status=Job::Queued_Job;
				item->resumed(part->job->partId); //ugly
			}
		}
		queueLock.unlock();
		
		++it;
	}
	emit threadFinished();
	
}

void QMgr::slotCancelSelected( )
{
	QPtrList<QListViewItem> selection=queueList->selectedItems();
	QPtrListIterator<QListViewItem> it(selection);
	
	queueLock.lock();
	while(it.current()) {
		
		QItem *item=queue[it.current()->text(0).toInt()];
		QMap<int, Part*>::iterator pit;
		NewsGroup *ng=0;
		Part *part;
		
		for (pit=item->parts.begin(); pit != item->parts.end(); ++pit) {
// 			queueLock.lock();
			
			part=pit.data();
			
			if (part->job->status==Job::Queued_Job || part->job->status == Job::Paused_Job) {
				part->job->status=Job::Canceled_Job;
				if (part->job->jobType == Job::GetPost)
					(*servers)[part->job->qId]->size-=part->job->artSize;
				item->canceled(part->job->partId); //ugly
				ng=part->job->ng;
// 				part->job->status=Job::Canceled_Job;
// 				part->listItem->setText(2, "Canceled job");
			}
			else if (part->job->status==Job::Processing_Job) {
// 				qDebug("Job is running: %d", part->job->id);
// 				qDebug("cancelling thread...");
				part->listItem->setText(2, "Canceling job...");
				threads[part->job->qId][part->job->threadId]->threadCancel();
				emit sigThreadCanceling(part->job->qId, part->job->threadId);
				
			}
			
		}
		if (item->partsToDo == 0) {
			if (item->type == Job::UpdHead) {
				queueLock.unlock();
				emit sigUpdateFinished(ng);
				queueLock.lock();
			}
			moveCanceledItem(item);
		}
		
		++it;
		
	}
	queueLock.unlock();
	
}



void QMgr::decodeFinished( QPostItem *item, bool ok, QString fileName, QString err )
{
// 	item->decodeFinished();
	//Finished decodeding, remove the item, delete the jobs, remove from the list...
	//ARGH!
	kdDebug() << "QMgr::decodeFinished()\n";
	//Only if it's a nzb part...hmmmm
// 	delNzbItem(item->post->getSubj().simplifyWhiteSpace() + item->post->getFrom());
	delSaveItem(item->qItemId);
	queueLock.lock();
	QString fileWithPath;
	if (!fileName.isNull()) {
		fileWithPath=item->getSavePath();
		fileWithPath += fileName;
	} else {
		fileWithPath="No file decoded";
	}
	//so I can unlock the queue before viewing the file...
	bool view = item->view;
	
	queue.remove(item->qItemId);
	
	
// 	QValueList<int>::iterator it;
// 	it=queueView.find(item->qItemId);
	queueView.remove(item->qItemId);
	
	KListViewItem *temp, *child, *after=0;
	if ( item->failedParts == 0 && ok)
		temp = new KListViewItem(doneList, doneList->lastChild());
	else temp=new KListViewItem(failedList, failedList->lastChild());
	temp->setText(0, QString::number(item->qItemId));
	temp->setText(1, item->listItem->text(1));
	if (ok)
		temp->setText(2, "Decoded to " + fileWithPath);
	else {
		if (!fileName.isEmpty())
			temp->setText(2, "Error decoding " + fileWithPath + ": " + err);
		else temp->setText(2, err);
	}
	QFile::remove(item->getFName());
	QMap<int, Part*>::iterator pit;
	for (pit=item->parts.begin(); pit != item->parts.end(); ++pit) {
		//Delete from the queues...
		queueItems[pit.data()->qId].remove(item->qItemId);
		//delete the file
		
		QString file=item->getFName() + '.' + QString::number(pit.key());
		QFile::remove(file);
		
		//delete the jobs...
// 		queues[pit.data()->qId].remove(pit.data()->job);
		if (temp->childCount() == 0)
			child=new KListViewItem(temp);
		else child=new KListViewItem(temp, after);
		
		
		
		child->setText(0, QString::number(pit.data()->jobId));
		child->setText(1, pit.data()->desc);
		if (pit.data()->status == QItem::Failed_Part)
			child->setText(2, pit.data()->job->error);
		else child->setText(2, "Done");
		after=child;
		delete pit.data()->job;
		//delete the part...
		delete pit.data();
		
		
	}
	item->parts.clear();
	
	
	//Debug!
// 	QValueList<int>::iterator it;
// 	qDebug("Items in queue:");
// 	for (it=queueView.begin(); it != queueView.end(); ++it) {
// 		qDebug("item: %d", *it);
// 	}
	//End debug
	
	
// 	delete item->listItem;
// 	delete item->deletePost();
	
	queueList->setSelected(item->listItem, false);
	queueSize-=item->post->size;
// 	delete item->post;
	delete item;
	queueCount--;
	
	queueLock.unlock();
	
	if (!ok && Config().deleteFailed)
		QFile::remove(fileWithPath);
	else if (view && !fileName.isEmpty())
		emit (viewItem(KURL::fromPathOrURL(fileWithPath)));
	
	emit queueInfo(queueCount, queueSize);
	
}

void QMgr::moveItem( QItem *item )
{
// 	qDebug("Moving");
	
	queue.remove(item->qItemId);
// 	QValueList<int>::iterator it;
// 	it=queueView.find(item->qItemId);
	queueView.remove(item->qItemId);
	
	KListViewItem *temp = NULL, *child = NULL, *after = NULL;
	if ( item->failedParts == 0)
		temp = new KListViewItem(doneList, doneList->lastChild());
	else temp=new KListViewItem(failedList, failedList->lastChild());
	temp->setText(0, QString::number(item->qItemId));
	temp->setText(1, item->listItem->text(1));
	if (item->failedParts == 0)
		temp->setText(2, "Done");
	else temp->setText(2, QString::number(item->failedParts) + " Failed part(s)");
	
	QMap<int, Part*>::iterator pit;
	//Delete from the queues...
	
	for (pit=item->parts.begin(); pit != item->parts.end(); ++pit) {
		
		//delete the jobs...
// 		queues[pit.data()->qId].remove(pit.data()->job);
		if (temp->childCount()==0)
			child=new KListViewItem(temp);
		else child=new KListViewItem(temp, after);
		if (item->queuePresence[pit.data()->qId] == true) {
			queueItems[pit.data()->qId].remove(item->qItemId);
			item->queuePresence[pit.data()->qId]=false;
		}
		
		child->setText(0, QString::number(pit.data()->jobId));
		child->setText(1, pit.data()->desc);
		if (pit.data()->status == QItem::Failed_Part) {
			child->setText(2, pit.data()->job->error);
		} else child->setText(2, "Done");
		after=child;
				
		
			
			
		delete pit.data()->job;
		//delete the part...
		delete pit.data();
		
		
	}
	item->parts.clear();
	
	
	
	
	//Debug!
// 	QValueList<int>::iterator it;
// 	qDebug("Items in queue:");
// 	for (it=queueView.begin(); it != queueView.end(); ++it) {
// 		qDebug("item: %d", *it);
// 	}
	//End debug
	
	
// 	delete item->listItem;
// 	delete item->deletePost();
	queueList->setSelected(item->listItem, false);
	queueCount--;
	delete item;
	emit queueInfo(queueCount, queueSize);
	
}

void QMgr::requeue( Job * j )
{
// 	qDebug("Requeueing!");
	QPostItem* item;
	bool found=false;
	
	//Delete the job from the server queue
	
	int newServerId;
	// Check if there are other item's part on the server q. If not,
	// delete the item from the server's queue.
	item=(QPostItem*)queue[j->qItemId];
	QMap<int, Part*>::iterator pit;
	for (pit=item->parts.begin() ; pit != item->parts.end(); ++pit) {
		if (pit.data()->qId == j->qId && pit.key() != j->partId ) {
			found=true;
			break;
		}
		
	}
	if (!found) {
		kdDebug() << "No other items found; removing " << item->qItemId << endl;
		queueItems[j->qId].remove(item->qItemId);
		//serverPrecence on the item???
		item->queuePresence[j->qId] = false;
	} //else qDebug("Other items in this q, keeping...");
	
	newServerId=chooseServer(item->post, j->partId );
	qDebug("New serverId: %d", newServerId);
// 	kdDebug() << "new server: " << newServerId << endl;
	
	//Find the index for the new item....to do so, we:
	//First, check if there are other jobs for this item in the server's q.
	//If no job is found, we put the job immediately after the last job of
	//the previous item
	
	found = false;
	//Very boring, silly, and convoluted. But should work...
	if (item->queuePresence[newServerId] == false ) {
		//Gotta add the item to the server's queue, possibly in the right place...
// 		kdDebug() << "Presence on new server: false\n";
		qDebug("Presence on new server: false");
		
		QValueList<int>::iterator it=queueView.find(item->qItemId);
		while (it != queueView.begin()) {
// 			qDebug("Not first");
			kdDebug() << "Finding in queueView?\n";
			--it;
			kdDebug() << "Looking for " << *it << endl;
			if ( queueItems[newServerId].contains(*it) ) {
// 				//Ok, got the item. Now find index and insert the item
				found=true;
				kdDebug() << "Found in queueview\n";
				
// 				newIndex=findLastJob(newServerId, queue[*it]);
				//Insert the item in the queueItems
				//Dangerous?
				
				it=queueItems[newServerId].find(*it);
				queueItems[newServerId].insert(it, item->qItemId);
// 				item->queuePresence[newServerId]=true;			
				break;
								
			
			} 
		}
		if (!found) {
			//insert at the top...
// 			kdDebug() << "Inserted at the top of the list\n";
			qDebug("Inserted at the top of the list");
			queueItems[newServerId].prepend(item->qItemId);
// 			item->queuePresence[newServerId]=true;
					
// 			QueueList::iterator qit;
			
			
			
		}
		item->queuePresence[newServerId]=true;
		QueueList::iterator qit;
		for (qit=queueItems[newServerId].begin(); qit != queueItems[newServerId].end(); ++qit)
			kdDebug() << "Queue: " << newServerId << " item: " << *qit << endl;
		
	} else kdDebug() << "item " << item->qItemId << "is already in queue " << newServerId << endl;
	
	//Now change the job (finally! :)
	
	j->qId=newServerId;
	j->nh=(*servers)[newServerId];
	j->tries=(*servers)[newServerId]->retries;
	j->nh->size+=j->artSize;
	j->artNum=item->post->partNum[j->partId][newServerId];
	queue[j->qItemId]->parts[j->partId]->qId=newServerId;
	queue[j->qItemId]->parts[j->partId]->status=QItem::Queued_Part;
	j->status=Job::Queued_Job;
	queue[j->qItemId]->parts[j->partId]->listItem->setText(2, "Requeued on " + (*servers)[j->qId]->name );
	queue[j->qItemId]->parts[j->partId]->listItem->setText(3, "");
	
	
	//debug
// 	qDebug("New queue:");
// 	Job* debug;
// 	for (debug=queues[newServerId].first(); debug; debug = queues[newServerId].next())
// 		qDebug("Id: %d", debug->id);
	
	
	
}

void QMgr::pauseQ( bool p)
{
	ThreadMap::iterator it;
	QueueThreads::iterator qit;
	
	if (p) {
		qDebug("Pausing queue");
		queuePaused=true;
		for (qit=threads.begin(); qit != threads.end() ; ++qit) {
			for (it= qit.data().begin(); it != qit.data().end(); ++it)
				it.data()->pause();
		}
		
	}
	
	else { 
		qDebug("Resume queue");
		queuePaused=false;
		
		for (qit=threads.begin(); qit != threads.end() ; ++qit) {
			for (it= qit.data().begin(); it != qit.data().end(); ++it)
				it.data()->resume();
		}
		if (diskError) {
			//Start decode and upd threads...
			if ( ! decodeThread->running())
				decodeThread->start();
// 			if ( ! updateDbThread->running())
// 				updateDbThread->start();
			diskError=false;
		}
// 		emit threadFinished();
	}
}

void QMgr::moveCanceledItem( QItem *item )
{
// 	qDebug("MoveCanceledItem");
	queue.remove(item->qItemId);
// 	QValueList<int>::iterator it;
// 	it=queueView.find(item->qItemId);
	queueView.remove(item->qItemId);
	
	if (item->type == Job::GetPost) {
		//Delete files
		QFile::remove(((QPostItem*)item)->getFName());
		queueSize-=((QPostItem*)item)->post->size;
		
// 		delNzbItem(((QPostItem*)item)->post->getSubj().simplifyWhiteSpace() + 
// 				((QPostItem*) item)->post->getFrom());
		delSaveItem(item->qItemId);
	}
	queueCount--;
	
	KListViewItem *temp, *child, *after=0;
	temp=new KListViewItem(failedList, failedList->lastChild());
	temp->setText(0, QString::number(item->qItemId));
	temp->setText(1, item->listItem->text(1));
	temp->setText(2, "User Cancel");
	
	QMap<int, Part*>::iterator pit;
	for (pit=item->parts.begin(); pit != item->parts.end(); ++pit) {
		//Delete from the queues...
		if (item->type == Job::GetPost) {
			QString fileName=((QPostItem*)item)->getFName() + '.' + QString::number(pit.key());
			QFile::remove(fileName);
		}
		queueItems[pit.data()->qId].remove(item->qItemId);
		//delete the jobs...
// 		queues[pit.data()->qId].remove(pit.data()->job);
		if (temp->childCount()==0)
			child=new KListViewItem(temp);
		else child=new KListViewItem(temp, after);
		
		child->setText(0, QString::number(pit.data()->jobId));
		child->setText(1, pit.data()->desc);
		child->setText(2, "Canceled");
		after=child;
				
		
			
			
		delete pit.data()->job;
		//delete the part...
		delete pit.data();
		
		
	}
	item->parts.clear();
	
	
	
	
	//Debug!
// 	QValueList<int>::iterator it;
// 	qDebug("Items in queue:");
// 	for (it=queueView.begin(); it != queueView.end(); ++it) {
// 		qDebug("item: %d", *it);
// 	}
	//End debug
	
	
// 	delete item->listItem;
// 	delete item->deletePost();
	
	queueList->setSelected(item->listItem, false);
	
	delete item;
	emit queueInfo(queueCount, queueSize);
}

void QMgr::slotEmptyFinishedQ( )
{
	while (doneList->firstChild())
		delete doneList->firstChild();
}

void QMgr::slotEmptyFailedQ( )
{
	while (failedList->firstChild())
		delete failedList->firstChild();
}

void QMgr::slotQueueContextMenu( QListViewItem *, const QPoint &p )
{
	emit sigShowQueueMenu(p);
}

void QMgr::slotFinishedContextMenu( QListViewItem *, const QPoint &p )
{
	emit sigShowFinishedMenu(p);
}

void QMgr::slotFailedContextMenu( QListViewItem *, const QPoint &p )
{
	emit sigShowFailedMenu(p);
}

void QMgr::slotMoveSelectedToTop( )
{
	QPtrList<QListViewItem> selection=queueList->selectedItems();
	QPtrListIterator<QListViewItem> it(selection);
	it.toLast();
	
	
	while(it.current()) {
		
		queueList->takeItem(*it);
		queueList->insertItem(*it);
		slotItemMoved(*it, 0,0 );
		
		
		--it;
	}
	
	
}

void QMgr::slotMoveSelectedToBottom( )
{
}

/*
void QMgr::slotThreadDisconnected( int serverId, int threadId)
{
	emit sigThreadDisconnected(serverId, threadId);
}*/

void QMgr::addServerQueue( NntpHost *nh )
{
	//Create the empty q
 	queueItems[nh->id];
	//create the threads...

	for (int i = 1; i <= nh->maxThreads; i++) {
		
		
		threads[nh->id].insert(i, new Thread(nh->id, i, nh->timeout, nh->threadTimeout, this ));
// 		connect(threads[nh->id][i], SIGNAL(sigThreadSpeedChanged(int,int,int)), this, SLOT(slotThreadSpeedChanged(int, int, int )));
		connect(threads[nh->id][i], SIGNAL(sigThreadSpeedChanged(int,int,int)), this, SIGNAL(sigSpeedChanged(int, int, int )));
// 		connect(threads[nh->id][i], SIGNAL(sigThreadDisconnected(int, int)), this, SLOT(slotThreadDisconnected(int, int )));
		connect(threads[nh->id][i], SIGNAL(sigThreadDisconnected(int, int)), this, SIGNAL(sigThreadDisconnected(int, int )));
		connect(threads[nh->id][i], SIGNAL(sigThreadResumed()), this, SLOT(slotResumeThreads()));
		connect(threads[nh->id][i], SIGNAL(sigThreadPaused(int, int, int)), this, SIGNAL(sigThreadPaused(int, int, int)));
		threads[nh->id][i]->setQueue(&(queueItems[nh->id]), &queue, &queueLock, &pendingOperations[nh->id]);
		
	}
	
	
}

void QMgr::slotAddServer( NntpHost *nh )
{
	
	addServerQueue(nh);
}

void QMgr::slotAddThread( int serverId , int threadId )
{
	threads[serverId].insert(threadId, new Thread(serverId, threadId, ((*servers)[serverId])->timeout, ((*servers)[serverId])->threadTimeout,this));
	connect(threads[serverId][threadId], SIGNAL(sigThreadSpeedChanged(int, int, int)), this, \
			SIGNAL(sigSpeedChanged(int, int, int )));
	connect(threads[serverId][threadId], SIGNAL(sigThreadDisconnected(int, int)), this, SIGNAL(sigThreadDisconnected(int, int )));
	connect(threads[serverId][threadId], SIGNAL(sigThreadResumed()), this, SLOT(slotResumeThreads()));
	connect(threads[serverId][threadId], SIGNAL(sigThreadPaused(int, int, int)), this, SIGNAL(sigThreadPaused(int, int, int)));
	threads[serverId][threadId]->setQueue(&(queueItems[serverId]), &queue, &queueLock, &pendingOperations[serverId]);
	
	emit threadFinished();
}

void QMgr::slotDeleteThread( int serverId)
{
	ThreadMap::iterator it;
	int deleted=0; //threads starts at one...
	for (it = threads[serverId].begin(); it != threads[serverId].end(); ++it) {
		
		if (!it.data()->isActive() ) {
			//can safely delete the thread...
			deleted = it.key();
			
			delete (it.data()); //delete thread
			threads[serverId].remove(it);
			
			//Now move other threads...
			//Hhmmmm...disabled for now
			/*
			ThreadMap::iterator moveIterator = it;
			++moveIterator;
			while (moveIterator != threads[serverId].end()) {
				
				it.data()=moveIterator.data();
				
				++it;
				++moveIterator;
				
				
				
				
			}
			threads[serverId].remove(it);
			*/
			break;
			
		}
		
		
			
	}
// 	qDebug("thread list:");
	for (it = threads[serverId].begin(); it != threads[serverId].end(); ++it) {
		qDebug("id: %d", it.key());
	}
// 	qDebug("Total #: %d", threads[serverId].count());
	if (deleted) {
		emit sigThreadDeleted(serverId, deleted);
		return;
	}
		
	//Else, do a delayed delete (sic)
	
	pendingOperations[serverId]++;
	
	
	
	
	
	
}

void QMgr::enable( bool b)
{
	if (b) {
		queueList->setCursor(KCursor::arrowCursor());
		doneList->setCursor(KCursor::arrowCursor());
		failedList->setCursor(KCursor::arrowCursor());
		setCursor(KCursor::arrowCursor());
		
	} else {
		queueList->setCursor(KCursor::waitCursor());
		doneList->setCursor(KCursor::waitCursor());
		failedList->setCursor(KCursor::waitCursor());
		setCursor(KCursor::waitCursor());
	}
// 	queueList->setEnabled(b);
// 	doneList->setEnabled(b);
// 	failedList->setEnabled(b);
// 	setEnabled(b);
}

bool QMgr::empty( )
{
	QMap<int, QueueList>::iterator it;
	for (it = queueItems.begin(); it != queueItems.end(); ++it) {
		if (!it.data().isEmpty())
			return false;
	}
	return true;
}

void QMgr::downloadFinished( Job *j )
{
	kdDebug() << "DownloadFinished\n";
	//Adds the job to the updatedb queue
	queueLock.lock();
	j->status=Job::Updating_Job;
	queueLock.unlock();
	updateListLock.lock();
	updateJobList.append(j);
	updateListLock.unlock();
	
	if (!updateDbThread->running())
		updateDbThread->start();
	((QUpdItem*)queue[j->qItemId])->downloadFinished(j->partId);
	
// 	emit sigThreadFinished(j->qId, j->threadId);
	
	
	emit threadFinished();
	
}

//Now, if I cancel a download, I have to put the headers in the db...

void QMgr::downloadCanceled( Job *j )
{
// 	j->status=Job::Canceled_Job;
	//If an update job is cancceled, DO NOT merge into the Db...
	/*
	updateListLock.lock();
	updateJobList.append(j);
	updateListLock.unlock();
	
	if (!updateDbThread->running())
		updateDbThread->start();
	
	threads[j->qId][j->threadId]->canceled();
// 	emit sigThreadFinished(j->qId, j->threadId);
	*/
	
	QFile::remove(j->fName);
	cancel(j);
// 	emit sigThreadDisconnected(j->qId, j->threadId);
	
	
// 	emit threadFinished();
	
}


void QMgr::slotDeleteServerQueue( int qId)
{
	//delete server queue
	queueItems.remove(qId);
	ThreadMap::iterator it;
	for (it=threads[qId].begin(); it != threads[qId].end(); ++it) 
		delete it.data();
	threads.remove(qId);
	queueItems.remove(qId);
	
}

void QMgr::startExpiring( Job * j )
{
	((QUpdItem*)queue[j->qItemId])->startExpiring(j->partId);
	
}

void QMgr::startUpdatingDb( Job * j )
{
	((QUpdItem*)queue[j->qItemId])->startUpdateDb(j->partId);
	
}

void QMgr::slotViewArticle(BinHeader *bh, NewsGroup *ng )
{
	slotAddPostItem(bh, ng, true, true);
}


void QMgr::slotResumeThreads() {
	emit threadFinished();
}

void QMgr::startAllThreads( int qId )
{
	ThreadMap::iterator it;
	for (it= threads[qId].begin(); it != threads[qId].end(); ++it) {
// 		qDebug("Starting thread %d", it.key());
		it.data()->start();
		
	}
}

void QMgr::stopped( int qId, int threadId )
{
	qDebug("%d,%d: QMgr::stopped()", qId, threadId);
	if (threads[qId][threadId]->stop())
		emit sigThreadFinished(qId, threadId);
	else {
		emit sigThreadDisconnected(qId, threadId);
		qDebug("%d,%d disconnected", qId, threadId);
	}
	

	
	
}

void QMgr::paused( int qId, int threadId, bool error )
{
		
	
	Thread *t=threads[qId][threadId];
	
	if (!error) {
		t->paused();
		emit sigThreadPaused(qId, threadId, 0);
	} else if (!diskError)
		 t->comError();
	
}

void QMgr::delayedDelete( int qId, int threadId )
{
	//Wait for termination if the thread has been preempted after sending the message...
	qDebug("Delayed delete of thread %d, %d", qId, threadId);
	threads[qId][threadId]->wait();
	delete threads[qId][threadId];
	threads[qId].remove(threadId);
	emit sigThreadDeleted(qId, threadId);
	
	
	
}


void QMgr::slotPauseThread( int qId, int threadId)
{

	threads[qId][threadId]->pause();
	
}

void QMgr::slotResumeThread( int qId, int threadId)
{
	//Resume the thread I paused...
	threads[qId][threadId]->resume();
	slotResumeThreads();
}
/*
char * QMgr::insert( QString s, char * p )
{
	int strlen=s.length();
	int suint = sizeof(strlen);
	memcpy(p, &strlen, suint);

	p+=suint;
	memcpy(p, (const char *)s, strlen);
	p+=strlen;
	return p;
}*/

char * QMgr::retrieve( char * i, QString & s )
{
	int strlen;
	int ssize=sizeof(strlen);

	char *temp;
	memcpy(&strlen, i, ssize);

	i+=ssize;
	temp=new char[strlen+1];
	memcpy(temp, i, strlen);
	temp[strlen]='\0';
	s=temp;
	delete [] temp;
	i+=strlen;
	return i;

}


QSaveItem * QMgr::loadSaveItem( char *data )
{

	char *i=&data[0];
	QSaveItem * si = new QSaveItem;
	i=retrieve(i, si->group);
	i=retrieve(i, si->index);

	i=retrieve(i, si->rootFName);
	i=retrieve(i, si->savePath);
	i=retrieve(i, si->tmpDir);
	
	int szInt=sizeof(uint);
	
	memcpy( &(si->curPostLines), i, szInt);
	i+=szInt;
	
	int count, id, status;
	
	
	memcpy(&count, i, szInt);
	i+=szInt;
	for (int j = 0; j < count ; j++) {
		memcpy(&id, i, szInt);
		i+=szInt;
		memcpy(&status, i, szInt);
		i+=szInt;
		si->partStatus.insert(id, status);
		
	}
	

	return si;
	
}




void QMgr::writeSaveItem(QSaveItem * si )
{
	sQLock.lock();
	saveQueue.append(si);
	sQLock.unlock();
	if (!saveQThread->running())
		saveQThread->start();
	
	
}


void QMgr::updateSaveItem( int id, int part, int status, uint lines  )
{
	
	QSaveItem *si = new QSaveItem;
	si->id = id;
	si->modPart = part;
	si->modStatus = status;
	si->curPostLines = lines;
	si->type = QSaveItem::QSI_Update;
	writeSaveItem(si);
}

void QMgr::setDbEnv( QString d, DbEnv * dbe, GroupList *gl )
{
	dbEnv=dbe;
	dbDir=d;
	gList=gl;
	//Open the db...
	qDb=new Db(dbEnv, 0);
	if (qDb->open(NULL, "queue" , NULL, DB_BTREE, DB_CREATE | DB_THREAD , 0644) != 0)
		kdDebug() << "Error opening queue db\n";
	nzbGroup = new NewsGroup(dbEnv, "nzb", Config().decodeDir);
	saveQThread = new SaveQThread(&saveQueue, &sQLock, qDb, this);
	
	
}

//This is called after program init...

void QMgr::checkQueue( )
{
	Dbc *cursor;
	Dbt key, data;
	key.set_flags(DB_DBT_MALLOC);
	data.set_flags(DB_DBT_MALLOC);
	uint id;
	QSaveItem *qsi;
	BinHeader* bh=0;
	QMap<uint, QSaveItem*> queueMap;

	kdDebug() << "Checking queue\n";
	
	qDb->cursor(0, &cursor, DB_WRITECURSOR);
	
// 	qDebug("Saved the following items:");
	int ret;
	bool go = false;
	while ( ( (ret=cursor->get(&key, &data, DB_NEXT)) ) ==0 ) {
		//I know, I know, this sucks :)
		if (go == false) {
			if (g_qResume == 0 && g_qDiscard == 0) {
				//ask
				switch (KMessageBox::questionYesNo(this, i18n("Found items in the download Queue from the previous session. Do you want to reload them?") , i18n("Reload download Queue?")) ) {
					case KMessageBox::Yes:
						go=true;
						//Do nothing...
						break;
					case KMessageBox::No:
						//cleanup & return
						cursor->close();
						uint *count = new uint;
						qDb->truncate(0,count,0);
						kdDebug() << "Truncated " << *count << "items from queue db\n";
						nzbGroup->getDb()->truncate(0, count, 0);
						kdDebug() << "Truncated " << *count << " items from nzb db\n";
						
						delete count;
						free(key.get_data());
						free(data.get_data());
						
						return;
						
						break;
				}
			} else if (g_qResume) {
				go = true;
			} else if (g_qDiscard) {
				cursor->close();
				uint *count = new uint;
				qDb->truncate(0,count,0);
				kdDebug() << "Truncated " << *count << "items from queue db\n";
				nzbGroup->getDb()->truncate(0, count, 0);
				kdDebug() << "Truncated " << *count << " items from nzb db\n";
						
				delete count;
				free(key.get_data());
				free(data.get_data());
						
				return;
			}
				
		}
		
		memcpy(&id, key.get_data(), sizeof(uint));
		
		if (id > nextItemId)
			nextItemId=id;
		
		qsi=loadSaveItem((char*)data.get_data());
		
		free(key.get_data());
		free(data.get_data());
		memset(&key, 0, sizeof(key));
		key.set_flags(DB_DBT_MALLOC);
		memset(&data, 0, sizeof(data));
		data.set_flags(DB_DBT_MALLOC);
		
// 		qDebug("Id: %d", id);
// 		qDebug("Newsgroup: %s", qsi->group.latin1());
// 		qDebug("index: %s", qsi->index.latin1());
// 		qDebug("rootFName: %s", qsi->rootFName.latin1());
// 		qDebug("savePath: %s", qsi->savePath.latin1());
// 		qDebug("tmpDir: %s", qsi->tmpDir.latin1());
		
// 		uchar *p=gList->getBinHeader(qsi->index, qsi->group);
		
/*		if (!p)
			qDebug("checkQueue(): error getting Binheader!!!");
		else bh=new BinHeader(p);
		
		delete p;*/
		//don't create post item from queue immediately. First, 
		//sort the queue by putting it in a QMap.

		// 		createPostItemFromQ(id, qsi, bh, gList->getNg(qsi->group));
		if (queueMap.contains(id))
			qDebug("Warning: duplicate id!!!");
		queueMap.insert(id, qsi);
		
// 		cursor->del(0);
// 		delete qsi;

		
	} if (ret != DB_NOTFOUND) {
		//Error!
		KMessageBox::error(this, i18n("The saved queue seems to be corrupted. Please exit KLibido and remove \"queue\" from the db/ dir"), i18n("Error!"));
		
	}
	cursor->close();
	//Now reload the map...
	QMap<uint, QSaveItem*>::iterator it;
	uchar *p;
	for (it=queueMap.begin(); it != queueMap.end(); ++it) {
		if (it.data()->group == "nzb") {
// 			kdDebug() << "item from a nzb post!\n";
			p=nzbGroup->getBinHeader(it.data()->index);
		}
		else {
			p=gList->getBinHeader(it.data()->index, it.data()->group);
		}
		if (!p) {
			kdDebug() << "Error getting binheader\n";
			delSaveItem(it.key());
			
		}
		else {
			bh=new BinHeader(p);
		
	// 		kdDebug() << "Reloading id: " << it.key() << " subj: " << bh->getSubj() << endl;
			delete p;
			if (it.data()->group == "nzb") {
				
				createPostItemFromQ(it.key(), it.data(), bh, nzbGroup);
				
				//BEGIN DEBUG
	// 			kdDebug() << "Binheader parts:\n";
	// 			PartMid::Iterator pit;
	// 			for (pit = bh->partMid.begin(); pit != bh->partMid.end(); ++pit) {
	// 				kdDebug() << "Part: " << pit.key() << " mid: " << pit.data() << endl;
	// 			}
				//END DEBUG
				
			} else createPostItemFromQ(it.key(), it.data(), bh, gList->getNg(it.data()->group));
			delete it.data();
			queueMap.remove(it);
		}
	}
	
	
	emit (queueInfo(queueCount, queueSize));
	
	emit threadFinished();
	
}

void QMgr::delSaveItem( int id )
{
	
	QSaveItem *qsi = new QSaveItem;
	qsi->type = QSaveItem::QSI_Delete;
	qsi->id = id;
	writeSaveItem(qsi);	
}

bool QMgr::delNzbItem( QString index )
{
	Dbt key;
	memset(&key, 0, sizeof(key));
	key.set_data( (void*)(const char *) index);
	key.set_size(index.length());
	if (nzbGroup->getDb()->del(0, &key, 0) != 0) {
		kdDebug() << "QMgr::delNzbItem(): Error deleting item from nzb db!\n";
		return false;
	} else {
// 		kdDebug() << "QMgr::delNzbItem(): nzb item deleted\n";
		nzbGroup->getDb()->sync(0);
		return true;	
	}
}


void QMgr::createPostItemFromQ(int id, QSaveItem * qsi, BinHeader * bh, NewsGroup *ng )
{
	
		Part *tPart;
		Job *tJob;
		int serverId=0;
		QString rootFName, tempDir;
		
		rootFName=qsi->rootFName;
		
		queueSize+=bh->size;
		queueCount++;
		
		
		QString dir = qsi->savePath.isNull()? ng->getSaveDir() : qsi->savePath;
		tempDir=qsi->tmpDir;
		QPostItem *qp=new QPostItem(queueList, id, bh, rootFName, dir,  0, 0 );
		queue.insert(id, qp );
		
		qp->curPostLines=qsi->curPostLines;
	
	
	
		connect(qp, SIGNAL(decodeMe(QPostItem*)), this, SLOT(addDecodeItem(QPostItem* )));
	
		QMap<int, NntpHost*>::iterator sit; //Server iterator
		for (sit =servers->begin() ; sit != servers->end() ; ++sit)
			queue[id]->queuePresence[sit.key()] = false;
	
	
	
// 	if (first)
// 		queueView.prepend(nextItemId);
// 	else queueView.append(nextItemId);
		queueView.append(id);
		
		
	
	
		for (bh->pnmit=bh->partNum.begin(); bh->pnmit != bh->partNum.end(); ++(bh->pnmit)) {
			
			nextJobId++;
// 			qDebug("Adding part %d to item %d with jobId %d (subject: %s)", bh->pnmit.key(), id, nextJobId, bh->getSubj().latin1());
			tJob=new Job;
		// Choose the right server, based on priority....
		// In the future, will try to balance the queues with the same priority (using qinfo)
		
// 		serverId=chooseServer(bh);
		//New version of chooseServer...
			serverId=chooseServer(bh, bh->pnmit.key());
			(*servers)[serverId]->size+=bh->partSize[bh->pnmit.key()];
			tJob->artSize=bh->partSize[bh->pnmit.key()];
		
			tJob->qId=serverId;
			tJob->id=nextJobId;
			tJob->jobType=Job::GetPost;
			tJob->nh=(*servers)[serverId]; //Got to choose the server....
			tJob->ng=ng;
			tJob->qItemId=id;
			tJob->partId=bh->pnmit.key();
			tJob->tries=(*servers)[serverId]->retries;
			if (bh->partMid.contains(bh->pnmit.key()) ) {
// 			kdDebug() << "Have mid\n";
				tJob->mid=bh->partMid[bh->pnmit.key()];
// 			kdDebug() << "Mid: " << tJob->mid << endl;
			
			} else {
				tJob->mid = QString::null;
// 			kdDebug() << "Have number\n";
			}
			
			
			tJob->artNum=bh->pnmit.data()[serverId];
			tJob->fName=rootFName + '.' + QString::number(tJob->partId);
		
			if (qp->queuePresence[serverId] == false) {
				qp->queuePresence[serverId]=true;
				queueItems[serverId].append(id);
// 				qDebug("Appended item %d on queue %d", id, serverId);
			}
		
		
			// 		
		
		
			tPart=new Part;
			tPart->desc=bh->getSubj() + " " + QString::number(bh->pnmit.key()) + "/" +QString::number(bh->getParts());
			
			
			
			tPart->status=QItem::Queued_Part;
			tJob->status=Job::Queued_Job;
			
			tPart->jobId=nextJobId;
			tPart->job=tJob;
			tPart->qId=serverId;
			
			
			if (qsi->partStatus.contains(bh->pnmit.key()))
				qp->addJobPartWithStatus(nextJobId, bh->pnmit.key(), tPart, qsi->partStatus[bh->pnmit.key()] );
			else qp->addJobPart(nextJobId, bh->pnmit.key(), tPart );
			

		}
		qp->listItem->setText(3, QString::number(qp->totalParts - qp->partsToDo) + '/' + QString::number(qp->failedParts) + '/' + QString::number(qp->totalParts) );
		//Check if the item is complete, and I have to decode it...
		if (qp->partsToDo == 0) {
			qp->listItem->setText(2, "Decoding");
			qp->listItem->setText(3, "");
			qp->listItem->setText(4, "");
			addDecodeItem(qp);
		}

}

void QMgr::writeError( Job * j )
{
	//Currently, it pause the queue and show a dialog box.
	//May change in the future (i.e.: check if the disk is full, if not retry...
	if (j!= 0) {
		queue[j->qItemId]->comError(j->partId);
		threads[j->qId][j->partId]->paused();
		emit sigThreadPaused(j->qId, j->threadId, 0);
	}
	if (!queuePaused) {
		//Pause the queue
		pauseQ(true);
		
		//This variable for queue resume....
		diskError=true;
		//Should emit a signal to press the checkButton....
		emit sigQPaused(true);
		//Display an error dialog...
		KMessageBox::error(this, i18n("There was an error writing to disk - the download queue has been paused. Chances are that the filesystem is out of space. Correct the error and restart the queue"), i18n("Write error"));
		
	}
	
	
	
}

void QMgr::slotOpenNzb( )
{
	QString nzbFilename = KFileDialog::getOpenFileName(QString::null, "*.nzb|Newzbin Files\n", this, i18n("Open a .nzb file"));
	kdDebug() << "Opened " << nzbFilename << endl;
	
	if (nzbFilename.isNull())
		return;
	
	//Parse nzb and add posts to the queue
	//Ok, I should create a separate class...but for now, let's try a quick & dirty solution...
	//Code taken (and adapted with permission) from knzb, (C) 2004 David Pye.
	
	QFile nzbFile(nzbFilename);
	if (!nzbFile.open(IO_ReadOnly)) {
		//TODO: Error messagebox!
		return;
	}
	QMap<int, BinHeader*> headerMap;
	int i=0;
	
	QDomDocument doc("nzbfile");
	BinHeader *bh = NULL;
	doc.setContent(&nzbFile);
	nzbFile.close();
	QFileInfo qf(nzbFilename);
	QRegExp rx("\\((\\d+)/(\\d+)\\)");
	QDomElement docElem = doc.documentElement();
	QDomNode n = docElem.firstChild();
	
	while (!n.isNull()) {
		
		QDomElement e = n.toElement();
		if (!e.isNull()) {
			if (e.tagName() = "file") {
				//Create a BinHeader
				i++;
				bh = new BinHeader();
				QString subject = e.attribute("subject");
				int pos=0;
				int capPart=0;
				int capTotal=0;
				int index=-1; // = rx.search(h->m_subj, -1);
				while ( (pos=rx.search(subject, pos)) != -1 ) {
					index=pos;
					pos+=rx.matchedLength();
					capPart=rx.cap(1).toInt();
					capTotal=rx.cap(2).toInt();
				}
				subject=subject.left(index).simplifyWhiteSpace();
				bh->setSubj(subject);
				
				bh->setFrom(e.attribute("poster"));
				QDateTime qdt;
				qdt.setTime_t(e.attribute("date").toUInt());
				bh->setDate(qdt.toString());
				bh->setStatus(BinHeader::bh_new);
				bh->setNumParts(capTotal);
				QDomNode fileSubNode = e.firstChild();
				while (!fileSubNode.isNull()) {
					QDomElement fileElement = fileSubNode.toElement();
					if (!fileElement.isNull()) {
						if (fileElement.tagName()=="segments") {
							QDomNode segmentsSubNode = fileSubNode.firstChild();
							while (!segmentsSubNode.isNull()) {
								QDomElement segmentsElement = segmentsSubNode.toElement();
								if (!segmentsElement.isNull()) {
									if (segmentsElement.tagName()=="segment") {
										int bytes = segmentsElement.attribute("bytes").toInt();
										int part = segmentsElement.attribute("number").toInt();
										QString mid = segmentsElement.text();
										bh->addNzbPart(part, bytes, mid);
										Servers::Iterator sit;
										for (sit = servers->begin(); sit != servers->end(); ++sit) {
											bh->addHost(part, sit.key());
										}
									}
								}
								segmentsSubNode = segmentsSubNode.nextSibling();
							}
						}
					}
					
					fileSubNode=fileSubNode.nextSibling();
				}
				
			}
			//BEGIN DEBUG!
// 			kdDebug() << "Binheader created!" << endl;
// 			kdDebug() << "Subject: " << bh->getSubj() << endl;
// 			kdDebug() << "From: " << bh->getFrom() << endl;
// 			kdDebug() << "Bytes: " << bh->getSize() << endl;
// 			kdDebug() << "Parts: " << bh->getParts() << endl;
// 			PartMid::Iterator pit;
// 			for (pit=bh->partMid.begin() ; pit != bh->partMid.end(); ++pit) {
// 				kdDebug() << "Part: " << pit.key() << " mid: " << pit.data() << endl;
// 			}
			//END DEBUG
			
			headerMap[i]=bh;
			
			//Insert binheader into nzb group...
			/*
			Dbt key, data;
			memset(&key, 0, sizeof(key));
			memset(&data, 0, sizeof(data));
			
			
			QString index=bh->getSubj().simplifyWhiteSpace() + bh->getFrom();
			kdDebug() << "Saving " << index << endl;
			
			key.set_data((void*) (const char *) index);
			key.set_size(index.length());
			data.set_data(bh->data() );
			data.set_size(bh->getRecordSize());
			int ret;
			if ( (ret = nzbGroup->getDb()->put(0, &key, &data, 0) ) != 0) 
				kdDebug() << "Error inserting binheader into nzbGroup: " << dbEnv->strerror(ret) << endl;
			
			free(data.get_data());
			
			
			slotAddPostItem(bh, nzbGroup, false,false);
			*/
		}
		n=n.nextSibling();
	}
	QFileInfo fi(nzbFilename);
	
	NzbForm *nzbForm = new NzbForm(&headerMap, nzbGroup->getSaveDir() +  fi.baseName(true), this, nzbFilename, true);
	connect(nzbForm, SIGNAL(sigDownloadNzbPost(BinHeader*, bool, QString )), this, SLOT(slotAddNzbItem(BinHeader*, bool, QString)));
	nzbForm->exec();
	
	nzbGroup->getDb()->sync(0);
	
}


void QMgr::slotAddNzbItem(BinHeader* bh, bool first, QString dDir) {
	
	Dbt key, data;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
			
			
	QString index=bh->getSubj().simplifyWhiteSpace() + bh->getFrom();
	kdDebug() << "Saving " << index << endl;
			
	key.set_data((void*) (const char *) index);
	key.set_size(index.length());
	data.set_data(bh->data() );
	data.set_size(bh->getRecordSize());
	int ret;
	if ( (ret = nzbGroup->getDb()->put(0, &key, &data, 0) ) != 0) 
		kdDebug() << "Error inserting binheader into nzbGroup: " << dbEnv->strerror(ret) << endl;
			
	free(data.get_data());
			
			
	slotAddPostItem(bh, nzbGroup, first,false, dDir );
	
	
}

void QMgr::closeEvent( QCloseEvent * e )
{
	
	e->ignore();
}

void QMgr::started( int serverID, int threadID )
{
	emit sigThreadStart(serverID, threadID);
	
}






/*$SPECIALIZATION$*/


#include "qmgr.moc"

