/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef QMGR_H
#define QMGR_H

#include "qmgrform.h"
#include "queueparts.h"
#include <qevent.h>
#include <qmap.h>
#include <qvaluelist.h>
#include <ktempfile.h>
#include <kiconloader.h>
#include <ktabwidget.h>
#include "availablegroups.h"
#include "updatedb.h"

typedef QMap<uint, Thread*> ThreadMap; //threadid-thread*

typedef QMap<uint, ThreadMap> QueueThreads; //serverid-threadid-thread*

typedef QValueList<int> QueueList;
// typedef QMap<uint, Job*> Queue; //jobId, Job*
typedef QPtrList<Job> Queue;

class GroupList;
class MyListView;

class QMgr : public KMdiChildView
{
  Q_OBJECT
		  
// 	KListView *queueList;
	MyListView *queueList;
    KListView *doneList;
	KListView *failedList;
// 	QMap<int, Queue> queues; //server-queue for the server
	QMap<int, NntpHost *> *servers;
	
	QValueList<int> queueView;
	QMap<int, QueueList> queueItems;
	
	QMap<int, QItem*> queue;  //Maps qitemId->QItem*
	QMutex queueLock;
	
	uint nextItemId;
	uint nextThreadID;
	KTabWidget* tabWidget;
	//for Queue infos
	unsigned long long queueSize;
	unsigned long long queueCount;
	
	// Next ID for jobs
	uint nextJobId;
	Db * gdb; //The group db, will change....
	
	
	QueueThreads threads;
	bool queuePaused;
	QMap<int, int> pendingOperations;
	int operationsPending;
	bool diskError;
	
	
	

	
	
	
	
	
	
	//Decode thread...
	QMutex decodeListLock;
	QMutex updateListLock;
	QValueList<QPostItem*> decodeList;
	QValueList<Job*> updateJobList;
// 	DecodeThread *decodeThread;
// 	SelfDecodeThread *decodeThread;
	DecoderThread *decodeThread;
	UpdateDbThread *updateDbThread;
	int findIndex(int, int, bool);
	
// 	int findFreeThread(int qId);
// 	Job *findNextJob(int qId);
	Job* findNextJob(int qId);
	
	
	
	void update(Job *j, int partial, int total, int interval);
	void startExpiring(Job *j);
	void startUpdatingDb(Job *j);
	void start(Job *j);
	void stopped(int qId, int threadId);
	void finished (Job *j);	
	void expiring(Job *j, int);
	void decodeFinished(QPostItem*, bool, QString, QString);
	void error(Job *j);
	void upDbErr(Job *j);
	void comError(Job *j);
	void cancel(Job *j);
	int chooseServer(BinHeader *bh, int); //gets the binheader, returns the highest priority server with the article
	virtual void customEvent(QCustomEvent *);
	void moveItem(QItem *);
	void moveCanceledItem(QItem *);
	void requeue(Job*);
	void addServerQueue(NntpHost *);
	void downloadFinished(Job*);
	void downloadCanceled(Job*);
	void downloadError(Job*);
	void paused(int qId, int threadId, bool error);
	void delayedDelete(int qId, int threadId);
	void writeError(Job *j=0);
	void started(int serverID, int threadID);
	
// 	void updateSaveQueueError();
	
	//Queue saving
// 	char* saveItemData(QSaveItem*);
// 	uint saveItemSize(QSaveItem*);
	
	QSaveItem* loadSaveItem(char*);
	
// 	char* insert(QString s, char* p);
	char* retrieve(char* i,QString &s);
// 	QSaveItem* readSaveItem(int id);
	
	void writeSaveItem(QSaveItem* si);
	void updateSaveItem(int id, int part, int status, uint lines);
	void delSaveItem(int id);
	bool delNzbItem(QString index);
	void createPostItemFromQ(int id, QSaveItem *qsi, BinHeader *bh, NewsGroup *ng);
	
	//new queue saving
	SaveQThread *saveQThread;
	QValueList<QSaveItem*> saveQueue;
	QMutex sQLock;
	
	Db *qDb;
	DbEnv *dbEnv;
	QString dbDir;
	GroupList *gList;
	NewsGroup *nzbGroup;
	
	
	
	
public:
  QMgr(Servers *_servers, Db *_gdb, QString caption, QWidget* parent=0);
  ~QMgr();
  void pauseQ(bool);
  void enable(bool);
  bool empty();
  void setDbEnv(QString d, DbEnv * dbe, GroupList *gl);
  void checkQueue();
  void setDecodeOverwrite(bool o) {decodeThread->setOverWrite(o);}
  virtual void closeEvent(QCloseEvent *e);
  
  
  
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
	
	void slotAddUpdItem(NewsGroup *_ng, int headers=0);
	void slotAddListItem( AvailableGroups *ag);
	void slotAddPostItem(BinHeader *bh, NewsGroup *ng, bool first=0, bool view =0, QString dDir=QString::null);
	void slotAddNzbItem(BinHeader* bh, bool first = 0, QString dDir=QString::null);
// 	void slotThreadSpeedChanged(int, int, int);
// 	void slotThreadDisconnected(int, int);
	void slotEmptyFinishedQ();
	void slotEmptyFailedQ();
	void slotPauseSelected();
	void slotResumeSelected();
	void slotCancelSelected();
	void slotMoveSelectedToTop();
	void slotMoveSelectedToBottom();
	void slotAddServer(NntpHost*);
	void slotAddThread(int, int);
	void slotDeleteThread(int);
	void slotDeleteServerQueue(int);
	void slotViewArticle(BinHeader *, NewsGroup *);
	void slotResumeThread(int, int);
	void slotResumeThreads();
	void slotPauseThread(int, int);
	void slotOpenNzb();

	

	

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
	
	void slotThreadFinished();
	void addDecodeItem(QPostItem*);
	void slotQueueContextMenu(QListViewItem*, const QPoint &);
	void slotFinishedContextMenu(QListViewItem*, const QPoint &);
	void slotFailedContextMenu(QListViewItem*, const QPoint &);
	void slotSelectionChanged();
	void slotItemMoved(QListViewItem*, QListViewItem*, QListViewItem*);
	void startAllThreads(int qId);
	
	
	
signals:
	
	void newItem(int );  //new item inserted in queue "int"
	void threadFinished();
	void sigSpeedChanged(int,int,int);
	void sigThreadStart(int,int);
	void sigThreadFinished(int,int);
	void sigThreadCanceling(int,int);
	void sigThreadError(int,int);
	void sigThreadPaused(int, int, int);
	void sigThreadDisconnected(int, int);
	void sigUpdateFinished(NewsGroup *);
	void sigShowQueueMenu(const QPoint &);
	void sigShowFinishedMenu(const QPoint &);
	void sigShowFailedMenu(const QPoint &);
	void sigItemsSelected(bool);
	void sigThreadDeleted(int, int);
	void viewItem(KURL);
	void queueInfo(unsigned long long, unsigned long long);
	void sigQPaused(bool);
	
// 	
	
	

};

#endif

