/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "updatedb.h"
#include "binheader.h"

//CACHE PARAMETERS
#define CACHESIZE 503
#define CACHEWATERMARK 490
#define CACHEFLUSH 300


void UpdateDbThread::run() {

// 	qDebug("UpdateDbThread::run(): Items in queue: %d", jobList->count() );
	
	while(!jobList->isEmpty()) {
		listLock->lock();
		job=jobList->first();
		listLock->unlock();
		if (update() ) {
		
			listLock->lock();
			jobList->remove(jobList->first());
			listLock->unlock();
			e = new UpdateDbThreadEvent(job, UpdateDbThreadEvent::UpDb_stopUpd);
			QApplication::postEvent(parent, e);
		} else {
			// Db error...
			listLock->lock();
			jobList->remove(jobList->first());
			listLock->unlock();
			e = new UpdateDbThreadEvent(job, UpdateDbThreadEvent::UpDb_Err);
			
			//set the error and exit...
			
			QApplication::postEvent(parent, e);
			break;
		}
		
// 		qDebug("Updated, now the queue has %d items", jobList->count());
	}
// 	qDebug("Update done");


	
}


bool UpdateDbThread::expire( NewsGroup * ng, int hostId) {
    Dbc *cursor;
	int lw=ng->low[hostId];
	kdDebug() << ng->ngName << " lowWatermark: " << lw << endl;
	QTime previous, current;
	previous=QTime::currentTime();
	uint progress=groupArticles;

	if ((ng->getDb()->cursor(0, &cursor, DB_WRITECURSOR))!= 0) {
		qDebug("Error creating cursor!!");
		//Set the error!
		return false;
	}
    BinHeader *bh;
    int count =0, ret;
	Dbt key, data;
	uchar *p;
	
	memset(&data, 0, sizeof(data));
	data.set_flags(DB_DBT_MALLOC);
	
	memset(&key, 0, sizeof(key));
	key.set_flags(DB_DBT_MALLOC);
	

	
	
	while((ret=cursor->get(&key, &data, DB_NEXT)) == 0) {
		
			
		count++;
		if (!hasToBeExpired(hostId, lw, (char*) data.get_data())) {
			
			free(data.get_data());
			
		} else {
		
		
			bh=new BinHeader((uchar*) data.get_data());
			free(data.get_data());
			
			
			switch (bh->expire(hostId, lw)) {
				case BinHeader::Delete_Unread:
					unreadArticles--;
				case BinHeader::Delete_Read:
					if ((ret=cursor->del(0))!=0)
						qDebug("Error deleting from db: %d", ret);
					else groupArticles--;
	// 				memset(&data, 0, sizeof(data));
	// 				data.set_flags(DB_DBT_MALLOC);
					
					break;
				case BinHeader::No_Delete:
					//Don't delete, resave
					p=bh->data();
					memset(&data, 0, sizeof(data));
					data.set_data(p);
					data.set_size(bh->getRecordSize());
					
					if ((ret=cursor->put(&key, &data, DB_CURRENT))!=0) 
						qDebug("Error updating post: %d", ret);
					// 			else qDebug("Error! %d", ret);
					delete p;
					break;
				case BinHeader::No_Change:
					break;
				
			}
			delete bh;
			
		}
		
		
		free(key.get_data());
		memset(&key, 0, sizeof(key));
		key.set_flags(DB_DBT_MALLOC);
		memset(&data, 0, sizeof(data));
		data.set_flags(DB_DBT_MALLOC);
		
		
		
		if (ret != 0) {
			qDebug("Error while expiring...");
			return false;
		}
		
		current=QTime::currentTime();
		if (previous.secsTo(current) > 1) {
			e=new UpdateDbThreadEvent(job, UpdateDbThreadEvent::UpDb_Working, count, progress);
			QApplication::postEvent(parent, e);
			previous=QTime::currentTime();
			
		}
		
	} 
	
	if (ret != DB_NOTFOUND) {
		qDebug("Exited from cursor cycle with strange error %d", ret);
		return false;
	}
	

    // Begin pasted code
    if (cursor->close() != 0)
		qDebug("Error closing cursor!");

	return true;
//     qDebug("Elements in DB: %d", count);

}

bool UpdateDbThread::update()
{
	//expire newsgroup
	groupArticles=job->ng->totalArticles;
	unreadArticles=job->ng->unreadArticles;
// 	qDebug("Expiring");
	e=new UpdateDbThreadEvent(job, UpdateDbThreadEvent::UpDb_startExp);
	QApplication::postEvent(parent, e);
	if (! expire(job->ng,job->qId))
		return false;
	e=new UpdateDbThreadEvent(job, UpdateDbThreadEvent::UpDb_startUpd);
	QApplication::postEvent(parent, e);
// 	qDebug("Expired");
	Header *h;
	int tret;
	int lineProcessed=0;
	int totalLines=job->artSize;
	headerFile=new QFile(job->fName);
	cacheSize=0;
	//TODO: only insert in Db if artSize >= 0!
	if (totalLines != 0) {
		int hostId=job->qId;
		Db* db=job->ng->getDb();
#if INDEXDB_VERSION != 0
		Db* sdb=job->ng->getSDb(hostId);
#endif
		
		
		if (!headerFile->open(IO_ReadOnly)) {
			qDebug("UpdateDbThread::update: Cannot open file %s", (const char *) job->fName);
			return false;
		} 
		QTime previous, current;
		previous=QTime::currentTime();
		while ( (headerFile->readLine(line, 2000)) != -1 ) {
			h=new Header(line);
			
			lineProcessed++;
			if (h->isOk()) {
				/* 
				if ((tret=dbHeaderPut(db, h, hostId)) != 0 && tret != DB_KEYEXIST) {
					kdDebug() << "NntpThread::getXover(): Exit from insert:" << tret << endl;
					return false;
				*/
#if INDEXDB_VERSION != 0
				if (dbBinHeaderPut(db, sdb, h, hostId) == false) 
#else
				if (dbBinHeaderPut(db, h, hostId) == false) 
#endif
				{
					qDebug("Error inserting header!");
					return false;
				
				} else job->ng->high[hostId] = h->m_num;
			} else kdDebug() << "Wrong header - maybe an incomplete line?\n";
			
			job->artSize=0;
			delete h;
			
			//DEBUG!!!
	// 		if (lineProcessed >= 50)
	// 			return false;
			//End debug!
			current=QTime::currentTime();
			if (previous.secsTo(current) > 1) {
				e=new UpdateDbThreadEvent(job, UpdateDbThreadEvent::UpDb_Working, lineProcessed, totalLines);
				QApplication::postEvent(parent, e);
				previous=QTime::currentTime();
				
			}
				
			
		}
		cacheFlush(db);
		db->sync(0);
	} else kdDebug() << "Empty headerFile!\n";
	
	kdDebug() << "Inserted articles \'til " << job->ng->high[job->qId] << endl;
	headerFile->close();
	
	if (!headerFile->remove()) 
		qDebug("Error deleting file");
	
	delete headerFile;
	
	
	Dbt groupkey, groupdata;
	memset(&groupkey, 0, sizeof(groupkey));
	memset(&groupdata, 0,  sizeof(groupdata));
	job->ng->totalArticles=groupArticles;
	job->ng->unreadArticles=unreadArticles;
	char *tempng=job->ng->data();
	groupdata.set_data(tempng);
	groupdata.set_size(job->ng->getRecordSize());
	const char *tempkey=(const char *) job->ng->ngName;
	groupkey.set_data((void*)tempkey);
	groupkey.set_size(job->ng->ngName.length());
	if ((tret=job->gdb->put(NULL, &groupkey, &groupdata, 0)) != 0) {
		qDebug("Error updating newsgroup: %d", tret);
		delete tempng;
		return false;
	}
	delete tempng;
	
	job->gdb->sync(0);
	return true;
	
	
	
}

BinHeader * UpdateDbThread::dbBinHeaderGet(Db *db, QString index) {
	
	Dbt key, data;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	data.set_flags(DB_DBT_MALLOC);
	BinHeader *bh=0;
	key.set_data((void*)index.latin1());
	key.set_size(index.length());
	
	if ( (db->get(NULL, &key, &data, 0) ) == 0 ) {
		bh = new BinHeader((uchar*) data.get_data());
		free(data.get_data());
	}
	return bh;

}

#if INDEXDB_VERSION != 0
bool UpdateDbThread::dbBinHeaderPut( Db * db, Db *sdb, Header *h, int hostId)
#else
bool UpdateDbThread::dbBinHeaderPut( Db * db, Header *h, int hostId)
#endif
{
	pos=0;
	capPart=0;
	capTotal=0;
	index=-1;
	while ( (pos=rx.search(h->m_subj, pos)) != -1) {
		index=pos;
		pos+=rx.matchedLength();
		capPart=rx.cap(1).toInt();
		capTotal=rx.cap(2).toInt();
	}
	if (index == -1)
		return true;
	QString sIndex=h->m_subj.left(index).simplifyWhiteSpace() + h->m_from;
	//Try the cache....
#if INDEXDB_VERSION != 0
	if (cachePut(db, sdb, h, sIndex, hostId))
#else
	if (cachePut(db, h, sIndex, hostId))
#endif
		return true;
	else return false;
	
	
	
	
	
}
#if INDEXDB_VERSION != 0
bool UpdateDbThread::cachePut( Db * db, Db* sdb, Header * h, QString cIndex, int hostId )
#else 
bool UpdateDbThread::cachePut( Db * db, Header * h, QString cIndex, int hostId )
#endif
{
	//TODO check the size of the cache and flush if needed...
	if (cacheSize > CACHEWATERMARK) {
		//Empty only half of the cache?
		if (!cacheFlush(db, CACHEFLUSH))
			return false;
	}
	
	bh=cache[cIndex];
	if (bh == 0) {
		//Try to get the header from the db...
		bh=dbBinHeaderGet(db, cIndex);
		if (bh) {
			cache.insert(cIndex, bh);
			cacheSize++;
			cacheIndex.append(cIndex);
		}
	}
	
	if (bh == 0) {
				
		//Create new header and put it in the cache...
		
		bh=new BinHeader;
		groupArticles++;
		//The new article is, of course, unread...
		unreadArticles++;
		bh->setSubj(h->m_subj.left(index).simplifyWhiteSpace());
		bh->setFrom(h->m_from);
		bh->setStatus(BinHeader::bh_new);
		
		if (h->m_date.isNull()) {
			qDebug("Date is null!!!");

		} else {
			bh->setDate(createDateTime(QStringList::split(" ", h->m_date, true)));
		}
		bh->setNumParts(capTotal);

		bh->addPart(capPart, h, hostId);
			
		cache.insert(cIndex, bh);
		cacheIndex.append(cIndex);
		cacheSize++;

	} else {
		//update the header in the cache...
		switch (bh->addPart(capPart, h, hostId)) {
			case BinHeader::Duplicate_Part:
				break;
			case BinHeader::Unread_Status:
					//Added a part that changed the status of the post...
				unreadArticles++;
			case BinHeader::New_Part:
				break;


		}
	}
	
	//Now write the index...
#if INDEXDB_VERSION != 0	
	SIndex *si = new SIndex;
	si->index=cIndex;
	si->partId=capPart;
	writeSIndex(sdb, h->m_num, si);
	delete si;
#endif
	
	return true;
	
}

bool UpdateDbThread::cacheFlush(Db* db, uint size )
{
	QString cIndex;
	Dbt key, data;
	int ret;
	kdDebug() << "Flushing cache" << endl;
	kdDebug() << "cacheIndex is " << cacheSize << " .Flushing " << size << " records" << endl;
	if (size == 0) {
		//Flush all
		QDictIterator<BinHeader> it(cache);
		while (it.current()) {
			cIndex=it.currentKey();
			bh=it.current();
			
			data.set_data(bh->data());
			data.set_size(bh->getRecordSize());
			key.set_data((void*)cIndex.latin1());
			key.set_size(cIndex.length());
			ret=db->put(NULL, &key, &data, 0);
			if (ret != 0) {
				qDebug("Error flushing cache: %d", ret);
				return false;
			}
			free(data.get_data());
			cache.remove(it.currentKey());
		}
		
		
		cacheIndex.clear();
		cacheSize=0;
		
	} else {
		//Flush "size" elements, with a FIFO policy
		if (size > cache.count()) {
			qDebug("wrong flush size!");
			size=cache.count();
		}
			
		for (uint i = 0; i < size; i++) {
			cIndex=cacheIndex.first();
			bh=cache[cIndex];
			//Insert in the db...
			memset(&key, 0, sizeof(key));
			memset(&data, 0, sizeof(data));
			data.set_data(bh->data());
			data.set_size(bh->getRecordSize());
			key.set_data((void*)cIndex.latin1());
			key.set_size(cIndex.length());
			ret=db->put(NULL, &key, &data, 0);
			if (ret != 0) {
				qDebug("Error flushing cache: %d", ret);
				return false;
			}else {
				//Remove item from the cache
				cacheIndex.pop_front();
				cache.remove(cIndex);
				cacheSize--;
			}
			free(data.get_data());
			
			
			
		}
		
	}
	kdDebug() << "Ok, cache flushed" << endl;
	return true;
}



int UpdateDbThread::dbHeaderPut( Db * db, Header * h, int hostId ) {
    int ret;

	Dbt key, data;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	data.set_flags(DB_DBT_MALLOC);
    pos=0;
	capPart=0;
	capTotal=0;
	index=-1; // = rx.search(h->m_subj, -1);
	while ( (pos=rx.search(h->m_subj, pos)) != -1 ) {
		index=pos;
		pos+=rx.matchedLength();
		capPart=rx.cap(1).toInt();
		capTotal=rx.cap(2).toInt();
	}
	
    if (index != -1) {	//probably a binheader, now add to the list, or add the corresponding part
        // check for existence
        QString ts=h->m_subj.left(index).simplifyWhiteSpace(); //this is our subject/index
		
        //build the key
        QString index=ts+h->m_from; //Now our index is: subj+from

        const char *k=(const char *) index;
        key.set_data((void*)k);
        key.set_size(index.length());
		
		ret=db->get(NULL, &key, &data, 0);
		
		
        if ((ret == 0)) {
            //key exists, add part and save binheader again
			
            bh=new BinHeader((uchar*) data.get_data());
			free(data.get_data());
			
            
//             if (bh->addPart(capPart, h, hostId)) { //Part is not a duplicate, inserted
			
			switch (bh->addPart(capPart, h, hostId)) {
				case BinHeader::Duplicate_Part:
					break;
				case BinHeader::Unread_Status:
					//Added a part that changed the status of the post...
					unreadArticles++;
				case BinHeader::New_Part:
					uchar *p = bh->data();
					memset(&data, 0, sizeof(data));
					
					data.set_size(bh->getRecordSize());
					data.set_data(p);
					if ((ret=db->put(NULL, &key, &data, 0)) != 0) {
						qDebug("Error inserting header");
					}
					// 					qDebug("Updated header inserted");
					// 				else qDebug("Error updating record");
					delete p;
					break;
				
				
					


            } //else { //part is a duplicate, do not insert? Or insert only if bin is different? Hmmm
//                 qDebug("Got a duplicate part!");
            //}
            delete bh;
			
			
            return ret;

            //debug: exit first time you make this cycle



        }
        else if (ret==DB_NOTFOUND) {
            //key doesn't exist, create header and save it
            //             				qDebug("Header does not exist, creating it");
			
            bh=new BinHeader;
			groupArticles++;
			//The new article is, of course, unread...
			unreadArticles++;
            bh->setSubj(ts);
			

            bh->setFrom(h->m_from);
            bh->setStatus(BinHeader::bh_new);



            if (h->m_date.isNull()) {
                qDebug("Date is null!!!");
                // 				qDebug("Header: %s", (const char *) h->m_subj);
                // 				qDebug("Number: %s", (const char *) h->m_num);
            } else
                bh->setDate(createDateTime(QStringList::split(" ", h->m_date, true)));

            // 			qDebug("DateTime is: %s", (const char *) bh->getDate());
            //             				qDebug("Header subj: %s", (const char *) ts);
            bh->setNumParts(capTotal);
            //             				qDebug("Parts: %d", rx.cap(2).toInt());
            bh->addPart(capPart, h, hostId);

            //             				qDebug("Part in question: %d", rx.cap(1).toInt());
            uchar *p=bh->data();
            //             				qDebug("Binheader size: %d", bh->getRecordSize());

            //             				bh->printServerPart();
			
			memset(&data, 0, sizeof(data));
            data.set_size(bh->getRecordSize());
			data.set_data(p);

            ret=db->put(NULL, &key, &data, 0);


            delete bh;
            delete p;
// 			free(data->get_data());
			
            return ret;

        
        } else {
			qDebug("Other error: %d", ret);
			return ret;
		}






    }
	return 0;








}

UpdateDbThread::UpdateDbThread( QWidget *w, QMutex *lock, QValueList< Job * > *jobs )
{
	parent=w;
	listLock=lock;
	jobList=jobs;
	cache.resize(CACHESIZE);
	cache.setAutoDelete(true);
	rx.setPattern("\\((\\d+)/(\\d+)\\)");
	
	
}

QString UpdateDbThread::createDateTime( QStringList dateTime) {

    int i=(dateTime[0].at(dateTime[0].length()-1) == ',') ? 1:0;
    QDate d=QDate::fromString(" " + dateTime[i+1] + " " + dateTime[i] +" " + dateTime[i+2]);
    QTime t=QTime::fromString(dateTime[i+3]);
    QDateTime dt(d, t);
	


    return dt.toString();


}

bool UpdateDbThread::hasToBeExpired( int hostId, int lw, char * p )
{
	QMap<int, int> sLowest;
	char *i=&p[0];
	int serverId, lowest, size;
	int szInt=sizeof(int);
	memcpy(&size, i, szInt);
	i+=szInt;
	for (int j = 0; j < size; j++) {
		memcpy(&serverId, i, szInt);
		i+=szInt;
		memcpy(&lowest, i, szInt);
		i+=szInt;
		sLowest.insert(serverId, lowest);
	}
	if (sLowest.contains(hostId)) {
		if (sLowest[hostId] < lw)
			return true;
	} 
	
	return false;
	
}

#if INDEXDB_VERSION != 0

SIndex * UpdateDbThread::getSIndex( Db * sdb, int artNum )
{
	Dbt key, data;
	SIndex *si;
	int ret;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	data.set_flags(DB_DBT_MALLOC);
	key.set_data(&artNum);
	key.set_size(sizeof(artNum));
	ret=sdb->get(0, &key, &data, 0);
	if (ret == 0) {
		//SIndex found!
		si = unmarIndex((char*)data.get_data());
		free(data.get_data());
		return si;
		
	} else return 0;
		
}



bool UpdateDbThread::writeSIndex( Db * sdb, int artNum, SIndex * sindex )
{
	Dbt key, data;
	int ret;
	
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	
	key.set_data(&artNum);
	key.set_size(sizeof(artNum));
	data.set_data(marIndex(sindex));
	data.set_size(sIndexSize(sindex));
	
	ret=sdb->put(0, &key, &data,0);
	
	free(data.get_data());
	if (ret == 0)
		return true;
	else {
		qDebug("Cannot write secondary index: %d", ret);
		return false;
	}
	
	
}

bool UpdateDbThread::delSIndex( Db * sdb, int partId )
{
	Dbt key;
	int ret;
	memset(&key, 0, sizeof(key));
	key.set_data(&partId);
	ret=sdb->del(0, &key, 0);
	if (ret == 0)
		return true;
	else {
		qDebug("Cannot delete item from secondary index: %d", ret);
		return false;
	}
	
}

char * UpdateDbThread::marIndex( SIndex * si )
{
	char *p=new char[sIndexSize(si)];
	char *i=&p[0];
	i=insert(si->index, i);
	memcpy(i, &(si->partId), sizeof(int));
	return p;
	
	
}

SIndex * UpdateDbThread::unmarIndex( char * p )
{
	char *i=&p[0];
	SIndex *si=new SIndex;
	i=retrieve(i, si->index);
	memcpy(&(si->partId), i, sizeof(int));
	return si;
	
	
}



int UpdateDbThread::sIndexSize( SIndex * si )
{
	return (si->index.length() + 2*sizeof(int));
}




bool UpdateDbThread::expireByNum( NewsGroup * ng, int hostId )
{
	
	int lw=ng->low[hostId];
	int oldLw = ng->oldLow[hostId];
	QTime previous, current;
	previous=QTime::currentTime();
	uint progress=groupArticles;
	int ret, count=0;
	
	Dbt key, data;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	data.set_flags(DB_DBT_MALLOC);
	Db* db=ng->getDb();
	Db* sdb=ng->getSDb(hostId);
	cacheSize=0;
	SIndex *si;
	
	BinHeader *bh;
	
	for (int i = oldLw ; i < lw; i++) {
		count++;
		//Verify the cache size...
		if (cacheSize > CACHEWATERMARK) {
		//Empty only half of the cache?
			if (!cacheFlush(db, CACHEFLUSH))
				return false;
		}
		//Get the index from the secondary db
		key.set_data(&i);
		key.set_size(sizeof(i));
		ret=sdb->get(0, &key, &data, 0);
		
		if (ret == 0) {
			si = unmarIndex((char*)data.get_data());
			free(data.get_data());
			//Check if the header is already in the cache...
			bh=cache[si->index];
			if (bh == 0) {
				bh=dbBinHeaderGet(db, si->index);
				if (bh == 0) {
					//Error getting binheader...something's wrong!
					qDebug("Errot getting binheader from db");
					return false;
				}
				cache.insert(si->index, bh);
				cacheIndex.append(si->index);
				cacheSize++;
			}
			//ok, now the header is in the cache...
			switch (bh->expirePart(hostId, si->partId)) {
				case BinHeader::Delete_Unread:
					unreadArticles--;
				case BinHeader::Delete_Read:
					//delete the binheader from the db, the corresponding sindex from the secondary db, 
					//and remove it from the cache...
					
					//Key still contains the sIndex key...delete the corresponding record
					sdb->del(0, &key, 0);
					
					//Now delete the binheader from the main db
					memset(&key, 0, sizeof(key));
					key.set_data((void*) si->index.latin1());
					key.set_size(si->index.length());
					db->del(0, &key, 0);
					//Now remove the binheader from the cache
					cache.remove(si->index);
					cacheIndex.remove(si->index);
					cacheSize--;
					
					break;
				case BinHeader::No_Delete:
					//Delete sIndex only (the article is expired, but the binheader isn't)
					sdb->del(0, &key, 0);
					break;
				
			}
			delete si;
			
		} else if (ret != DB_NOTFOUND) {
			//Error reading db!
			qDebug("Error getting secondary index: %d", ret);
			return false;
		}
		current=QTime::currentTime();
		if (previous.secsTo(current) > 1) {
			e=new UpdateDbThreadEvent(job, UpdateDbThreadEvent::UpDb_Working, count, progress);
			QApplication::postEvent(parent, e);
			previous=QTime::currentTime();
			
		}
		
		
		
		
		
	}
	cacheFlush(db, 0);
	return true;
	
	
}

#endif

