/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KLIBIDO_UPDATEDB_H_
#define _KLIBIDO_UPDATEDB_H_

#include <qthread.h>
#include <qmutex.h>
#include "globals.h"
#include "newsgroup.h"
#include "nntpthreadsocket.h"
#include <qvaluelist.h>
#include <qfile.h>

 
#define UPDATEDBTHREADEVENT 64533

#if INDEXDB_VERSION != 0

struct SIndex {
	QString index;
	int partId;
};
#endif


class UpdateDbThreadEvent : public QCustomEvent {
	friend class QMgr;
	private:
		Job *j;
		int type;
		int partial;
		int total;
		int err;
		
	public:
		enum UpDbMessages  { UpDb_startExp, UpDb_stopExp, UpDb_startUpd, UpDb_stopUpd,  UpDb_Working, UpDb_Err, UpDb_DiskErr };
		UpdateDbThreadEvent(Job *_j, int t, int p=0, int tot=0) : QCustomEvent(UPDATEDBTHREADEVENT) , j(_j),  type(t) , partial(p), total(tot) {};
	
};



 /*
 Thread to update the newsgroup's db using temporary files...
 I'm having great problems directly updating db's, if more than one update thread is running.
 This could be a temporary workaround or a definitive solution..we'll see.
 */
 
 class UpdateDbThread: public QThread {
	 
	
		  
 	private:
		bool expire(NewsGroup *ng, int hostId);
		int dbHeaderPut(Db *db, Header*, int);
		QString createDateTime( QStringList dateTime);
		bool update();
		BinHeader* dbBinHeaderGet(Db*db, QString index);
		bool hasToBeExpired(int hostId, int lw, char* p);
		
		
		bool cacheFlush(Db* db, uint size=0);
#if INDEXDB_VERSION != 0		
		bool cachePut(Db* db, Db* sdb, Header* h, QString cIndex, int hostId);
		bool dbBinHeaderPut(Db *db, Db* sdb, Header*, int);
#else
		
		bool cachePut(Db* db, Header* h, QString cIndex, int hostId);
		bool dbBinHeaderPut(Db *db, Header*, int);
#endif
		
		
		//TEST: Secondary index for fast expiring
#if INDEXDB_VERSION != 0
		

		SIndex *getSIndex(Db* sdb, int artNum);
		bool writeSIndex(Db* sdb, int artNum, SIndex* sindex);
		bool delSIndex(Db* sdb, int partId);
		char* marIndex(SIndex* si);
		SIndex* unmarIndex(char* p);
		int sIndexSize(SIndex *si);
		bool expireByNum(NewsGroup *ng, int hostId);
#endif
		
		//Try to speed up updates using a cache...
		BinHeader *bh;
    
		
	
		int pos;
		int capPart;
		int capTotal;
		int index; // = rx.search(h->m_subj, -1);
		QRegExp rx;
		
		QDict<BinHeader> cache;
		QValueList<QString> cacheIndex;
		int cacheSize;
		
		int groupArticles;
		int unreadArticles;
		QValueList<Job*> *jobList;
		QMutex *listLock;
		QWidget *parent;
		Job *job;
		QFile *headerFile;
		QString line;
		UpdateDbThreadEvent *e;
		
	 
	 
	 
	 
 public:
 	UpdateDbThread(QWidget *, QMutex*, QValueList<Job*>*);
	virtual void run();
	enum Error {Write_Err};
 
};

#endif //_KLIBIDO_UPDATEDB_H_
