/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "queueparts.h"
#include <qfileinfo.h>




 
 void QUpdItem::update( int partId,  int partial, int total, int  )
{
	if (total == 0)
		return;
// 	parts[partId]->listItem->setText(3, QString::number(uint((float(partial)/float(total))*100)) + '%');
	parts[partId]->listItem->setText(3, QString::number( (partial*100)/total ) + '%');
}

QItem::QItem( KListView * parent, int id, int _type, NewsGroup *_ng)
{
	qItemId=id;
	type=_type;
	status=QItem::Queued_Item;
	partsToDo=0;
	failedParts=0;
	totalParts=0;
	workingThreads=0;
	processing = false;
	
// 	listItem=new KListViewItem(parent, QString::number(id), "Update " + _ng->dbName);
	listItem=new KListViewItem(parent, parent->lastChild());
	listItem->setText(0, QString::number(id));
	listItem->setText(1, "Update " + _ng->getName());
	listItem->setText(2, "Queued");
// 	listItem=new QUListViewItem(parent, this, ng);
	
	
	
	
	
	
}

QItem::QItem(KListView *parent, int id, int _type, QString subj, bool first)
{
	qItemId=id;
	type=_type;
	status=QItem::Queued_Item;
	partsToDo=0;
	totalParts=0;
	failedParts=0;
	workingThreads=0;
	
	if (!first) {
		listItem=new KListViewItem(parent, parent->lastChild());
		listItem->setText(0, QString::number(id));
		listItem->setText(1, subj);
	} else listItem=new KListViewItem(parent, QString::number(id), subj);
	listItem->setText(2, "Queued");
	
}


QItem::QItem( KListView * parent, int id, int _type, BinHeader *bh, bool first)
{
	qItemId=id;
	type=_type;
	status=QItem::Queued_Item;
	partsToDo=0;
	totalParts=0;
	failedParts=0;
	workingThreads=0;
	processing=false;
// 	if (!parent->childCount()) {
// 		listItem=new KListViewItem(parent, QString::number(id), bh->getSubj());
// 		
// 	} else {
// 	
	if (!first) {
			listItem=new KListViewItem(parent, parent->lastChild());
			listItem->setText(0, QString::number(id));
			listItem->setText(1, bh->getSubj());
	} else listItem=new KListViewItem(parent, QString::number(id), bh->getSubj());
	listItem->setText(2, "Queued");
		
		
	
	
// 	listItem=new QUListViewItem(parent, this, ng);
	
}

QItem::QItem( KListView * parent, int id, int _type )
{
	qItemId=id;
	type=_type;
	status=QItem::Queued_Item;
	partsToDo=0;
	failedParts=0;
	workingThreads=0;
	listItem=new KListViewItem(parent, parent->lastChild());
	listItem->setText(0, QString::number(id));
	listItem->setText(1, "Get list of all groups");
	processing = false;
}



bool QUpdItem::finished(int partId) {
// 	qDebug("QUpdItem::finished");

	parts[partId]->job->ng->stopUpdating();
	return QItem::finished(partId);
	
}

bool QListItem::finished( int partId )
{
// 	parts[partId]->job->ag->stopUpdating();
	return QItem::finished(partId);
}



bool QItem::finished(int partId) {
	
	//WTF?????
// 	status=QItem::Finished_Item;
	parts[partId]->status=QItem::Finished_Part;
	parts[partId]->listItem->setText(2, "Finished");
	parts[partId]->listItem->setText(3, "100%");
	workingThreads--;

	partsToDo--;
	if (partsToDo == 0) {
		listItem->setText(2, "Finished");
		status=QItem::Finished_Item;
		return true;
	} else {
		if (workingThreads == 0)
			listItem->setText(2, "Queued");
		else listItem->setText(2, "Processing (" + QString::number(workingThreads) + ")");
		return false;
	}
	
	
	
	
}


void QItem::canceled( int partId )
{
	status=QItem::Canceled_Item;
	parts[partId]->status=QItem::Canceled_Part;
	partsToDo--;
// 	workingThreads--;
	
	//Not useful anymore
	if (partsToDo == 0) {
		listItem->setText(2, "Canceled");
		status=QItem::Canceled_Item;
	}
	parts[partId]->listItem->setText(2, "Canceled");
	parts[partId]->listItem->setText(3, "");
}

/*
void QItem::error(int partId, QString &error) {
	parts[partId]->status=QItem::Failed_Part;
	parts[partId]->job->status=Job::Failed_Job;
	count--;
	if (count == 0) {
		listItem->setText(2, "Finished!");
		status=QItem::Finished_Item;
	}
		parts[partId]->listItem->setText(2, "Failed");
		parts[partId]->listItem->setText(3, error);
	
	
	
}
*/

QPostItem::QPostItem( KListView * parent, int id, QString subj, QString rfn, QString _savePath, bool first, bool _view ) : QItem(parent, id, Job::GetPost, subj, first)
{
	rootFName=rfn;
	savePath=_savePath;
	post=NULL;
	view=_view;
	etaTimeout=5;
	etaTimer=NULL;
	
// 	qDebug("TotalLines: %d", totalPostLines);
	curPostLines=0;
	intervalPostLines=0;
	partialLines=0;
	overwriteExisting=Config().overwriteExisting;
	deleteFailed=Config().deleteFailed;
	
}


QPostItem::QPostItem( KListView * parent, int id, BinHeader * bh, QString rfn, QString _savePath, bool first, bool _view ) :QItem(parent, id, Job::GetPost, bh, first)
{
	rootFName=rfn;
	savePath=_savePath;
// 	totalPostLines=bh->getLines();
	totalPostLines=bh->getSize();
	post=bh;
	view=_view;
	etaTimeout=5;
	etaTimer=NULL;
	
// 	qDebug("TotalLines: %d", totalPostLines);
	curPostLines=0;
	intervalPostLines=0;
	partialLines=0;
	overwriteExisting=Config().overwriteExisting;
	deleteFailed=Config().deleteFailed;
// 	qDebug("Created QPostItem with id %d, listItem: %d", id, listItem);
	
	
	
}

void QUpdItem::addJobPart( int jobId, int partId, Part * part )
{
// 	jobPart.insert(jobId, partId);
	parts.insert(partId, part);
	if (listItem->childCount() == 0)
		part->listItem=new KListViewItem(listItem, QString::number(jobId), part->desc, "Queued");
	else {
		QMap<int, Part*>::iterator it=parts.end();
		--it;
		--it;
		part->listItem=new KListViewItem(listItem, it.data()->listItem);
		part->listItem->setText(0, QString::number(jobId));
		part->listItem->setText(1, part->desc);
		part->listItem->setText(2, "Queued");
	}
	++partsToDo;
	part->listItem->setSelectable(false);
	
	
}

void QListItem::addJobPart( int jobId, int partId, Part * part )
{
	parts.insert(partId, part);
	if (listItem->childCount() == 0)
		part->listItem=new KListViewItem(listItem, QString::number(jobId), part->desc, "Queued");
	else {
		QMap<int, Part*>::iterator it=parts.end();
		--it;
		--it;
		part->listItem= new KListViewItem(listItem, it.data()->listItem);
		part->listItem->setText(0, QString::number(jobId));
		part->listItem->setText(1, part->desc);
		part->listItem->setText(2, "Queued");
	}
	part->listItem->setSelectable(false);
	++partsToDo;
}




void QPostItem::addJobPart( int jobId, int partId, Part * part )
{
	
// 	jobPart.insert(jobId, partId);
	
	
	parts.insert(partId, part);

	if (listItem->childCount() == 0)
			part->listItem=new KListViewItem(listItem,QString::number(jobId), part->desc, "Queued article");
	else {
		QMap<int, Part*>::iterator it=parts.end();
		--it;
		--it;
// 		part->listItem=new KListViewItem(listItem, parts[partId-1]->listItem);
		part->listItem=new KListViewItem(listItem, it.data()->listItem);
		part->listItem->setText(0, QString::number(jobId));
		part->listItem->setText(1, part->desc);
		part->listItem->setText(2, "Queued article");
	// 	qDebug("JobId: %d, PartId: %d", jobId, partId);
	}
	part->listItem->setSelectable(false);
	++partsToDo;
	++totalParts;
	listItem->setText(3, "0/0/" + QString::number(totalParts));
// 	qDebug("Added jobId %d to listItem %d, qItemId: %d", jobId, listItem, qItemId);
	
	
}

void QPostItem::addJobPartWithStatus( int jobId, int partId, Part * part, int status )
{
	//First, normally add the part...
// 	qDebug("Status: %d", status);
	addJobPart(jobId, partId, part);
	QString err="Failed from previous session";
	//Then simulate what happened...
	switch (status) {
		case QItem::Queued_Part:
			//Nothing to do...
			break;
		case QItem::Failed_Part:
			partsToDo--;
			failedParts++;
			parts[partId]->job->status=Job::Failed_Job;
			parts[partId]->listItem->setText(2, "Failed");
			parts[partId]->listItem->setText(3, err);
			
			
			break;
		case QItem::Finished_Part:
			parts[partId]->status=QItem::Finished_Part;
			parts[partId]->listItem->setText(2, "Finished");
			parts[partId]->listItem->setText(3, "100%");
			parts[partId]->job->status=Job::Finished_Job;
			partsToDo--;
			
			
			break;
	}
}


QUpdItem::QUpdItem( KListView * parent, int id, NewsGroup * ng ) : QItem(parent, id, Job::UpdHead, ng)
{
}

QListItem::QListItem( KListView * parent, int id, Db * gdb ) : QItem(parent, id, Job::GetList) ,    groupsDb(gdb)
{
	
}


//Bleach! :-P
void QPostItem::update( int partId, int partial, int total, int lastIntervalLines )
{
	if (total == 0)
		return;
	uint percentage=uint((float(partial)/float(total))*100);
	if ( (percentage <= 100) )
		parts[partId]->listItem->setText(3, QString::number(percentage) + '%');
	else parts[partId]->listItem->setText(3, QString::number(partial) + " lines");
	
	curPostLines+=lastIntervalLines;
	listItem->setText(2, "Processing (" + QString::number(workingThreads) + ") " + \
			QString::number(uint(float(curPostLines)/float(totalPostLines)*100)) + '%');
	
// 	etaCount++;
// 	if (etaCount >=etaTimeout) {
// 		etaCount=0;
// 		
// 		updateEta();
// 		
// 	}
	
	
	
	
	
}


void QPostItem::updateDecodingProgress(int prog)
{
	listItem->setText(2, i18n("Decoding (") + QString::number(prog) + "%)");
}

void QPostItem::startDecoding()
{
	listItem->setText(2, i18n("Decoding..."));
}



bool QPostItem::finished( int partId )
{
	QItem::finished(partId);
	partialLines=0;
	

	
	if (partsToDo == 0) {
		//send the item to the decoder thread...
// 		decode();
		if (etaTimer) {
			etaTimer->stop();
			delete etaTimer;
			etaTimer=0;
		}
		listItem->setText(2, i18n("Waiting for decoding..."));
		listItem->setText(3, "");
		listItem->setText(4, "");
		
		
		processing = true;
		emit decodeMe(this);
		return true;
	}else  {
		if (workingThreads == 0)
			etaTimer->stop();
		
		listItem->setText(3, QString::number(totalParts - partsToDo) + '/' + QString::number(failedParts) + '/' + QString::number(totalParts) );
		
		return false;
	}
}


void Thread::resetSpeed() {
	speedIndex = 0;
	for (int i = 0; i < SPEED_MEAN ; i++) {
		speedBytes[i][0] = 0;
		speedBytes[i][1] = 0;
	}
	prevTime = QTime::currentTime();
}


Thread::Thread(uint _serverId, uint _threadId, uint to, uint rc, QWidget * p ) : serverId(_serverId), threadId(_threadId), threadTimeout(rc)
{
	retryCount=0;
	timeout=to*1000;
	threadBytes=new uint;
	*threadBytes=0;
	prevBytes=0;
	resetSpeed();
// 	status=NntpThreadSocket::Ready;
	nt=new NntpThreadSocket(p, threadBytes);
	nt->setId(serverId, threadId);
	speedTimer=new QTimer(this);
	idleTimer=new QTimer(this);
	retryTimer=new QTimer(this);
	connect(speedTimer, SIGNAL(timeout()), this, SLOT(slotSpeedTimeout()));
	connect(idleTimer, SIGNAL(timeout()), this, SLOT(slotIdleTimeout()));
	connect(retryTimer, SIGNAL(timeout()), this, SLOT(slotRetryTimeout()));
	

	
	
}

/*
void Thread::setJob( Job * j )
{
	
 	if (nt->running()) {
		//Should never be here, 'coz now I wait for the thread to finish in the Thread::stop()
 		qDebug("Thread::setJob(): trying to add a job to a running thread!");
		qDebug("ServerId: %d, id: %d", serverId, threadId);
		nt->wait();
		qDebug("ok, thread stopped");
 	}
	
	
	if (nt->addJob(j)) {
			
		nt->start();
// 		status=NntpThreadSocket::Working;
	} else qDebug("Failed to add job");
// 	qDebug("Added job to thread %d,%d", serverId, threadId);
// 	qDebug("Status: %d", status);
		
	
// 	nt->start();
	
}
*/


bool Thread::stop( )
{
// 	qDebug("About to lock %d,%d", serverId, threadId);

// 	qDebug("Locked");
/*	if ( nt->running() )
		nt->wait();*/
	
// 	retryCount=0;
// 	qDebug("%d,%d: Stopping retry Timer inside Thread::stop()", serverId, threadId);
// 	retryTimer->stop();
	speedTimer->stop();
	if (nt->isConnected()) {
		idleTimer->start(timeout, true);
		
		return true;
	} else {
		
		return false;
	}

}

void Thread::slotSpeedTimeout( )
{
	
	curTime = QTime::currentTime();
	interval = prevTime.msecsTo(curTime);
	prevTime = curTime;
	speedBytes[speedIndex][0] = *threadBytes - prevBytes;
	prevBytes = *threadBytes;
	speedBytes[speedIndex][1] = interval;
	bytes = 0;
	interval = 0;
	for (int i = 0 ; i < SPEED_MEAN; i++) {
		bytes += speedBytes[i][0];
		interval += speedBytes[i][1];
// 		qDebug("Bytes: %f; interval: %d", bytes, interval);
		
	}
// 	emit sigThreadSpeedChanged(serverId, threadId, (int)((*threadBytes-prevBytes)/1024));
	emit sigThreadSpeedChanged(serverId, threadId, (int)(((bytes/1024)/(float) (interval/1000))));
	if (++speedIndex >= SPEED_MEAN)
		speedIndex = 0;
	
	
}

void Thread::error( )
{
// 	retryCount=0;
	
}

void Thread::slotRetryTimeout()
{
	//Unpause the job
	qDebug("%d, %d: Thread::slotRetryTimeout", serverId, threadId);
// 	status=NntpThreadSocket::Ready;
// 	nt->setStatus(NntpThreadSocket::Ready);
	//No need to stop the timer as it's single shot...

// 	nt->tStart();
	nt->tResume();
	emit sigThreadResumed();
	speedTimer->start(1000,false);
	idleTimer->stop();
	
}


void Thread::comError( )
{
	//Now I'm paused...
// 	status=NntpThreadSocket::Paused;
	speedTimer->stop();
	resetSpeed();
	idleTimer->stop();
	
// 	qDebug("%d, %d: retrycount: %d", serverId, threadId, retryCount);
	
	if (retryCount < RETRYCOUNT) {
// 		qDebug("Starting %d,%d retry Timer", serverId, threadId);
		retryTimer->start(retryTimeouts[retryCount]*1000, true);
		emit sigThreadPaused(serverId, threadId, retryTimeouts[retryCount]);
		retryCount++;
	}
	else if (retryCount  > (RETRYCOUNT + threadTimeout+1)) {
		//Pause the thread!!!
		emit sigThreadPaused(serverId, threadId, 0); 
	} else {
		retryTimer->start(60000, true);
		retryCount++;
		
		emit sigThreadPaused(serverId, threadId, 60);
	}
	
	
	
	
	
}

void Thread::paused( )
{
	speedTimer->stop();
	resetSpeed();
	
	idleTimer->start(timeout, true);
// 	qDebug("Thread Paused");
	
}



/*
DecodeThread::DecodeThread(QWidget *p, QMutex *mutex, QValueList< QPostItem * > *decodeList) : QThread()
{
	parent=p;
	items=decodeList;
	listLock=mutex;
	
	
}*/

DecodeThread::DecodeThread(QWidget *p, QMutex *mutex, QValueList< QPostItem * > *decodeList) : DecoderThread(p, mutex, decodeList)
{
	uu = new UUCallBack();
	uu->parent = p;
	uu->cancel = &m_cancel;
	uu->item = 0;
}

void SelfDecodeThread::run( )
{
// 	kdDebug() << "Starting decode thread...\n";
	while(!items->isEmpty()) {
		listLock->lock();
		item=items->first();
		listLock->unlock();
		if ( decode(item )) {
			listLock->lock();
			items->remove(items->first());
			item=0;
			listLock->unlock();
			
		} else if (m_cancel) {
			kdDebug() << "Canceled item id: " << item->qItemId << endl;
			DecodeThreadEvent *dte = new DecodeThreadEvent(item, DecodeThreadEvent::Dte_Canceled);
			listLock->lock();
			items->remove(items->first());
			item = 0;
			m_cancel = false;
			listLock->unlock();
			QApplication::postEvent(parent, dte);
		} else break;

	}
// 	kdDebug() << "Exiting decode thread...\n";
	
}


void DecodeThread::run( )
{
	

// 	qDebug("DecodeThread::run(): Items in queue: %d", items->count());
	
	while(!items->isEmpty()) {
		listLock->lock();
		item = items->first();
		listLock->unlock();
		if (decode(item)) {
			listLock->lock();
			items->remove(items->first());
			item = 0;
			listLock->unlock();
		} else  if (m_cancel) {
			//Canceled the item...
			DecodeThreadEvent *dte = new DecodeThreadEvent(item, DecodeThreadEvent::Dte_Canceled);
			listLock->lock();
			items->remove(items->first());
			item = 0;
			m_cancel = false;
			listLock->unlock();
			QApplication::postEvent(parent, dte);
			
					
		} else break;

	}
// 	qDebug("Decoding done");

	
}


//Static function to get the progress of the decoding...

static int busyCallback( void *opaque, uuprogress * uuprog )
{
// 	bool *canc = (bool*) opaque;
// 	DecoderThread *dt = (DecoderThread*) opaque;
	UUCallBack *uu = (UUCallBack*) opaque;
	DecodeThreadEvent *dte;
	kdDebug() << "Cancel: " << *(uu->cancel) << endl;
// 	kdDebug() << "Parent: " << uu->parent << endl;
	if (*(uu->cancel)) {
		//Cancel loading/decoding
		dte = new DecodeThreadEvent(uu->item, DecodeThreadEvent::Dte_Canceling);
		QApplication::postEvent(uu->parent, dte);
		return -1;
	} else if (uuprog->action  == UUACT_DECODING) {
		//float progress = ((float)100*((float)uuprog->partno) + ((float)uuprog->percent))/(float)(uuprog->numparts);
		int progress = (100 * uuprog->partno - uuprog->percent) / uuprog->numparts;
		kdDebug() << "Part " << uuprog->partno << " progress: " << uuprog->percent << endl;
		kdDebug( ) << "Total progress: " << progress << endl;
		dte = new DecodeThreadEvent(uu->item, DecodeThreadEvent::Dte_Progress);
		dte->setProgress(progress);
		QApplication::postEvent(uu->parent, dte);		
	}
	return 0;
	
}



bool DecodeThread::decode(QPostItem *postItem )
{
// 	qDebug("DecodeThread::decode()");
	DecodeThreadEvent *dte = new DecodeThreadEvent(postItem, DecodeThreadEvent::Dte_Start);
	QApplication::postEvent(parent, dte);
	dte = NULL;
	uulist *UUItem;
	int res;
	
	QTime start, end;
	start = QTime::currentTime();
	uu->item = postItem;
	
	UUInitialize();
	UUSetOption(UUOPT_FAST, 0, NULL);
	//BEGIN modified for debug
	UUSetOption(UUOPT_OVERWRITE, m_overWrite , NULL);
	//END modified for debug
	UUSetOption(UUOPT_DESPERATE, 1, NULL);
	UUSetOption(UUOPT_SAVEPATH, 0, postItem->getSavePath());
	UUSetOption(UUOPT_REMOVE, 0, NULL);
// 	int (*cb)(void*, uuprogress*);
// 	cb = (int (*) ( void*, uuprogress*)) busyCallback(void*, uuprogress* );
	UUSetBusyCallback(uu, busyCallback, 500);
	QMap<int, Part *>::iterator pit;
	bool errorFlag=false;
	
	kdDebug() << "Cancel: " << m_cancel << endl;
	for (pit=postItem->parts.begin(); pit != postItem->parts.end() ; ++pit) {
		QString file=postItem->getFName() + '.' + QString::number(pit.key());
		kdDebug() << "Loaded " << postItem->getFName() << '.' << pit.key() << endl;
// 		if ((res=UULoadFileWithPartNo( (char*)((const char *) file) , NULL, 0, pit.key())) != UURET_OK)
		if ((res=UULoadFile( (char*)((const char *) file) , NULL, 0)) != UURET_OK)
		{
			kdDebug() << "Error loading part " << pit.key() << ": " << res << endl;
		}
		if (m_cancel) {
			UUCleanUp();
			if (dte)
				delete dte;
			return false;
		}
		
	}
	int i;
	for (i = 0; (UUItem=UUGetFileListItem(i)) != NULL; i++) {
		
		if ((UUItem->state & UUFILE_OK) == 0) {
			kdDebug() << "Error decoding post\n";
			dte=new DecodeThreadEvent(false, postItem);
			QString error=i18n("Error(s): ");
			if ((UUItem->state & UUFILE_MISPART)==0)
				error+=i18n("Missing part; ");
			if ((UUItem->state & UUFILE_NODATA)==0)
				error+=i18n("No data; ");
			dte->setError(error);
			errorFlag=true;
		}
		
			
		//Try to decode anyway...
		if (m_cancel) {
			UUCleanUp();
			if (dte)
				delete dte;
			return false;
		}
		res = UUDecodeFile(UUItem, NULL);
		
		end = QTime::currentTime();
		kdDebug() << "Seconds used with UULib decoder: " << start.secsTo(end) << endl;
		
		
		int j = 1;
		QString origName=UUItem->filename;
		while (res == UURET_EXISTS & !m_cancel) {
			//new name!
			QString newName = origName + '.' + QString::number(j);
			j++;
			UURenameFile(UUItem, (char*) newName.latin1());
			res=UUDecodeFile(UUItem, NULL);
			
		}
		if (m_cancel) {
			UUCleanUp();
			if (dte)
				delete dte;
			return false;
		}
		
		if ( res != UURET_OK) {
			
			
			if (res == UURET_IOERR) {
				//Write error...disk full?
				kdDebug() << "Write error during decode\n";
				//Forgot to put "diskerr" to "yes"
				dte=new DecodeThreadEvent(false, postItem, true);
				dte->setFileName(UUItem->filename);
				dte->setError(i18n("Write error!"));
				QApplication::postEvent(parent, dte);
				return false;
				
			} else if (!errorFlag) {
				dte=new DecodeThreadEvent(false, postItem);
				dte->setError(UUstrerror(res));
				dte->setFileName(UUItem->filename);
			}

			
		} else {
			if (!errorFlag) {
// 				qDebug("Successfully decoded %s", item->filename);
				dte=new DecodeThreadEvent(true, postItem);
				dte->setFileName(UUItem->filename);
				
			}
			
			
		}
		
	}
	if ( i==0 ) {
		//No file do decode (rare, but it happens)
// 		qDebug("No data");
		dte=new DecodeThreadEvent(false, postItem);
		dte->setError(i18n("No data to decode"));
		dte->setFileName("");
	}
	
	
	
	
	
	
	
	UUCleanUp();
	QApplication::postEvent(parent, dte);
	return true;
	
}


void Thread::threadCancel( )
{
	
	nt->tCancel();
	retryCount=0;
	
}


void Thread::canceled( )
{
	if (nt->running()) {
// 		qDebug("Thread::stop(): Thread %d,%d running...", serverId, threadId);
		nt->wait();
// 		qDebug("Thread::stop(): ok, thread %d,%d stopped ", serverId, threadId);
	} // else qDebug("Thread::stop(): thread %d,%d stopped", serverId, threadId);
	speedTimer->stop();
	resetSpeed();
	//The thread is now disconnected...I don't need a timeout timer...
// 	idleTimer->start(timeout, true);
// 	status=NntpThreadSocket::Ready;
// 	qDebug("Thread %d,%d Canceled", serverId, threadId);
	
// 	nt->setStatus(NntpThreadSocket::Ready);
// 	*cancel=false;
	//*control=
	
}

void Thread::start( )
{
// 	idleTimer->stop();
// 	qDebug("%d,%d: Stopping retry Timer inside Thread::start()", serverId, threadId);
// 	retryTimer->stop();
	
// 	retryCount=0;
// 	qDebug("Start!");
	nt->tStart();
	
// 	speedTimer->start(1000, false);
			
	
	
		

	
// 	status=NntpThreadSocket::Working;
}

void Thread::pause() {

	nt->tPause();

	
}



void Thread::resume() {
	
	idleTimer->stop();
// 	speedTimer->start(1000, false);
	nt->tResume();
	
// 	speedTimer->start();
	
}

void QPostItem::decodeFinished( )
{
	listItem->setText(2, "Decoded");
}

int QUpdItem::error( int partId, QString & error )
{
	
	parts[partId]->status=QItem::Failed_Part;
	parts[partId]->job->status=Job::Failed_Job;
	partsToDo--;
	failedParts++;
	workingThreads--;
	parts[partId]->listItem->setText(2, i18n("Failed"));
	parts[partId]->listItem->setText(3, error);
	parts[partId]->job->ng->stopUpdating();
	if (partsToDo == 0) {
		listItem->setText(2, i18n("Finished!"));
		status=QItem::Finished_Item;
		return QItem::Finished;
	} else {
		listItem->setText(2, i18n("Queued"));
		return QItem::Continue;
	}
		
	
	
	
}
int QListItem::error( int partId, QString & error )
{
	kdDebug() << "QListItem::error\n";
	parts[partId]->status=QItem::Failed_Part;
// 	parts[partId]->job->status=Job::Failed_Job;
	partsToDo--;
	failedParts++;
	workingThreads--;
	parts[partId]->listItem->setText(2, "Failed");
	parts[partId]->listItem->setText(3, error);
// 	parts[partId]->job->ag->stopUpdating();
	if (partsToDo == 0) {
		listItem->setText(2, i18n("Finished"));
		status=QItem::Finished_Item;
		return QItem::Finished;
	} else {
		listItem->setText(2, i18n("Queued"));
		return QItem::Continue;
	}
}

void QPostItem::comError( int partId )
{
	parts[partId]->status=QItem::Queued_Part;
	workingThreads--;
	parts[partId]->listItem->setText(2, i18n("Queued"));
	parts[partId]->listItem->setText(3, "");
	if (workingThreads == 0)   {
		listItem->setText(2, i18n("Queued"));
		etaTimer->stop();
	}
	else listItem->setText(2, i18n("Processing (") + QString::number(workingThreads) + ")");
}



int QPostItem::error( int partId, QString & error )
{
	parts[partId]->status=QItem::Failed_Part;
// 	parts[partId]->job->status=Job::Failed_Job;
	
	//Check if there is another server for the part.
	//Yes->tell the qManager to reque
	//No-> if this was the last part, send
	
	//Delete the server from the part
	post->partNum[partId].remove(parts[partId]->qId);
	//check if there are other parts
	workingThreads--;
	if (workingThreads == 0)   {
		listItem->setText(2, i18n("Queued"));
		etaTimer->stop();
	} else listItem->setText(2, i18n("Processing (") + QString::number(workingThreads) + ")");
	if (post->partNum[partId].count() != 0) {
		//Yes, requeue me
		return QItem::RequeMe;
	} else {
		partsToDo--;
		failedParts++;
		parts[partId]->listItem->setText(2, i18n("Failed"));
		parts[partId]->listItem->setText(3, error);
		//No, check if this was the last part...
		if (partsToDo == 0) {
			//last part, remove from queue
			status=QItem::Finished_Item;
			listItem->setText(2, i18n("Waiting for decoding..."));
			listItem->setText(3, "");
			etaTimer->stop();
			delete etaTimer;
			etaTimer=NULL;
			emit decodeMe(this);
			return QItem::Finished;
			
		} else {
			//there are other parts, continue
// 			listItem->setText(3, QString::number(partsToDo) + " parts left");
			listItem->setText(3, QString::number(totalParts - partsToDo) + '/' + QString::number(failedParts) + '/' + QString::number(totalParts) );
			return QItem::Continue;
			
		}
	}
	
	
	
	return -1;

}


QPostItem::~ QPostItem( )
{
	if (etaTimer)
		delete etaTimer;	
	delete listItem;
	delete post;
	
}

QUpdItem::~ QUpdItem( )
{
	listItem->setSelected(false);
	delete listItem;
}

void QItem::start( int partId)
{
	parts[partId]->listItem->setText(2, "Downloading");
	parts[partId]->listItem->setText(3, "0%");
	workingThreads++;
	listItem->setText(2, "Processing ("+ QString::number(workingThreads) + ")");
	
}

Thread::~ Thread( )
{
	
	
	delete speedTimer;
	delete idleTimer;
	delete retryTimer;
	
	delete nt;
	delete threadBytes;
	
	
	
}

void Thread::kill( )
{
	if (nt->running()) {
		nt->terminate();
		nt->wait();
	}
}

void QItem::paused( int partId )
{
	status=QItem::Paused_Item;
	parts[partId]->status=QItem::Paused_Part;
	parts[partId]->listItem->setText(2, "Paused");
}

void QItem::resumed( int partId )
{
	status=QItem::Queued_Item;
	parts[partId]->status=QItem::Queued_Part;
	parts[partId]->listItem->setText(2, "Queued");
}

void Thread::slotIdleTimeout( )
{
	if (nt->running()) {
		qDebug("Thread::slotIdleTimeout(): quitting a running thread??");
		return;
	}
	
	nt->closeConnection();
	qDebug("Quit idle thread");
	emit sigThreadDisconnected(serverId, threadId);
	
	
}

void QUpdItem::startExpiring( int partId )
{

	parts[partId]->listItem->setText(2, "Expiring");
	parts[partId]->listItem->setText(3, "0%");
}

void QUpdItem::stopExpiring(int partId)
{

	parts[partId]->listItem->setText(2, "Idle");
}


void QListItem::update( int , int , int,int )
{
}

QListItem::~QListItem()
{
	delete listItem;
}

void QUpdItem::startUpdateDb( int partId )
{
	parts[partId]->listItem->setText(2, "Updating DB");
	parts[partId]->listItem->setText(3, "0%");
	
}

void QUpdItem::stopUpdateDb( int partId )
{
	parts[partId]->listItem->setText(2, "Done");
}

void QUpdItem::downloadFinished( int partId )
{
	
	parts[partId]->listItem->setText(2, "Waiting for db update");
	parts[partId]->listItem->setText(3, "");
}

void QPostItem::start( int partId)
{
	parts[partId]->listItem->setText(2, "Downloading");
	parts[partId]->listItem->setText(3, "0%");
	if (etaTimer == 0) {
		etaTimer=new QTimer(this);
		connect(etaTimer, SIGNAL(timeout()), this, SLOT(slotEtaTimeout()));
		prevTime=QTime::currentTime();
		intervalPostLines=curPostLines;
		etaTimer->start(etaTimeout*1000);
	} else if (workingThreads==0) {
		prevTime=QTime::currentTime();
		etaTimer->start(etaTimeout*1000);
		intervalPostLines=curPostLines;
	}
	workingThreads++;
	listItem->setText(2, "Processing ("+ QString::number(workingThreads) + ") " + QString::number(uint(float(curPostLines)/float(totalPostLines)*100)) + '%');
	
	
}

void QPostItem::slotEtaTimeout( )
{
	curTime=QTime::currentTime();
	uint interval=prevTime.msecsTo(curTime);
	uint intervalLines=curPostLines-intervalPostLines;
	
	float speed=( (float(intervalLines)/float(interval)) *float(1000));
	if (speed == 0)
		return;
	uint eta= uint (float(totalPostLines - curPostLines)/float(speed));
	//Maybe a mean can "stabilize" the result
// 	uint eta=prevEta+currEta/2;
// 	prevEta=currEta;
	

	
	//Now convert to HH::MM::SECS
// 	qDebug("eta: %d", eta);
	uint hours=(uint)(eta/3600);
	
	eta%=3600;
	
	uint minutes=eta/60;
	eta%=60;
	//now eta = seconds.
	QString etaString = QString::number(hours).rightJustify(2,'0') + ':' +\
			QString::number(minutes).rightJustify(2,'0') + ':' + QString::number(eta).rightJustify(2,'0');
	
	listItem->setText(4, etaString);
	
	
}

void QPostItem::canceled( int partId )
{
	status=QItem::Canceled_Item;
	parts[partId]->status=QItem::Canceled_Part;
	partsToDo--;
// 	workingThreads--;
	if (etaTimer)
		delete etaTimer;
	etaTimer=NULL;
	//Not useful anymore ?
	if (partsToDo == 0) {
		listItem->setText(2, "Canceled");
		status=QItem::Canceled_Item;
	}
	parts[partId]->listItem->setText(2, "Canceled");
	parts[partId]->listItem->setText(3, "");
	
}

void QItem::requeue( int partId )
{
	parts[partId]->status=QItem::Queued_Part;
	workingThreads--;
	parts[partId]->listItem->setText(2, "Queued");
	parts[partId]->listItem->setText(3, "");
}




void Thread::setQueue(QValueList<int> *tq, QMap<int, QItem*> *q, QMutex *qLock, int *po) {
	nt->setQueue(tq, q, qLock,po);
}

void Thread::resetRetryCounter( )
{
	retryCount=0;
}

void Thread::started( )
{
	speedTimer->start(1000);
	resetSpeed();
	idleTimer->stop();
}

/*
Decoder * SelfDecodeThread::getDecoderForPost( QStringList posts )
{
	Decoder *decoder = new yyDecoder(posts,destDir);
	if (decoder->isDecodable()) {
		return decoder;
	}
	else { 
		delete decoder;
		decoder = new uuDecoder(posts,destDir);
		if (decoder->isDecodable()) {
			return decoder;
		}
		else {
			delete decoder;
			kdDebug()<<"Downloadmanager: Unrecognised post format - not y/uencoded\n";
			return NULL;
		}
	}
}*/

Decoder * SelfDecodeThread::getDecoderForPost(QStringList posts) {
	int linesToCheck=100;
	QStringList::Iterator partIt = posts.begin();
	while (partIt != posts.end()) {
		QFile partFile(*partIt);
		++partIt;
		if (partFile.open(IO_ReadOnly)) {
			//Find the begin tag
			QString line;
			while ( (linesToCheck-- > 0) && (partFile.readLine(line,1024)!=-1) ) {
				if (line.left(5)=="begin") {
					kdDebug() << "UUencoded post found\n";
// 					kdDebug() << "UUencoded file found!\n";
					partFile.close();
					//We want everything after "begin 644 "
					QString fName = line.stripWhiteSpace().mid(10);
					kdDebug() << "Checking existance of " << destDir+fName << endl;
					if (!m_overWrite && QFile::exists(destDir + fName)) {
						kdDebug() << "File exists!\n";
						//rename the file
						int i = 1;
						while (QFile::exists(destDir + fName + '.' + QString::number(i)) ) {
							i++;
						}
						fName += '.';
						fName += QString::number(i);
					}
					kdDebug() << "Fname: " << fName << endl;
					return new uuDecoder(posts, destDir, fName, parts );
					
					
					
					
				} else if (line.left(7) == "=ybegin") {
					//ok, found a yyencoded post
					line=line.stripWhiteSpace();
					kdDebug() << "yyenc post found\n";
					int namePos = line.find("name=");
					QString fName = line.right(line.length()-namePos-5);
					if (!m_overWrite && QFile::exists(destDir + fName)) {
						int i = 1;
						while (QFile::exists(destDir + fName + '.' + QString::number(i)) )
							i++;
						fName += '.';
						fName += QString::number(i);
					}
					kdDebug() << "Filename: " << fName << endl;
					int sizePos = line.find("size=");
					int expectedSize=line.mid(sizePos+5, line.find(" ", sizePos+5) - sizePos - 5).toLong();
					partFile.close();
					return new yyDecoder(posts, destDir , fName, expectedSize);
					
				}
				
				
			}
		}
		partFile.close();
	}
	
	return NULL;
	
	
	
}



bool SelfDecodeThread::decode( QPostItem *postItem )
{
	
	DecodeThreadEvent *dte=0;
	dte = new DecodeThreadEvent(postItem, DecodeThreadEvent::Dte_Start);
	QApplication::postEvent(parent, dte);
	QTime start, end;
	start=QTime::currentTime();
	QStringList partList;
	bool errorFlag=false;
	bool diskError=false;
	QString errorString=QString::null;
	QMap<int, Part *>::iterator pit;
	parts = 0;
	int progress = 0;
	
	//Build a QStringList of filenames (with path)
	for (pit=postItem->parts.begin(); pit != postItem->parts.end(); ++pit) {
		partList.append(postItem->getFName() + '.' + QString::number(pit.key()));
		if (pit.key() > parts)
			parts=pit.key();
	}
	destDir=postItem->getSavePath();
	
 	decoder=getDecoderForPost(partList);
	int doneParts = 0;
	if (decoder!=NULL) {
		while (!m_cancel && !diskError && !decoder->decodingComplete()) {
			doneParts++;
// 			sleep(1);
			switch (decoder->decodeNextPart()) {
				case Decoder::Err_BadCRC:
					//bad crc in part
					errorFlag=true;
					errorString += "Bad part crc; ";
					break;
				case Decoder::Err_MissingPart:
					//Missing part...right now only activated if cannot read from input
					errorFlag=true;
					errorString +="Missing part; ";
					break;
				case Decoder::Err_No:
					//No error
					break;
				case Decoder::Err_SizeMismatch:
					//Size mismatch between expected size and written bytes
					errorFlag=true;
					errorString += "Part size mismatch; ";
					break;
				case Decoder::Err_Write:
					//Disk error...disk full?
					errorFlag=true;
					diskError=true;
					errorString = "I/O error!";
					break;
				
// 				
			}
			dte = new DecodeThreadEvent(postItem, DecodeThreadEvent::Dte_Progress);
			progress = (int)(((float)doneParts/(float) parts)*100);
			dte->setProgress(progress);
			QApplication::postEvent(parent, dte);
			
				
		}
		if (!m_cancel && !decoder->isSizeCorrect()) {
			//Error: size is wrong.
			//This can happen because there are some missing parts in the post.
			errorFlag=true;
			errorString += "Wrong size";
			kdDebug() << "Wrong total size" << endl;
		}
		
		
	} else {
		kdDebug() << "Decoder is null!" << endl;
		kdDebug() << "Post is not uu/yyencoded\n";
		errorFlag=true;
		errorString = "Post is not uu/yyencoded";
	}
	
	
	
	//TODO: Handle rename if file exists (nope...it has to be done inside the decoder class
	/*
	int j = 1;
	while (res == UURET_EXISTS) {
		//new name!
		QString newName=item->filename;
			newName+= '.' + QString::number(j);
			j++;
			UURenameFile(item, (char*) newName.latin1());
			res=UUDecodeFile(item, NULL);
			
	}*/
	end = QTime::currentTime();
	kdDebug() << "Seconds used for decoding with knzb decoder: " << start.secsTo(end) << endl;
	if (m_cancel) {
		kdDebug() << "Canceled decoding\n";
		kdDebug() << "Deleting partial file: " << destDir + '/' + decoder->encodedFilename() << endl;
// 		dte = new DecodeThreadEvent(postItem, DecodeThreadEvent::Dte_Canceled);
		//Remove partial file
		if (decoder)
			QFile::remove(destDir + '/' + decoder->encodedFilename());
		return false;
	} else if (errorFlag && !diskError) {
		kdDebug() << "Error (but not a diskError)\n";
		dte=new DecodeThreadEvent(false, postItem);
		if (decoder)
			dte->setFileName(decoder->encodedFilename() );
		dte->setError(errorString);
	} else if (diskError) {
		dte = new DecodeThreadEvent(false, postItem, true);
		dte->setFileName(decoder->encodedFilename());
		dte->setError(errorString);
		
	} else {
		dte = new DecodeThreadEvent(true, postItem);
		dte->setFileName(decoder->encodedFilename());
	}
	if (decoder)
		delete decoder;
	kdDebug() << "Posting decoder event\n";
	QApplication::postEvent(parent, dte);
	
	if (diskError)
		return false;
	else return true;
	
	
}


DecoderThread::DecoderThread(QWidget *p, QMutex *mutex, QValueList<QPostItem*> *decodeList) : QThread()
{
	parent=p;
	items=decodeList;
	listLock=mutex;
	m_cancel = false;
}

/*
SelfDecodeThread::SelfDecodeThread( QWidget *p, QMutex *mutex, QValueList< QPostItem * > *decodeList ) : QThread()
{
	parent=p;
	items=decodeList;
	listLock=mutex;

	
}*/

SelfDecodeThread::SelfDecodeThread( QWidget *p, QMutex *mutex, QValueList< QPostItem * > *decodeList ) : DecoderThread(p, mutex, decodeList) {}

void QUpdItem::comError(int partId) {
	parts[partId]->status=QItem::Requeue_Part;
// 	workingThreads--;
	parts[partId]->listItem->setText(2, "Waiting for db update");
	parts[partId]->listItem->setText(3, "");
	
	
}

SaveQThread::SaveQThread( QValueList< QSaveItem * > *list, QMutex * lock, Db * qDb, QWidget * p )
{
	saveQDb = qDb;
	saveQLock = lock;
	parent = p;
	saveQItems = list;
	item = 0;
}

void SaveQThread::run( )
{
	int ok = 0;
	while(!saveQItems->isEmpty()) {
		item=saveQItems->first();
		if ( item &&  (ok = processItem(item ))) {
			saveQLock->lock();
			saveQItems->remove(saveQItems->first());
			saveQLock->unlock();
			delete item;
			item=0;
		} else if (!ok) {
			SaveQThreadEvent *e = new SaveQThreadEvent(SaveQThreadEvent::SQT_Error);
			QApplication::postEvent(parent, e);
			break;
		}

	}
	
}

bool SaveQThread::writeSaveItem( QSaveItem *si )
{
	kdDebug() << "Writing save item " << si->id << endl;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	key.set_data(&(si->id));
	key.set_size(szInt);
	char *p = saveItemData(si);
	data.set_data(p);
	data.set_size(saveItemSize(si));
	//TODO:free the data?
	

	if ( (saveQDb->put(0, &key, &data, 0) ) != 0) {
		delete [] p;
		return false;
	} else {
		delete [] p;
		saveQDb->sync(0);
		return true;
	}
	
}

QSaveItem *SaveQThread::readSaveItem( int id )
{
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	key.set_data(&id);
	key.set_size(szInt);
	
	data.set_flags(DB_DBT_MALLOC);
// 	key.set_flags(DB_DBT_MALLOC);
	
	if ( (saveQDb->get(0, &key, &data, 0)) != 0) {
		qDebug("Error getting item from queue db");
		return 0;
	} else {
		QSaveItem *si = loadSaveItem((char*)data.get_data());
// 		qDebug("SaveItem Loaded");
		free(data.get_data());
// 		free(key.get_data());
		return si;
	}
	
}

bool SaveQThread::processItem( QSaveItem *qsi )
{
	switch (qsi->type) {
		case QSaveItem::QSI_Add:
			return writeSaveItem(qsi);
			break;
		case QSaveItem::QSI_Delete:
			return delSaveItem(qsi->id);
			break;
		case QSaveItem::QSI_Update:
			return updateItem(qsi);
			break;
		default:
			kdDebug() << "Error: wrong QSaveItem type\n";
			return false;
			break;
	}
}

bool SaveQThread::updateItem( QSaveItem *qsi )
{
	QSaveItem *si = readSaveItem(qsi->id);
	kdDebug() << "Updating saveitem " << qsi->id << endl;
	if (!si) {
		kdDebug() << "Error reading the save item during update" << qsi->id << endl;
		return false;
	} else {
		si->partStatus[qsi->modPart]=qsi->modStatus;
		si->curPostLines=qsi->curPostLines;
		si->id = qsi->id;
		writeSaveItem(si);
		delete si;
		return true;
	}
	
	
}

bool SaveQThread::delSaveItem( int id )
{
	kdDebug() << "Deleting saveItem " << id << endl;
	QSaveItem *si = readSaveItem(id);
	if (si->group == "nzb"){
		SaveQThreadEvent *e = new SaveQThreadEvent(SaveQThreadEvent::SQT_DelNZB, si->index);
		QApplication::postEvent(parent, e);
	}
	delete si;
		
	memset(&key, 0, sizeof(key));
	key.set_data(&id);
	key.set_size(szInt);
	
	
	if (saveQDb->del(0, &key,0) != 0) {
		kdDebug() << "Error deleting key from db\n";
		return false;
	} else {
		saveQDb->sync(0);
		return true;
	}
	
}

int SaveQThread::saveItemSize( QSaveItem *si )
{
	return si->group.length() + si->index.length() +  + si->rootFName.length() + \
			si->savePath.length() + si->tmpDir.length() + 7*sizeof(uint) \
			+ 2*(si->partStatus.count())*sizeof(int) ;
}

char* SaveQThread::saveItemData( QSaveItem *si )
{
	char *p=new char[saveItemSize(si)];
	char *i=&p[0];
	i=insert( si->group, i);
	i=insert( si->index, i);
	
	i=insert( si->rootFName, i);
	i=insert( si->savePath, i);
	i=insert( si->tmpDir, i);
	
	
	
	int szInt=sizeof(uint);
	memcpy(i, &(si->curPostLines), szInt);
	i+=szInt;
	
	//Now save the partMap...
	int count = si->partStatus.count();
	memcpy(i, &count, szInt);
	i+=szInt;
	
	int id, status;
	QMap<int, int>::iterator it;
	for (it = si->partStatus.begin(); it != si->partStatus.end() ; ++it) {
		
		id = it.key();
		status = it.data();
		memcpy(i, &id, szInt);
		i+=szInt;
		memcpy(i, &status, szInt);
		i+=szInt;
		
	}
	
	return p;
}

QSaveItem * SaveQThread::loadSaveItem( char *data )
{
	char *i=&data[0];
	QSaveItem * si = new QSaveItem;
	i=retrieve(i, si->group);
	i=retrieve(i, si->index);

	i=retrieve(i, si->rootFName);
	i=retrieve(i, si->savePath);
	i=retrieve(i, si->tmpDir);
	
	int szInt=sizeof(uint);
	
	memcpy( &(si->curPostLines), i, szInt);
	i+=szInt;
	
	int count, id, status;
	
	
	memcpy(&count, i, szInt);
	i+=szInt;
	for (int j = 0; j < count ; j++) {
		memcpy(&id, i, szInt);
		i+=szInt;
		memcpy(&status, i, szInt);
		i+=szInt;
		si->partStatus.insert(id, status);
		
	}
	

	return si;
	
}

char * SaveQThread::insert( QString s, char * p )
{
	int strlen=s.length();
	int suint = sizeof(strlen);
	memcpy(p, &strlen, suint);

	p+=suint;
	memcpy(p, (const char *)s, strlen);
	p+=strlen;
	return p;
}

char * SaveQThread::retrieve( char * i, QString & s )
{
	int strlen;
	int ssize=sizeof(strlen);

	char *temp;
	memcpy(&strlen, i, ssize);

	i+=ssize;
	temp=new char[strlen+1];
	memcpy(temp, i, strlen);
	temp[strlen]='\0';
	s=temp;
	delete [] temp;
	i+=strlen;
	return i;
}



int DecoderThread::cancel( int qID )
{
	DecodeThreadEvent *dte = 0;
	listLock->lock();
	//Check if we're canceling the currently decoding item
	kdDebug() << "Currently decondig: " << item->qItemId << endl;
	if (item->qItemId == qID) {
		m_cancel = true;
		dte = new DecodeThreadEvent(item, DecodeThreadEvent::Dte_Canceling);
		
	} else {
		//Sync cancel...
		QValueList<QPostItem*>::iterator it;
		for( it = items->begin() ; it != items->end() ; ++it ){
			if( (*it)->qItemId == qID ){
				//Cancel item
				items->remove(it);
				//send a message to the QMgr saying we canceled the item
				dte = new DecodeThreadEvent(*it, DecodeThreadEvent::Dte_Canceled);
				break;
				
			}
		}
		
	}
	listLock->unlock();
	/*
	if (m_cancel)
		return 0; //Asynccancel
	else return qID; //Item canceled
	*/
	QApplication::postEvent(parent, dte);
	return 0;
}

DecodeThread::~ DecodeThread( )
{
	delete uu;
}











