/***************************************************************************
                          qso.cpp  -  description
                             -------------------
    begin                : jue ago 15 2002
    copyright            : (C) 2002 by Jaime Robles
    email                : jaime@robles.nu
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/
#include <klocale.h>
//#include <kdebug.h>
#include "qso.h"


Qso::Qso(){}

Qso::Qso(const QString& tqrz, int tnumb, QString& tmode){
  qrz = tqrz;
  numb = tnumb;
  mode = tmode;
  freq = "";
  qslRecc = 'N';      // QSL_RCVD Y, N, R, I
  qslSenc = 'N';      // QSL_SENT Y, N, R, I

}


Qso::Qso(const int tnumb, const QString& tqrz, const int trstrx, const int trsttx, int tband, const QString& tmode, const int tpower){

    qrz = tqrz;
    numb = tnumb;
    mode = tmode;
    rstrx = trstrx;
    rsttx = trsttx;
    band = tband;
    freq = "";
    mode = tmode;
    power = tpower;
  qslRecc = 'N';      // QSL_RCVD Y, N, R, I
  qslSenc = 'N';      // QSL_SENT Y, N, R, I
}


Qso::Qso(const int tnumb, const QDateTime tdateTime, const QString& tqrz, const int trstrx, const int trsttx, const QString& tband, const QString& tmode, const QString& tpower, const QString& tcomment)
{
  qrz = tqrz;
  numb = tnumb;
  dateTime = tdateTime;
  rstrx = trstrx;
  rsttx = trsttx;
  band = tband;
  freq = "";
  mode = tmode;
  power = tpower;
  comment = tcomment;
  qslRecc = 'N';      // QSL_RCVD Y, N, R, I
  qslSenc = 'N';      // QSL_SENT Y, N, R, I

}      

Qso::Qso (const int tnumb, const QDateTime& tdateTime, const QString& tqrz, const int trstrx, const int trsttx, int tband, const QString& tmode, const int tpower, const QDate& tqslSen,  const QDate& tqslRec, const QString& tcomment){

  qrz = tqrz;
  numb = tnumb;
  dateTime = tdateTime;
  rstrx = trstrx;
  rsttx = trsttx;
  band = tband;
  freq = "";
  mode = tmode;
  power = tpower;
  qslSen = tqslSen;
  qslRec = tqslRec;
  comment = tcomment;
  qslRecc = 'N';      // QSL_RCVD Y, N, R, I
  qslSenc = 'N';      // QSL_SENT Y, N, R, I
}


Qso::~Qso(){}

void Qso::setQrz(const QString &tqrz ){
  qrz = tqrz;
}

QString Qso::getQrz() const {
  return qrz;
}


void Qso::setNumb (int tnumb){
  numb = tnumb  ;
}

int Qso::getNumb() const{return numb;}

void Qso::setDateTime(QDateTime tdateTime){dateTime = tdateTime;}
QDateTime Qso::getDateTime() const{return dateTime;}

void Qso::setRstrx(int trstrx){
  rstrx = trstrx;  
}

int Qso::getRstrx() const{return rstrx;}

void Qso::setRsttx(int trsttx){
  rsttx = trsttx;  
}

int Qso::getRsttx() const{return rsttx;}

void Qso::setBand (const QString& tband){
 band = tband;  
}

QString Qso::getBand() const{return band;}

void Qso::setFreq (const QString& tfreq){freq = tfreq;}

QString Qso::getFreq() const{return freq;}
  
void Qso::setMode(const QString& tmode){
  mode = tmode;
}

QString Qso::getMode() const{return mode;}

void Qso::setPower(const QString& tpower){
  power = tpower;  
}

QString Qso::getPower() const{return power;}

void Qso::setComment(const QString &tcomment){
  comment = tcomment;
}
QString Qso::getComment()const{return comment;}

void Qso::setQslSenDateOn(QDate tdate){
  qslSen = tdate;
  qslSenc = 'Y';  
}

QDate Qso::getQslSenDate() const{
  return qslSen;
}

void Qso::QslSent(const QChar& qslState){
  qslSenc = qslState;
}

QChar Qso::isQslSent(){
  return  qslSenc;  
}

void Qso::setQslRecDateOn(const QDate tdate){
  qslRec = tdate;
  qslRecc = 'Y';
}

QDate Qso::getQslRecDate() const{
  return qslRec;
  
}

void Qso::QslRec(const QChar& qslState){
  qslRecc = qslState;
}

QChar Qso::isQslRec(){
  return qslRecc;  
}

bool Qso::gotTheQSL(){  // Ask if i have his QSL
  if (qslRecc == 'Y')
    return true;
  else
    return false;
}

bool Qso::sentTheQSL(){ // Did i sent my QSL?
  if (qslSenc == 'Y')
    return true;
  else
    return false;
}

void Qso::setQslVia(const QString &tInfo){
  qslVia = tInfo;
  
}

QString Qso::getQslVia() const{
  return qslVia;  
}

void Qso::setQslManager(const QString &tqrz){
  manager = tqrz;

} 

QString Qso::getQslManager() const {return manager;}

void Qso::setQslInfo(const QString &tqslInfo){
  qslInfo = tqslInfo;

}

QString Qso::getQslInfo()const{return qslInfo;}


void Qso::setLocator(const QString &tgridSquare ){
  gridSquare = tgridSquare;
}

QString Qso::getLocator() const {
  return gridSquare;
}

void Qso::setIota(const QString &tiota){
  iota = tiota;
}

QString Qso::getIota() const{return iota;}

QString Qso::getIotaContinent() const{
  return iota.section('-',0,0);
}

int Qso::getIotaNumber() const {
  return (iota.section('-',1,1)).toInt();
}

void Qso::setName(const QString &tname){
  name = tname;  
}

QString Qso::getName() const{
  return name;  
}

void Qso::setQth(const QString &tqth){
  qth = tqth;
}

QString Qso::getQth() const{
  return qth;
}

void Qso::setOperator(const QString &toperator){
  callUsed = toperator;
}

QString Qso::getOperator() const{
  return callUsed;
}

void Qso::setPropMode(const QString &tprop_mode){
  prop_mode = tprop_mode;
  
}

QString Qso::getPropMode() const{
  return prop_mode;
}


void Qso::clearQso(){
//qrz = "";        // CALL
//numb = 0;           // STX
//  QDateTime dateTime; // QSO_DATE/TIME_ON YYYYMMDD - Time HHMM (0000-2359)
/*  int rstrx;          // RST_RCVD
  int rsttx;          // RST_SENT
//band;       // BAND
  QString mode;       // MODE
  QString rx_power;   // RX_PWR
  QString power;      // TX_PWR
  QDate qslSen;       // QSLSDATE
  QDate qslRec;       // QSLRDATE
  
*/  
qslRecc = 'N';      // QSL_RCVD Y, N, R, I
qslSenc = 'N';      // QSL_SENT Y, N, R, I
qslVia = "";     // QSL_VIA (C) //Manager
qslInfo = ""; //;    // ADDRESS /QSLMSG
comment = "";    // COMMENT
//  int qslHow;         // How is the qsl to be send
  manager = "";
  gridSquare = "";
  iota = "AF-0";   // GRIDSQUARE
  callUsed = "";   // OPERATOR
  name = "";       // NAME
  qth = "";        // QTH

/*  QString iota;       // IOTA
  QString state;    // STATE

*/  
}
