/***************************************************************************
                          award  -  description
                             -------------------
    begin                : vie may 20 2005
    copyright            : (C) 2005 by Jaime Robles
    email                : jaime@robles.nu
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/

//#include <kdebug.h>
#include <klocale.h>
//#include <ostream.h>
#include "award.h"

Award::Award(){
	number = 0;
	awardReference = -1;
	numberOfReferences = -1;
	entityPrefix = "";
	awardName = "DEFAULT";
	organizer = "KLOG-DEFAULT";
	//cout << "AWARD: Created!" << endl;
}

Award::Award(const int treference, const int tnumberOfReferences, const QString &tname, const QString &tprefix, const QString &torganizer){
	number = 0;
	awardReference = treference;
	numberOfReferences = tnumberOfReferences;
	entityPrefix = tprefix;
	awardName = tname;
	organizer = torganizer;
}

Award::~Award(){}
	
void Award::setAwardReference(int treference){
	awardReference = treference;
	//cout << "AWARD: setAwardReference = " << QString::number(awardReference) << endl;
}

int Award::getAwardReference() const{
	return awardReference;
}

void Award::setNumberOfReferences(int treference){
	numberOfReferences = treference;
	//cout << "AWARD: numberOfReferences = " << QString::number(numberOfReferences) << endl;
}

int Award::getNumberOfReferences() const{
	return numberOfReferences;
}
	
void Award::setAwardName(const QString &tname){
	awardName = tname;
	//cout << "AWARD: setAwardName = " << awardName << endl;
}

QString Award::getAwardName() const{
	return awardName;
}

void Award::setEntityPrefix(const QString &tprefix){
	//entity = world.findEntity(tprefix);
	entityPrefix = tprefix;
	//cout << "AWARD: setEntityPrefix = " << entityPrefix << endl;
}

QString Award::getEntityPrefix() const{
	return entityPrefix;
}

void Award::addPrefix(const QString &prefix){
	prefixes.append(prefix);
}

bool Award::checkPrefix(const QString &prefix){
	Prefixes::iterator it;
	//cout << "CheckPrefix : " << prefix << endl;
	for ( it = prefixes.begin(); it != prefixes.end(); ++it ){
		//cout << "CheckPrefix recibido/Checked: " << prefix << " / " << (*it) << endl;
		if (prefix == (*it) ){
			return true;
		}
	}
	return false;
}
	
	
void Award::setOrganizer(const QString &torganizer){
	organizer = torganizer;
	//cout << "AWARD: setOrganizer = " << organizer << endl;
}

QString Award::getOrganizer() const{
	return organizer;
}
	
void Award::addReference(const QString &treference){
	number++;
	ref.setNumber(number);
	ref.setReference(treference);
	references.append(ref);
	//cout << "AddReference: (numb/ref): " << QString::number(number) << " / " << "#" << treference  << "#" << endl;
	
	//cout << "AWARD: addAwardReference = " << QString::number(ref.getNumber()) << " - " << ref.getReference() << endl;
}

QString Award::getReference(int treference){
	References::iterator it;
	for ( it = references.begin(); it != references.end(); ++it ){
		if (treference == (*it).getNumber() ){
			//cout << "AWARD: getReference Award/reference readed) = " << getAwardName() << " / " << (*it).getReference() << endl;
			return (*it).getReference();
		}
	}
	return "NULL-REFERENCE";
}

void Award::readAward(const QString &tfile){
	//cout << "AWARD: readAward - Fichero recibido: " << tfile << endl;
	klogDir = QDir::homeDirPath()+"/.klog";  // We create the ~/.klog for the logs
	if (!QDir::setCurrent ( klogDir )){
		QDir d1(klogDir);
		dirExist = d1.mkdir(klogDir, true);
	}
	QFile file( tfile );
	if ( file.open( IO_ReadOnly ) ) {
		QTextStream stream( &file );
		QString line;
		QString adifTab;
		QString theData;
		int len; // for the tab length
		QString data = "";
		int aux = 0;
		while ( !stream.eof()  && (aux == 0)) {
			data = stream.readLine();
			if(!data.isEmpty()){
				QStringList fieldss = QStringList::split('<', data );
			
				if (data.upper().contains("<EOH>") != 0)
					aux = 1;
				data = data.simplifyWhiteSpace().upper();
				aux = data.contains('<');
				fields = QStringList::split('<', data );
				for (int i = 0; i < aux; i++){ // It was to aux-
					adifTab = fields[i].section(':',0,0);
					len = (fields[i].section(':',1)).section('>',0,0).toInt();
					theData = ((fields[i]).section('>',1));
					theData.truncate(len);
				}
				
				if (adifTab == "AWARD_NAME"){  
					awardName = theData;
					//cout << "AWARD_NAME = " << theData << endl;
				}else if (adifTab == "AWARD_ADIF"){			
					//cout << "AWARD_ADIF = " << theData << endl;
				}else if (adifTab == "AWARD_ENTITY"){
					addPrefix(theData);
					//entityPrefix = theData;
					//cout << "AWARD_ENTITY = " << theData << endl;
				}else if (adifTab == "AWARD_NUMBER"){
					numberOfReferences = theData.toInt();
					//cout << "AWARD_NUMBER = " << theData << endl;
				}else if (adifTab == "AWARD_INFO"){
					//cout << "AWARD_NAME = " << theData << endl;
				}      
			}
			
		}
// The Header reading ends here
		
		data = ""; //
		addReference("unknown");
		while (!stream.eof()){
			data = stream.readLine();
			if(!data.isEmpty()){
				data = data.simplifyWhiteSpace().upper();
				aux = data.contains('<');
				fields = QStringList::split('<', data );
				for (int i = 0; i < aux; i++){ 
					adifTab = fields[i].section(':',0,0);
					len = (fields[i].section(':',1)).section('>',0,0).toInt();
					theData = ((fields[i]).section('>',1));
					theData.truncate(len);
				}
				if (adifTab == "AWARD_NAME"){  
					awardName = theData;
					//cout << "AWARD: setAwardName = " << awardName << endl;
					//The data is in theData
				}else if (adifTab == "AWARD_ADIF"){
					//cout << "AWARD: AwardAdif" << endl;
				}else if (adifTab == "AWARD_ENTITY"){
					addPrefix(theData);	
				}else if (adifTab == "AWARD_NUMBER"){
					numberOfReferences = theData.toInt();
				}else if (adifTab == "AWARD_INFO"){
					organizer = theData;
				}else if (adifTab == "AWARD_REFERENCE"){
					addReference(theData);
				}      
			}
		}
	}
	file.close();
	
}

void Award::clearAward(){
	number = -1;
	awardReference = -1;
	numberOfReferences = -1;
	entityPrefix = "";
	awardName = "DEFAULT";
	organizer = "KLOG-DEFAULT";
	references.clear();
	//cout << "AWARD: Cleared!" << endl;


}

/*
References Award::getAllReferences(){
	return references;
}
*/



