/***************************************************************************
                          awards.c  -  description
                             -------------------
    begin                : mar ago 27 2002
    copyright            : (C) 2002 by Jaime Robles
    email                : jaime@robles.nu
 ***************************************************************************/
/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/

#include <klocale.h>
//#include <ostream.h>
#include "awards.h"
Awards::Awards(){
	numberOfReferences = 0;
	numberOfAwards = 0;
	//cout << "AWARDS: Constructor" << endl;
}

Awards::~Awards(){}

void Awards::readConfig(){
	klogDir = QDir::homeDirPath()+"/.klog";  // We create the ~/.klog for the logs
	if (!QDir::setCurrent ( klogDir )){
		QDir d1(klogDir);
		dirExist = d1.mkdir(klogDir, true);
	}
	//cout << "AWARDS: readConfig" << endl;
	QFile file( "awardsrc" );
	if ( file.open( IO_ReadOnly ) ) {
	//cout << "AWARDS: readConfig - file opened" << endl;
		World world; // This world is just to have the entity number asignment to the awards
		QTextStream stream( &file );
		QString data = "";
		data = ""; //
		while (!stream.eof()){
			data = stream.readLine();
	//		cout << "AWARDS: from awardrc: " << data << endl;
			if(!data.isEmpty()){ // Each line is a file with an award.
			// HERE WE HAVE TO CREATE A NEW AWARD AND CALL TO READ IT!	
	//			cout << "AWARDS: from awardrc: " << data << endl;
				awardAux.readAward(data);
				awardAux.setAwardReference(numberOfAwards); // Each award has its own reference in each Klog execution.
				//cout << "LEYENDO AWARDSRC numberOfAwards: " << QString::number(numberOfAwards) << endl;
				numberOfAwards++;
				// With the followin line I obtain the entity Number to
				// asign it to the award.
//				awardAux.setEntityNumber((world.findEntity(awardAux.getEntityPrefix())));
				awards.append(awardAux);
				awardAux.clearAward();
			}//Closes the if != empty
		}// Closes the while
		file.close();
	}else{
	//	cout << "AWARDS: readConfig -No file opened" << endl;
	}
}


int Awards::checkPrefix(const QString &tprefix){
	AwardType::iterator it;
	for ( it = awards.begin(); it != awards.end(); ++it ){
		if (tprefix == (*it).getEntityPrefix() ){
			//cout << "AWARDS: checkPrefix: Located: " << (*it).getAwardName() << endl;
			return (*it).getAwardReference();
		}
	}
	return -1;
}
	
QString Awards::getAwardName (const QString &tprefix){
	AwardType::iterator it;
	for ( it = awards.begin(); it != awards.end(); ++it ){
		if (tprefix == (*it).getEntityPrefix() ){
			return (*it).getAwardName();
		}
	}
	return "Award";
}
/*
Award Awards::getIntAwardFor(int tEntity){
 	awardAux = awardDefault;
	AwardType::iterator it;
	for ( it = awards.begin(); it != awards.end(); ++it ){
		if (tEntity == (*it).getEntityNumber() ){
			awardAux = (*it);  // We are copying the whole award... if it does not
			return awardAux;
		}
	}
	//cout << "GetAwardFor: Default selected: " << awardAux.getAwardName() << endl;
	return awardDefault; // If we did not found the award for this prefix we simply return


}
*/

Award Awards::getAwardFor(const QString &tprefix){
 	awardAux = awardDefault;
	AwardType::iterator it;
	//cout << "getAwardFor recibido: " << tprefix << endl;
	for ( it = awards.begin(); it != awards.end(); ++it ){
		if ((*it).checkPrefix(tprefix)){
		//if (tprefix == (*it).getEntityPrefix() ){
			awardAux = (*it);  // We are copying the whole award... if it does not
			// work, we should built it with a for (i=0; i=numberOfReferences...)
			//numberOfReferences = (*it).getNumberOfReferences;
			// Here we have found the Entity Award so we build the current award
			//return (*it).getAwardReference();
			//cout << "GetAwardFor: Located: " << awardAux.getAwardName() << endl;
			/*
				ref.setNumber(number);
	ref.setReference(treference);
	references.append(ref);
	number++;
	cout << "AWARD: addAwardReference = " << QString::number(ref.getNumber()) << " - " << ref.getReference() << endl;
			
			*/
			return awardAux;
		}
	}
	//cout << "GetAwardFor: Default selected: " << awardAux.getAwardName() << endl;
	return awardDefault; // If we did not found the award for this prefix we simply return

}



Award Awards::getDefaultAward(){
	return awardDefault;
};
/*
QString Awards::getAllReferencesOfTheAward(const QString &tprefix){
	AwardType::iterator it;
	for ( it = awards.begin(); it != awards.end(); ++it ){
		if (tprefix == (*it).getEntityPrefix() ){
			return (*it).getAwardName() + ":";
		}
	}
	return "Award:";
}
*/	
	
