/*************************************************/
/* methods for class ClientW                     */
/*                                               */
/* window containing a scrollable logic circuit  */
/*                                               */
/* Andreas Rostin                                */
/* 12.03.99                                      */
/*************************************************/
#include <qtoolbar.h>
#include <qtoolbutton.h>

#include <qframe.h>
#include <qrect.h>
#include <qpushbutton.h>
#include <qframe.h> 
#include <qpixmap.h> 
#include <qkeycode.h>
#include <qscrollbar.h>

#include <klogic.h>
#include <mainw.h>
#include <netw.h>
#include <xnet.h>
#include <clientw.h>

#include "clientw.moc"

/***************************************************/
/* methods of class ClientW                        */
/***************************************************/
// main widget content
ClientW::ClientW(MainWidget *mainw, const char *file)
	: QFrame(mainw)
{
	setCaption(myAppName + " - " + i18n("subcircuit")); 

	mainwidget = mainw;
	netframe = new QFrame(this);
	netwidget = new NetWidget(netframe, mainw);

	if (file) netwidget->openNet(file, false);
	connect(this, SIGNAL(visibleChanged(QRect)), netwidget, SLOT(visible(QRect)));

	commonConstruct();

	toolbar->hide();
	main_client = true;
	m_devnet = (XDeviceNet *)NULL;
}

// client widget content
ClientW::ClientW(MainWidget *mainw, XDeviceNet *devnet)
	: QFrame()
{
	mainwidget = mainw;
	netframe = new QFrame(this);
	setCaption(myAppName + " - " + i18n("subcircuit"));

	commonConstruct();
	toolbar->show();
	main_client = false;

	// prepare circuit to display
	netwidget = new NetWidget(netframe, mainwidget, devnet);
	connect(this, SIGNAL(visibleChanged(QRect)), netwidget, SLOT(visible(QRect)));
	logicPos.setWidth(0);
	logicPos.setHeight(0);
	setWidgets();
	netwidget->show();
	m_devnet = (XDeviceNet *)NULL;
}

// create client widget elsewhere, content to be created by function (used for libraries!)
ClientW::ClientW(QFrame *parent, int function)
	: QFrame(parent)
{
	mainwidget = (MainWidget *)NULL;
	netframe = new QFrame(this);
	setCaption(myAppName + " - " + i18n("subcircuit"));

	commonConstruct();
	main_client = false;

	// prepare circuit to display
	m_devnet = new XDeviceNet();
	m_devnet->newDevice(function, 10, 10);
	netwidget = new NetWidget(netframe, parent, m_devnet);
	connect(this, SIGNAL(visibleChanged(QRect)), netwidget, SLOT(visible(QRect)));
	logicPos.setWidth(0);
	logicPos.setHeight(0);
	setWidgets();
	netwidget->show();
}

void ClientW::commonConstruct()
{	QPixmap px;

	setBackgroundMode( PaletteBase );    // set widgets background

        vscroll = new QScrollBar(0, VIRT_SCREEN_SIZE_Y, 10, 100, 0, QScrollBar::Vertical, this);
        hscroll = new QScrollBar(0, VIRT_SCREEN_SIZE_X, 10, 100, 0, QScrollBar::Horizontal, this);
        connect(vscroll, SIGNAL(valueChanged(int)), this, SLOT(vScroll(int)));
        connect(hscroll, SIGNAL(valueChanged(int)), this, SLOT(hScroll(int)));

        setWidgets();

	if (mainwidget) {
		toolbar = new QToolBar(i18n("up"), mainwidget, this, FALSE, 0, Qt::WStyle_NoBorder);
		px.load((const char *)(MainWidget::TBPATH + "tbUP.xpm"));
		QToolButton *t = new QToolButton(px, NULL, NULL, this, SLOT(up()), toolbar);
		t->setFixedWidth(30);
		toolbar->setFixedWidth(43);
	} else {
		toolbar = (QToolBar *)NULL;
	}
}

ClientW::~ClientW()
{
	if (m_devnet) delete m_devnet;
}

void ClientW::show()
{
	QFrame::show();
}

void ClientW::closeEvent(QCloseEvent *)
{
	if (mainwidget) mainwidget->closeClient(this);
	if (main_client) {
		disconnect(this, SIGNAL(visibleChanged(QRect)), netwidget, SLOT(visible(QRect)));
	}
	delete netwidget;

	disconnect(vscroll, SIGNAL(valueChanged(int)), this, SLOT(vScroll(int)));
	disconnect(hscroll, SIGNAL(valueChanged(int)), this, SLOT(hScroll(int)));

	QFrame::hide();
	QFrame::close(TRUE);
}

NetWidget * ClientW::net()
{
	return netwidget;
}

//slot
void ClientW::keyPressEvent (QKeyEvent * e)
{
	if (!main_client && mainwidget) {
		switch (e->key()) {
		case Key_S:
			mainwidget->menuCallback(NetWidget::MODE_SIM_STEP);
			break;
		case Key_M:
			mainwidget->menuCallback(NetWidget::MODE_SIM_MULT);
			break;
		case Key_G:
			mainwidget->menuCallback(ID_SIM_SHOW);
			break;
		}
	}
}

// slot
void ClientW::paintEvent(QPaintEvent *)
{
	setWidgets();
	netwidget->repaint(FALSE);
}

// set position of child-widgets and range of scrollbars
void ClientW::setWidgets()
{	vscroll->setGeometry(width() - 16, 0, 16, height() - 16 - 0);
	hscroll->setGeometry(0, height() - 16, width() - 16, 16);

	logicBase.setRect(0, 0, width() - 16, height() - 16 - 0);
	netframe->setGeometry(logicBase);
	hscroll->setRange(0, VIRT_SCREEN_SIZE_X - logicBase.width());
	vscroll->setRange(0, VIRT_SCREEN_SIZE_Y - logicBase.height());

	if ((logicPos.width() != logicBase.width()) || (logicPos.height() != logicBase.height())) {
		logicPos.setX(hscroll->value());
		logicPos.setWidth(logicBase.width());
		logicPos.setY(vscroll->value());
		logicPos.setHeight(logicBase.height());
		emit visibleChanged(logicPos);
	}
}

// slot
// horizontal scrollbar signaled that value changed
void ClientW::hScroll(int val)
{
	logicPos.setX(val);
	logicPos.setWidth(logicBase.width());
	netwidget->move(-1 * logicPos.x(), -1 * logicPos.y());
	emit visibleChanged(logicPos);
}

// slot
// vertical scrollbar signaled that value changed
void ClientW::vScroll(int val)
{
	logicPos.setY(val);
	logicPos.setHeight(logicBase.height());
	netwidget->move(-1 * logicPos.x(), -1 * logicPos.y());
	emit visibleChanged(logicPos);
}

// slot
// switch to parent circuit
void ClientW::up()
{
	netwidget->toParentNet();
	repaint(FALSE);
	if (toolbar) {
		if (!netwidget->getActive()->parent()) toolbar->hide();
		else toolbar->show();
	}
}

// slot
// net-widget has a new devnet
void ClientW::netChange(int hasparent)
{
	if (toolbar) {
		if (hasparent) toolbar->show();
		else toolbar->hide();
	}
	hscroll->setValue(0);
	vscroll->setValue(0);
	hScroll(0);
	vScroll(0);
	repaint();
}

