/*************************************************/
/* member methods for class fifo                 */
/*                                               */
/* signal delay                                  */
/*                                               */
/* Andreas Rostin                                */
/* 15.03.99                                      */
/*************************************************/
#include <fifo.h>

int Fifo::instance = 0;

Fifo::Fifo(int d)
{
	instance++;

	_fifo = (int *)NULL;
	setDelay(d);
}

Fifo::~Fifo()
{
	instance--;

	if (_fifo) delete [] _fifo;
}

// size of the fifo, is used as a delay
void Fifo::setDelay(int d)
{
	if (_fifo) delete [] _fifo;
	_fifo = new int[d + 1];
	_depth = d;
	bzero(_fifo, sizeof(int) * (d + 1));
}

// size of the fifo, is used as a delay
int Fifo::delay()
{
	return _depth;
}

void Fifo::flush(int val)
{
	int i;
	for(i=0;i<=_depth;i++) _fifo[i] = val;
}

// shift queue by 1
// insert newval on first place
// return dropped value
int Fifo::put(int newval)
{
	int i;
	int ret = _fifo[_depth];

	for(i=_depth;i > 0;i--) _fifo[i] = _fifo[i - 1];
	_fifo[0] = newval;
	if (_depth > 0) _fifo[_depth] = _fifo[_depth - 1];
	return ret;
}

int Fifo::get()
{
	return _fifo[_depth];
}
