#ifndef __XDevice_CLASS__
#define __XDevice_CLASS__

#include <klogicList.h>
#include <device.h>
#include <qpixmap.h>
#include <xobject.h>
#include <device.h>
#include <deviceInterface.h>

class XWire;
class XDeviceNet;

/********************************************
* a device                                  *
*********************************************/
class XDevice: public XObject, public DeviceInterface
{
public:
	static int instance;

	XDevice(int func, int x, int y, int size = -1, int delay = -1, int undef = -1, int clock = -1);
	virtual ~XDevice();

	// settings for all devices
	static int defSize();
	static void setDefSize(int);
	static bool isDefInverted();
	static void setDefInverted(bool);
	static void displayTextGlobal(bool);
	static bool textDisplayedGlobal();
	static void setFont(const QString &);
	static QString getFont();
	static void setFontSize(int);
	static int getFontSize();
	static void setSymbolSet(int);
	static int getSymbolSet();
	static void setDefWidth(int);
	static int defWidth();

	// positioning methods
	int contains(QPoint);
	int contains(QRect);
	int setPos(QPoint);

	// drawing methods
	void erase(QPainter *);				// erase device image
	virtual void setImage();			// internal redraw of the device pixmap
	void drawImage(QPainter *);			// draw device as lines and text to a printer device
	virtual bool setColor();				// set image by actual state of input/output  (e.g. LED)
	void drawImage(QPaintDevice *, QPainter *);	// the usual method to draw devices!

	// graph methods
	bool drawGraph();
	bool graphEnabled();
	void enableGraph(bool);
	int invertGraph(int, int);

	// some status methods
	int size();
	virtual bool setSize(int);
	virtual int neededSize();
	virtual bool sizeChangeable();

	bool isEditable();
	bool isInverted();
	void setInverted(bool);
	int maxI();
	int currI();
	void setMaxI(int);
	int maxO();
	int currO();
	void setMaxO(int);
	virtual void setClock(int);
	virtual void setText(const QString&);
	void displayText(bool);
	bool textDisplayed();
	void setTextDevPos();
	void setTristate(bool flag);
	int getTristateControlPos();
	void setTristateControlPos(int pos);
	void setTristateInputImport();
	void setSwitchType(bool type);
	bool isSwitchType();
	void setWidth(int);
	int width();

	// special cases: properties dialog methods
	// return pointers to input/output lists
	// called by PropDev
	KlogicList<XWire> *getIRef();
	KlogicList<XWire> *getORef();

	// check and set/reset connections
	int checkConnection(XWire *, int invert = 0);

	// called by wire: add/remove connections
	int inputIsInvertedAt(QPoint);
	void addInput(XWire *, int);
	void removeInput(XWire *, int);
	int outputIsInvertedAt(QPoint);
	void addOutput(XWire *, int);
	void removeOutput(XWire *, int);

	// remove garbage from wires
	void garbageCollection();

	// add/remove named inputs/outputs (overloaded from class Device)
	virtual int addInputName(const QString&, int pos = -1, int input_id = 0);
	virtual int changeInputName(int, const QString&);
	virtual void removeInputName(int);
	virtual int addOutputName(const QString&, int pos = -1, int output_id = 0);
	virtual int changeOutputName(int, const QString&);
	virtual void removeOutputName(int);

	// set connection-lines	(connected by wires)
	void eraseConnectionLines(QPainter *prt = (QPainter *)NULL);
	void drawConnectionLines(QPainter *prt = (QPainter *)NULL);

	// find out which kind of device it is
	virtual XDeviceNet * devIsNet() { return (XDeviceNet *)NULL; };		// this is not a Circuit

	static void loadPix();

	static const int MINSIZE = 2;
	static const int MAXSIZE = 99;
	static const int MAXI = 99;
	static const int MAXO = 99;

	static const int DEFAULT_SIZE = 4;
	static const int DEFAULT_WIDTH = 2;	// 1 .. 3

	static const int SYMBOLSET_DIN40900 = 0;
	static const int SYMBOLSET_IEC617 = 1;

	// global standard input/output names
	static const QString IO_BUS_ADDRESS[8];

protected:
	virtual void init();
	virtual void printImage(QPainter *, const QRect &);

	int deviceSize;
	int deviceWidth;
	int deviceMaxInput;
	int deviceMaxOutput;
	bool deviceOutputInverted;

	// text device, optionally displayed above this
	XDevice *text_dev;

	// device pixmaps
	static QPixmap *PTOPH, *PMIDH, *PBOTH, *PTOPL, *PMIDL, *PBOTL, *PTOP, *PMID, *PBOT, *PTOPBlank, *PMIDBlank, *PBOTBlank;
	static QPixmap *pxPOS, *pxNEG;
	static QPixmap *pxOUT, *pxIN, *pxLED0, *pxLED1, *pxSWI0, *pxSWI1;
	static QPixmap *pxJKF, *pxJK, *pxRSCMF, *pxRS, *pxRSC, *pxRSCM, *pxDM, *pxD;
	static QPixmap *pxSSB, **pxSS;
	static QPixmap *pxLED0blue, *pxLED1blue, *pxLED0red, *pxLED1red, *pxLED0green, *pxLED1green, *pxLED0yellow, *pxLED1yellow;
	static QColor BlankColor;

	// devices symbols (sign within the pixmaps)
	static QPixmap *syAND, *syOR, *syXOR, *syINV, *syOSC, *syNET, *sySS, *syMONOFLOP;
	static QPixmap *syIECAND, *syIECOR, *syIECXOR, *syIECNOT;
	static int pix_loaded;

	static QFont STATfont;

private:
	static int STATdef_size;
	static bool STATdef_inverted;
	static bool STATdisplay_name;
	static QString STATfontFamily;
	static int STATfontSize;
	static int STATSymbolSet;
	static int STATdefWidth;

	// standard input/output names
	static const QString INPUT_SS_2_0;
	static const QString INPUT_SS_2_1;
	static const QString INPUT_SS_2_2;
	static const QString INPUT_SS_2_3;
protected:
	static const QString INPUT_FF_S;
	static const QString INPUT_FF_1S;
	static const QString INPUT_FF_R;
	static const QString INPUT_FF_1R;
        static const QString INPUT_FF_C1;
        static const QString INPUT_FF_1D;
	static const QString INTERNAL_FF_MASTER_Q;
	static const QString INTERNAL_C1_PREVIOUS;
private:
	static const QString INPUT_TRISTATE_CONTROL;

	void setRegions();
	void updateWires();

	int checkInput(XWire *, int, int);
	int connectInput(XWire *, QPoint, int, int output_id = 0);
	int checkOutput(XWire *, int, int);
	int connectOutput(XWire *, QPoint, int, int output_id = 0);

	void setInputLine(XWire *, QColor, int, QPainter *prt = (QPainter *)NULL, int x = 0, int y = 0);
	void setOutputLine(XWire *, QColor, int, QPainter *prt = (QPainter *)NULL, int x = 0, int y = 0);

	void prepareTristateInputImport();

	QRect input_region;
	QRect output_region;

	// connected wires
	KlogicList<XWire> in_w;
	KlogicList<XWire> out_w;

	// some device parameters
	bool editable;
	bool graph_enabled;
	bool switch_type;	// switch or push button for fSWI type

	// tristate handling
	int tristate_input_moved;
	int tristate_pos_import;

public:
	// old device import/export
	QString device2string(int, int);
	bool string2device(QString, int, int);

};

#endif

