/* filechunk.h definitions   */

#ifndef __FILECHUNK_H__
#define __FILECHUNK_H__

#include <pthread.h>
#include <stdio.h>
#include <sndfile.h>
#include "speciallist.h"

enum {
	DS_PRIORITY_URGENT,
	DS_PRIORITY_NORMAL,
	DS_PRIORITY_RELAXED,
	DS_PRIORITY_NONE,
	DS_PRIORITY_LAST
};

typedef struct filechunk {
        char*           filename;
        SF_INFO*        sfinfo;
        SNDFILE*        sf;
	int		group;
        int             priority;
	int		channels;
        long            start;
        long            end;
        long            length;
        long            done;
        float*         	L;
        float*         	R;
} filechunk_t;

typedef struct _chunk_group {
        int 		gid;
	int 		priority;
	long		area_start;
	long		area_end;
	long		area_bandwith;
        filechunk_t*    readfc;
        filechunk_t*    nextfc;
        filechunk_t*    prevfc;
	filechunk_t*	wrapfc;
} chunk_group_t;

chunk_group_t*	chunkgroup_new(int gid, int priority);
void		chunkgroup_delete(chunk_group_t* group);

filechunk_t* 	filechunk_new(char* filename);
void 		filechunk_delete(filechunk_t* fc);
int 		filechunk_get_group(filechunk_t* fc);
long 		filechunk_resize(filechunk_t* fc, long new_size);
long 		filechunk_set (filechunk_t* fc, long start, long end, int priority, int group);
long 		filechunk_read_chunk (filechunk_t* fc);

long		filechunk_get_length (filechunk_t* fc);
long 		filechunk_get_start (filechunk_t* fc);
long 		filechunk_get_end (filechunk_t* fc);
long		filechunk_get_done (filechunk_t* fc);
int		filechunk_get_channels (filechunk_t* fc);
long		filechunk_get_filelength (filechunk_t* fc);
long		filechunk_get_samplerate (filechunk_t* fc);
int		filechunk_get_priority	(filechunk_t* fc);

float 		filechunk_get_sample(filechunk_t* fc, int channel, long sample);
void 		filechunk_write_sample(filechunk_t* fc, int channel, long sample, float value);
#endif
