#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "interpol.h"

float inter4pol (short* buf, float index, long size){
	float frac, a, b, c, d, cminusb;
	short* fp;
	long lindex = (long)index;

	/* 4 point interpolation taken from tabread4~ of pd (pure-data.org) */

	if (!size) return 0.;

	if (lindex < 1){
            	lindex = 1, frac = .0;
        }else if (lindex > (size - 3)){
            	lindex = size - 3;
		frac = 1.;
	}else{
		frac = index - lindex;
	}

	fp = buf + lindex;
	a = (float)(fp[-1]) / 32767.;
        b = (float)(fp[0]) / 32767.;
        c = (float)(fp[1]) / 32767.;
        d = (float)(fp[2]) / 32767.;

	cminusb = c-b;
	return (b + frac * (cminusb - 0.5f * (frac - 1.) * 
		 ((a - d + 3.0f * cminusb) * frac + (b - a - cminusb))));
}

#if 0
float inter4pol_stereo(short* buf, float index, long size){
        float frac, a, b, c, d, cminusb;
        short* fp;
        long lindex = (long)index;

        /* version for (stereo-)interleaved buffers */

        if (lindex < 1){
                lindex = 1, frac = .0;
        }else if (lindex > (size - 6)){
                lindex = size - 6;
                frac = 1.;
        }else{
                frac = index - lindex;
        }

        fp = buf + lindex;
        a = (float)(fp[-2]) / 32767.;
        b = (float)(fp[0]) / 32767.;
        c = (float)(fp[2]) / 32767.;
        d = (float)(fp[4]) / 32767.;

        cminusb = c-b;
        return (b + frac * (cminusb - 0.5f * (frac - 1.) *
                 ((a - d + 3.0f * cminusb) * frac + (b - a - cminusb))));
}
#endif
float inter4pol_float (float* buf, float index, long size){
        float frac,  a,  b,  c,  d, cminusb;
        float* fp;
        long lindex = (long)index;

        /* 4 point interpolation taken from tabread4~ of pd (pure-data.org) */

        if (!size) return 0.;

        if (lindex < 1){
                lindex = 1, frac = .0;
        }else if (lindex > (size - 3)){
                lindex = size - 3;
                frac = 1.;
        }else{
                frac = index - lindex;
        }

        fp = buf + lindex;
        a = fp[-1];
        b = fp[0];
        c = fp[1];
        d = fp[2];

        cminusb = c-b;
        return (b + frac * (cminusb - 0.5f * (frac - 1.) *
                 ((a - d + 3.0f * cminusb) * frac + (b - a - cminusb))));
}
