#include <unistd.h>
#include <stdio.h>

#define RAMSIZE 0x8000000
#define REGSIZE 0x1000
#define uchar unsigned char


int  board_getchararray (int, unsigned char*);
int  board_sendchararray(int, unsigned char*);
int  board_getchar           (unsigned char*);
int  board_sendchar          (unsigned char);
int  board_getb16(int*);
int  board_sendb16(int);
int  board_getb32(int*);
int  board_sendb32(int);


void afterinstruction(uchar);
uchar* getwotrustring(void);
void boardreset(void);
uchar execute_instruction(void);


typedef enum {        /*Board instructions unsigned char*/
 BR_NOP     = 0x0,    /*need work on*/
 BR_PING    = 0x1, 
 BR_WOT_R_U = 0x2,
 BR_RESET   = 0x4,
 BR_FR_GET  = 0x10,
 BR_FR_SET  = 0x10,
 BR_FR_FILE = 0x14,
 BR_FR_SEND = 0x15,
 
 
 BR_WOT_U_DO= 0x20,
 BR_STOP    = 0x21,
 BR_PAUSE   = 0x22,
 BR_CONTINUE= 0x23,
 
 BR_RTF_SET = 0x24,
 BR_RTF_GET = 0x25,
 
 BR_BP_WRITE= 0x30,
 BR_BP_READ = 0x31,
 BR_BP_SET  = 0x32,
 BR_BP_GET  = 0x33,
 
 BR_WP_WRITE= 0x34,
 BR_WP_READ = 0x35,
 BR_WP_SET  = 0x36,
 BR_WP_GET  = 0x37,
 
 BR_START   = 0x80
} BR_Instruction;

typedef struct {
 char cond;
 char size;
 int addra;
 int addrb;
 int dataa[2];
 int datab[2];
 } BreakElement;

BreakElement breakpoints[32];
BreakElement watchpoints[32];

int emul_bp_flag[2];
int emul_wp_flag[2];
uchar registers[REGSIZE];
uchar memory[RAMSIZE];
uchar status;
int paused;
unsigned int steps_togo;
unsigned int steps_reset;
char runflags;
uchar rtf;
