/*		Name:		flash.c
		Version:	0.0.2
		Date:		17/7/2001
		Flash (aaaahh) 
*/
#include <stdio.h>
#include <stdlib.h>
#include "serial.h"
#include "flash.h"


int main(int argc, char* argv[])
{ 
 uchar tabledata[16*512];
 unsigned char input[16];
 unsigned int start, length, count, count2;
 FILE* file;
 int hex;
 int comp;
 int temp;
 char* commandstrings[]={"--help", "-h", "-?", "-s",  NULL};
            //            0         1     2     3  
 board_type = SERIAL;
 portname = PORTNAME;
 count =1;
 while (argv[count]){
   if ('-' != *argv[count]) {g_print("Unknown option %s\n",argv[count]);exit(1);}
   comp=0;
   while (g_strcasecmp(commandstrings[comp],argv[count]))
        if (!commandstrings[comp]) {g_print("Unknown option  %s\n",argv[count]);exit(1);}
        else comp++;
   switch (comp) {
    case 0:
    case 1:
    case 2:         //help
        g_print("\n Flash (aaaaahhhhh) Version " VERSION " (" DATE ")\n"
                " Copyright " YEAR " University of Manchester \n"
                " Authors:Charlie Brej & Jim Garside\n"
                " Bug reports and feature requests: komodo@cs.man.ac.uk\n"
                " Website: http://www.cs.man.ac.uk/teaching/electronics/komodo\n"
                "\n"
                " Usage: kmd [options]\n"
                "\n"
                "   --help\n"
                "   -h\n"
                "   -?              display this help message\n"
                "   -s [port]       run through serial port Default:" PORTNAME "\n");
        exit(0);
    case 3:         //serial
        board_type = SERIAL;
        if (argv[count+1]) if ('-' != *argv[count+1]) portname = argv[++count];
        break;
    default:
        g_print("Command paramiter Error!");
        exit(0);
    }
   count++;
   }

 
 g_print("\nSerial Setup    :%d",serial_setup(100));      /*setup serial port */
 
    read_pipe = serial_FD;
    write_pipe = serial_FD;
 
 g_print("\nFLASH (aaaaahhhhh) v0.1 (c) 2001 Manchester Uni");
   board_sendchar (0xfe);
   board_sendchar (0xa5);
   board_sendchar (0x1b);
   board_sendchar (0x1e);
   input[0]=0;
   input[1]=0;
   input[2]=0;
   input[3]=0;
   do {
   input[0]=input[1];
   input[1]=input[2];
   input[2]=input[3];
   board_getchar(input+3);
   }
   while (  input[0] != 0xFE ||
            input[1] != 0xE1 ||
            input[2] != 0x90 ||
            input[3] != 0x0D );
 while(1){
 g_print("\n>");
  if (EOF == scanf ("%s", input)) exit(0);
  hex=input[1];
  switch(input[0])
  {
  	case 'H':
  	case 'h':
  	case '?':
        g_print("\n FLASH (aaaaahhhhh) v0.1 (c) 2001 Manchester Uni");        
        g_print("\n R Filename StartAddress Length - Read to file from Flash"); 
        g_print("\n W Filename StartAddress Length - Write from file to Flash"); 
        g_print("\n P                              - Ping board");        
        g_print("\n H                              - Help Menu");        
        g_print("\n T                              - Show free memory areas");   
        g_print("\n E EraseAddress                 - Erase memory areas");   
        g_print("\n L LockAddress                  - Lock memory areas");   
        g_print("\n C CheckAddres                  - Lock Check memory areas");   
             
        break;
    case 'R':
    case 'r':
        g_print ("\nFilename>");
        scanf ("%s", input);
        if ('@' == *input) file=stdout;
        else file = fopen (input, "w");
        if (file <0){       g_print("\nBad Filename\a");
                            break;
                            }
        g_print ("Start address>");
        scanf ("%x", &start);
        g_print ("Length>");
        scanf ("%x", &length);
        g_print ("\nReading:%s, at %x size %x\n", input, start, length);
        board_sendchar ('R');
        board_sendb32 (start);
        board_sendb32 (length);
        if ('h'==hex || 'H'==hex)
            while ((count = MIN(length,16))){
                if (count != board_getchararray(count, input)){ 
                            if (file != stdout)fclose(file);
                            g_print("\nTimeout!!!!!\a");
                            break;
                            }
                for(count2=0; count2<count; count2++)
                    fprintf(file,"%02x ", input[count2]);
                fprintf(file,"\n");
                board_sendchar ('A');
                length -= count;
                g_print(".");fflush(stdout);
                }
                
                
        else while ((count = MIN(length,16))){
                if (count != board_getchararray(count, input)){ 
                            if (file != stdout)fclose(file);
                            g_print("\nTimeout!!!!!\a");
                            break;
                            }
                for(count2=0; count2<count; count2++)
                    fprintf(file,"%c", input[count2]);
                board_sendchar ('A');
                length -= count;
                g_print(".");fflush(stdout);
                }
                
                
        if (file != stdout)fclose(file);
        g_print("\nSuccess");
        break;
        
        
        
        
     case 'W':
     case 'w':
        g_print ("\nFilename>");
        scanf ("%s", input);
        if ('@' == *input) file=stdin;
        else file = fopen (input, "r");
        if (file<=0) {
                g_print("\nBad Filename!!!!!\a");
                break;
                }
        g_print ("Start address>");
        scanf ("%x", &start);
        g_print ("Length>");
        scanf ("%x", &length);
        g_print ("\nWriting:%s, at %x size %x", input, start, length);
        board_sendchar ('W');
        board_sendb32 (start);
        board_sendb32 (length);
        if ('h'==hex || 'H'==hex)
            while ((count = MIN(length,16))){
                for(count2=0; count2<count; count2++){
                    fscanf(file,"%x",  &temp);
                    input[count2] = temp;
                    }
                    
                board_sendchararray(count, input);
                if (1 != board_getchar(input)){ 
                            if (file != stdin)fclose(file);
                            g_print("\nTimeout!!!!!\a");
                            break;
                            }
                if ('A'!=input[0]){ 
                            if (file != stdin)fclose(file);
                            g_print("\nBad Ack!!!!!\a");
                            break;
                            }
                length -= count;
                g_print(".");
                if (!(length&0x3f0)) g_print("\n %06d  ", length);
                fflush(stdout);
                
                }
        else
             while ((count = MIN(length,16))){
                g_print("A\n");
                for(count2=0; count2<count; count2++)
                    fscanf(file,"%c", &input[count2]);
                board_sendchararray(count, input);
                if (1 != board_getchar(input)){ 
                            if (file != stdin)fclose(file);
                            g_print("\nTimeout!!!!!\a");
                            break;
                            }
                if ('A'!=input[0]){ 
                            if (file != stdin)fclose(file);
                            g_print("\nBad Ack!!!!!\a");
                            break;
                            }
                length -= count;
                g_print(".");fflush(stdout);
                }
                
        if (file != stdin) fclose(file);
        g_print("\nSuccess");
        break;
        
     case 'E':
     case 'e':
        g_print ("\nErase address>");
        scanf ("%x", &start);
        board_sendchar ('E');
        board_sendb32 (start);
               if (1 != board_getchar(input)){ 
                            g_print("\nTimeout!!!!!\a");
                            break;
                            }
                if ('A'!=input[0]){
                            g_print("\nBad Ack!!!!!\a");
                            break;
                            }
        g_print("\nSuccess");
        break;
        
     case 'P':
     case 'p':
        board_sendchar ('P');
               if (1 != board_getchar(input)){ 
                            fclose(file);
                            g_print("\nTimeout!!!!!\a");
                            break;
                            }
                if ('A'!=input[0]){ 
                            fclose(file);
                            g_print("\nBad Ack!!!!!\a");
                            break;
                            }
        g_print("\nSuccess");
        break;
     case 'T':
     case 't':
        board_sendchar ('R');
        board_sendb32 (TABLE);
        board_sendb32 (length = 16 * 512);
        start=0;
        while ((count = MIN(length,16))){
            if (count != board_getchararray(count, tabledata + start)){  
                       g_print("\nTimeout!!!!!\a");
                       break;
                       }
            board_sendchar ('A');
            length -= count;
            start += count;
            }
        printtable(tabledata);
        break;
     case 'L':
     case 'l':
        g_print ("Lock address>");
        scanf ("%x", &start);
        board_sendchar ('L');
        board_sendb32 (start);
                if (1 != board_getchar(input)){ 
                            g_print("\nTimeout!!!!!\a");
                            break;
                            }
                if ('A'!=input[0]){ 
                            g_print("\nBad Ack!!!!!\a");
                            break;
                            }
        g_print("\nSuccess");
        break;
       
        
     case 'C':
     case 'c':
        g_print ("Check address>");
        scanf ("%x", &start);
        board_sendchar ('C');
        board_sendb32 (start);
                if (1 != board_getchar(input)){ 
                            g_print("\nTimeout!!!!!\a");
                            break;
                            }
                if ('L' ==input[0]){ 
                            g_print("\nLocked");
                            break;
                            }
                if ('N' ==input[0]){ 
                            g_print("\nNot Locked");
                            break;
                            }
                g_print("Bad Ack!!!!");
        break;
       
       case 'I':
       case 'i':
        board_sendchar ('I');
                if (1 != board_getchar(input)){
                            g_print("\nTimeout!!!!!\a");
                            break;
                            }
                switch(input[0]){
                    case 0x1f:
                        g_print("\nManufacturer:  Atmel"); //1f -atmel
                        break;
                    default:
                        g_print("\nManufacturer:  %X",input[0]);
                    }
                            
                if (1 != board_getchar(input)){
                            g_print("\nTimeout!!!!!\a");
                            break;
                            }
                switch(input[0]){
                    case 0xc0:
                        g_print("\nPart No:       AT49BV16X4");     
                        break;
                    case 0xc2:
                        g_print("\nPart No:       AT49BV16X4T");                    
                        break;
                    default:
                        g_print("\nPart No:       %X",input[0] );
                    }
        break;
      
        
     default:
        g_print ("\nunknown command");
        break;
  }
 }
}

void printtable(uchar *tabledata)
{
 unsigned int last=0;
 unsigned int lowest=0xfffffff;
 unsigned int next;
 
 int count;
 
 while(0xffffffff != lowest) {
  lowest=0xffffffff;
  for (count=0; count<16; count++){
    while ( 'C' != tabledata[count * 512] ||
            'O' != tabledata[count * 512 + 1] ||
            'D' != tabledata[count * 512 + 2] ||
            'E' != tabledata[count * 512 + 3])  if(count++>=16) break;
    if (count>=16) break;
    if (lowest >  chararr2int(tabledata + (count * 512) + ROM_START) &&
        last   <= chararr2int(tabledata + (count * 512) + ROM_START) ){
                lowest=chararr2int(tabledata + (count * 512) + ROM_START);
                next=chararr2int(tabledata + (count * 512) + ROM_LENGTH);
                }
    if (lowest >  chararr2int(tabledata + (count * 512) + SPARTAN_START) &&
        last   <= chararr2int(tabledata + (count * 512) + SPARTAN_START) ){
                lowest=chararr2int(tabledata + (count * 512) + SPARTAN_START);
                next=chararr2int(tabledata + (count * 512) + SPARTAN_LENGTH);
                }
    if (lowest >  chararr2int(tabledata + (count * 512) + VIRTEX_START) &&
        last   <= chararr2int(tabledata + (count * 512) + VIRTEX_START) ){
                lowest=chararr2int(tabledata + (count * 512) + VIRTEX_START);
                next=chararr2int(tabledata + (count * 512) + VIRTEX_LENGTH);
                }
    }
  if (last != lowest)       g_print("\nFree : %08x - %08x", last, lowest);
  last=lowest+next;
  if (0xffffffff != lowest)   g_print("\nUsed : %08x - %08x", lowest, last);
  if (!next) last+=2;
  }
}


int chararr2int(uchar *arr)
{
return (arr[0] | arr[1]<<8 | arr[2]<<16 | arr[3]<<24);
}
