/*		Name:		lint.c
		Version:	0.9.17
		Date:		20/12/2003
		Expressions 
*/
#include "lint.h"
#include "exp.h"



Lint lint_new(long long value)
{
 Lint ret;
 int index;
 for (index=0; index<LINT_ARRAY_COUNT; index++){
    ret.data[index] = value & LINT_SINGLE_MASK;
    value = value >> LINT_SINGLE_SIZE;
    }
 return ret;
}

long long lint_to_longlong(Lint value)
{
 long long ret=0;
 int index;
 for (index=LINT_ARRAY_COUNT-1; index>=0; index--){
    ret = (ret << LINT_SINGLE_SIZE) | (value.data[index]&LINT_SINGLE_MASK);
    }
 return ret;
}


int lint_compare (Lint a, Lint b)
{
 int index;
 int ret;
 a.data[LINT_ARRAY_COUNT-1] ^= 1<<(LINT_SINGLE_SIZE-1);
 b.data[LINT_ARRAY_COUNT-1] ^= 1<<(LINT_SINGLE_SIZE-1);
 for (index=LINT_ARRAY_COUNT-1; index>=0; index--){
    ret= a.data[index] - b.data[index];
    if (ret) return ret;
    }
 return 0;
}



Lint lint_operate (Lint a, Lint b, LintSymbolType type)
{
 LintDouble dbl;
 int index;
 long long ammount;
 Lint ret;
 switch (type) {
    case EXP_MUL:
        ret=lint_new(0);
        for (index=0; index<LINT_BIT_COUNT; index++){
            if (b.data[index/LINT_SINGLE_SIZE] & (1 << (index%LINT_SINGLE_SIZE))){
                ret = lint_operate(ret, lint_operate(a, lint_new(index), EXP_SL), EXP_ADD);
                }
            }
        return ret;
    case EXP_DIV:
        index=5;
        ret=lint_new(0);
        while (0 <= lint_compare(a, lint_operate(b, lint_new(index), EXP_SL))) index++;
       
        while (index--){
            if(0 <= lint_compare(a, lint_operate(b, lint_new(index), EXP_SL))){
                a = lint_operate(a, lint_operate(b, lint_new(index), EXP_SL), EXP_SUB);
                ret = lint_operate(ret, lint_operate(lint_new(1), lint_new(index), EXP_SL),EXP_OR);
                }
            }
        return ret;
    case EXP_MOD:
        ret = lint_operate(a,lint_operate(lint_operate(a, b, EXP_DIV), b , EXP_MUL), EXP_SUB);
        return ret;
    case EXP_ADD:
        dbl=0;
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            dbl = a.data[index] + b.data[index] + (dbl >> LINT_SINGLE_SIZE);
            ret.data[index] = dbl & LINT_SINGLE_MASK;
            }
        return ret;
    case EXP_SUB:
        dbl=0;
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            dbl = a.data[index] - b.data[index] + (dbl >> LINT_SINGLE_SIZE);
            ret.data[index] = dbl & LINT_SINGLE_MASK;
            }
        return ret;
    case EXP_SL:
        ammount = lint_to_longlong(b);
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            if      (index <  ammount / LINT_SINGLE_SIZE)
                    ret.data[index] = 0;
            else if (index == ammount / LINT_SINGLE_SIZE)
                    ret.data[index] = (a.data[index-ammount/LINT_SINGLE_SIZE  ]<<                 (ammount%LINT_SINGLE_SIZE)) & LINT_SINGLE_MASK;
            else    ret.data[index] = (a.data[index-ammount/LINT_SINGLE_SIZE-1]>>(LINT_SINGLE_SIZE-ammount%LINT_SINGLE_SIZE) |
                                       a.data[index-ammount/LINT_SINGLE_SIZE  ]<<                 (ammount%LINT_SINGLE_SIZE)) & LINT_SINGLE_MASK;
            }
        return ret;
    case EXP_SR:
        ammount = lint_to_longlong(b);
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            if      (index >  LINT_ARRAY_COUNT-ammount / LINT_SINGLE_SIZE)
                    ret.data[index] = 0;
            else if (index == LINT_ARRAY_COUNT-ammount / LINT_SINGLE_SIZE)
                    ret.data[index] = (a.data[index+ammount/LINT_SINGLE_SIZE  ]>>                 (ammount%LINT_SINGLE_SIZE)) & LINT_SINGLE_MASK;
            else    ret.data[index] = (a.data[index+ammount/LINT_SINGLE_SIZE+1]<<(LINT_SINGLE_SIZE-ammount%LINT_SINGLE_SIZE) |
                                       a.data[index+ammount/LINT_SINGLE_SIZE  ]>>                 (ammount%LINT_SINGLE_SIZE)) & LINT_SINGLE_MASK;
            }
        return ret;
    case EXP_XOR:
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            ret.data[index] = a.data[index] ^ b.data[index];
            }
        return ret;
    case EXP_AND:
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            ret.data[index] = a.data[index] & b.data[index];
            }
        return ret;
    case EXP_OR:
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            ret.data[index] = a.data[index] | b.data[index];
            }
        return ret;
    default:
        return lint_new(0);
    }
}




