/***************************************************************************
                          contact.h  -  description
                             -------------------
    begin                : Sun Jan 5 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACT_H
#define CONTACT_H

#include <qwidget.h>

#include "contactbase.h"
#include "contactextension.h"

// Forward declarations
class MsnObject;
class ChatInformation;


/**
 * A contact from the contact list.
 * @author Mike K. Bennett
 */
class Contact : public ContactBase
{
  Q_OBJECT

  public: // Public constants


  // Client capabilities for CHG command and getCapabilities() method
  enum MsnClientCapabilities
  {
    MSN_CAP_WIN_MOBILE   = 0x01,       // Uses a Windows Mobile device (shows phone icon in buddy list).
    MSN_CAP_INK_GIF      = 0x04,       // Supports handwritten messages in GIF format
    MSN_CAP_INK_ISF      = 0x08,       // Supports handwritten messages in ISF format
    MSN_CAP_VIDEO_CHAT   = 0x10,       // Supports video chats, ie; webcam is connected and shared.
    MSN_CAP_MULTI_PACKET = 0x20,       // Supports multi packet messages.
    MSN_CAP_MSN_MOBILE   = 0x40,       // Has an MSN Mobile device you can page them on  (MSN6 displays a yellow icon
                                       // if they're offline, and received a 'BPR MOB Y' command in the LST commands).
    MSN_CAP_MSN_DIRECT   = 0x80,       // Has an MSN Direct device you can direct-page them on.
    MSN_CAP_WEB_CLIENT   = 0x100,      // Connected with "webmessenger.msn.com"
    MSN_CAP_DIRECT_IM    = 0x4000,     // Supports direct im (no switchboard)
    MSN_CAP_WINKS        = 0x8000,     // Supports Winks
    MSN_CAP_SEARCH       = 0x10000,    // Supports MSN shared search
    MSN_CAP_VOICECLIPS   = 0x40000,    // Supports Voice Clips
    MSN_CAP_MSN60        = 0x10000000, // The client supports client protocols up to and including MSNC (msn6   compatible).
    MSN_CAP_MSN61        = 0x20000000, // The client supports client protocols up to and including MSNC (msn6.1 compatible).
    MSN_CAP_MSN62        = 0x30000000, // The client supports client protocols up to and including MSNC (msn6.2 compatible).
    MSN_CAP_MSN70        = 0x40000000  // The client supports client protocols up to and including MSNC (msn7   compatible).
  };


  // Contact list constants
  enum MsnContactLists
  {
    MSN_LIST_FRIEND  = 1,   // The contact is visible in the contact list (was added to FL list)
    MSN_LIST_ALLOWED = 2,   // The contact is only allowed                (was added to AL list)
    MSN_LIST_BLOCKED = 4,   // The contact is blocked                     (was added to BL list)
    MSN_LIST_REVERSE = 8    // The contact has you on his/hers list       (added by server to RL list)
  };
  

  public: // Public methods
    // The constructor
                         Contact(QString handle, QString friendlyName, int lists, QString groupIds);
    // The destructor
                        ~Contact();
    // Add the groupID to the list of current groups
    void                 addGroupId(const QString &groupId);
    // Check if this is a new contact
    bool                 checkIfContactAddedUser();
    // Return the capablities of the client the contact uses.
    uint                 getCapabilities() const;
    // Return the path to the contact's picture
    QString              getContactPicturePath() const;
    // Return a pointer to the extension class
    ContactExtension    *getExtension() const;
    // Return the contact's friendly name
    QString              getFriendlyName() const;
    // Return the group ID's the contact is added to
    QStringList          getGroupIds() const;
    // Return the contact's status
    QString              getStatus() const;
    // Return the contact's true friendly name, regardless of extension
    QString              getTrueFriendlyName() const;
    // Return an MSN Object
    const MsnObject*     getMsnObject() const;
    // the chat session used to retreive the new msn object
    const ChatInformation *getMsnObjectChat() const;
    // Whether or not the contact is allowed
    bool                 isAllowed() const;
    // Whether or not the contact is blocked
    bool                 isBlocked() const;
    // Whether or not the contact is on the friends list
    bool                 isFriend() const;
    // Whether or not the contact is on the reverse list
     bool                isReverse() const;
    // Setup and load a string representing an MSNObject
    void                 loadMsnObject( QString msnObject );
    // Remove the group from the list of group IDs
    void                 removeGroupId(const QString &groupId);
    // Set whether or not the contact is allowed
    void                 setAllowed(bool allowed);
    // Set whether or not the contact is blocked
    void                 setBlocked(bool blocked);
    // Set the capabilities flag of the contact's msn client.
    void                 setCapabilities(uint capabilities);
    // Set whether or not the contact is on the friends list
    void                 setFriend(bool isFriend);
    // Change the contact's friendly name
    void                 setFriendlyName(QString newName);
    // Set whether or not the user is on a given list
    void                 setList(const QString list, bool isMember);
    // the chat session used to retreive the new msn object
    void                 setMsnObjectChat(const ChatInformation *msnObjectChat);
    // Set whether or not the contact is on the reverse list
    void                 setReverse(bool reverse);
    // Set the contact's status
    void                 setStatus(const QString status, bool showBaloon = true);

  private: // Private attributes
    // Whether or not the contact is "allowed"
    bool                 allowed_;
    // Whether or not the contact is blocked
    bool                 blocked_;
    // The capabilities of the client
    uint                 capabilities_;
    // The extensions class
    ContactExtension    *extension_;
    // Whether or not the contact is a friend
    bool                 friend_;
    // The contact's group id
    QStringList          groupIds_;
    // Whether or not the object has been initialized
    bool                 initialized_;
    // msn object
    MsnObject           *msnObject_;
    // the chat session used to retreive the new msn object
    const ChatInformation *msnObjectChat_;
    // Whether or not the contact is on the reverse list
    bool                 reverse_;
    // The contact's online status
    QString              status_;

  private slots: // Slots
    void                 emitChangedFriendlyName();
    // Forward the "changed picture" signal
    void                 forwardChangedPicture();

  signals: // Public signals
    // Signal that the contact may have changed list affiliation
    void                 changedList(Contact *contact);
    // Signal that the contact may have moved to a different group
    void                 changedGroup(Contact *contact);
    // Signal that the contact's msnobject has changed
    void                 changedMsnObject(Contact *contact);
    // Signal if the contact goes offline
    void                 contactOffline(Contact *contact, bool showBaloon);
    // Signal if the contact goes online
    void                 contactOnline(Contact *contact, bool showBaloon);
};

#endif
