/***************************************************************************
                          msnstring.h  -  description
                             -------------------
    begin                : Mon Jun 30 2003
    copyright            : (C) 2003 by Michael Curtis
    email                : michael@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MSNSTRING_H
#define MSNSTRING_H

#include <qstring.h>

class QString;
class CurrentAccount;
class EmoticonCollection;

/**
  *@author Michael Curtis
  */

class MsnString
{
  public:
    // The constructor
    MsnString();
    // The destructor
    ~MsnString();

    // get the text as it was given
    QString &   getOriginalText();
    // get the text after it has gone through the markup processor(s)
    //  paying attention to the users options..
    QString &   getText();

    // set the text
    void        setText( QString text );

  private: // Private methods
    // parse an MSN+ string into an HTML one
    void        parseMessengerPlus( QString &text );

  private: // Private attributes
    // A pointer to the instance of the current account
    CurrentAccount     *currentAccount_;
    // The emoticons
    EmoticonCollection *emoticons_;
    // the text with MSN+/other markup turned into HTML
    QString     markupText_;
    // the original text as it was given
    QString     originalText_;
};

#endif
