/***************************************************************************
                          mimeapplication.h -  description
                             -------------------
    begin                : Thu Nov 23 2004
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2004 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIMEAPPLICATION_H
#define MIMEAPPLICATION_H

#include "application.h"

/**
 * Application framework class, implementing MSN4 Mime-style invitations.
 */
class MimeApplication : public Application
{
  Q_OBJECT

  public:
    // The constructor
                           MimeApplication(const QString& localIp);
    // The descructor
    virtual               ~MimeApplication();

    // Parse a received message (implements a pure virtual method)
    void                   gotMessage(const MimeMessage& message);

  protected:
    // Return the session ID, generating one if it doesn't exist
    const QString&         getSessionId();
    // Send a cancel message (implements a pure virtual method)
    void                   sendCancelMessage(const ApplicationCancelReason cancelReason);
    // Send a message to the contact
    void                   sendMessage(const MimeMessage& message);

  private: // Private methods
    // Generate a random session ID
    QString                generateSessionId() const;

  private: // Private attributes
    // A session ID
    QString                sessionId_;
};

#endif
