/***************************************************************************
                          chatnotification.h  -  description
                             -------------------
    begin                : Fri Jan 31 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATNOTIFICATION_H
#define CHATNOTIFICATION_H

#include <qwidget.h>

// Forward declarations
class ChatWindow;
class Contact;
class BalloonWidget;
class NotificationWidget;
class QStringList;

/**Inform the user of a chat that's been started by a contact.
  *@author Mike K. Bennett
  */

class ChatNotification : public QObject
{
  Q_OBJECT

  public:
    // The constructor
  	             ChatNotification( BalloonWidget *balloonWidget );
    // The destructor
  	            ~ChatNotification();

  public slots:
    // Called when a new chat is started
    void         newChat(const Contact *contact, QString message, ChatWindow *chatWindow);

  private slots: // Private slots
    // The balloon was clicked
    void         clicked( QStringList stringList, QObject *object );

  private: // Private attributes
    // Balloon Widget
    BalloonWidget      *balloonWidget_;
    // Chat window to open when clicked
    ChatWindow         *chatWindow_;
     // Not. Widget
    NotificationWidget *notificationWidget_;
};

#endif
