/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "../kmessdebug.h"

#include "networkwindow.h"

#include <qcheckbox.h>
#include <qvbox.h>
#include <qdatetime.h>
#include <ktextedit.h>
#include <klocale.h>

/*
 * I've tried to put this entire class in a big #ifdef block,
 * but moc doesn't seam to like that.
 */


// Create a non-modal dialog box with a close button, no main widget
// (we'll add one ourselves), and no separator.
// Display with NetworkWindow::show()
NetworkWindow::NetworkWindow(QWidget *parent, const char *name)
  : KDialogBase(parent, name, false, i18n("Network Window"),
                KDialogBase::Close, KDialogBase::Close, false),
    capacity_(500), showIncoming_(false), showOutgoing_(false)
{
#ifdef KMESS_NETWORK_WINDOW
  // Dialog layout is a large text box in a vertical layout with another layout.
  // This second layout contains filter controls.
  // The Close button is at the bottom, and is managed by KDialogBase
  makeVBoxMainWidget(); // TODO: Check for success

  // Create main log
  logWidget_= new KTextEdit(mainWidget());
  logWidget_->setTextFormat(Qt::LogText);
  //logWidget_->setReadOnly(true); // Handled by LogText mode


  // Create control filters
  QWidget *filterBox= new QVBox(mainWidget());
  filterIncomingWidget_= new QCheckBox(i18n("Show incoming server messages"),
				       filterBox);
  filterIncomingWidget_->setChecked(showIncoming_);
  filterOutgoingWidget_= new QCheckBox(i18n("Show outgoing server messages"),
				       filterBox);
  filterOutgoingWidget_->setChecked(showOutgoing_);

  connect(filterIncomingWidget_, SIGNAL(clicked()), this,
	  SLOT(adjustFilters()));
  connect(filterOutgoingWidget_, SIGNAL(clicked()), this,
	  SLOT(adjustFilters()));



  // Set initial log capacity
  setLogCapacity(capacity_);

  // A little message to start us off
  addLogEntry(0, i18n("KMess started."));
#endif
}


void NetworkWindow::setLogCapacity(int entries)
{
#ifdef KMESS_NETWORK_WINDOW
  capacity_= entries;
  logWidget_->setMaxLogLines(capacity_);
#endif
}


void NetworkWindow::addMessage(const QString &msg)
{
#ifdef KMESS_NETWORK_WINDOW
  // [datetime] msg\n
  QString myMsg("(");
  myMsg+= QDateTime::currentDateTime().toString(QString(
    "yy-MM-dd hh:mm:ss")) + ") " + msg;
  logWidget_->append(myMsg);
#endif
}


void NetworkWindow::addLogEntry(int priority, const QString &msg)
{
#ifdef KMESS_NETWORK_WINDOW
  addMessage(msg);
#endif
}


void NetworkWindow::addIncomingServerMessage(const QString &msg)
{
#ifdef KMESS_NETWORK_WINDOW
  // Filter if neccessary
  if(showIncoming_)
  {
    // We're going to have to strip <> tags.
    QString ourMsg= msg;
    ourMsg.replace(QChar('<'), QString("&lt;"));
    ourMsg.replace(QChar('>'), QString("&gt;"));
    ourMsg.prepend(QString("<-- "));

    // Some incoming messages (mime-like for example) have extra \n's
    QChar endch= ourMsg.at(ourMsg.length() - 1);
    while(endch.latin1() == '\n' || endch.latin1() == '\r')
    {
      ourMsg.truncate(ourMsg.length() - 1);
      endch= ourMsg.at(ourMsg.length() - 1);
    }

    addMessage(ourMsg);
  } // End if (showIncoming_)
#endif
}


void NetworkWindow::addOutgoingServerMessage(const QString &msg)
{
#ifdef KMESS_NETWORK_WINDOW
  // Filter if neccessary
  if(showOutgoing_)
  {
    // We're going to have to strip <> tags.
    QString ourMsg= msg;
    ourMsg.replace(QChar('<'), QString("&lt;"));
    ourMsg.replace(QChar('>'), QString("&gt;"));
    ourMsg.prepend(QString("--> "));

    // Outgoing messages tend to have extra \n on them (we must strip them)
    QChar endch= ourMsg.at(ourMsg.length() - 1);
    while(endch.latin1() == '\n' || endch.latin1() == '\r')
    {
      ourMsg.truncate(ourMsg.length() - 1);
      endch= ourMsg.at(ourMsg.length() - 1);
    }

    addMessage(ourMsg);
  } // End if(showOutgoing_)
#endif
}


void NetworkWindow::adjustFilters()
{
#ifdef KMESS_NETWORK_WINDOW
  showIncoming_= filterIncomingWidget_->isChecked();
  showOutgoing_= filterOutgoingWidget_->isChecked();
#endif
}


#include "networkwindow.moc"
