/***************************************************************************
                          autologinview.cpp  -  description
                             -------------------
    begin                : Mon Feb 10 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "autologinview.h"

#include <qcolor.h>
#include <qfont.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qdatetime.h>

#include <kiconloader.h>
#include <klocale.h>

// The constructor
AutologinView::AutologinView(QWidget *parent, const char *name )
 : QWidget(parent,name)
{
  KIconLoader *loader = KGlobal::iconLoader();
  QFont        font;

  // Select an image to load into the main screen.. mmmm, eggs!
  // Applied both in InitialView and AutologinView.
  QString imageName;
  QDate currentDate = QDate::currentDate();
  if( currentDate.month() == 12 && currentDate.day() > 15 )
  {
    imageName = "kmesslogo2";
  }
  else
  {
    imageName = "kmesslogo";
  }

  setPaletteBackgroundColor( QColor( 85, 170, 255 ) );

  QVBoxLayout *mainLayout = new QVBoxLayout( this, 0, 0, "mainLayout" );

  // Create label with the chosen icon
  QPixmap icon = loader->loadIcon( imageName, KIcon::User );
  QLabel *logoPixmapLabel = new QLabel( this, "logoPixmapLabel" );
  logoPixmapLabel->setScaledContents( FALSE );
  logoPixmapLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignHCenter ) );
  logoPixmapLabel->setPixmap( icon );
  logoPixmapLabel->setMinimumSize( icon.width(), icon.height() );

  // Add to layout
  mainLayout->addWidget( logoPixmapLabel );

  // Creater logging in label
  QLabel *connectingLabel = new QLabel( i18n("Logging in..."), this, "connectingLabel" );
  connectingLabel->setPaletteForegroundColor( Qt::black );
  connectingLabel->setAlignment( int( QLabel::AlignHCenter ) );

  // Make fond bold
  font = connectingLabel->font();
  font.setPointSize( 18 );
  font.setBold( true );
  connectingLabel->setFont( font );

  // Add to layout
  mainLayout->addWidget( connectingLabel );
}



// The destructor
AutologinView::~AutologinView()
{
}

#include "autologinview.moc"
