/***************************************************************************
                          grouplistviewitem.h  -  description
                             -------------------
    begin                : Fri Mar 28 2003
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2005 by Diederik van der Boor
    email                : mkb137b@hotmail.com
                           vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GroupListViewItem_H
#define GroupListViewItem_H

#include "kmesslistviewitem.h"

#include <qobject.h>


// Forward declarations
class Contact;
class Group;
class QString;
class QListView;
class QListViewItem;
class ContactListViewItem;
class KAction;


/**
 * @brief Group node of the contact list window
 *
 * The contact list uses a Model-Viewer-Controller model.
 * The Group class signals what something has changed, this view updates itself in the slots.
 *
 * @author Mike K. Bennett
 * @ingroup Root
 */
class GroupListViewItem : public QObject, public KMessListViewItem
{
  Q_OBJECT

  public:
    // The constructor
                         GroupListViewItem(QListView *parent, Group *group);
    // The constructor
                         GroupListViewItem(QListViewItem *parent, Group *group);
    // The destructor
    virtual             ~GroupListViewItem();

    // Add a new contact item
    ContactListViewItem *addContactItem(Contact *contact);
//    // Compare
//     virtual int          compare( QListViewItem *item, int column, bool ascending ) const;
    // Called to signal that the contactitem will be removed from this group.
    void                 detachContactItem(ContactListViewItem *item);
    // Return the group
    Group *              getGroup() const;
    // Return the KAction object to be used in the copy-contact-to-group menu
    KAction             *getCopyAction() const;
    // Return the KAction object to be used in the move-contact menu (and null if it's not possible)
    KAction             *getMoveAction() const;
    // Return the tooltip text.
    QString              getToolTipText() const;
    // Return the type of the item
    int                  getType() const;
    // Update the contacts online/offline count
    void                 recountContacts();

  private: // Private methods
    // Do general construction
    void                 construct();

  private slots:
    // Update the online/offline counters
    void                 slotContactOffline();
    // Update the online/offline counters
    void                 slotContactOnline();
    // Forward when moveAction_ is activated
    void                 slotForwardActivated();
    // Forward when copyAction_ is activated
    void                 slotForwardCopyActivated();
    // Update the appearance of the item
    void                 slotUpdateAppearance();

  private: // Private attributes
    // The group to embed.
    Group               *group_;
    // The action to handle
    KAction             *moveAction_;
    KAction             *copyAction_;
    // The number of contacts online
    int                  noContactsOnline_;

  signals:
    void                 moveToGroup(Group *group);
    void                 copyToGroup(Group* group);
};

#endif
