/***************************************************************************
                          webapplicationp2p.cpp -  description
                             -------------------
    begin                : Sun Aug 7 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "webapplicationp2p.h"

#include "../mimemessage.h"

#include "../../kmessdebug.h"

#include <kmdcodec.h>
#include <klocale.h>
#include <kdebug.h>

/**
 * Constructor
 *
 * @param  applicationList  The shared sources for the contact.
 */
WebApplicationP2P::WebApplicationP2P(ApplicationList *applicationList)
: P2PApplication(applicationList)
{
}


/* *
 * Constructor
 *
 * @param  applicationList  The shared sources for the contact.
 * @param  applicationId    The ID of the web application to start.
 */
/*
WebApplicationP2P::WebApplicationP2P(const QString &contactHandle, int applicationId)
: P2PApplication(contactHandle)
{
}
*/


/**
 * Destructor
 */
WebApplicationP2P::~WebApplicationP2P()
{
}



/**
 * Step one of a contact-started chat: the contact invites the user
 *
 * @param  message  The invitation message
 */
void WebApplicationP2P::contactStarted1_ContactInvitesUser(const MimeMessage &message)
{
#ifdef KMESSDEBUG_WEBAPPLICATION_P2P
  kdDebug() << "WebApplicationP2P - contactStarted1_ContactInvitesUser" << endl;
#endif


  QString  appID   = message.getValue("AppID");
  QString  context = message.getValue("Context");

#ifdef KMESSTEST
  ASSERT( appID.length() == 8 );
#endif

  // Split the appID
//  int languageCode = appID.mid(0, 4).toInt();
//  int realAppID    = appID.mid(4, 4).toInt();

  // Parse the context
  context += "===="; // Make sure the base64 encoded string is null padded to avoid problems with QString::fromUcs2().
  QByteArray decodedContext;
  KCodecs::base64Decode(context.utf8(), decodedContext);

  // Contents is something like '10331021;1;Tic Tac Toe'
  QString contextString = QString::fromUcs2( reinterpret_cast<const unsigned short*>(decodedContext.data()) );

  // Get the fields
  QString unknown       = contextString.section(';', 1, 1);
  QString appName       = contextString.section(';', 2, 2);

#ifdef KMESSTEST
  // Not sure why, the AppID is included with the context again
  ASSERT( contextString.section(';', 0, 0) == appID );
#endif

  // KMess does not support the webapplication invitations yet,
  // this class only parses the context so we can produce a proper error message
  // Warn the user we received an unknown invitation
  showSystemMessage( i18n("The contact is inviting you for '%1', but this is not implemented yet.")
                          .arg( appName ),
                     ChatMessage::CONTENT_SYSTEM_NOTICE, true );

  // Tell the contact we don't support this.
  sendCancelMessage(CANCEL_NOT_INSTALLED);

//  // Everything seams OK, accept this message:
//  contactStarted2_UserAccepts();
}



/**
 * Return the application's GUID.
 */
QString WebApplicationP2P::getAppId()
{
  return "{6A13AF9C-5308-4F35-923A-67E8DDA40C2F}";
}
