/***************************************************************************
                          passivepopupwidget.cpp -  Implements the passive
                          popups widget
                             -------------------
    begin                : Tuesday April 10 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "passivepopupwidget.h"

#include <kdebug.h>
#include <kdeversion.h>



// Class constructor
PassivePopupWidget::PassivePopupWidget( QWidget *parent )
#if KDE_IS_VERSION(3,5,0)
 : KPassivePopup( KPassivePopup::Balloon, parent, "PassivePopup" )
#else
 : KPassivePopup( parent, "PassivePopup" )
#endif
{
  setAutoDelete( true );
}



// Class destructor
PassivePopupWidget::~PassivePopupWidget()
{
  emit dying();
}



// Handles mouse events for the balloon
void PassivePopupWidget::mouseReleaseEvent( QMouseEvent *e )
{
  if( e->button() == Qt::LeftButton )
  {
    emit leftClicked();
  }
  else if( e->button() == Qt::RightButton )
  {
    emit rightClicked();
  }
}



#include "passivepopupwidget.moc"
