/***************************************************************************
                          contactaddeduserdialog.h  -  description
                             -------------------
    begin                : Sun Apr 14 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTADDEDUSERDIALOG_H
#define CONTACTADDEDUSERDIALOG_H

#include "ui_contactaddeduserdialog.h"

#include <KDialog>



/**
 * The dialog for when someone has added the user to his or her contact list.
 *
 * @author Mike K. Bennett
 * @ingroup Dialogs
 */
class ContactAddedUserDialog : public KDialog, private Ui::ContactAddedUserDialog
{
  Q_OBJECT

  public:
    // Return types for the dialog
    enum ReturnCode
    {
      ADD   = 0
    , ALLOW = 1
    , BLOCK = 2
    };

  public:
    // The constructor
                  ContactAddedUserDialog( const QString &contactHandle, const QString &contactFriendlyName );
    // The destructor
    virtual      ~ContactAddedUserDialog();

  public slots: // Protected slots
    // The user pressed the "ok" button
    virtual void  accept();
    // The user pressed the "cancel" button
    virtual void  reject();

  private: // Private properties
    // The handle of the contact who has added the user
    QString       contactHandle_;

  signals:
    // Notify of the choice made by the user
    void          userChoice( const QString &handle, const QStringList &groupsId, const int code );

};

#endif
