/***************************************************************************
                          unknownapplication.cpp -  description
                             -------------------
    begin                : Thu Jul 23 2009
    copyright            : (C) 2009 by Valerio Pilo
    email                : "project" --at-- "kmess" --dot-- "org"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "unknownapplication.h"

#include "../mimemessage.h"

#include <KLocalizedString>



/**
 * The constructor
 */
UnknownApplication::UnknownApplication( ApplicationList *applicationList, const QString &eufGuid )
: P2PApplication( applicationList )
, applicationGuid_( eufGuid )
{
}



/**
 * The destructor
 */
UnknownApplication::~UnknownApplication()
{
}



/**
 * Step one of a contact-started chat: the contact invites the user
 *
 * @param  message  The invitation message
 */
void UnknownApplication::contactStarted1_ContactInvitesUser( const MimeMessage &message )
{
  QString errorMessage( i18n( "The contact is inviting you for '%1', but this is not implemented yet." ) );
  QString appName;

  if( applicationGuid_ == getWebcamPullAppId()
  ||  applicationGuid_ == getWebcamPushAppId() )
  {
    errorMessage = errorMessage.arg( i18n( "webcam" ) );
  }
  else if( applicationGuid_ == getMeetingAppId() )
  {
    errorMessage = errorMessage.arg( I18N_NOOP( "meeting" ) );
  }
  else if( applicationGuid_ == getRemoteDesktopAppId() )
  {
    errorMessage = errorMessage.arg( I18N_NOOP( "remote desktop" ) );
  }
  else if( applicationGuid_ == getVoiceAppId() )
  {
    errorMessage = i18n( "You are invited to start a voice conversation but support for this was not installed" );
  }
  else if( applicationGuid_ == getGamesAppId() )
  {
    // Parse the context
    // Contents is something like '10331021;1;Tic Tac Toe'
    QByteArray decodedContext( QByteArray::fromBase64( message.getValue("Context").toLatin1() ) );
    QString    contextString ( QString::fromUtf16( reinterpret_cast<const ushort*>( decodedContext.data() ),
                                                   decodedContext.size() / 2 ) );

    errorMessage = errorMessage.arg( contextString.section( ';', 2, 2 ) );
  }

  // Tell the contact we don't support the application
  showSystemMessage( errorMessage, ChatMessage::CONTENT_SYSTEM_NOTICE, true );
  sendCancelMessage( CANCEL_NOT_INSTALLED );
}




// Return the GUID for web applications (games)
QString UnknownApplication::getGamesAppId()
{
  return "{6A13AF9C-5308-4F35-923A-67E8DDA40C2F}";
}



// Return the GUID for meeting
QString UnknownApplication::getMeetingAppId()
{
  return "{44BBA842-CC51-11CF-AAFA-00AA00B6015C}";
}



// Return the GUID for remote desktop
QString UnknownApplication::getRemoteDesktopAppId()
{
  return "{56b994a7-380f-410b-9985-c809d78c1bdc}";
}



// Return the GUID for webcam transfer sending
QString UnknownApplication::getWebcamPushAppId()
{
  return "{4BD96FC0-AB17-4425-A14A-439185962DC8}";
}



    // Return the GUID for webcam transfer receiving
QString UnknownApplication::getWebcamPullAppId()
{
  return "{1C9AA97E-9C05-4583-A3BD-908A196F1E92}";
}



// Return the GUID for voice conversations
QString UnknownApplication::getVoiceAppId()
{
  return "{02D3C01F-BF30-4825-A83A-DE7AF41648AA}";
}



#include "unknownapplication.moc"
