//KMformat
//by Mickael Minarie
//this program is under GNU/GPL licence

#include "CDrive.h"
#include <stdlib.h>
#include <iostream>
#include <errno.h>
#include <string>

CDrive::CDrive()
{

}

CDrive::~CDrive()
{

}

   
void CDrive::QuickFormat(QString fs, QString label, bool check)
{	
  qDebug("CDrive::QuickFormat");
  QString strm;
  QString arg;
  bool isOK=FALSE; //to detect an error with the filesystem giving in argument
  if( fs=="ext2") 
    {
      isOK=TRUE;	
      strm.append("mkfs.ext2 ");
      arg.append("-q ");
      if(!label.isEmpty())
	arg.append("-L ");
    }
  
  if( fs=="ext3") 
    {   
      isOK=TRUE;	
      strm.append("mkfs.ext3 ");
      arg.append("-q ");
      if(!label.isEmpty())
	arg.append("-L ");
    }

  if( fs=="minixfs") 
    {
      isOK=TRUE;
      if(label.isEmpty())
	strm.append("mkfs.minix ");
      else
	{
	  emit SigState(1); //minixfs does not support the label
	  return;
	}
    }
  
  if( fs=="vfat") 
    {
      isOK=TRUE;
      strm.append("mkdosfs ");	
      if(!label.isEmpty())
	arg.append("-n ");
    }
  
  if( fs=="fat32") 
    {
      isOK=TRUE;
      strm.append("mkdosfs "); 
      arg.append("-F32 "); 
      if(!label.isEmpty())
	arg.append("-n "); 
    }

  if( fs=="hfs") 
    {
      isOK=TRUE;
      strm.append("hformat "); 
      if(!label.isEmpty())
	arg.append("-l "); 
    }

  if( fs=="xfs") 
    { 
      isOK=TRUE; 
      strm.append("mkfs.xfs ");
      arg.append("-f -q ");
      if(!label.isEmpty())
	arg.append("-L ");
    }

  if( fs=="jfs") 
    { 
      isOK=TRUE; 
      strm.append("mkfs.jfs ");
      arg.append("-q ");
      if(!label.isEmpty())
	arg.append("-L ");
    }

  if( fs=="reiserfs") 
    {   
      isOK=TRUE;
      strm.append("mkreiserfs ");	
      arg.append("-q ");
      if(!label.isEmpty())
	arg.append("-l ");
    }
  
  if( fs=="reiser4")
    { 
      isOK=TRUE;
      strm.append("mkfs.reiser4 ");	
      arg.append("-y ");
      if(!label.isEmpty())
	arg.append("-L ");
    } 

  if( fs=="ntfs")
    { 
      isOK=TRUE;
      strm.append("mkfs.ntfs ");
      if(!label.isEmpty())
	arg.append("-L ");
    } 

  if( fs=="ufs")
    { 
      isOK=TRUE;
      if(label.isEmpty())
	strm.append("mkfs.ufs ");
      else
	{
	  emit SigState(1); //The version of mkfs.ufs I using doesn't support label, if you have a never version, please change this part
	  return;
	}
    } 

  if( fs=="ocfs2")
    { 
      isOK=TRUE;
      strm.append("mkfs.ocfs2 ");
      if(!label.isEmpty())
	arg.append("-L ");
    } 

  if( fs=="bfs")
    { 
      isOK=TRUE;
      strm.append("mkfs.bfs ");
      if(!label.isEmpty())
	arg.append("-N ");
    } 
  
  
  if(!label.isEmpty())
    arg.append(label);
  if(check)
    arg.append(" -c");
  arg.append(" ");
  arg.append("/dev/");
  arg.append(MountPoint);
  
  if(isOK==TRUE)
    {
      run(strm, arg);
    }  

}

void CDrive::FullFormat(int size)
{
  qDebug("CDrive::FullFormat");
  QString strm;
  QString arg;
  strm.append("fdformat ");
  arg.append("/dev/");
  switch(size){
  case(0):
    arg.append(MountPoint);
    break;
  case(1):
    arg.append(MountPoint);
    arg.append("H1440 "); //for 3p1/2 high density drive
    break;
  case(2):
    arg.append(MountPoint);
    arg.append("D720 "); //for 3p1/2 double density drive
    break;
  case(3):
    arg.append(MountPoint);
    arg.append("h1200 "); //for 5p1/4 high density drive
    break;
  case(4):
    arg.append(MountPoint);
    arg.append("d360 "); //for 5p1/4 double density drive
    break;
  }
  run(strm, arg);
}


const QString CDrive::getMountPoint()
{
  return MountPoint;
}


void CDrive::setMountPoint(QString mp)
{
  MountPoint.resize(0);
  MountPoint.append(mp);
}



void CDrive::run(QString strm, QString arg){
  int status;
  std::string strmstl, argstl; // transform to std::string to have a true C char*
  strmstl=strm.toStdString();
  argstl=arg.toStdString();
  strmstl+=argstl;
  qDebug(strmstl.c_str());
  status=system(strmstl.c_str()); //send to the system

  switch(status)
    {
    case(0):
      emit SigState(0); 
      break;

    case(-1):
      qDebug("-1");
      qDebug(strerror (errno));
      emit SigState(-2); //if there is an error with fork
      break;

    default:
      emit SigState(-1);
      break;
    }
}
