/***************************************************************************
 *   Copyright (C) 2004 by Spiros Georgaras                                *
 *   sngeorgaras@otenet.gr                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include <kfiledialog.h>
#include <qlabel.h>
#include <qwidget.h>
#include <qcombobox.h>

#include "kmhtconvert.h"
#include "MHT.h"
#include "WAR.h"
#include "about.h"

//#define DEBUGING
//#define ONE_OPTION_ACTIVE
extern MHT mhtToWarFile;
extern QString fName;
extern bool viewOnly;
extern bool createMHT;
extern bool hideAttachments;
extern bool hideInfo;
//iconload ic;

/*================================
	default constractor
================================*/
kmhtConvert::kmhtConvert(){
}
/*================================
	custom constractor
	
================================*/
kmhtConvert::kmhtConvert(QString dir,bool hInfo,bool hAttachments)
    : QWidget( 0, "kmhtConvert" ){
	delay=250;
	outputFolder=dir;
	lastState=0;
	currentState=0;
	setCaption("kmhtConvert - " + i18n("Web Archive Converter"));
	if(viewOnly){
		Form1Layout = new QVBoxLayout( this, 11, 6, "Form1Layout"); 
		lblCur = new QLabel( this, "lblCur" );
		lblCur->setText(i18n("Creating War file"));
		lblCur->setAlignment( int( QLabel::AlignCenter ) );
		Form1Layout->addWidget( lblCur );
		setFixedSize(292,68);
		QRect desktopSize=KGlobalSettings::splashScreenDesktopGeometry();
		move((desktopSize.right() - desktopSize.left() -292)/2,(desktopSize.bottom() - desktopSize.top() -68)/2);
		connect(&counter, SIGNAL(timeout()), this, SLOT(viewWar()));
		counter.start(100,TRUE);
	}else{
		// Added from ui generated cpp
		Form1Layout = new QVBoxLayout( this, 11, 6, "Form1Layout"); 

		groupBox1 = new QGroupBox( this, "groupBox1" );
		groupBox1->setColumnLayout(0, Qt::Vertical );
		groupBox1->layout()->setSpacing( 6 );
		groupBox1->layout()->setMargin( 11 );
		groupBox1Layout = new QHBoxLayout( groupBox1->layout() );
		groupBox1Layout->setAlignment( Qt::AlignTop );

		txtFile = new KLineEdit( groupBox1, "txtFile" );
		txtFile->setMinimumSize( QSize( 500, 0 ) );
		groupBox1Layout->addWidget( txtFile );

		cmbFile = new KPushButton( groupBox1, "cmbFile" );
		cmbFile->setMinimumSize( QSize( 30, 30 ) );
		cmbFile->setMaximumSize( QSize( 30, 32767 ) );
		groupBox1Layout->addWidget( cmbFile );
		Form1Layout->addWidget( groupBox1 );

		groupBox1_2 = new QGroupBox( this, "groupBox1_2" );
		groupBox1_2->setColumnLayout(0, Qt::Vertical );
		groupBox1_2->layout()->setSpacing( 6 );
		groupBox1_2->layout()->setMargin( 11 );
		groupBox1_2Layout = new QVBoxLayout( groupBox1_2->layout() );
		groupBox1_2Layout->setAlignment( Qt::AlignTop );

		layout2 = new QHBoxLayout( 0, 0, 6, "layout2"); 

		txtFolder = new KHistoryCombo( groupBox1_2, "txtFolder" );
		txtFolder->setMinimumSize( QSize( 500, 0 ) );
		layout2->addWidget( txtFolder );

		cmbFolder = new KPushButton( groupBox1_2, "cmbFolder" );
		cmbFolder->setMinimumSize( QSize( 30, 30 ) );
		cmbFolder->setMaximumSize( QSize( 30, 32767 ) );
		layout2->addWidget( cmbFolder );
		groupBox1_2Layout->addLayout( layout2 );

		chkLast = new QCheckBox( groupBox1_2, "chkLast" );
		groupBox1_2Layout->addWidget( chkLast );
		Form1Layout->addWidget( groupBox1_2 );

		layout5 = new QHBoxLayout( 0, 0, 6, "layout5"); 

		groupMHT = new QGroupBox( this, "groupMHT" );
		groupMHT->setColumnLayout(0, Qt::Vertical );
		groupMHT->layout()->setSpacing( 6 );
		groupMHT->layout()->setMargin( 11 );
		groupMHTLayout = new QVBoxLayout( groupMHT->layout() );
		groupMHTLayout->setAlignment( Qt::AlignTop );

		chkSave = new QCheckBox( groupMHT, "chkSave" );
		groupMHTLayout->addWidget( chkSave );

		chkView = new QCheckBox( groupMHT, "chkView" );
		groupMHTLayout->addWidget( chkView );
		layout5->addWidget( groupMHT );

		groupEML = new QGroupBox( this, "groupEML" );
		groupEML->setColumnLayout(0, Qt::Vertical );
		groupEML->layout()->setSpacing( 6 );
		groupEML->layout()->setMargin( 11 );
		groupEMLLayout = new QVBoxLayout( groupEML->layout() );
		groupEMLLayout->setAlignment( Qt::AlignTop );

		chkInfo = new QCheckBox( groupEML, "chkInfo" );
		groupEMLLayout->addWidget( chkInfo );

		chkAtt = new QCheckBox( groupEML, "chkAtt" );
		groupEMLLayout->addWidget( chkAtt );
		layout5->addWidget( groupEML );
		Form1Layout->addLayout( layout5 );

		textLabel2 = new QLabel( this, "textLabel2" );
		Form1Layout->addWidget( textLabel2 );

		lstAction = new KListBox( this, "lstAction" );
		lstAction->setMinimumSize( QSize( 0, 100 ) );
		lstAction->setFocusPolicy( KListBox::NoFocus );
		Form1Layout->addWidget( lstAction );

		layout33 = new QHBoxLayout( 0, 0, 6, "layout33"); 

		cmbAbout = new KPushButton( this, "cmbAbout" );
		cmbAbout->setMinimumSize( QSize( 100, 0 ) );
		layout33->addWidget( cmbAbout );
		spacer1 = new QSpacerItem( 243, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
		layout33->addItem( spacer1 );

		cmbOk = new KPushButton( this, "cmbOk" );
		cmbOk->setMinimumSize( QSize( 100, 0 ) );
		cmbOk->setAutoDefault( TRUE );
		cmbOk->setDefault( TRUE );
		layout33->addWidget( cmbOk );

		cmbCancel = new KPushButton( this, "cmbCancel" );
		cmbCancel->setMinimumSize( QSize( 100, 0 ) );
		layout33->addWidget( cmbCancel );
		Form1Layout->addLayout( layout33 );

		resize( QSize(0, 0).expandedTo(minimumSizeHint()) );
		clearWState( WState_Polished );
		// Strings and accel
		groupBox1->setTitle( i18n( "Input file" ) );
		cmbFile->setText( QString::null );
		cmbFile->setFocusPolicy( KPushButton::NoFocus );
		QToolTip::add( cmbFile, i18n( "Select Archive to convert" ) );
		groupBox1_2->setTitle( i18n( "Output folder" ) );
		cmbFolder->setText( QString::null );
		cmbFolder->setFocusPolicy( KPushButton::NoFocus );
		chkLast->setText( i18n( "Save in last used folder" ) );
		QToolTip::add( cmbFolder, i18n( "Select folder to save the converted file(s)" ) );
		groupMHT->setTitle( i18n( "MHTML Options" ) );
		chkSave->setText( i18n( "Only extract files" ) );
		QToolTip::add( chkSave, i18n( "Extract the files contained in the mhtml file\nNo KDE Web Archive will not be created" ) );
		chkView->setText( i18n( "View file after extraction" ) );
		QToolTip::add( chkView, i18n( "Display the extracted file in Konqueror" ) );
		groupEML->setTitle( i18n( "EML Options" ) );
		chkInfo->setText( i18n( "Hide Info table" ) );
		QToolTip::add( chkInfo, i18n( "Do not display the Info fields (From:, To: etc.)" ) );
		chkAtt->setText( i18n( "Hide Attachments table" ) );
		QToolTip::add( chkAtt, i18n( "Do not display the Attached files" ) );
		textLabel2->setText( i18n( "Actions - Messages" ) );
		cmbAbout->setText( i18n( "&About" ) );
		//cmbAbout->setFocusPolicy( KPushButton::NoFocus );
		cmbAbout->setAccel( QKeySequence( i18n( "Alt+A" ) ) );
		cmbOk->setText( i18n( "&OK" ) );
		cmbOk->setAccel( QKeySequence( i18n( "Alt+O" ) ) );
		cmbCancel->setText( i18n( "&Cancel" ) );
		cmbCancel->setAccel( QKeySequence( i18n( "Alt+C" ) ) );
		// Added from ui generated cpp
		// signals and slots connections
		connect( cmbCancel, SIGNAL( clicked() ), this, SLOT( exitForm() ) );
		connect( cmbOk, SIGNAL( clicked() ), this, SLOT( convertIt() ) );
		connect( cmbFolder, SIGNAL( clicked() ), this, SLOT( getSaveFolder() ) );
		connect( cmbFile, SIGNAL( clicked() ), this, SLOT( getArchive() ) );
		connect( txtFile, SIGNAL(textChanged(const QString&)), this, SLOT(txtFolderChanged()));
		connect( txtFile, SIGNAL(returnPressed( const QString & )), cmbOk, SIGNAL( clicked()));
		connect( txtFolder, SIGNAL(returnPressed( const QString & )), cmbOk, SIGNAL( clicked()));
		// connect signals for calculating canConvert
		connect( chkView,SIGNAL(stateChanged(int)),this, SLOT(calcCanConvert(int)));
		connect( chkSave,SIGNAL(stateChanged(int)),this, SLOT(calcCanConvert(int)));
		connect( chkInfo,SIGNAL(stateChanged(int)),this, SLOT(calcCanConvert(int)));
		connect( chkAtt,SIGNAL(stateChanged(int)),this, SLOT(calcCanConvert(int)));
		connect( chkLast,SIGNAL(stateChanged(int)),this, SLOT(setLastUsed(int)));
		#ifdef ONE_OPTION_ACTIVE
		connect( chkView,SIGNAL(stateChanged(int)),this, SLOT(chkViewstateChanged(int)));
		connect( chkSave,SIGNAL(stateChanged(int)),this, SLOT(chkSavestateChanged(int)));
		#endif
		//
		canConvert=TRUE;
		outputFileCreated=FALSE;
		canExit=TRUE;
		inputFile="";
		outputFolder="";
		findMode(); 
		loadIcons();
		connect( cmbAbout, SIGNAL( clicked() ), this, SLOT(showAboutWindow()));
		cmbFile->setPixmap(ic->Icon(0));
		cmbFolder->setPixmap(ic->Icon(1));
		if(!fName.isEmpty()) txtFile->setText(fName);
		if(outputFolder.isEmpty()) outputFolder=defaultFolder();
		if(outputFolder.right(1)=="/"){
			QString tmpoutputFolder=outputFolder.left(outputFolder.length()-1);
			outputFolder=tmpoutputFolder;
		}
		txtFolder->completionObject()->setCompletionMode(KGlobalSettings::CompletionPopupAuto);
		KConfig conf("kmhtconvertrc");
		QStringList list;
		list = conf.readListEntry( "Completion list" );
		txtFolder->completionObject()->setItems( list );
		list = conf.readListEntry( "History list" );
		txtFolder->setHistoryItems( list );
		conf.setGroup("Options");
  	chkView->setChecked(conf.readBoolEntry("ViewAfterExtraction",FALSE));
		chkSave->setChecked(conf.readBoolEntry("ExtractOnly",FALSE));
		if(hInfo) chkInfo->setChecked(TRUE);
		else chkInfo->setChecked(conf.readBoolEntry("ShowEMLInfo",FALSE));
		if(hAttachments) chkAtt->setChecked(TRUE);
		else chkAtt->setChecked(conf.readBoolEntry("ShowEMLAttachment",FALSE));
		chkLast->setChecked(conf.readBoolEntry("SaveInLastUsed",FALSE));
		if(txtFolder->count()>0){
			chkLast->setText( i18n( "Save in last used folder" ) + " (" + txtFolder->text(0) + ")" );
			if(chkLast->isChecked()){
				txtFolder->setEnabled(FALSE);
				cmbFolder->setEnabled(FALSE);
			}
		}else
			chkLast->setEnabled(FALSE);
		txtFolder->completionObject()->setCompletionMode(KGlobalSettings::CompletionPopupAuto);
	}
}

kmhtConvert::~kmhtConvert(){}
//================================
//
//          MHT -> WAR
//
//================================
/*================================
================================*/
void kmhtConvert::loadIcons(){
	ic=new iconload();
	QStringList picture("16x16/actions/filenew.png");
	if(ic->loadIcon(picture,0)==-1) iconLoadError("filenew.png");
	picture=QStringList("16x16/filesystems/folder.png");
	if(ic->loadIcon(picture,1)==-1) iconLoadError("folder.png");
	picture=QStringList("16x16/actions/ok.png");
	if(ic->loadIcon(picture,2)==-1) iconLoadError("ok.png");
	picture=QStringList("16x16/actions/cancel.png");
	if(ic->loadIcon(picture,3)==-1) iconLoadError("cancel.png");
	picture=QStringList("16x16/actions/info.png");
	if( ic->loadIcon(picture,4)==-1) iconLoadError("info.png"); 
	picture=QStringList("48x48/apps/kmhtconvert.png");
	if( ic->loadIcon(picture,5)==-1) iconLoadError("kmhtconvert.png");
}
/*================================
================================*/
void kmhtConvert::iconLoadError(QString str){
	lstAction->insertItem(ic->Icon(3),"Error loading icon: " + str);
}
/*================================
================================*/
QString kmhtConvert::defaultFolder(){
	int c=txtFile->text().findRev('/');
	return txtFile->text().left(c);
}
/*================================
================================*/
void kmhtConvert::findMode(){
	mode=0;
	groupMHT->setEnabled(TRUE);
	groupEML->setEnabled(TRUE);
	if(txtFile->text().endsWith(".mht",FALSE) || txtFile->text().endsWith(".mhtml",FALSE)){
		mode=1;
		QToolTip::remove(chkInfo);
		QToolTip::remove(chkAtt);
		groupEML->setEnabled(FALSE);
		QToolTip::add( chkSave, i18n( "Extract the files contained in the mhtml file\nNo KDE Web Archive will not be created" ) );
		QToolTip::add( chkView, i18n( "Display the extracted file in Konqueror" ));
	}else if(txtFile->text().endsWith(".eml",FALSE)){
		mode=1;
		QToolTip::add( chkSave, i18n( "Extract the files contained in the mhtml file\nNo KDE Web Archive will not be created" ) );
		QToolTip::add( chkView, i18n( "Display the extracted file in Konqueror" ));
		QToolTip::add( chkInfo, i18n( "Do not display the Info fields (From:, To: etc.)" ) );
		QToolTip::add( chkAtt, i18n( "Do not display the Attached files" ) );
	}else if(txtFile->text().endsWith(".war",FALSE)){
		mode=2;
		QToolTip::remove(chkInfo);
		QToolTip::remove(chkAtt);
		QToolTip::remove(chkView);
		QToolTip::remove(chkSave);
		groupMHT->setEnabled(FALSE);
		groupEML->setEnabled(FALSE);
	}else{
		QToolTip::add( chkSave, i18n( "Extract the files contained in the mhtml file\nNo KDE Web Archive will not be created" ) );
		QToolTip::add( chkView, i18n( "Display the extracted file in Konqueror" ));
		QToolTip::add( chkInfo, i18n( "Do not display the Info fields (From:, To: etc.)" ) );
		QToolTip::add( chkAtt, i18n( "Do not display the Attached files" ) );
	}
}
/*================================
================================*/
void kmhtConvert::getSaveFolder(){
	QString defFolder=txtFolder->currentText();
	if(defFolder.isEmpty()){
		if(txtFile->text().isEmpty()) defFolder=QString(getenv("HOME"));
		else{
			int sl=txtFile->text().findRev("/");
			if(sl!=-1) defFolder=txtFile->text().left(sl);
		}
	}
	QString newFolder=KFileDialog::getExistingDirectory(defFolder,this,QString(i18n("Select the location to save the output file")));
	if(!newFolder.isEmpty()){
		QFileInfo dirNewFolder(newFolder);
		if(!dirNewFolder.isWritable()){
			addMessageToList(3,i18n("You don't have write permission to folder \"%1\"").arg(newFolder));
		}else{
			outputFolder=newFolder;
			txtFolder->setCurrentText(newFolder);
		}
	}
	txtFolder->setFocus();
}
/*================================
================================*/
void kmhtConvert::addMessageToList(int pixId, QString message){
	lstAction->insertItem(ic->Icon(pixId),message);
	lstAction->setBottomItem(lstAction->count()-1);
}
/*================================
================================*/
void kmhtConvert::getArchive( ){
	QString defFolder=defaultFolder();
	if(defFolder.isEmpty()) defFolder=QString(getenv("HOME"));
	QString  fileFilter;
	if(txtFile->text().endsWith(".mhtml",FALSE)){
		fileFilter="*.mhtml | " + i18n("MHTML Web Archive") + " (*.mhtml)";
		fileFilter+="\n*.mht | " + i18n("Windows Web Archive") + " (*.mht)";
		fileFilter+="\n*.eml | " + i18n("Email Archive") + " (*.eml)";
		fileFilter+="\n*.war | " + i18n("KDE Web Archive") + " (*.war)";
		fileFilter+="\n*.mhtml *.mht *.eml *.war | " + i18n("Web Archive") + " (*.mhtml, *.mht, *.eml, *.war)";
	}else if(txtFile->text().endsWith(".mht",FALSE)){
		fileFilter="*.mht | " + i18n("Windows Web Archive") + " (*.mht)";
		fileFilter+="\n*.eml | " + i18n("Email Archive") + " (*.eml)";
		fileFilter+="\n*.mhtml | " + i18n("MHTML Web Archive") + " (*.mhtml)";
		fileFilter+="\n*.war | " + i18n("KDE Web Archive") + " (*.war)";
		fileFilter+="\n*.mhtml *.mht *.eml *.war | " + i18n("Web Archive") + " (*.mhtml, *.mht, *.eml, *.war)";
	}else if(txtFile->text().endsWith(".eml",FALSE)){
		fileFilter="*.eml | " + i18n("Email Archive") + " (*.eml)";
		fileFilter+="\n*.mht | " + i18n("Windows Web Archive") + " (*.mht)";
		fileFilter+="\n*.mhtml | " + i18n("MHTML Web Archive") + " (*.mhtml)";
		fileFilter+="\n*.war | " + i18n("KDE Web Archive") + " (*.war)";
		fileFilter+="\n*.mhtml *.mht *.eml *.war | " + i18n("Web Archive") + " (*.mhtml, *.mht, *.eml, *.war)";
	}else if(txtFile->text().endsWith(".war",FALSE)){
		fileFilter="*.war | " + i18n("KDE Web Archive") + " (*.war)";
		fileFilter+="\n*.mht | " + i18n("Windows Web Archive") + " (*.mht)";
		fileFilter+="\n*.mhtml | " + i18n("MHTML Web Archive") + " (*.mhtml)";
		fileFilter+="\n*.eml | " + i18n("Email Archive") + " (*.eml)";
		fileFilter+="\n*.mhtml *.mht *.eml *.war | " + i18n("Web Archive") + " (*.mhtml, *.mht, *.eml, *.war)";
	}else{
		fileFilter="*.mhtml *.mht *.eml *.war | " + i18n("Web Archive") + " (*.mhtml, *.mht, *.eml, *.war)";
		fileFilter+="\n*.mhtml | " + i18n("MHTML Web Archive") + " (*.mhtml)";
		fileFilter+="\n*.mht | " + i18n("Windows Web Archive") + " (*.mht)";
		fileFilter+="\n*.eml | " + i18n("Email Archive") + " (*.eml)";
		fileFilter+="\n*.war | " + i18n("KDE Web Archive") + " (*.war)";
	}
	QString tmpfName=KFileDialog::getOpenFileName(defFolder,fileFilter,this,i18n("Select Web Archive to convert"));
	if(!tmpfName.isEmpty()){
		QFileInfo tmpfNameInfo(tmpfName);
		if(!tmpfNameInfo.isReadable()){
			addMessageToList(3,i18n("You don't have read permission to file \"%1\"").arg(tmpfName));
			canConvert=FALSE;
		}else{
			inputFile=tmpfName;
			txtFile->setText(tmpfName);
			canConvert=TRUE;
			lstAction->clear();
			//findMode();
		}
	}
	txtFile->setFocus();
}
//================================
// Slots
//================================
/*================================
================================*/
void kmhtConvert::keyReleaseEvent ( QKeyEvent * e ){
	if(e->key()==Qt::Key_Enter || e->key()==Qt::Key_Return){
		if(cmbCancel->hasFocus()){
			e->accept();
			if(!justShowed) exitForm();
			else justShowed=FALSE;
		}else if (cmbAbout->hasFocus()){
			e->accept();
			if(!justShowed){
				justShowed=TRUE;
				showAboutWindow();
			}else justShowed=FALSE;
		}else{
			e->accept();
			justShowed=FALSE;
			convertIt();
		}
	}else if(e->key()==Qt::Key_Escape){
		e->accept();
		if(!justShowed) exitForm();
	}else{
		justShowed=FALSE;
		e->ignore();
	}
}
/*================================
================================*/
void kmhtConvert::exitForm(){
	if(canExit) close(TRUE);
}
/*================================
================================*/
void kmhtConvert::convertIt(){
	//inputFile=txtFile->text();
	KURL inputURL(txtFile->text());
	inputFile=inputURL.url();
	if(!inputURL.isLocalFile() && !inputFile.isEmpty()){
		lstAction->clear();
		addMessageToList(3,i18n(QString("kmhtconvert can handle only local files...")));
		return;
	}
	inputFile=inputURL.path();
	if(inputFile.isEmpty()){
		lstAction->clear();
		return;
	}
	//outputFolder=txtFolder->text();
	if(chkLast->isChecked()) outputFolder=txtFolder->text(0);
	else outputFolder=txtFolder->currentText();
	if(outputFolder.isEmpty()){
		int c=inputFile.findRev("/");
		if(c!=-1) outputFolder=inputFile.left(c);
	}else{
		if(txtFolder->contains(txtFolder->currentText())) txtFolder->removeFromHistory(txtFolder->currentText());
		txtFolder->addToHistory(txtFolder->currentText());
	}
	if(!canConvert){
		bool okToExit=FALSE;
		if(inputFile==lastInputFile){
			if((outputFolder==lastOutputFolder) && outputFileCreated) okToExit=TRUE;
		}
		if(okToExit){
			lstAction->clear();
			addMessageToList(2,i18n("The file has already been converted"));
			return;
		}
	}
	QFileInfo tmpfNameInfo(inputFile);
	if(!tmpfNameInfo.exists()){
		lstAction->clear();
		addMessageToList(3,i18n("The input file does not exist"));
		return;
	}else if(!tmpfNameInfo.isReadable()){
		lstAction->clear();
		addMessageToList(3,i18n("You don't have read permission to file \"%1\"").arg(inputFile));
		return;
	}
	tmpfNameInfo.setFile(outputFolder);
	if(!tmpfNameInfo.exists()){
		lstAction->clear();
		addMessageToList(3,i18n("The ouput folder does not exist"));
		return;
	}else if(!tmpfNameInfo.isDir()){
		lstAction->clear();
		addMessageToList(3,i18n("Invalid output folder specified"));
		saveLastState();
		return;
	}else if(!tmpfNameInfo.isWritable()){
		lstAction->clear();
		addMessageToList(3,i18n("You don't have write permission to the output folder"));
		return;
	}
	if(lstAction->count()>0)
		lstAction->clear();
	findMode();
	if(mode==0){
		addMessageToList(3,i18n("File type not supported"));
		return;
	}else if(mode==1){
		//MHT --> WAR
		MHT locMHT;
		connect( &locMHT, SIGNAL (archiveOpened()), this, SLOT(slotFileOpened()));
		connect( &locMHT, SIGNAL(foundFilesInArchive(int)), this, SLOT(slotFilesInArchive(int)));
		connect( &locMHT, SIGNAL (fileExtraced(QString)), this, SLOT(slotExtractingFile(QString)));
		connect( &locMHT, SIGNAL (archiveCreated(QString)), this, SLOT(slotOutputFileCreated(QString)));
		connect( &locMHT, SIGNAL (errorAppeared(int)), this, SLOT(slotErrorAppeared(int)));
		if(chkSave->isChecked()) locMHT.setNoSaveWarFile(TRUE);
		if(!locMHT.setFile(inputFile,outputFolder,hideInfo,hideAttachments)) return;
		if(chkInfo->isChecked() && chkInfo->isEnabled()) locMHT.setShowInfo(FALSE);
		if(chkAtt->isChecked() && chkAtt->isEnabled()) locMHT.setShowAttachments(FALSE);
		if(!locMHT.extractAllFiles()) return;
		if(!chkSave->isChecked()) if(!locMHT.createWarArchive()) return;
	}else{
		//WAR --> MHT
		WAR locWAR;
		connect( &locWAR, SIGNAL (archiveOpened()), this, SLOT(slotFileOpened()));
		connect( &locWAR, SIGNAL(foundFilesInArchive(int)), this, SLOT(slotFilesInArchive(int)));
		connect( &locWAR, SIGNAL (fileExtraced(QString)), this, SLOT(slotExtractingFile(QString)));
		connect( &locWAR, SIGNAL (archiveCreated(QString)), this, SLOT(slotOutputFileCreated(QString)));
		connect( &locWAR, SIGNAL (errorAppeared(int)), this, SLOT(slotErrorAppeared(int)));
		locWAR.setName(inputFile,outputFolder);
	}
	KConfig conf("kmhtconvertrc");
	QStringList list;
	list = txtFolder->completionObject()->items();
	conf.writeEntry( "Completion list", list );
	list = txtFolder->historyItems();
	conf.writeEntry( "History list", list );
	lastState=currentState;
	conf.setGroup("Options");
	conf.writeEntry("ViewAfterExtraction",chkView->isChecked());
	conf.writeEntry("ExtractOnly",chkSave->isChecked());
	conf.writeEntry("ShowEMLInfo",chkInfo->isChecked());
	conf.writeEntry("ShowEMLAttachment",chkAtt->isChecked());
	conf.writeEntry("SaveInLastUsed",chkLast->isChecked());
	saveLastState();
}
/*================================
	called with
		emit archiveOpened();
================================*/
void kmhtConvert::slotFileOpened(){
	addMessageToList(2,i18n("Archive successfully opened"));
}
/*================================
	called with
		foundFilesInArchive([number of items]);
================================*/
void kmhtConvert::slotFilesInArchive(int num){
	addMessageToList(4,QString(i18n("Files in archive: ")) + QString("%1").arg(num));
}
/*================================
	called with
		emit fileExtraced([file name]);
================================*/
void kmhtConvert::slotExtractingFile(QString file){
	addMessageToList(4,QString(i18n("Extracting file: ")) + QString("%1").arg(file));
}
/*================================
	Called when the output file / files is created
	if MHT -> WAR (or save files only) show the
	output file in konqueror
================================*/
void kmhtConvert::slotOutputFileCreated(QString file){
	addMessageToList(2,i18n("Output file successfully created"));
	saveLastState();
	if(chkView->isChecked() && chkView->isEnabled()){
		//if(chkSave->isChecked()) KRun::runCommand(QString("/opt/kde3/bin/kfmclient openURL \"file:" + file + "/index.html\""));
		//else KRun::runCommand(QString("/opt/kde3/bin/kfmclient openURL \"tar:" + file + "/index.html\"|"));
		if(chkSave->isChecked()) KRun::runURL("file:" + file + "/index.html","text/html",FALSE);
		else KRun::runURL("tar:" + file + "/index.html","text/html",FALSE);
	}
}
/*================================
	Add error messages to the list
	
	called with
		emit errorAppeared([error code]);
================================*/
void kmhtConvert::slotErrorAppeared(int err){
	QString msg;
	switch(err){
	case 1:
		msg=i18n(QString("Error opening input file"));
		;;
	case 2:
	case 3:
		msg=i18n(QString("File is corrupt"));
		break;;
	case 4:
		msg=i18n(QString("File type not supported"));
		break;;
	case 5:
		msg=i18n(QString("Error extracting file"));
		break;;
	case 6:
		msg=i18n(QString("Error opening output file"));
		;;
	}
	addMessageToList(3,msg);
	saveLastState(); // FIX ?
}
/*================================
================================*/
void kmhtConvert::txtFolderChanged( ){
	findMode();
	if(mode==1) mhtToWarFile.reset();
}
/*================================
	show about window
================================*/
void kmhtConvert::showAboutWindow(){
	justShowed=TRUE;
	cmbAbout->setFocus();
	aboutMhtConvert* abMHT=new aboutMhtConvert(ic->Icon(5));
	abMHT->show();
}
/*================================
================================*/
void kmhtConvert::chkViewstateChanged(int status){
	if(status==2) chkSave->setChecked(FALSE);
}
/*================================
================================*/
void kmhtConvert::chkSavestateChanged(int status){
	if(status==2) chkView->setChecked(FALSE);
}
/*================================
	saves the state of last execution
================================*/
void kmhtConvert::saveLastState(){
	canConvert=FALSE;
	outputFileCreated=TRUE;
	lastInputFile=inputFile;
	lastOutputFolder=outputFolder;
	calcCanConvert(0);
}
/*================================
================================*/
void kmhtConvert::keyPressEvent( QKeyEvent *e ){
if(e->key()==Qt::Key_Escape && e->state()==Qt::NoButton && cmbOk->isEnabled()) close(TRUE);
}
/*================================
================================*/
void kmhtConvert::viewWar(){
			counter.stop();
// 		prog->setProgress(30);
// 		lblCur->update();update();
		mhtToWarFile.setFile(fName,"",hideInfo,hideAttachments);
		//close(TRUE); // test case
		if(mhtToWarFile.status==1){
			hide();
			KMessageBox::error(0,i18n(QString("Error opening file")),0);
			close(TRUE);
		}else if(mhtToWarFile.status==2 || mhtToWarFile.status==3){
			hide();
			KMessageBox::error(0,i18n(QString("File is corrupt")),0);
			close(TRUE);
		}else if(mhtToWarFile.status==4){
			hide();
			KMessageBox::error(0,i18n(QString("File type not supported")),0);
			close(TRUE);
		}
		//close(TRUE); // test case
		if(!mhtToWarFile.extractAllFiles()){
			hide();
			KMessageBox::error(0,i18n(QString("Error extracting files")),0);
			close(TRUE);
		}
		if(!mhtToWarFile.createWarArchive()){
			hide();
			KMessageBox::error(0,i18n(QString("Error creating output file")),0);
			close(TRUE);
		}
		mhtToWarFile.showWarFile();
		close(TRUE);
}

/*================================
================================*/
void kmhtConvert::calcCanConvert(int status){
	currentState=status;
	currentState=0;
	if(groupMHT->isEnabled()){
		if(chkView->isChecked()) currentState+=1;
		if(chkSave->isChecked()) currentState+=2;
	}
	if(groupEML->isEnabled()){
		if(chkInfo->isChecked()) currentState+=4;
		if(chkAtt->isChecked()) currentState+=8;
	}
	if(currentState==lastState) canConvert=FALSE;
	else canConvert=TRUE;
}
/*================================
================================*/
void kmhtConvert::setLastUsed(int status){
	if(status==0){
		// not checked
		txtFolder->setEnabled(TRUE);
		cmbFolder->setEnabled(TRUE);
	}else{
		// checked
		txtFolder->setEnabled(FALSE);
		cmbFolder->setEnabled(FALSE);
	}
}
#include "kmhtconvert.moc"
