/* -*- c++ -*-
 *
 * prefsgeneralpage.ui.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


void KMLDonkeyPrefGeneralPage::encodingSelectionChanged( int foo )
{
    if (KMessageBox::warningContinueCancel(this, i18n("<p><b>Changing the text encoding may result in unpredictable behavior.</b></p>\n"
                                                      "<p>You must take care to select an encoding that is relatively compatible with "
                                                      "ISO 8859-1, as you are guaranteed to receive ISO 8859-1 encoded text from MLDonkey. "
                                                      "Even so, KMLDonkey <i>may crash or fail to work properly</i> if you use any text "
                                                      "encoding other than ISO 8859-1. Proceed at your own risk.</p>"),
                                           i18n("Text Encoding Warning"), KStdGuiItem::cont(),
					   "WarningChangeTextEncoding") == KMessageBox::Cancel)
        encodingSelector->setCurrentItem(oldEncoding);
    else
        oldEncoding = foo;
}

void KMLDonkeyPrefGeneralPage::setEncoding( const QString & name )
{
    int i;
    QString encoding = "( " + name.lower() + " )";
    for (i = 0; i < encodingSelector->count(); i++)
        if (encodingSelector->text(i).lower().find(encoding) != -1) {
            encodingSelector->setCurrentItem(i);
            oldEncoding = i;
            return;
        }
}

QString KMLDonkeyPrefGeneralPage::getEncoding()
{
    return KGlobal::charsets()->encodingForName(encodingSelector->currentText());
}

void KMLDonkeyPrefGeneralPage::initPage()
{
    encodingSelector->insertStringList(KGlobal::charsets()->descriptiveEncodingNames());
    oldEncoding = encodingSelector->currentItem();
}
