/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <termios.h> 
#include <qlistview.h> 

#include "c_config.h"

c_config::c_config()
 : KConfigSkeleton( QString("kmobiletools") )
{
	old_device=""; old_encoding=""; old_verbose="";
	setCurrentGroup( "KMobileTools" );
	addItemString( "device", device, "/dev/mobile");
	addItemString( "encoding", encoding, "8859-1");
	addItemString( "smsSaveSlot", sms_saveslot, "" );
	addItemBool ( "verbose", verbose, false );
	
	addItemInt ( "phoneProfile", phoneProfile, 0 );
	addItemInt ( "dialOpts", dialOpts, 0 );
	addItemBool( "motoBattery", motoBattery, false );
	addItemInt ( "baudrate", baudrate, 4 );
	addItemInt ("pb_overwrite", pb_overwrite, 1 );
	addItemInt ("pb_importFormat", pb_importFormat, 0);
	addItemBool("firstTime", firstTime, true);
	addItemBool("pb_clear", pb_clear, false);
	addItemBool("sms_mode2", sms_mode2, false);
	addItemStringList("sms_mem_avail", sms_mem_avail);
	addItemStringList("sms_mem_used", sms_mem_used, (QStringList("MT")+="ME")+="SM" );
	addItemStringList("pb_mem_avail", pb_mem_avail);
	addItemStringList("pb_mem_used", pb_mem_used, QStringList("ME")+="SM" );
	addItemBool("sms_memchanged", smsmemchg );
	addItemBool("pb_memchanged", pbmemchg );
	addItemInt("lastpbmemused", lastPbMemUsed, 0);
 addItemString( "initString", initString, "AT S7=45 S0=0 V1 X4 &c1 E0\r");
 addItemString( "initString_2", initString_2, QString::null);

}


c_config::~c_config()
{
}




/*!
    \fn c_config::getBaudRate()
 */
int c_config::getBaudRate()
{
	switch( baudrate ){
		case 0:
		return B9600;
		case 1:
        return B19200;
		case 2:
        return B38400;
		case 3:
        return B57600;
		case 4:
        return B115200;
		case 5:
        return B230400;
		case 6:
		return B460800;
		case 7:
		return B921600;
		case 8:
		return B1500000;
		case 9:
		return B3000000;
		case 10:
		return B4000000;
	}
	return 0;
}
