/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GSM_H
#define GSM_H

#include <qobject.h>

#include "device.h"
#include "c_sms.h"

#include <kabc/addressbook.h>
#include <kabc/stdaddressbook.h> 

#include "c_smslist.h"
#include "c_config.h"
extern c_config* Config;

/**
@author Marco Gulino
*/
class GSM : public QObject
{
Q_OBJECT
public:
    GSM(QString device=NULL, QObject *parent = 0, const char *name = 0);
    ~GSM();
	
	enum ABSource { PhoneBook=1, SIM=2, STDABC=4, LD=8, LR=16, LL=32 };
	static const int TYPE_SMS = 1;
	static const int TYPE_PB = 2;
	
	Device* getDevice() { return device; }
    void getPhoneStatus();	
	bool getAbInited() { return addressbookIsInited; }
	void setAbInited( bool status ) { addressbookIsInited=status; }
	
	c_SMSList* getSMSList() { return smsList; }
    QString storeSMS( c_SMS* sms);
	QStringList getUsedSMSSlots();
    bool sendSMS( c_SMS* sms);
	bool sendSMS( const QString sms);
	void clearSMSList() { smsList->clear(); }
	int getCharging() { return i_chargeType; }
	int getSignal() { return i_signal; }
	int getCharge() { return i_charge; }
	bool getCalling() { return b_calling; }
	bool isPDU() { return pdu; }
	
	KABC::AddressBook* getPhoneBook() { return addressbook; }
    int motoMode();
    QString getSMSBuffer(const QString id);
	bool changeSMSMemSlot(const QString slot);
    QString getNameFromNumber(const QString number);
    static const QString parseNumber(const QString number);
	static const QStringList getMemDesc(int type, const QString memstr);
	static const QString decodeText(const QString text);
	static const QString recodeText(const QString text);
private:
	Device* device;
	KABC::AddressBook* addressbook;

	bool addressbookIsInited;
	c_SMSList* smsList;
	// Status variables
	int i_signal, i_charge, i_chargeType;
	bool b_calling;
	bool pdu;
	bool isMotorola;
	bool canDoMM;
	bool isSiemens;
	
	// Buffer for  AddressBook data
	QString s_abPhone, s_abSim, s_ld, s_ll, s_lr;
	QStringList phonebookBuffer;
public slots:
    bool initDevice(const QString devpath);
    void initDevice() { initDevice( Config->getDevice() ); }
    void initSMSList( const QStringList memsource=QStringList() );
    void removeSMS( const QString ID );
    void dial(const QString number);
    void hangup();
    void answer();
    QStringList getSMSMemSlots();
    QStringList getPbMemSlots();
    void initPhoneBook( const QString p_type );
    void initPhoneBookSiemensVCF();
	void parsePhoneBook();
	void parsePhoneBookSiemensVCF( QString buffer );
};

#endif
