/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "d_terminal.h"
#include "device.h"
#include <ktextedit.h>
#include <kdebug.h> 
#include <kglobal.h> 
#include <qlayout.h>
#include <qtimer.h>

d_Terminal::d_Terminal(Device* c_device, QWidget *parent, const char *name)
 : KDialog( parent, name, true )
{
	device=c_device;
	device->sendCommand("ATE1\r",20);
    ui_TerminalLayout = new QGridLayout( this, 1, 1, 11, 6, "ui_TerminalLayout"); 
    modemDiag = new modemText( device, this, "modemDiag" );
    ui_TerminalLayout->addWidget( modemDiag, 0, 0 );
	resize(620, 470);
	QTimer *read_buffer=new QTimer(this);
	connect(read_buffer,SIGNAL(timeout()),this, SLOT( readText() ) );
	read_buffer->start(0);
}


d_Terminal::~d_Terminal()
{
}

modemText::modemText(Device* c_device, QWidget *parent, const char *name)
 : KTextEdit( parent, name )
{
	device=c_device;
}

void modemText::keyPressEvent(QKeyEvent *k)
{
	if( (int) k->ascii() == 0 ) 
	{
		KTextEdit::keyPressEvent( k );
		return;
	}
	device->sendChar( (unsigned char) k->ascii() );
	switch ( (int) k->ascii() )
	{
		case (8):
			KTextEdit::keyPressEvent(k);
			break;
		case (13):
			myReturn();
			break;
		case (127):
			KTextEdit::keyPressEvent(k);
			break;
	}
}
#include "d_terminal.moc"


/*!
    \fn modemText::readText()
 */
void d_Terminal::readText()
{
	char* buffer= device->getDevBuffer();
	QString s_buffer=buffer;
	delete [] buffer;
	s_buffer=s_buffer.replace("\r","\n").replace("\n\n","\n");
	if( !s_buffer.isEmpty() ) 
		for(unsigned int i=0; i<s_buffer.length(); i++)
			switch((int) s_buffer.at(i).unicode() ) {
			case 8:
				modemDiag->moveCursor( KTextEdit::MoveEnd, true );
				modemDiag->removeSelectedText();
				break;
// 			case 10:
// 				modemDiag->myReturn();
// 				break;
// 			case 13:
// 				modemDiag->myReturn();
// 				break;
			case 127:
				modemDiag->moveCursor( KTextEdit::MoveEnd, true );
				modemDiag->removeSelectedText();
				break;
			default:
    			modemDiag->insert( QString(s_buffer.at(i) ) );
			}
}
void modemText::myReturn() // copied from KPPP miniterm.cpp
{
  int column;
  int line;

  getCursorPosition(&line,&column);
  for (int i = 0; i < column;i++)
    KTextEdit::moveCursor(KTextEdit::MoveForward, false);
}
