/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kglobal.h> 
#include <klistview.h>
#include <kiconloader.h>
#include <qcheckbox.h>
#include <klocale.h>
#include <kpushbutton.h>
#include <kcombobox.h>
#include <qbuttongroup.h>

#include "d_settingsui.h"
#include "ui_sPhoneBook.h"
#include "ui_sSMS.h"
#include "ui_sPhone.h"
#include "ui_sDevice.h"
#include "gsm.h"
extern GSM* d_gsm;


d_settingsUI::d_settingsUI(QWidget *parent, const char *name, KConfigSkeleton *config)
 : KConfigDialog(parent, name, config)
{
	s_Device=new ui_sDevice();
	s_Phone=new ui_sPhone();
	s_PhoneBook=new ui_sPhoneBook();
	s_SMS=new ui_sSMS();
	
	s_SMS->kb_refresh->setIconSet( KGlobal::iconLoader()->loadIcon( "reload", KIcon::FirstGroup, KIcon::SizeSmall ) );
	s_PhoneBook->kb_refresh->setIconSet( KGlobal::iconLoader()->loadIcon( "reload", KIcon::FirstGroup, KIcon::SizeSmall ) );
	
	addPage( s_Device, i18n("Device"), "blockdevice" );
	addPage( s_Phone, i18n("Mobile phone"), "kmobiletools" );
	addPage( s_PhoneBook, i18n("PhoneBook"), "korganizer" );
	addPage( s_SMS, i18n("SMS"), "mail_generic" );
	s_SMS->kcfg_sms_memchanged->hide();
	connect( s_Phone->kcfg_phoneProfile, SIGNAL( activated(int) ), this, SLOT( phoneProfileChanged(int) ) );
	connect( s_PhoneBook->kcfg_pb_overwrite, SIGNAL( clicked(int) ), this, SLOT(pb_overwriteChanged(int ) ) );
	connect( s_PhoneBook->kb_refresh, SIGNAL( clicked() ), this, SLOT(parseMemSlotsPB() ) );
	connect( s_SMS->kb_refresh, SIGNAL( clicked() ), this, SLOT(parseMemSlotsSMS() ) );
	connect( this, SIGNAL( settingsChanged () ), this,SLOT( saveSettings() ) ) ;
	connect( s_SMS->sms_memtype, SIGNAL( clicked(QListViewItem*) ), this, SLOT(SMSMemChg() ) );
	connect( s_PhoneBook->pb_memtype, SIGNAL( clicked(QListViewItem*) ), this, SLOT(SMSMemChg() ) );
	pb_overwriteChanged( Config->getPbOverwrite() );
	QStringList::Iterator s_it;
	QStringList tmpStrList;
	QCheckListItem* c_item;
	// SMS memory slots
	tmpStrList=QStringList( Config->getSMSMemAval() );
	for( s_it=tmpStrList.begin(); s_it!=tmpStrList.end(); ++s_it)
	{
		c_item=new QCheckListItem( s_SMS->sms_memtype, *s_it, QCheckListItem::CheckBox );
		c_item->setText(1, GSM::getMemDesc(GSM::TYPE_SMS, *s_it).first() );
	}
	tmpStrList=Config->getSMSMemUsed();
	for( s_it=tmpStrList.begin(); s_it!=tmpStrList.end(); ++s_it)
	{
		if(s_SMS->sms_memtype->findItem( *s_it, 0) ) 
			( (QCheckListItem*) s_SMS->sms_memtype->findItem( *s_it, 0) )->setState( QCheckListItem::On );
	}
	// PhoneBook memory slots
	tmpStrList=QStringList( Config->getPbMemAval() );
	for( s_it=tmpStrList.begin(); s_it!=tmpStrList.end(); ++s_it)
	{
		c_item=new QCheckListItem( s_PhoneBook->pb_memtype, *s_it, QCheckListItem::CheckBox );
		c_item->setText(1, GSM::getMemDesc(GSM::TYPE_PB, *s_it).first() );
	}
	tmpStrList=Config->getPbMemUsed();
	for( s_it=tmpStrList.begin(); s_it!=tmpStrList.end(); ++s_it)
	{
		if(s_PhoneBook->pb_memtype->findItem( *s_it, 0) ) 
			( (QCheckListItem*) s_PhoneBook->pb_memtype->findItem( *s_it, 0) )->setState( QCheckListItem::On );
	}
}


d_settingsUI::~d_settingsUI()
{
}

void d_settingsUI::saveSettings()
{
	// handle memory slots
	QListViewItemIterator it;
	QStringList tempStrList, checkedStrList;
	// here we handle SMS memory slots
	it=QListViewItemIterator(s_SMS->sms_memtype);
	while(it.current() ) {
		tempStrList.append( it.current()->text(0) );
		if( ( (QCheckListItem*) it.current() )->isOn() ) checkedStrList.append( it.current()->text(0) );
		++it;
	}
	Config->setSMSMemAval( tempStrList );
	if(!tempStrList.isEmpty() ) Config->setSMSMemUsed( checkedStrList );
	// now PhoneBook memory slots
	tempStrList.clear(); checkedStrList.clear();
	it=QListViewItemIterator(s_PhoneBook->pb_memtype);
	while(it.current() ) {
		tempStrList.append( it.current()->text(0) );
		if( ( (QCheckListItem*) it.current() )->isOn() ) checkedStrList.append( it.current()->text(0) );
		++it;
	} 
	Config->setPbMemAval( tempStrList );
	if(!tempStrList.isEmpty() ) Config->setPbMemUsed( checkedStrList );
	Config->writeConfig();
	if(Config->chgDevice() || Config->chgBaudrate() ) d_gsm->initDevice( Config->getDevice() );
	if(Config->getSMSMode2() ) d_gsm->getDevice()->sendCommand("AT+MODE=2\r",50);
		else d_gsm->getDevice()->sendCommand("AT+MODE=0\r",50);
	Config->upgradeOlds();
}

#include "d_settingsui.moc"


/*!
    \fn kmobiletools::phoneProfileChanged
 */
void d_settingsUI::phoneProfileChanged(int i_phone)
{
	switch( i_phone ){
		case 0:
			s_Phone->kcfg_motoBattery->setChecked (false);
			s_Phone->kcfg_dialOpts->setButton (0);
			break;
		case 1:
			s_Phone->kcfg_motoBattery->setChecked (true);
			s_Phone->kcfg_dialOpts->setButton (0);
			break;
		case 2:
			s_Phone->kcfg_motoBattery->setChecked (false);
			s_Phone->kcfg_dialOpts->setButton (1);
			break;
		case 3:
			s_Phone->kcfg_motoBattery->setChecked (false);
			s_Phone->kcfg_dialOpts->setButton (1);
			break;
		default:
			s_Phone->kcfg_motoBattery->setChecked (false);
			s_Phone->kcfg_dialOpts->setButton (0);
			break;
	}
	cout << i_phone << endl;
}


/*!
    \fn d_settingsUI::pb_overwriteChanged(int item)
 */
void d_settingsUI::pb_overwriteChanged(int item)
{
	if(item==0)
	{
		s_PhoneBook->kcfg_pb_clear->setChecked(false);
		s_PhoneBook->kcfg_pb_clear->setEnabled(false);
	} else {
		s_PhoneBook->kcfg_pb_clear->setEnabled(true);
	}
}

void d_settingsUI::parseMemSlotsPB()
{
	SMSMemChg();
	QStringList memslots=d_gsm->getPbMemSlots();
	s_PhoneBook->pb_memtype->clear();
	QCheckListItem* c_item;
	for(QStringList::iterator it=memslots.begin(); it!=memslots.end(); ++it)
	{
		c_item=new QCheckListItem( s_PhoneBook->pb_memtype, *it, QCheckListItem::CheckBox );
		c_item->setText(1, GSM::getMemDesc(GSM::TYPE_PB, *it).first() );
	}
	QStringList tmpStrList=Config->getPbMemUsed();
	for( QStringList::Iterator s_it=tmpStrList.begin(); s_it!=tmpStrList.end(); ++s_it)
	{
		if(s_PhoneBook->pb_memtype->findItem( *s_it, 0) ) 
			( (QCheckListItem*) s_PhoneBook->pb_memtype->findItem( *s_it, 0) )->setState( QCheckListItem::On );
	}
}

void d_settingsUI::parseMemSlotsSMS()
{
	SMSMemChg();
	QStringList memslots=d_gsm->getSMSMemSlots();
	s_SMS->sms_memtype->clear();
	QCheckListItem* c_item;
	for(QStringList::iterator it=memslots.begin(); it!=memslots.end(); ++it)
	{
		c_item= new QCheckListItem( s_SMS->sms_memtype, *it, QCheckListItem::CheckBox );
		c_item->setText(1, GSM::getMemDesc(GSM::TYPE_SMS, *it).first() );
	}
	QStringList tmpStrList=Config->getSMSMemUsed();
	for( QStringList::Iterator s_it=tmpStrList.begin(); s_it!=tmpStrList.end(); ++s_it)
	{
		if(s_SMS->sms_memtype->findItem( *s_it, 0) ) 
			( (QCheckListItem*) s_SMS->sms_memtype->findItem( *s_it, 0) )->setState( QCheckListItem::On );
	}
}
