/***************************************************************************
                       kmfruleeditorlimit.cpp  -  description
                          -------------------
 begin                : Wed Mar 13 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditorlimit.h"

// qt includes
#include <qstring.h>
#include <qptrlist.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kapplication.h>
#include <kmessagebox.h>

KMFRuleEditorLimit::KMFRuleEditorLimit( QWidget *parent, const char *name, WFlags fl /*,IPTRule* cr*/ ) : KMyFirewallRuleEditorLimit( parent, name, fl ) {}
KMFRuleEditorLimit::~KMFRuleEditorLimit() {}
void KMFRuleEditorLimit::loadRule( IPTRule * rule ) {
	kdDebug() << "void KMFRuleEditorLimit::loadRule( IPTRule * rule )" << endl;
	curr_rule = rule;
	c_use_limit->setChecked( false );
	c_limit->setChecked( false );
	sb_limit->setValue( 5 );
	cb_interval->setCurrentItem( 0 );
	c_burst->setChecked( false );
	readRuleConfig();
}

void KMFRuleEditorLimit::readRuleConfig() {
	QPtrList<QPtrList<QString> > opt_list = curr_rule->ruleOptions();
	for ( uint j = 0;j < opt_list.count();j++ ) {
		options = new QPtrList<QString>;
		options = opt_list.at( j );
		if ( options->count() > 1 ) {
			QString * opt = options->at( 0 );
			QString* cmd = options->at( 1 );
			if ( *opt == "limit" ) {
				kdDebug() << "Found Rule Limit: " << *cmd << endl;
				c_use_limit->setChecked( true );
				c_limit->setChecked( true );
				int i = cmd->find( "/" );
				QString str_rate = cmd->left( i );
				kdDebug() << "Found Rate: " << str_rate << endl;
				int rate = str_rate.toInt();
				sb_limit->setValue( rate );
				QString interval = cmd->right( cmd->length() - i - 1 );
				kdDebug() << "Found Limit: " << str_rate << "/" << interval << endl;
				//cb_interval->setEnabled(true);
				if ( interval == "second" )
					cb_interval->setCurrentItem( 0 );
				if ( interval == "minute" )
					cb_interval->setCurrentItem( 1 ); //setEditText("minute");
				if ( interval == "hour" )
					cb_interval->setCurrentItem( 2 ); //setEditText("hour");
				if ( options->count() > 2 ) {
					c_burst->setChecked( true );
					QString* cmd = options->at( 2 );
					kdDebug() << "Found Burst: " << str_rate << endl;
					int rate = cmd->toInt();
					sb_burst->setValue( rate );
				}
			}
		}
	}
}
void KMFRuleEditorLimit::slotOk() {
	if ( c_use_limit->isChecked() ) {
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "limit" );
		QString* opt = new QString( "" );
		if ( !c_limit->isChecked() && !c_burst->isChecked() ) {
			KMessageBox::sorry( this, i18n( "You cannot enable a limit without at least the rate." ), i18n( "Limit Matches" ) );
			return ;
		}
		QString* del = new QString( "limit" );
		//    curr_rule->delRuleOption(del);
		emit sigDelRuleOpt( del );
		if ( c_limit->isChecked() ) {
			QString str_rate = sb_limit->text();
			QString interval = cb_interval->currentText();
			opt->append( str_rate );
			opt->append( "/" );
			opt->append( interval );
			options->append( opt );
			if ( c_burst->isChecked() ) {
				str_rate = sb_burst->text();
				QString* burst_rate = new QString( str_rate );
				options->append( burst_rate );
			}
			emit sigAddRuleOpt( name, options );
		}
	} else {
		QString* del = new QString( "limit" );
		//    curr_rule->delRuleOption(del);
		emit sigDelRuleOpt( del );
	}
	emit sigDocumentChanged();
	//	accept();
}

void KMFRuleEditorLimit::slotHelp() {
	kdDebug() << "void KMFRuleEditorLimit::slotHelp()" << endl;
	kapp->invokeHelp( "limit" );
}
void KMFRuleEditorLimit::reject() {
	kdDebug() << "void KMFRuleEditorLimit::reject()" << endl;
	emit sigHideMe();
}
#include "kmfruleeditorlimit.moc"
