/***************************************************************************
                          kmfconfigdialog.h  -  description
                             -------------------
    begin                : Sat Feb 22 2003
    copyright            : (C) 2003 by Christian Hubinger
    email                : a9806056@unet.univie.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFCONFIGDIALOG_H
#define KMFCONFIGDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kprocess.h>
#include <qstring.h>
#include <qpixmap.h>

/**
  *@author Christian Hubinger
  */

class QFrame;
class QCheckBox;
class KURLRequester;
class KPushButton;
class KComboBox;
class KListBox;
class KIntSpinBox;
class KMFCheckListOutput;

class KMFConfigDialog : public KDialogBase  {
   Q_OBJECT
   
public: 
	KMFConfigDialog(QWidget *parent=0, const char *name=0, bool modal = true );
	~KMFConfigDialog();

private slots:
	void slotEnableGentooMode( bool enable );
	void slotProcessExited( KProcess* );
	void slotReceivedOutput( KProcess*, char*, int );
	void slotReceivedError( KProcess*, char*, int );
  void slotAutoConf();
	void slotDelInterface();
	void slotAddInterface();
  void slotReadConfig();
  void slotSaveConfig();
  void slotEnableWarnings();
  void accept();

private: // members
	void setupInterfaces();
	void setupPaths();
	void setupGeneral();
  void loadIcons();
	bool isRunning();
  bool checkFirstRun();

private: // data
	KProcess* childproc;
	KProcess &operator<<( const QString& arg );
	KMFCheckListOutput *m_progView;



  // General
  QCheckBox *m_cb_show_splash;
  QCheckBox *m_cb_gentoo_mode;

  // Path widget
  QLabel *m_lab_ipt_path;
  QLabel *m_lab_init_path;
  QLabel *m_lab_runlevel_path;
  QLabel *m_lab_modprobe_path;
	KURLRequester *m_url_ipt_path;
	KURLRequester *m_url_init_path;
	KURLRequester *m_url_runlevel_path;
	KURLRequester *m_url_modprobe_path;

	// Interfaces
	KPushButton *m_b_add_interface;
	KPushButton *m_b_del_interface;
	KPushButton *m_b_enable_warnings;
	KComboBox *m_cb_interface_name;
	KListBox *m_lb_interfaces;
	KIntSpinBox *m_sb_interface_number;
	QPixmap icon_paths, icon_interfaces, icon_general;
};

#endif
