/***************************************************************************
*   Copyright (C) 2005 by Christian Hubinger   *
*   e9806056@student.tuwien.ac.at   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/


#include "details.h"

// QT includes
#include <qlcdnumber.h>

// KDE includes
#include <kdebug.h>
#include <kpushbutton.h>

Details::Details( QWidget* parent, const char* name, WFlags fl )
		: DetailsDesigner( parent, name, fl ) {

	QObject::connect( m_cmd_close, SIGNAL( clicked() ), this, SLOT ( close() ) );

}

Details::~Details() {}

/*$SPECIALIZATION$*/

void Details::close() {
	kdDebug() << "void Details::close()" << endl;
	emit closing();
	QWidget::close();
}

void Details::show() {
	kdDebug() << "void Details::show()" << endl;
	emit showing();
	QWidget::show();
}

void Details::hide() {
	kdDebug() << "void Details::hide()" << endl;
	emit closing();
	QWidget::hide();
}

void Details::slotUpdateRuleCount( const QString& table, const QString& chain, int num ) {
	kdDebug() << "slotUpdateRuleCount( const QString& " << table << ", const QString& " << chain << ", int " << num << " )" << endl;	
	QLCDNumber *lcd = 0;
	if ( table == "filter" ) {
		if ( chain == "INPUT" ) {
			lcd = m_lcd_numRulesIn_Filter_Input;
		}	
		if ( chain == "OUTPUT" ) {
			lcd = m_lcd_numRulesIn_Filter_Output;
		}	
		if ( chain == "FORWARD" ) {
			lcd = m_lcd_numRulesIn_Filter_Forward;
		}	
	} else if (  table == "nat" ) {
		if ( chain == "OUTPUT" ) {
			lcd = m_lcd_numRulesIn_Nat_Output;
		}	
		if ( chain == "PREROUTING" ) {
			lcd = m_lcd_numRulesIn_Nat_Prerouting;
		}	
		if ( chain == "POSTROUTING" ) {
			lcd = m_lcd_numRulesIn_Nat_Postrouting;
		}
	} else if ( table  == "mangle" ) {
		if ( chain == "INPUT" ) {
			lcd = m_lcd_numRulesIn_Mangle_Input;
		}		
		if ( chain == "OUTPUT" ) {
			lcd = m_lcd_numRulesIn_Mangle_Output;
		}	
		if ( chain == "FORWARD" ) {
			lcd = m_lcd_numRulesIn_Mangle_Forward;
		}	
		if ( chain == "PREROUTING" ) {
			lcd = m_lcd_numRulesIn_Mangle_Prerouting;
		}	
		if ( chain == "POSTROUTING" ) {
			lcd = m_lcd_numRulesIn_Mangle_Postrouting;
		}

	}
	if ( ! lcd ) {
		kdDebug() << "ERROR unknown chain or table" << endl;
		return;	
	}
	lcd->display( num );
}

#include "details.moc"

