// -*-Mode: C++;-*-
#include <string>
#include <vector>

#ifndef PatternPair_inc
#define PatternPair_inc

//! Patterndescriptor
/*!
    This class descripes a pair of pattern, which will be a assignement.
    i.e, a=1 will result in a CPatternPair with entry = 'a' and pattern = '1'.
    It can be used to assign a variable name to a value.
*/
class CPatternPair
{
protected:
    std::string entry;
    std::string pattern;
    bool password_entry;
    bool numeric_entry;
    bool large_text;
    bool binary;
    bool no_escape;
    bool pattern_is_name;
    bool blob;
    virtual void copy_old(const CPatternPair&old);
    std::string op;

public:
    //! Constructor
    /*!
      constructs a CPatternPair, setting entry to Entry and pattern to Pattern
      \param Entry the entry-name
      \param Pattern the pattern which is assigned with the entry
      \sa CPatternPair(const CPatternPair& old)
    */
    CPatternPair(const char*Entry,const char*Pattern,const char*aOp="LIKE",bool ano_escape=false,bool ais_name=false);
    CPatternPair(const std::string&Entry,const std::string&Pattern,const std::string&aOp="LIKE",bool ano_escape=false,bool ais_name=false);
    CPatternPair(){password_entry=false;numeric_entry=false;large_text=false;no_escape=false;op="LIKE";pattern_is_name=false;}
    //! copy constructor
    /*!
      this is the copy constructor of CPatternPair.
      all values of \c old are stored in a resulting copy
      \param old object to be copied
    */
    CPatternPair(const CPatternPair& old);
    CPatternPair&operator=(const CPatternPair&old);
    //! Destructor
    virtual ~CPatternPair(){};
    //! The entry
    /*!
      returns the entry as a null-terminated c-string
    */
    virtual const char*get_entry()const{return entry.c_str();}
    virtual const std::string&std_entry()const{return entry;}
    //! The pattern
    /*!
      returns the pattern of this object as null-terminated c-string
    */
    virtual const char*get_pattern()const{return pattern.c_str();}
    virtual const char*pattern_data()const{return pattern.data();}
    virtual unsigned int get_pattern_size()const{return pattern.size();}
    virtual const std::string&std_pattern()const{return pattern;}
    //! setting the entry
    /*!
      emptys the current entry and set it to What.
      \param What new entry
    */
    virtual void set_entry(const char*What){entry=What?What:"";}
    virtual void set_pattern(const char*What){pattern = What?What:"";}
    virtual void set_pattern(const std::string&What){pattern = What;}
    virtual void set_entry(const std::string&What){entry = What;}
    virtual void setIsPassword(bool how){password_entry = how;}
    virtual void setIsNumeric(bool how){numeric_entry = how;}
    virtual void setLargeText(bool how){large_text = how;}
    virtual void setBlob(bool how){blob = how;}

    virtual const bool isPassword()const{return password_entry;}
    virtual const bool isNumeric()const{return numeric_entry;}
    virtual const bool isLargeText()const{return large_text;}
    virtual const bool isBlob()const{return blob;}
    virtual const bool isEntry(const std::string&what)const{return what == entry;}
    virtual const bool get_no_escape()const{return no_escape;}
    virtual void set_no_escape(bool how){no_escape=how;}
    virtual const bool get_is_name()const{return pattern_is_name;}
    virtual void set_is_name(bool how){pattern_is_name=how;if (how) no_escape=how;}

    virtual const std::string&get_op()const{return op;}
    virtual void set_op(const std::string&aop){op = aop;}

    const int operator <(const CPatternPair&old)const;
    const int operator ==(const CPatternPair&old)const;
};

inline const int CPatternPair::operator <(const CPatternPair&old)const
{
    return pattern<old.pattern;
}

inline const int CPatternPair::operator ==(const CPatternPair&old)const
{
    return pattern==old.pattern;
}

typedef std::vector<CPatternPair> PatternList;
typedef std::vector<CPatternPair>::iterator PatternIterator;
typedef std::vector<CPatternPair>::const_iterator PatternConstIterator;

#endif
