#include "binlistviewitem.h"

CBinListViewItem::CBinListViewItem ( QListView * parent )
    : QListViewItem(parent)
{
    init_data();
}

CBinListViewItem::CBinListViewItem ( QListViewItem * parent )
    : QListViewItem(parent)
{
    init_data();
}

CBinListViewItem::CBinListViewItem ( QListView * parent, QListViewItem * after )
    : QListViewItem(parent,after)
{
    init_data();
}

CBinListViewItem::CBinListViewItem ( QListViewItem * parent, QListViewItem * after )
    : QListViewItem(parent,after)
{
    init_data();
}

CBinListViewItem::~CBinListViewItem()
{
}

void CBinListViewItem::setText(int column, const QString & text)
{
    QListViewItem::setText(column,text);
    if (column>=0) {
        m_BinContent[column]="";
    }
}

void CBinListViewItem::init_data()
{
    m_BinContent.clear();
    m_BinContent[-1]="";
}

void CBinListViewItem::setBinContent(int column, const std::string&aContent)
{
    if (column>=0) {
        m_BinContent[column]=aContent;
    }
}

const std::string&CBinListViewItem::getBinContent(int column)
{
    if (column>=0 && m_BinContent.find(column)!=m_BinContent.end()) {
        return m_BinContent[column];
    } else {
        return m_BinContent[-1];
    }
}
