#include "serverview.h"

#include <sys/time.h>
#include <unistd.h>
#include <string>
#include <fstream>
#include <iostream>
#include <vector>
#include <sstream>
#include <iomanip>

#include <kapp.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kprogress.h>
#include <kdebug.h>

#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qcombobox.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qheader.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qwidgetstack.h>
#include <qtextbrowser.h>
#include <kpushbutton.h>
#include <qcheckbox.h>
#include <qtabwidget.h>

#include "kmysqladmin/globals.h"
#include "kmysqladmin/backend/my_sql/my_sql.h"
#include "kmysqladmin/PatternPair.h"
#include "e_patternpair.h"
#include "kmysqladmin/frontend/browsetable/MultiTextInput.h"
#include "kmysqladmin/tabledescr.h"
#include "kmysqladmin/frontend/browsetable/selectoutfile.h"
#include "kmysqladmin/frontend/browsetable/converter.h"
#include "kmysqladmin/helpers/stringlist.h"
#include "kmysqladmin/stringres.h"
#include "kmysqladmin/helpers/smart_pointer.h"
#include "kmysqladmin/frontend/browsetable/progressdlg.h"
#include "kmysqladmin/frontend/binlistviewitem.h"
#include "kmysqladmin/helpers/stringhelper.h"
#include "kmysqladmin/setup/settings.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include "dbtablelistviewitem.h"


#define Inherited ServerViewData

using namespace std;

static const char*modifiers[]={"","password()","char()","ascii()","lcase()",
                               "md5()","encrypt()","rand()",
                               "user()","now()",0};

static const unsigned char blob_image_data[]= {
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x10,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x60, 0x22, 0xed, 0x90, 0x00, 0x00, 0x01,
    0x41, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xd5, 0x96, 0xbb, 0x4a, 0x03,
    0x41, 0x14, 0x86, 0xbf, 0xb5, 0x89, 0x60, 0xba, 0x90, 0x47, 0x10, 0x2c,
    0x05, 0x4b, 0x5f, 0xc0, 0xce, 0x22, 0xda, 0x29, 0x06, 0x2f, 0x60, 0xf0,
    0x15, 0x62, 0x17, 0xf0, 0x61, 0x6c, 0x7c, 0x02, 0xeb, 0x94, 0x2a, 0x84,
    0x24, 0x42, 0x6c, 0x2c, 0x45, 0xb0, 0x0c, 0xb2, 0x41, 0x0b, 0xcf, 0x26,
    0xc7, 0xd9, 0x99, 0x1d, 0x8f, 0x11, 0x06, 0x0f, 0x0c, 0x33, 0xff, 0x5c,
    0xbe, 0xf9, 0x61, 0xf6, 0xec, 0x0c, 0xfc, 0x93, 0xc8, 0x54, 0x7b, 0x43,
    0xb5, 0x5f, 0x81, 0x17, 0x60, 0x4f, 0xf4, 0x0d, 0x90, 0x7b, 0xd6, 0xd7,
    0x80, 0x4b, 0x69, 0x77, 0x0d, 0xfb, 0xc6, 0xb8, 0x4d, 0xa0, 0xa1, 0xf4,
    0x48, 0x0f, 0x7e, 0xa8, 0xd2, 0x73, 0xfa, 0xea, 0x81, 0x0d, 0xeb, 0x6a,
    0x8e, 0x25, 0x62, 0xdc, 0x9e, 0xe3, 0x27, 0xba, 0x38, 0x95, 0xd1, 0x12,
    0x7b, 0xc5, 0xb8, 0x41, 0xb2, 0xf8, 0xa9, 0xd1, 0x75, 0xa0, 0x0f, 0xbc,
    0x03, 0xd7, 0xc0, 0x5a, 0xc5, 0xdc, 0x0c, 0xe8, 0x00, 0x4f, 0xc0, 0x0c,
    0x18, 0x03, 0x87, 0x7f, 0xc0, 0x9d, 0x47, 0xd5, 0xd1, 0x3f, 0x03, 0xb7,
    0xc0, 0x9b, 0xe8, 0x2b, 0x19, 0xf7, 0x1d, 0xfd, 0xb1, 0xe8, 0x07, 0xe0,
    0x0c, 0x78, 0x14, 0xdd, 0x32, 0x70, 0x43, 0xec, 0xa8, 0xd1, 0x03, 0xd1,
    0xbb, 0xa2, 0x27, 0x15, 0xb0, 0xa1, 0xe8, 0x6d, 0xd1, 0x3b, 0xa2, 0xfb,
    0x06, 0xee, 0xaf, 0x8d, 0x16, 0x7d, 0x4d, 0xd1, 0xc5, 0x2f, 0xc5, 0x85,
    0xd5, 0x94, 0x5e, 0x75, 0xd6, 0x4c, 0x0d, 0xdc, 0x12, 0xdb, 0x9a, 0x4c,
    0x85, 0xa1, 0x69, 0x60, 0x7c, 0xe6, 0xe9, 0xcb, 0x3c, 0x7d, 0x56, 0xae,
    0xd9, 0xe8, 0xa6, 0xd4, 0x77, 0x81, 0xf1, 0x1c, 0x18, 0x48, 0x7b, 0xcb,
    0xa9, 0xef, 0x97, 0xe0, 0x7e, 0x8b, 0xaa, 0xa3, 0xbf, 0x00, 0xda, 0x7c,
    0x65, 0xb0, 0x4e, 0x0c, 0xdf, 0x77, 0x74, 0xc4, 0x22, 0x99, 0x4e, 0x59,
    0x24, 0xd3, 0xbe, 0x81, 0x1b, 0x62, 0x47, 0x8d, 0x16, 0x65, 0x02, 0x9c,
    0x44, 0x60, 0x19, 0x70, 0x2e, 0x73, 0x73, 0x31, 0xda, 0x0e, 0xec, 0x15,
    0xe2, 0x9a, 0x8d, 0xa6, 0x8c, 0xa8, 0x51, 0x7d, 0xd7, 0xa7, 0x8a, 0xd2,
    0x5d, 0x1f, 0x7b, 0x3d, 0xa5, 0x8a, 0xd2, 0xeb, 0xe9, 0x13, 0x54, 0xd2,
    0xa5, 0xb5, 0x41, 0x0a, 0x3c, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
    0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

ServerView::ServerView (smart_pointer<CMySql> & _sql_server,QWidget* parent,const char* name)
    //:Inherited( parent, name,false,WStyle_MinMax|WStyle_SysMenu)
    :Inherited( parent, name)
    /*false,WType_TopLevel|WStyle_MinMax|WStyle_SysMenu|WStyle_NormalBorder )*/
{
    m_first_init = true;
    sql_server = _sql_server;
    QString caption;
    caption = GET_TEXT(125);caption+=" - ";caption+=GET_TEXT(106);
    setCaption(caption);
    setIcon(kapp->icon());

    QImage test_image;
    test_image.loadFromData(blob_image_data,sizeof(blob_image_data));
    blob_image = test_image;

    Current_Table_Fields.resize(0);
    Current_Displayed_Fields.resize(0);
    CurrentKeys.resize(0);

    RefreshLists();

    KConfig * k = KGlobal::config();
    k->setGroup("table_view");
    int w,h;
    QString ws,hs;
    ws = k->readEntry("width","0");
    hs = k->readEntry("height","0");
    w = ws.toInt();
    h = hs.toInt();
    if (w && h) {
        resize(w,h);
    }
    connect(&GlobalSettings,SIGNAL(fixfont_changed()),this,SLOT(FixFontChanged()));
    connect(&GlobalSettings,SIGNAL(settingsChanged()),this,SLOT(handleSettings()));
    handleSettings();
    FixFontChanged();
    OutputList->setAllColumnsShowFocus(true);
    OutputList->setSorting(-1);
    m_first_init = false;
}

ServerView::~ServerView()
{
}

void ServerView::RefreshLists()
{
    OutputList->clear();
    m_structList->clear();
    stringlist list;
    sql_server->get_db_list("%",list);
    if (!list.size()) {
        m_structList->setEnabled(false);
        return;
    }
    m_structList->setEnabled(true);
    for (stringlist::iterator iter = list.begin();iter != list.end();++iter) {
        DbTableListViewItem*it = new DbTableListViewItem(m_structList,STL_TO_QT_STRING(*iter));
        m_structList->insertItem(it);
    }
    m_rightHand->raiseWidget(WStackInfoPage);
    m_structList->setCurrentItem(m_structList->firstChild());
    m_structList->setSelected( m_structList->firstChild(), TRUE );
    itemSelected(m_structList->firstChild());
}

void ServerView::MakeRequest()
{
    _make_fetch_request();
}

void ServerView::itemSelected(QListViewItem*which)
{
    DbTableListViewItem*it = (DbTableListViewItem*)which;
    if (!it) return;
    SortListBox->clear();
    ColumnDisplay->clear();
    ColumnList_iterator ergebnis;
    OutputList->clear();
    while (OutputList->header()->count()>0) {
        OutputList->removeColumn(0);
    }
    Current_Table_Fields.resize(0);
    Current_Displayed_Fields.resize(0);
    m_InfoBrowser->clear();
    m_tableInfoBrowser->clear();

    if (it->isTable()) {
        m_rightHand->raiseWidget(WStackTableSearch);
        table_select(it);
    } else {
        m_rightHand->raiseWidget(WStackInfoPage);
        db_select(it);
    }
}

void ServerView::db_select(DbTableListViewItem* which)
{
    if (!which||which->isTable()) return;

    QString s,t;
    s = which->dbName();
    if ( s.isEmpty()) {
        return;
    }
    stringlist Result;
    string _s = QT_TO_STL_STRING(s);
    list_vector result;
    stringlist headers;

    sql_server->do_statement("SHOW TABLE STATUS FROM "+_s,result,headers,true);
    unsigned j;

    int nPos,tPos,rPos,lPos,fPos,cPos,max;
    nPos = tPos = rPos = lPos = fPos = cPos = max = -1;

    t = "<qt><table border=\"1\"><tr>";

    /* yes - we cast unsigned to signed. but the values will never get that large at
       this point.*/
    for (j=0; j<headers.size();++j) {
        if (Caseequ()(headers[j],"Name")) {
            nPos = j;
            max = nPos>max?nPos:max;
        } else if (Caseequ()(headers[j],"Type")||Caseequ()(headers[j],"Engine")) {
            tPos = j;
            max = tPos>max?tPos:max;
        } else if (Caseequ()(headers[j],"Rows")) {
            rPos = j;
            max = rPos>max?rPos:max;
        } else if (Caseequ()(headers[j],"Data_length")) {
            lPos = j;
            max = lPos>max?lPos:max;
        } else if (Caseequ()(headers[j],"Data_free")) {
            fPos = j;
            max = fPos>max?fPos:max;
        } else if (Caseequ()(headers[j],"Comment")) {
            cPos = j;
            max = cPos>max?cPos:max;
        }
    }
    t+=QString("<th>%1</th><th>%2</th><th>%3</th><th>%4</th><th>%5</th><th>%6</th></tr>")
        .arg(i18n("Table")).arg(i18n("Type")).arg(i18n("Rows")).arg(i18n("Data length")).arg(i18n("Data free")).arg(i18n("Comment"));
    for (j=0;j<result.size();++j) {
        if (max>=(int)result[j].size()) continue;
        t+="<tr>";
        if (nPos > -1) {
            t+=("<td>"+STL_TO_QT_STRING(result[j][nPos])+"</td>");
        } else {
            t+=("<td>&nbsp;</td>");
        }
        if (tPos > -1) {
            t+=("<td>"+STL_TO_QT_STRING(result[j][tPos])+"</td>");
        } else {
            t+=("<td>&nbsp;</td>");
        }
        if (rPos > -1) {
            t+=("<td>"+STL_TO_QT_STRING(result[j][rPos])+"</td>");
        } else {
            t+=("<td>&nbsp;</td>");
        }
        if (lPos > -1) {
            t+=("<td>"+STL_TO_QT_STRING(result[j][lPos])+"</td>");
        } else {
            t+=("<td>&nbsp;</td>");
        }
        if (fPos > -1) {
            t+=("<td>"+STL_TO_QT_STRING(result[j][fPos])+"</td>");
        } else {
            t+=("<td>&nbsp;</td>");
        }
        if (cPos > -1) {
            t+=("<td>"+STL_TO_QT_STRING(result[j][cPos])+"</td>");
        } else {
            t+=("<td>&nbsp;</td>");
        }
        t+="</tr>";
    }
    t+="</table></qt>";
    m_InfoBrowser->setText(t);

    if (which->childCount()>0) {
        return;
    }

    sql_server->get_table_list("%",_s,Result);
    if (Result.size() == 0) {
        m_InfoBrowser->setText("<h2>No tables found</h2>");
        return;
    }

    if (sql_server->is_system_db(_s)) {
        EmptyTableButton->setEnabled(false);
    } else {
        EmptyTableButton->setEnabled(true);
    }
    for (stringlist::iterator iter=Result.begin();iter!=Result.end();++iter) {
        DbTableListViewItem*it = new DbTableListViewItem(which,s,STL_TO_QT_STRING(*iter));
        which->insertItem(it);
    }
}

void ServerView::table_select(DbTableListViewItem* which)
{
    ColumnList_iterator ergebnis;
    if (!which || !which->isTable()) return;

    QString s = which->tableName();
    QString t = which->dbName();

    if (s.isEmpty() || t.isEmpty()) {
        set_buttons(FALSE);
        ColumnDisplay->setEnabled(false);
        ColumnDisplay->update();
        SortListBox->setEnabled(false);
        return;
    }
    QString text="";
    unsigned long max = sql_server->table_rows(QT_TO_STL_STRING(t),QT_TO_STL_STRING(s));
    text+=QString(i18n("<p>Table contains %1 rows</p>")).arg(max);

    list_vector result;
    stringlist headers;
    sql_server->do_statement("SHOW CREATE TABLE "+QT_TO_STL_STRING(t)+"."+QT_TO_STL_STRING(s),result,headers,true);

    if (result.size()&&result[0].size()>1) {
        text+="<h3>"+i18n("Table creation")+"</h3><pre>";
        text+=STL_TO_QT_STRING(result[0][1])+"</pre>\n";
    }
    m_tableInfoBrowser->setText(text);
    sql_server->get_table_keys(QT_TO_STL_STRING(t),QT_TO_STL_STRING(s),CurrentKeys);
    if (!sql_server->get_table_fields(QT_TO_STL_STRING(t),QT_TO_STL_STRING(s),Current_Table_Fields) || Current_Table_Fields.size()==0) {
        SortListBox->setEnabled(false);
        ColumnDisplay->setEnabled(false);
        set_buttons(FALSE);
        return;
    }
    SortListBox->setEnabled(true);
    ColumnDisplay->setEnabled(true);
    int count = 0;
    SortListBox->insertItem("");
    for (ergebnis = Current_Table_Fields.begin();ergebnis!=Current_Table_Fields.end(); ++ergebnis){
        ColumnDisplay->insertItem(STL_TO_QT_STRING(ergebnis->get_name()));
        SortListBox->insertItem(STL_TO_QT_STRING(ergebnis->get_name()));
        OutputList->addColumn(STL_TO_QT_STRING(ergebnis->get_name()));
        ++count;
    }
    Current_Displayed_Fields = Current_Table_Fields;
    set_buttons(TRUE);
    OutputList->setFocus();
    m_queryTabs->setCurrentPage(0);
}

void ServerView::addRow()
{
    QString db;
    QString table;

    DbTableListViewItem*it = (DbTableListViewItem*)m_structList->currentItem();
    if (!it || !it->isTable()) return;

    table = it->tableName();
    db = it->dbName();

    e_PatternList which;
    PatternList*result = 0;
    ColumnList_iterator Field;
    int i;
    CMultiTextInput edit(false,true,this);
    for (Field = Current_Table_Fields.begin();Field != Current_Table_Fields.end();++Field) {
        if (!Field->is_AutoIncrement() ) {
            e_PatternIterator iter;
            which.push_back(e_patternpair(Field->get_name(),Field->get_default()));
            iter = which.end();
            iter--;
            iter->setIsNumeric(Field->is_Numeric());
            iter->setLargeText(Field->is_Text());
            iter->setBlob(Field->is_Blob());
            stringIlist _temp_list = Field->enum_list();
            if (_temp_list.size()>0) {
                if (!Field->is_NotNull()&&!Field->get_is_set())
                    _temp_list.insert(_temp_list.begin(),"");
                iter->set_enumlist(_temp_list);
                iter->set_is_set(Field->get_is_set());
            }
        }
    }
    edit.setCaption(GET_TEXT(77));
    edit.build_widgets(&which,modifiers);
    if (edit.exec())
        result = edit.get_entries();
    else
        return;
    if (!result)
        return;
    i = sql_server->insert_row(QT_TO_STL_STRING(db),QT_TO_STL_STRING(table),result);
    if (i < 0) {
        display_error_box();
    }
    delete result;
}

void ServerView::search_rows()
{
    _make_fetch_request(true);
}

void ServerView::set_buttons(bool how)
{
    searchButton->setEnabled(how);
    saveButton->setEnabled(how);
    AddRow->setEnabled(how);
    saveButton->setEnabled(how);
    Go_Button->setEnabled(how);
    EmptyTableButton->setEnabled(how);
    DeleteButton->setEnabled(how);
}

void ServerView::OutputMarked(QListViewItem*item)
{
    bool how = ( (item!=NULL) && (KeyDisplayed()));
    ModifyRow->setEnabled(how);
    DeleteButton->setEnabled(how);
}

void ServerView::modifyRow()
{
    QString Entry;
    QString Breaks;
    e_PatternList BreakList;// =  0;
    PatternList* ModList = 0;
    PatternList KeyList;// = 0;
    PatternList _BreakList;

    QString db;
    QString table;

    DbTableListViewItem*it = (DbTableListViewItem*)m_structList->currentItem();
    if (!it || !it->isTable()) return;

    table = it->tableName();
    db = it->dbName();

    CMultiTextInput edit(true,true,this);
    int i = 0;

    i = BreakIntoParts(&_BreakList,&KeyList);

    if (i < 0 || _BreakList.size() == 0 || KeyList.size() == 0) {
        return;
    }
    for (unsigned j = 0;j < _BreakList.size();++j) {
        BreakList.push_back(_BreakList[j]);
        for (unsigned a=0;a<Current_Displayed_Fields.size();++a) {
            if (Caseequ()(BreakList[j].get_entry(),Current_Displayed_Fields[a].get_name())) {
                stringIlist _temp_list = Current_Displayed_Fields[a].enum_list();
                if (_temp_list.size()>0) {
                    if (!Current_Displayed_Fields[a].is_NotNull() && !Current_Displayed_Fields[a].get_is_set())
                        _temp_list.insert(_temp_list.begin(),"");
                    BreakList[j].set_enumlist(_temp_list);
                    BreakList[j].set_is_set(Current_Displayed_Fields[a].get_is_set());
                }
                break;
            }
        }
    }
    edit.build_widgets(&BreakList,modifiers);

    edit.setCaption("Modify");
    if (!edit.exec()) {
        return;
    }

    ModList = edit.get_entries();

    if (!ModList || ModList->size() == 0) {
        if (ModList)
            delete ModList;
        return;
    }
    e_PatternIterator break_iter;
    PatternIterator mod_iter;

    break_iter = BreakList.begin();
    mod_iter = ModList->begin();
    while (break_iter!=BreakList.end()) {
        if ((break_iter->isBlob() && mod_iter->get_pattern_size()==0)
            || (mod_iter->std_pattern() == break_iter->std_pattern() && mod_iter->get_op().size()==0)) {
            mod_iter =  ModList->erase(mod_iter);
        } else {
            ++mod_iter;
        }
        ++break_iter;
    }
    if (ModList->size() == 0) {
        delete ModList;
        return;
    }
    PatternList::iterator piter;
    for (piter=KeyList.begin();piter!=KeyList.end();++piter) {
        piter->set_no_escape(true);
        piter->set_op("=");
    }
    i = sql_server->update_row(QT_TO_STL_STRING(db),QT_TO_STL_STRING(table),
                               ModList,&KeyList);
    if (i < 0) {
        delete ModList;
        display_error_box();
        return;
    }
    stringlist which;
    list_vector target;
    for (ColumnList_iterator it = Current_Displayed_Fields.begin();it != Current_Displayed_Fields.end();++it) {
        which.push_back(it->get_name());
    }

    PatternList::iterator pit,pit2;
    for (pit=KeyList.begin();pit!=KeyList.end();++pit) {
        for (pit2=ModList->begin();pit2!=ModList->end();++pit2) {
            if (Caseequ()(pit->get_entry(),pit2->get_entry()))
                pit->set_pattern(pit2->get_pattern());
        }
    }
    delete ModList;
    i = sql_server->fetch_rows(QT_TO_STL_STRING(db),QT_TO_STL_STRING(table),
                               "",false,which,target,0,0,&KeyList);
    if (i < 0) {
        display_error_box();
        return;
    }
    QListViewItem*current_item;
    current_item = OutputList->selectedItem();
    if (!current_item || target.size()!=1) {
        return;
    }
    unsigned j = 0;
    QImage test_image;
    for (;j < target[0].size();++j) {
        if (Current_Displayed_Fields[j].is_Blob()) {
            if (m_BlobAsImage &&
                binToImage(target[0][j],test_image)) {
                current_item->setPixmap(j,QPixmap(test_image));
            } else {
                current_item->setPixmap(j,blob_image);
            }
        } else {
            current_item->setText(j,STL_TO_QT_STRING(target[0][j]));
        }
    }
}

void ServerView::delete_row()
{
    QString db;
    QString table;

    DbTableListViewItem*it = (DbTableListViewItem*)m_structList->currentItem();
    if (!it || !it->isTable()) return;

    table = it->tableName();
    db = it->dbName();

    PatternList KeyList;
    int i = BreakIntoParts(0,&KeyList);
    if (i < 0 || KeyList.size() == 0) {
        return;
    }
    i = KMessageBox::questionYesNo(this,GET_TEXT(80),
                                   GET_TEXT(79));
    if (i == KMessageBox::No) {
        return;
    }
    PatternList::iterator piter;
    for (piter=KeyList.begin();piter!=KeyList.end();++piter) {
        piter->set_no_escape(true);
        piter->set_op("=");
    }
    i = sql_server->delete_row(QT_TO_STL_STRING(db),QT_TO_STL_STRING(table),&KeyList);
    if (i < 0) {
        display_error_box();
        return;
    }
    QListViewItem*current_item = OutputList->selectedItem();
    list_vector target;
    stringlist which;
    for (ColumnList_iterator it = Current_Displayed_Fields.begin();it != Current_Displayed_Fields.end();++it) {
        which.push_back(it->get_name());
    }
    i = sql_server->fetch_rows(
                               QT_TO_STL_STRING(db),
                               QT_TO_STL_STRING(table),
                               "",false,
                               which,target,0,0,&KeyList);
    if (i < 0) {
        display_error_box();
        return;
    }
    if (target.size()!=0)
        return;
    //OutputList->takeItem(current_item);
    delete current_item;
}

void ServerView::emptyTable()
{
    QString db;
    QString table;

    DbTableListViewItem*it = (DbTableListViewItem*)m_structList->currentItem();
    if (!it || !it->isTable()) return;

    table = it->tableName();
    db = it->dbName();

    QString message;
    message = GET_TEXT(81);
    message+="\n";
    message+= GET_TEXT(14);
    message+="\n";
    int i = KMessageBox::questionYesNo (this, message, GET_TEXT(82));
    if (i == KMessageBox::No)
        return;
    i = sql_server->delete_row(QT_TO_STL_STRING(db),QT_TO_STL_STRING(table));
    if (i < 0) {
        display_error_box();
        return;
    }
    OutputList->clear();
    ModifyRow->setEnabled(false);
    DeleteButton->setEnabled(false);
    OutputList->setFocus();
    return;
}

bool ServerView::KeyDisplayed()
{
    if (SelectFields.size()==0) {
        return false;
    }
    return true;
}

ColumnList_iterator ServerView::FindTableItem(const std::string&what,bool all_fields)
{
    vector<CColumnDescriptor>::iterator Entry;
    if (all_fields) {
        for (Entry = Current_Table_Fields.begin();Entry!=Current_Table_Fields.end();++Entry) {
            if (*Entry == what)
                return Entry;
        }
        return Entry;
    } else {
        for (Entry = Current_Displayed_Fields.begin();Entry!=Current_Displayed_Fields.end();++Entry) {
            if (*Entry == what) {
                return Entry;
            }
        }
        return Entry;
    }
}

int ServerView::BreakIntoParts(PatternList*BreakList,PatternList*KeyList,QListViewItem*item,
                               bool no_auto_filter,bool copy_bins,bool escape_bins)
{
    ColumnList_iterator Field;
    CBinListViewItem*current_item;

    int i = 0;

    if (Current_Displayed_Fields.size() == 0)
        return -1;
    if (item == 0)
        current_item = (CBinListViewItem*)OutputList->selectedItem();
    else
        current_item = (CBinListViewItem*)item;

    if (!current_item)
        return -1;

    for (i = 0; i < OutputList->columns();++i) {
        if (BreakList)
            BreakList->push_back(CPatternPair("",QT_TO_STL_STRING(current_item->text(i))));
        if (KeyList)
            KeyList->push_back(CPatternPair("",QT_TO_STL_STRING(current_item->text(i))));
    }
    PatternIterator break_iterator;// = BreakList->end();
    PatternIterator key_iterator;// = KeyList->end();
    if (BreakList)
        break_iterator = BreakList->begin();
    if (KeyList)
        key_iterator= KeyList->begin();
    i = 0;
    string temp;
    for (Field = Current_Displayed_Fields.begin();Field!=Current_Displayed_Fields.end();++Field) {
        if (BreakList) {
            if (Field->is_AutoIncrement() && !no_auto_filter) {
                break_iterator = BreakList->erase(break_iterator);
            } else {
                if (break_iterator!=BreakList->end()) {
                    break_iterator->set_entry(Field->get_name());
                    break_iterator->setBlob(Field->is_Blob());
                    if (copy_bins && Field->is_Blob()) {
                        if (escape_bins) {
                            temp = "";
                            sql_server->do_escape(current_item->getBinContent(i),temp);
                            break_iterator->set_pattern(temp);
                        } else {
                            break_iterator->set_pattern(current_item->getBinContent(i));
                        }
                        kdDebug() << "Insert binary data into output" << endl;
                    }
                    break_iterator->setLargeText(Field->is_Text());
                    ++break_iterator;
                }
            }
        }
        if (KeyList) {
            if (SelectFields.find(Field->get_name())!=SelectFields.end()) {
                if (key_iterator!=KeyList->end()) {
                    key_iterator->set_entry(Field->get_name());
                    ++key_iterator;
                }
            } else {
                key_iterator = KeyList->erase(key_iterator);
            }
        }
        ++i;
    }

    return 0;
}

void ServerView::saveResult()
{
    CSelectOutFile SelectBox(this);
    QString filename;
    QString message;
    QFileInfo finfo;
    int i;
    if (OutputList->childCount() == 0)
        return;
    if (!SelectBox.exec())
        return;
    filename = SelectBox.get_name();
    if (filename.isEmpty())
        return;
    finfo.setFile(filename);
    if (finfo.isDir()) {
        QMessageBox::warning(this,GET_TEXT(83),
                             GET_TEXT(84));
        return;
    }
    if (QFile::exists(filename)) {
        message = GET_TEXT(85);
        message+="\n\n";
        message+=filename;message+="\n\n";
        message+=GET_TEXT(86);
        message+="\n";
        i = KMessageBox::questionYesNo( this,message, GET_TEXT(87));
        if (i == KMessageBox::No )
            return;

        if (!finfo.isWritable()) {
            QMessageBox::warning(this,GET_TEXT(83),
                                 GET_TEXT(88));
            return;
        }
    }
    CSelectOutFile::SAVE_TYPE j = SelectBox.get_type();
    cout << "Select: " << j << "\n";
    switch (j) {
    case CSelectOutFile::SAVE_ASCII:
        saveAscii(filename,";");
        break;
    case CSelectOutFile::SAVE_HTML:
        saveHtml(filename);
        break;
    case CSelectOutFile::SAVE_LATEX:
        saveLatex(filename);
        break;
    case CSelectOutFile::SAVE_SQL:
        saveSql(filename);
        break;
    default:
        saveAscii(filename);
    }
}

void ServerView::saveAscii(const char*filename,const char*aSep)
{
    int j = 0;

    const char*sep = aSep?aSep:"\t";

    if (!filename || strlen(filename) == 0)
        return;
    if (OutputList->childCount() < 1)
        return;
    QFile outfile(filename);
    outfile.open(IO_WriteOnly|IO_Truncate);
    if (!outfile.isOpen())
        return;
    QTextStream st(&outfile);
    QListViewItemIterator it(OutputList);

    for (; it.current();++it) {
        for (j = 0; j < OutputList->columns();++j) {
            st << (j == 0?"":sep);
            st << it.current()->text(j);
        }
        st << "\n";
    }

    outfile.close();
}

QString ServerView::escape_output(const string&what)
{
    string t;
    sql_server->do_escape(what,t);
    return STL_TO_QT_STRING(t);
}

void ServerView::saveSql(const char*filename)
{
    QString db;
    QString table;

    DbTableListViewItem*_it = (DbTableListViewItem*)m_structList->currentItem();
    if (!_it || !_it->isTable()) return;

    table = _it->tableName();
    db = _it->dbName();

    PatternList KeyList;
    PatternIterator key_iterator;
    ColumnList_iterator desc;
    QString entry;
    QListViewItemIterator it(OutputList);

    if (!filename || strlen(filename) == 0)
        return;
    if (OutputList->childCount() < 1)
        return;
    QFile outfile(filename);
    outfile.open(IO_WriteOnly|IO_Truncate);
    if (!outfile.isOpen())
        return;
    QTextStream st(&outfile);
    QString pre = "insert into "+table+ " (";
    int start = 0;
    for (desc = Current_Displayed_Fields.begin();desc!= Current_Displayed_Fields.end();++desc) {
        if (start!=0) pre+=",";
        ++start;
        pre += STL_TO_QT_STRING(desc->get_name());
    }
    pre+= ")  values (";
    QString post = ");\n";

    for (; it.current();++it) {
        st << pre;
        KeyList.resize(0);
        BreakIntoParts(&KeyList,0,it.current(),true,true,false);
        desc = Current_Displayed_Fields.begin();
        key_iterator = KeyList.begin();
        desc = Current_Displayed_Fields.begin();

        int num = 0;
        bool asnum = false;
        for (key_iterator = KeyList.begin();key_iterator != KeyList.end();++key_iterator) {
            asnum = desc!=Current_Displayed_Fields.end() && desc->is_Numeric();
            if (num != 0) st << ",";
            if (!key_iterator->isBlob()) {
                if (!asnum) st << "'";
                st << escape_output(key_iterator->std_pattern());
                if (!asnum) st << "'";
            } else {
                st << "0x" << STL_TO_QT_STRING(Bin2Hex(key_iterator->std_pattern())());
            }
            ++num;
        }
        ++desc;
        st << post;
    }
    outfile.close();
}

void ServerView::saveHtml(const char*filename)
{
    smart_pointer<CConverter> converter(CConverter::get_converter(CConverter::HTML));
    if (!converter)
        return;
    PatternList*KeyList = 0;
    PatternIterator key_iterator;
    ColumnList_iterator desc;
    QString entry;

    if (!filename || strlen(filename) == 0)
        return;
    if (OutputList->childCount() < 1)
        return;
    QFile outfile(filename);
    outfile.open(IO_WriteOnly|IO_Truncate);
    if (!outfile.isOpen())
        return;
    QTextStream st(&outfile);
    st << "<HTML>\n<HEAD>\n<TITLE>TableOutput</TITLE>\n</HEAD>\n";
    st << "<BODY>\n<TABLE WIDTH=100% BORDER=1 CELLPADDING=3 CELLSPACING=1>\n";
    st << "  <TR VALIGN=TOP>\n";
    for (desc = Current_Displayed_Fields.begin();desc!= Current_Displayed_Fields.end();++desc) {
        st << "    <TH><P>" << STL_TO_QT_STRING(desc->get_name()) << "</TH>\n";
    }
    st << "  </TR>\n";
    KeyList = new PatternList;
    QListViewItemIterator it(OutputList);
    bool bimagesaved = false;
    QImage bImage;
    QString iname = "";
    int number = 0;
    QFileInfo inf(filename);

    for (; it.current();++it) {
        KeyList->resize(0);
        BreakIntoParts(KeyList,0,it.current(),true,true,false);
        st << "  <TR>\n";
        desc = Current_Displayed_Fields.begin();
        key_iterator = KeyList->begin();
        for (key_iterator = KeyList->begin();key_iterator != KeyList->end();++key_iterator) {
            if (desc!=Current_Displayed_Fields.end() && desc->is_Numeric()) {
                st << "    <TD><P ALIGN=RIGHT>";
            } else {
                st << "    <TD><P>";
            }

            if (key_iterator->isBlob()) {
                st << "<img src=\"";
                if (!binToImage(key_iterator->std_pattern(),bImage,true)) {
                    iname = "placeholder.jpg";
                    if (!bimagesaved) {
                        bImage.loadFromData(blob_image_data,sizeof(blob_image_data));
                        bImage.save(inf.dirPath(true)+"/"+iname,"JPEG");
                        bimagesaved = true;
                    }
                } else {
                    iname = QString("%1_%2.jpg").arg(STL_TO_QT_STRING(desc->get_name())).arg(number);
                    bImage.save(inf.dirPath(true)+"/"+iname,"JPEG");
                }
                st << iname << "\">\n";
            } else {
                entry = key_iterator->get_pattern();
                if (entry.length() > 0) {
                    st << STL_TO_QT_STRING(converter->convert(QT_TO_STL_STRING(entry)));
                } else {
                    entry = "<br>";
                    st << entry;
                }
            }
            st << "</p></TD>\n";
            ++desc;
        }
        st << "  </TR>\n";
        ++number;
    }
    st << "</TABLE>\n<P>\n<FONT SIZE=-1>\n"
        "Document created with KMySqlAdmin\n</FONT>\n</BODY>\n</HTML>\n";
    delete KeyList;
}

void ServerView::saveLatex(const char*filename)
{
    QString db;
    QString table;

    DbTableListViewItem*_it = (DbTableListViewItem*)m_structList->currentItem();
    if (!_it || !_it->isTable()) return;

    table = _it->tableName();
    db = _it->dbName();

    PatternList BreakList;
    smart_pointer<CConverter> converter(CConverter::get_converter(CConverter::LATEX));
    if (!converter)
        return;
    ColumnList_iterator desc;
    std::string entry;
    std::string head, head2, head3;
    unsigned int i;
    unsigned int j;

    if (!filename || strlen(filename) == 0)
        return;
    if (OutputList->childCount() < 1)
        return;
    ofstream st(filename);
    if (!st) {
        QMessageBox::critical(this,GET_TEXT(112),GET_TEXT(83));
        return;
    }
    unsigned int with = Current_Displayed_Fields.size();
    st << "\\documentclass[10pt,a4paper]{article}\n";
    //with = 120/with;
    st << "\\usepackage[latin1]{inputenc}\n";
    st << "\\usepackage{longtable}\n";
    st << "\\newcommand{\\tabcenter}[1]{\\multicolumn{1}{|c|}{#1}}\n";
    st << "\\newcommand{\\tabright}[1]{\\multicolumn{1}{|r|}{#1}}\n";
    std::string Buffer = FormatSTLString("%u",with);
    head3 = "";
    for (desc = Current_Displayed_Fields.begin();desc!= Current_Displayed_Fields.end();++desc ) {
        if (desc != Current_Displayed_Fields.begin()) {
            head3+=" & ";
        }
        string dummy = converter->convert(desc->get_name());
        if (!dummy.empty()) {
            head3+="\\tabcenter{\\bf ";
            head3+=dummy;
            head3+="}";
        }
        else {
            head3+=" ";
        }
    }
    head3 += "\\\\ \\hline\n";

    head = "\\begin{longtable}{|";
    for (i  = 0;i < Current_Displayed_Fields.size();++i ) {
        head+="l|";
    }
    head+="}\n\\caption*{\\bf Database: ";

    head+=converter->convert(QT_TO_STL_STRING(db));
    head+=" Table: ";
    head+=converter->convert(QT_TO_STL_STRING(table));
    head+="}\\\\ \\hline\n";
    head+=head3;
    head+="\\endfirsthead\n";
    head+="\\caption*{{\\bf ";
    head+=converter->convert(QT_TO_STL_STRING(db));
    head+=".";
    head+=converter->convert(QT_TO_STL_STRING(table));
    head+="} - continued}\\\\ \\hline\n";
    head+=head3;
    head+="\\endhead\n";
    head+="\\hline\\multicolumn{";
    head+=Buffer;
    head+="}{|r|}{\\slshape Continued on next page}\\\\ \\hline\n\\endfoot\n";
    head+="\\hline\\multicolumn{";
    head+=Buffer;
    head+="}{l}{\\small document created with \\textbf{KMySqlAdmin}}\n\\endlastfoot\n";

    st << "\n\\begin{document}\n";
    st << head;
    PatternIterator break_iterator;
    j = 0;
    CProgressDlg prg(0,OutputList->childCount(),"Exporting data",0,"ProgressDlg");
    prg.show();
    QListViewItemIterator it(OutputList);

    for (; it.current();++it) {
        BreakList.resize(0);
        prg.setPos(i);
        BreakIntoParts(&BreakList,0,it.current(),true);
        for (break_iterator=BreakList.begin();break_iterator!=BreakList.end();++break_iterator) {
            if (break_iterator != BreakList.begin())
                st << " & ";

            if (!break_iterator->isBlob()) {
                QString dummy = STL_TO_QT_STRING(converter->convert(break_iterator->get_pattern()));
                if (!dummy.isEmpty()) {
                    st << dummy;
                } else {
                    st << " ";
                }
            } else {
                st << "[BLOB]";
            }
        }
        st << "\\\\ \\hline\n";
    }
    st << "\\end{longtable}\n%ready with table\n\n";
    st << "\\end{document}\n";
}

void ServerView::build_relevant_keys()
{
    pairIlist e_list;
    bool all_found;
    SelectFields.resize(0);
    unsigned int count;
    if (!Current_Displayed_Fields.size() || !CurrentKeys.size()) {
        return;
    }
    KeyList::iterator k_iterator = CurrentKeys.begin();
    while(k_iterator != CurrentKeys.end()) {
        if (!k_iterator->is_UniqueKey()) {
            CurrentKeys.erase(k_iterator);
        } else {
            ++k_iterator;
        }
    }
    if (!CurrentKeys.size()) {
        return;
    }
    for(k_iterator=CurrentKeys.begin();k_iterator!=CurrentKeys.end();++k_iterator) {
        all_found = true;
        e_list = k_iterator->get_ColList();
        for (count = 0;count < e_list.size();++count) {
            /* muss auf Current_Displayed_Fields.end() testen, da wir auch in dieser Liste suchen
               mit der 2. Option (!= alles)
             */
            all_found = FindTableItem(e_list[count].first,false) != Current_Displayed_Fields.end();
            if (!all_found)
                break;
        }
        if (all_found) {
            for (count = 0; count < e_list.size();++count) {
                if (SelectFields.find(e_list[count].first)==SelectFields.end()) {
                    SelectFields.push_back(e_list[count].first);
                }
            }
        }
    }
}

void ServerView::_make_fetch_request(bool search_it)
{
    list_vector erg;
    stringlist which;
    ColumnList_iterator Field;
    QString sort;
    QString db;
    QString table;
    QString format;
    unsigned int id;
    int i;

    e_PatternList pattern_list;
    PatternList*result = 0;

    CMultiTextInput edit(false,false,this);

    DbTableListViewItem*it = (DbTableListViewItem*)m_structList->currentItem();
    if (!it || !it->isTable()) return;

    table = it->tableName();
    db = it->dbName();

    Current_Displayed_Fields.resize(0);
    if (SortListBox->count() == 0) {
        return;
    }
    sort = SortListBox->currentText();
    for (id = 0; id < ColumnDisplay->count();id++) {
        if (ColumnDisplay->isSelected(id)) {
            QString s_ = ColumnDisplay->text(id);
            which.push_back(QT_TO_STL_STRING(s_));
            Field = FindTableItem(QT_TO_STL_STRING(s_));
            /*
             * In this case we only search all fields so it is correct!
             */
            if (Field!=Current_Table_Fields.end()) {
                Current_Displayed_Fields.push_back(*Field);
            }
        }
    }
    if (Current_Displayed_Fields.size() == 0) {
        for (Field = Current_Table_Fields.begin();Field!=Current_Table_Fields.end();++Field) {
            Current_Displayed_Fields.push_back(CColumnDescriptor(*Field));
        }
    }
    build_relevant_keys();

    if (search_it) {
        size_t pos;
        static const char * ops[]={"LIKE","NOT LIKE","=","!=","<",">","<=",">=","!","<=>",0};
        for (Field = Current_Table_Fields.begin();Field != Current_Table_Fields.end();++Field) {
            if (Field->is_Blob()) {
                continue;
            }
            pattern_list.push_back(e_patternpair(Field->get_name(),""));
            pos = pattern_list.size()-1;
            pattern_list[pos].setIsNumeric(Field->is_Numeric());
            pattern_list[pos].setLargeText(Field->is_Text());
            pattern_list[pos].setBlob(Field->is_Blob());
            stringIlist _temp_enums = Field->enum_list();
            if (_temp_enums.size() > 0) {
                // we requires the empy one, too
                _temp_enums.insert(_temp_enums.begin(),"");
                pattern_list[pos].set_enumlist(_temp_enums);
            }
        }
        edit.setCaption(GET_TEXT(78));
        edit.build_widgets(&pattern_list,ops,"Search for empty value");
        if (edit.exec()) {
            result = edit.get_entries();
        } else {
            return;
        }
    }
    OutputList->clear();
    while(OutputList->header()->count()>0) {
        OutputList->removeColumn(0);
    }

    i = 0;

    for (Field = Current_Displayed_Fields.begin();Field!=Current_Displayed_Fields.end();++Field) {
        OutputList->addColumn(STL_TO_QT_STRING(Field->get_name()));
        ++i;
    }
    stringlist SizePattern;
    i = sql_server->fetch_rows(QT_TO_STL_STRING(db),QT_TO_STL_STRING(table),
                               QT_TO_STL_STRING(sort),(desc_box->isChecked()?true:false),which,erg,
                               (unsigned)OffsetEdit->value(),
                               (unsigned)LimitEdit->value(),result);

    if (result) {
        delete result;
        result = 0;
    }
    timeval starttime,endtime;
    KApplication::kApplication()->processEvents(100);
    list_vector::iterator erg_iter = erg.begin();
    gettimeofday(&starttime,0);
    // for a higher speed two seperate loops
    int running = 0;
    CBinListViewItem*item = 0;
    stringlist::iterator siter;
    unsigned int max_count = OutputList->columns();
    unsigned int count;
    QImage test_image;
    if (erg.size() > 4999) {
        OutputList->setUpdatesEnabled(false);
        CProgressDlg prg(0,erg.size(),"Inserting data into table view",0,"ProgressDlg");
        prg.show();
        for (;erg_iter != erg.end();++erg_iter) {
            siter = erg_iter->begin();
            item = new CBinListViewItem(OutputList,item);
            item->setMultiLinesEnabled(m_DisplayMultiline);
            prg.setPos(++running);
            count = 0;
            for (;siter!=erg_iter->end();++siter) {
                if (Current_Displayed_Fields[count].is_Blob()) {
                    item->setBinContent(count,(*siter));
                    if (m_BlobAsImage &&
                        binToImage(*siter,test_image)) {
                        item->setPixmap(count,QPixmap(test_image));
                    } else {
                        item->setPixmap(count,blob_image);
                    }
                } else {
                    item->setText(count,STL_TO_QT_STRING(*siter));
                }
                if (++count == max_count)
                    break;
            }
        }
        prg.hide();
        OutputList->setUpdatesEnabled(true);
        repaint();
        update();
        KApplication::kApplication()->processEvents(100);

    } else {
        for (;erg_iter != erg.end();++erg_iter) {
            siter = erg_iter->begin();
            item = new CBinListViewItem(OutputList,item);
            item->setMultiLinesEnabled(m_DisplayMultiline);
            count = 0;
            for (;siter!=erg_iter->end();++siter) {
                if (Current_Displayed_Fields[count].is_Blob()) {
                    item->setBinContent(count,(*siter));
                    if (m_BlobAsImage &&
                         binToImage(*siter,test_image)) {
                        item->setPixmap(count,QPixmap(test_image));
                    } else {
                        //item->setText(count,"[BLOB]");
                        item->setPixmap(count,blob_image);
                    }
                } else {
                    item->setText(count,STL_TO_QT_STRING(*siter));
                }
                if (++count == max_count)
                    break;
            }
        }
    }
    gettimeofday(&endtime,0);
    long int sec,usec;
    sec = endtime.tv_sec - starttime.tv_sec;
    usec = endtime.tv_usec - starttime.tv_usec;
    usec += 1000*1000*sec;
    printf("Inserttime: %li,%06li sec \n",usec/(1000*1000),usec%(1000*1000));

    //hope you'll never see it
    if (i < 0) {
        display_error_box();
    }
    OutputList->setSelected(OutputList->firstChild(),true);
    OutputList->setFocus();
    m_queryTabs->setCurrentPage(2);
}

bool ServerView::close( bool forceKill)
{
    KConfig * k = KGlobal::config();
    if (k) {
        k->setGroup("table_view");
        int w,h;
        w = width();
        h = height();
        QString s;
        s.setNum(w);
        k->writeEntry("width",s);
        s.setNum(h);
        k->writeEntry("height",s);
    }
    return ServerViewData::close(forceKill);
}

void ServerView::FixFontChanged()
{
    QFont font = GlobalSettings.get_fixed_font();
    OutputList->setFont( font );
    m_InfoBrowser->setFont(font);
    m_tableInfoBrowser->setFont(font);
}

void ServerView::OutputSelected(QListViewItem*)
{
    if (ModifyRow->isEnabled())
        modifyRow();
}

void ServerView::column_sel_change()
{
}

void ServerView::sort_select(int)
{
}

void ServerView::desc_box_toggled(bool)
{
}

void ServerView::showHelp()
{
    KApplication::kApplication()->invokeHelp("kmysqladmin-browsing_tables");
}

void ServerView::hide_it()
{
    hide();
}

void ServerView::handleSettings()
{
    GlobalSettings.getBlobimages(m_BlobAsImage,m_ScaleBlob,m_blob_width,m_blob_height);

    bool old = m_first_init?m_first_init:m_DisplayMultiline;
    m_DisplayMultiline = GlobalSettings.getRealmultilines();
    if ( (!m_first_init && old == m_DisplayMultiline )|| OutputList->childCount()<1) return;
    QListViewItem * item = OutputList->firstChild();
    while (item) {
        item->setMultiLinesEnabled(m_DisplayMultiline);
        item = item->nextSibling();
    }
}

bool ServerView::binToImage(const std::string&aData,QImage&target,bool ignoreScale)
{
    if (!target.loadFromData((const unsigned char*)aData.data(),aData.size())) {
        return false;
    }

    if (!ignoreScale && m_ScaleBlob &&
        (target.height()>m_blob_height ||
         target.width()>m_blob_width) ) {
        target = target.scale(m_blob_width,m_blob_height,QImage::ScaleMin);
    }
    return true;
}

void ServerView::standalone(bool how)
{
    if (how) {
        CloseButton->show();
    } else {
        CloseButton->hide();
    }
}
