//-*-Mode: C++;-*-
/***************************************************************************
                          altertable.h  -  description                              
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Rajko Albrecht                         
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef ALTERTABLE_H
#define ALTERTABLE_H

#include <qwidget.h>
#include "kmysqladmin/frontend/mtable/modifytable.h"
#include "kmysqladmin/backend/my_sql/change_type.h"

class CMySql;

//! class modifying tables
/*!
 * Class which will generate an
 *  "Alter Table" statement.
 * \author Rajko Albrecht
 */
class CAlterTable : public CModifyTable  {
    Q_OBJECT
public: 
    CAlterTable(smart_pointer<CMySql>& _sql_server,QWidget *parent=0, const char *name=0);
    ~CAlterTable();

protected:
    QComboBox* TableNameEdit;
    KeyList CurrentKeys;
    ColumnList CurrentColumns;
    change_list DescrChanges;
    change_list KeyChanges;
    
    virtual void build_strings();

protected slots:
    virtual void SetDBString(const QString&);
    virtual void SetTableString(int);
    virtual void NameChanged(const QString&);
    virtual void TableTextChanged(const QString&);
    virtual void Modify_Column();
    virtual void AddColumn();
    virtual void Delete_Column();
    virtual void AlterTable();

private:
#ifndef NO_DEBUG
    //! only used for debugging purpose
    void debug_change();
#endif
};

#endif
