#include <qstring.h>
#include <qptrlist.h>

#ifndef WIN32
#include <kapp.h>
#endif

#include <qmessagebox.h>
#include <qcheckbox.h>                                                          
#include <qcombobox.h>                                                          
#include <qframe.h>                                                             
#include <qlabel.h>                                                             
#include <qlcdnumber.h>                                                         
#include <qlineedit.h>                                                          
#include <qlistbox.h>                                                           
#include <qpushbutton.h>                                                        
#include <qradiobutton.h>                                                       
#include <qslider.h>                                                            
#include <qlayout.h>                                                            
#include <qvariant.h>                                                           
#include <qtooltip.h>                                                           
#include <qwhatsthis.h>    
#include <algorithm>

#include "createtable.h"
#include "kmysqladmin/tabledescr.h"
#include "kmysqladmin/globals.h"
#include "kmysqladmin/stringres.h"
#include "kmysqladmin/backend/my_sql/my_sql.h"
#include "kmysqladmin/helpers/qt_stl_string.h"

#define Inherited CModifyTable

CCreateTable::CCreateTable(smart_pointer<CMySql>& _sql_server, QWidget* parent, const char* name )
    :Inherited( _sql_server,parent, name )
{
    QString Caption = CStringRes::get_string(125);
    Caption+= " - ";
    Caption+=CStringRes::get_string(126);
    setCaption(Caption);
    TableNameEdit = new QLineEdit(TopMost,"TableNameEdit");
    TableNameEdit->setGeometry( 280, 5, 210, 25 );
    TableNameEdit->setMinimumSize( 0, 0 );
    TableNameEdit->setMaximumSize( 32767, 32767 );
    TableNameEdit->setText( "" );
    TableNameEdit->setMaxLength( 32767 );
    TableNameEdit->setFrame( TRUE );
    TableNameEdit->setFocus();
    connect(TableNameEdit,SIGNAL(textChanged(const QString&)),SLOT(TableTextChanged(const QString&)));
    connect( CreateTableButton, SIGNAL(clicked()), SLOT(CreateTable()) );
    TopMostLayout->addWidget(TableNameEdit);
}


CCreateTable::~CCreateTable()
{

}

void CCreateTable::TableTextChanged(const QString&text)
{
    bool how =  (text.length()>0 &&
                 (CurrentTables.find(text.latin1()) == CurrentTables.end()) );
    if (sql_server->is_system_db(DBList->currentText().latin1())) {
        how = false;
    }
    ColumnNameEdit->setEnabled(how);
    AddButton->setEnabled( how && ColumnNameEdit->text().latin1() );
}

void CCreateTable::TableTextActivate()
{
}

void CCreateTable::SetDBString(const QString&)
{
    CurrentTables.resize(0);
    if (!sql_server->get_table_list("%",QT_TO_STL_STRING(DBList->currentText()),CurrentTables)) {
        return;
    }
    TableTextChanged(TableNameEdit->text());
}

void CCreateTable::AddColumn()
{
    CKeyDescriptor Key;
    QString text;

    CColumnDescriptor Desc;
    Desc.set_name(ColumnNameEdit->text().latin1());
    if (std::find(desc_list.begin(),desc_list.end(),Desc)!=desc_list.end()) {
        QMessageBox::critical(this,CStringRes::get_string(6),
                              CStringRes::get_string(7));
        return;
    }
    if (Primary_Key->isEnabled() && Primary_Key->isChecked()) {
        Key.set_name("PRIMARY");
        if (std::find(key_list.begin(),key_list.end(),Key)!=key_list.end()) {
            QMessageBox::critical(this,CStringRes::get_string(6),
                                  CStringRes::get_string(8));
            return;
        }
    }
    if (!ReadDescriptor(&Desc,&text,&Key))
        return;

    ColumnsList->clearSelection();
    ColumnsList->insertItem(text,-1);
    DeleteButton->setEnabled(FALSE);
    ModifyButton->setEnabled(FALSE);
    desc_list.push_back(Desc);
    CreateTableButton->setEnabled(TRUE);
    if (desc_list.size() > 1) {
        CompoundKeyButton->setEnabled(TRUE);
    }
    if (!Key_None->isChecked()) {
        key_list.push_back(Key);
    }
}

void CCreateTable::Delete_Column()
{
    int Index = ColumnsList->currentItem();
    int counter = 0;
    if (Index == -1) {
        debug("index -1");
        return;
    }
    CColumnDescriptor desc;
    desc = desc_list[Index];
    RemoveFromKey(desc.get_name());
    ColumnsList->removeItem(Index);
    counter = 0;
    for (ColumnList_iterator col_iter = desc_list.begin();col_iter != desc_list.end();++col_iter) {
        if (counter == Index) {
            desc_list.erase(col_iter);
            break;
        }
        ++counter;
    }
    if (desc_list.size() < 2) {
        CompoundKeyButton->setEnabled(FALSE);
    }
    if (ColumnsList->count() == 0) {
        CreateTableButton->setEnabled(FALSE);
    }
    if (ColumnsList->currentItem() == -1 || ColumnsList->count() == 0) {
        DeleteButton->setEnabled(FALSE);
        ModifyButton->setEnabled(FALSE);
    }
}

void CCreateTable::CreateTable()
{
    if (sql_server->create_table(
                                 QT_TO_STL_STRING(DBList->currentText()),
                                 QT_TO_STL_STRING(TableNameEdit->text())
                                 ,&desc_list,&key_list) == false) {
        QMessageBox::critical(this,CStringRes::get_string(121),
                              CStringRes::get_string(10));
        return;
    }
    close();
}
