#ifndef SQLSYNTAX_H
#define SQLSYNTAX_H

#include <qglobal.h>

#if QT_VERSION < 0x030100
#define NO_SQL_HIGHLIGHT

class sqlsyntax
{
public:
    sqlsyntax(){};
    virtual ~sqlsyntax(){}
};

#else
#include <qsyntaxhighlighter.h>
#include <qregexp.h>
#include <qfont.h>

#include <vector>
#include <utility>
#include <string>

class QTextEdit;
class QString;
class QColor;

/**
  *@author Rajko Albrecht
  */

class sqlsyntax : public QSyntaxHighlighter
{
    typedef std::pair<int,int> RangePair;
    typedef std::vector<RangePair> RangeVector;

public:
    sqlsyntax(QTextEdit*);
    virtual ~sqlsyntax();

    virtual int highlightParagraph ( const QString & text, int endStateOfLastPara );

    virtual void setDefaultFont(const QFont&);
    virtual void setStatementColor(const QColor&aColor){statementColor=aColor;}
    virtual const QColor&StatementColor()const{return statementColor;}
    virtual void setStringColor(const QColor&aColor){stringColor=aColor;}
    virtual const QColor&StringColor()const{return stringColor;}
    virtual void setDatatypesColor(const QColor&aColor){datatypesColor=aColor;}
    virtual const QColor&DatatypesColor()const{return datatypesColor;}
    virtual void setCommentColor(const QColor&aColor){commentColor=aColor;}
    virtual const QColor&CommentColor()const{return commentColor;}
    virtual void setKeyColor(const QColor&aColor){keyColor=aColor;}
    virtual const QColor&KeytColor()const{return keyColor;}
    virtual void real_parse(bool how){m_RealParse=how;}

    virtual void statementItalic(bool how){statementFont.setItalic(how);}
    virtual void statementBold(bool how){statementFont.setBold(how);}
    virtual void keywordItalic(bool how){keywordFont.setItalic(how);}
    virtual void keywordBold(bool how){keywordFont.setBold(how);}
    virtual void datatypeItalic(bool how){datatypeFont.setItalic(how);}
    virtual void datatypeBold(bool how){datatypeFont.setBold(how);}
    virtual void stringItalic(bool how){stringFont.setItalic(how);}
    virtual void stringBold(bool how){stringFont.setBold(how);}
    virtual void commentItalic(bool how){commentFont.setItalic(how);}
    virtual void commentBold(bool how){commentFont.setBold(how);}

    static const std::string STATEMENT,
                             KEYWORD,
                             DATATYPE,
                             STRING,
                             COMMENT;

protected:
    QColor statementColor;
    QColor keyColor;
    QColor commentColor;
    QColor datatypesColor;
    QColor stringColor;

    static const QRegExp keyWords;
    static const QRegExp otherWords;
    static const QRegExp singleComment;
    static const QRegExp datatypeWords;

    QFont regularFont;
    QFont statementFont,keywordFont,datatypeFont,stringFont,commentFont;

    bool m_RealParse;

    bool pos_in_string(const RangeVector&aVector,int aPos);

};
#endif
#endif
