// -*-Mode: C++;-*-

#ifndef CTextView_included
#define CTextView_included

#include "kmysqladmin/frontend/status/TextViewData.h"
#include <qtimer.h>
#include "kmysqladmin/helpers/smart_pointer.h"

class CMySql;

class CStatusView : public CTextViewData
{
    Q_OBJECT

public:
    CStatusView(smart_pointer<CMySql>& _sql_server,QWidget* parent = NULL,const char* name = NULL);
    virtual ~CStatusView();
    void standalone(bool how);

protected:
    smart_pointer<CMySql> sql_server;
    QTimer*timer;
    int m_Timeout;
    void get_status();
    QString up_time(const std::string&aTime)const;

protected slots:
    virtual void RefreshOutput();
    virtual void newTimeout(int aValue);
    virtual void clear(){};
    virtual void newFont();

public slots:
    void hide_me();
    void show();
};
#endif // CTextView_included
