// -*- Mode: C++; -*-


#ifndef _settings_h
#define _settings_h
#include <string>

#include "settingsignals.h"

namespace KWallet {
  class Wallet;
}

class QFont;
class QColor;

class CSettings:public Settingsignals
{
protected:
    bool init_files();

    static KWallet::Wallet*openWallet(const std::string&aDir);

public:
    CSettings();
    ~CSettings();
    void SaveLastLogin(const std::string user,const std::string host,
                       const std::string port,const std::string pass);
    bool RetrieveLastLogin(std::string&user,std::string&host,
                           std::string&port,std::string&pass);
    void set_fixed_font( const QFont&fnt);
    void set_nprop_font( const QFont&fnt);

    QFont get_fixed_font();
    QFont get_nonprop_font();

    int ThreadPolltime()const;
    void ThreadPolltime(int aTimeout);

    int StatusPolltime()const;
    void StatusPolltime(int aTimeout);

    bool ScriptOutputAsRich()const;
    void ScriptOutputAsRich(bool);
    bool SyntaxHighlight()const;
    void SyntaxHighlight(bool);

    QColor getScriptColor(const std::string&which,const QColor&aDefaultColor);
    void   setScriptColor(const std::string&which,const QColor&aColor);
    bool   getScriptbold(const std::string&which,bool def);
    void   setScriptbold(const std::string&which,bool how);
    bool   getScriptit(const std::string&which,bool def);
    void   setScriptit(const std::string&which,bool how);

    void getBlobimages(bool&aDisplayimages, bool&aScaleimages, int&aMaxwidth, int&aMaxheight);
    void setBlobimages(bool aDisplayimages, bool aScaleimages, int aMaxwidth, int aMaxheight);

    QMap<QString,QString> getConnectProfile(const QString&aProfile);
    QStringList getConnectProfilesList();
    void addConnectProfile(const QString&aName,const QString&aHost,const QString&aUser,const QString&aPort,const QString&aPass);
    void addConnectProfile(const QMap<QString,QString>&aConnection);
    void deleteConnectProfile(const QString&aName);

    void setRealmultiLines(bool);
    bool getRealmultilines()const;

    void setCompactLayout(bool);
    bool getCompactLayout()const;

    void setOldBrowser(bool how);
    bool getOldBrowser()const;
};

extern CSettings GlobalSettings;
#endif
