#include <qmenudata.h>
#include <kpopupmenu.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qlayout.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qtextview.h>
#include <qregexp.h>
#include <qkeycode.h>

#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kapp.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kcolordialog.h>
#include <kaction.h>
#include <kurl.h>

#include <fstream>
#include <iostream>
#include <string>
#include <sstream>
#ifndef WIN32
#include <sys/time.h>
#include <unistd.h>
#endif

#include "sqlscript.h"
#include "kmysqladmin/backend/my_sql/my_sql.h"
#include "kmysqladmin/helpers/stringlist.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include "kmysqladmin/stringres.h"
#include "kmysqladmin/frontend/scripteditor/scriptsplit.h"
#include "kmysqladmin/TextInput.h"
#include "kmysqladmin/frontend/scripteditor/sqlsyntax.h"
#include "kmysqladmin/setup/settings.h"
#include "kmysqladmin/setup/setupscriptcolor.h"
#include "kmysqladmin/frontend/mysqlhelp/mysqlhelp.h"

#define Inherited CSqlScriptData

using namespace std;

CSqlScript::CSqlScript(smart_pointer<CMySql>& _sql_server,QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    SQLSyntax = 0;
    mActionCollection = new KActionCollection( this );
    ResultText = "";
    ScriptText = "";
    ErrorText = "";
    search_text = "";
    m_FileName = "";
    modified = false;
    status_Timer = NULL;
    KConfig * k = KGlobal::config();
    
    if (_sql_server) {
        sql_server = new CMySql(*_sql_server);
    } else {
        sql_server = 0;
    }
    if (sql_server) {
        sql_server->set_message_call_back(this);
    }
    
    /* setting up the menubar */
    MenuBar = new KMenuBar(this);
    CHECK_PTR(MenuBar);
    KPopupMenu*file = new KPopupMenu;
    CHECK_PTR(file);
    
    KAction * t_action;
    t_action = KStdAction::openNew(this,SLOT(new_script()),actionCollection());
    t_action->setText(GET_TEXT(135));
    t_action->plug(file);
    t_action = KStdAction::open(this,SLOT(load_script()),actionCollection());
    t_action->setText(GET_TEXT(134));
    t_action->plug(file);
    t_action = KStdAction::save(this,SLOT(save_script()),actionCollection());
    t_action->setText(GET_TEXT(133));
    t_action->plug(file);
    t_action = KStdAction::saveAs(this,SLOT(save_script_as()),actionCollection());
    t_action->setText(GET_TEXT(152));
    t_action->plug(file);

    file->insertSeparator();

    m_recentFiles = KStdAction::openRecent(this,SLOT(slotOpen(const KURL & )),actionCollection(),"recent_files");
    m_recentFiles->loadEntries(k,"recent_scripts");
    m_recentFiles->setMaxItems(5);
    m_recentFiles->plug(file);

    file->insertSeparator();
    file->insertItem(GET_TEXT(140),this,SLOT(saveResult()));
    file->insertSeparator();

    t_action = KStdAction::close(this,SLOT(close_You()),actionCollection());
    t_action->setText(GET_TEXT(113));
    t_action->plug(file);
    MenuBar->insertItem(GET_TEXT(109),file);
    
    file = new KPopupMenu;
    t_action = KStdAction::find(this,SLOT(searchText()),actionCollection());
    t_action->plug(file);
    t_action = KStdAction::findNext(this,SLOT(searchAgain()),actionCollection());
    t_action->plug(file);
    QString text = "&";
    text+=GET_TEXT(142);
    MenuBar->insertItem(text,file);

    settings_menu = new KPopupMenu;  
    switchRichtext = new KToggleAction(GET_TEXT(159),KShortcut(),this,SLOT(toggle_show_rich()),actionCollection(),"switch_rich");
    switchRichtext->plug(settings_menu);

#ifndef NO_SQL_HIGHLIGHT
    switchHighlight = new KToggleAction(GET_TEXT(162),KShortcut(),this,SLOT(toggle_use_highlight()),actionCollection(),"switch_rich");
    switchHighlight->plug(settings_menu);
    settings_menu->insertSeparator();
    settings_menu->insertItem(i18n("Setup script colors and style"),this,SLOT(setup_colors()));
#endif

    text = "&";
    text+= GET_TEXT(158);
    MenuBar->insertItem(text,settings_menu);
    MainLayout->setMenuBar(MenuBar);
    /* menubar end */

    rich_text_set=GlobalSettings.ScriptOutputAsRich();
    switchRichtext->setChecked(rich_text_set);

#ifndef NO_SQL_HIGHLIGHT
    use_highlight = GlobalSettings.SyntaxHighlight();
    switchHighlight->setChecked(use_highlight);
#endif

    resultEdit->setReadOnly(true);
    if (rich_text_set) {
        resultEdit->setTextFormat(Qt::RichText);
    } else {
        resultEdit->setTextFormat(Qt::PlainText);
    }
    errorEdit->setReadOnly(true);
    errorEdit->setTextFormat(Qt::PlainText);

    scriptEdit->setTextFormat(Qt::PlainText);

    setupSyntaxObject();
    StatusText->setText(GET_TEXT(136));
    connect(&GlobalSettings,SIGNAL(fixfont_changed()),this,SLOT(FixFontChanged()));
    connect(resultEdit,SIGNAL(cursormove()),SLOT(set_cursor_info()));
    connect(errorEdit,SIGNAL(cursormove()),SLOT(set_cursor_info()));
    connect(scriptEdit,SIGNAL(cursormove()),SLOT(set_cursor_info()));
    if (sql_server->master_version()>3) {
        /* use the master handle */
        QWidget*twidget = new CMysqlhelp(_sql_server,TabBar,"Mysql help");
        TabBar->insertTab( twidget, QString("Mysql help") );
    }
    FixFontChanged();
    TabSelected(0);
}

CSqlScript::~CSqlScript()
{
    save_state();
    sql_server = 0;
    if (SQLSyntax) delete SQLSyntax;
    SQLSyntax = 0;
#if 0
    mActionCollection->clear();
    delete mActionCollection;
#endif
}

bool CSqlScript::close (bool alsoDelete)
{
    return Inherited::close(alsoDelete);
}

void CSqlScript::close_You()
{
    hide();
}

void CSqlScript::hide ()
{
    save_state();
    Inherited::hide();
}

void CSqlScript::TabSelected(int i)
{
    last_tab = i;
    switch (i) {
        case 0:
            SubmitButton->setEnabled(true);
        break;
        case 1:
            SubmitButton->setEnabled(false);
        break;
        case 2:
        default:
            SubmitButton->setEnabled(false);
        break;
    }
    set_cursor_info();
}

void CSqlScript::submit()
{
    if (!sql_server || !sql_server->success_connect()) {
        return;
    }
    ScriptText=scriptEdit->text().latin1();
    ResultText = "";
    ErrorText = "";
    TabBar->setCurrentPage(1);
    stringlist target,headers;
    stringlist commands;
    list_vector target2;

    std::string _temp_result = "";
    StatusText->setText(GET_TEXT(139));
    KApplication::kApplication()->processEvents(100);

    split_commands(commands);
    if (commands.size() > 200) {
        resultEdit->setUpdatesEnabled(false);
    }
    bool had_errors = false;
    if (rich_text_set) {
        ResultText = "<qt>\n";
    }
    resultEdit->setText("");
    for (unsigned int i = 0; i < commands.size();++i) {
        target.resize(0);
        headers.resize(0);
        int update_counter = 0;
        KApplication::kApplication()->processEvents(100);
        if (!rich_text_set) {
            if (!sql_server->do_statement(commands[i],target,headers,true)) {
                had_errors = true;
                break;
            }
        } else {
            if (!sql_server->do_statement(commands[i],target2,headers,true)) {
                had_errors = true;
                break;
            }
        }
        if (rich_text_set) {
#ifndef WIN32    
            timeval starttime,endtime;
            gettimeofday(&starttime,0);
#endif
            _temp_result = displayRichResult(commands[i],target2,headers);
#ifndef WIN32
            gettimeofday(&endtime,0);
            long int sec,usec;
            sec = endtime.tv_sec - starttime.tv_sec;
            usec = endtime.tv_usec - starttime.tv_usec;
            usec += 1000*1000*sec;
            cout << "Textgenerate time: "<< (usec/(1000*1000)) << "," << usec%(1000*1000) << " sec " << endl;
#endif
        } else {
            if (target.size()==0) {
                _temp_result+="\n";
            }
            std::string _temp="";
            unsigned underline = 0;
            if (headers.size() > 0) {
                _temp+="| ";
                for (unsigned int j = 0;j < headers.size();++j) {
                    _temp+=headers[j];
                    if (j < headers.size()-1)
                        _temp+=" | ";
                }
                _temp+=" |"; underline = _temp.size();_temp+="\n";_temp_result += _temp;_temp="";
                _temp.resize(underline,'-');_temp+="\n";_temp_result+=_temp;_temp_result.insert(0,_temp);
                commands[i]+=":\n";_temp_result.insert(0,commands[i]);
            }
            if (target.size()>0) {
                std::string t;
                for (unsigned int j = 0;j < target.size();++j) {
                    t = "| ";t+=target[j];
                    size_t pos = t.find("\t");
                    while (pos !=std::string::npos) {
                        t.insert(pos,1,' ');
                        ++pos;
                        t.replace(pos,1,"|");
                        t.insert(pos+1,1,' ');
                        pos = t.find("\t");
                    }
                    _temp_result+=t;_temp_result+=" |\n";_temp_result+=_temp;
                }
            }
        }
        resultEdit->append(_temp_result.c_str());
        if (++update_counter == 500) {
            update_counter = 0;
            resultEdit->repaint();
            KApplication::kApplication()->processEvents(10);
        }
        ResultText+=_temp_result;
        _temp_result="";
    }
    if (rich_text_set) {
        ResultText+="\n</qt>\n";
        resultEdit->append("\n</qt>\n");
    }
    if (commands.size() > 200) {
        resultEdit->setUpdatesEnabled(true);
        resultEdit->repaint();
    }
    errorEdit->setText(STL_TO_QT_STRING(ErrorText));
    if (had_errors) {
        setStatusText(GET_TEXT(137),5000);
        TabBar->setCurrentPage(2);
    } else {
        setStatusText(GET_TEXT(138),3000);
    }
    ScriptText.resize(0);
}

void CSqlScript::split_commands(stringlist&target)
{
    target.resize(0);
    CScriptSplit splitter(&target,ScriptText);
    splitter.convert();
}

void CSqlScript::save_string(const std::string&contents,int format)
{
    QString file_name;
    QString pre;

    switch (format) {
    case 1:
        pre = "*.txt";
        break;
    case 2:
        pre = "*.html";
        break;
    case 0:
    default:
        pre = "*.sql *.txt";
        break;
    }
    file_name = KFileDialog::getSaveFileName(0,pre);
    QString message;
    QFileInfo finfo;
    int i;

    if (file_name.isEmpty())
        return;
    finfo.setFile(file_name);
    if (finfo.extension().isEmpty()) {
        switch (format) {
        case 1:
            file_name+=".txt";
            break;
        case 2:
            file_name+=".html";
            break;
        default:
            file_name+=".sql";
            break;
        }
        finfo.setFile(file_name);
    }
    if (finfo.isDir()) {
        KMessageBox::error(this,GET_TEXT(84),GET_TEXT(83));
        return;
    }

    if (QFile::exists(file_name)) {
        message = CStringRes::get_string(85);
        message+="\n\n";
        message+=file_name;message+="\n\n";
        message+=GET_TEXT(86);
        message+="\n";
        i = KMessageBox::questionYesNo( this,message, GET_TEXT(87));
        if (i != KMessageBox::Yes )
            return;
        if (!finfo.isWritable()) {
            KMessageBox::error(this,GET_TEXT(83),GET_TEXT(88));
            return;
        }
    }
    m_FileName = file_name.latin1();
    QFile outfile(file_name);
    outfile.open(IO_WriteOnly|IO_Truncate);
    if (!outfile.isOpen()) 
        return;
        
    if (format == 0) {
        m_recentFiles->addURL(KURL(file_name));
        m_recentFiles->setCurrentItem(0);
        save_state();
    }
    
    QTextStream st(&outfile);
    st << contents.c_str();
    outfile.close();
}

void CSqlScript::load_script()
{
    QString file_name = KFileDialog::getOpenFileName(0,"*.sql *.txt");
    if (file_name.length()==0) return;
    if (load_script(file_name)) {
        m_recentFiles->addURL(KURL(file_name));
        save_state();
    } else {
        new_script();
    }
}

bool CSqlScript::load_script(const QString&file_name)
{
    QFile ifs(file_name);
    if (!ifs.open(IO_ReadOnly) ) {
        KMessageBox::error(this,GET_TEXT(83),GET_TEXT(83));
        return false;
    }
    ScriptText = "";
    m_FileName = file_name.latin1();
    QTextStream t(&ifs);
    while (!t.eof()) {
        ScriptText+=t.readLine().latin1();ScriptText+="\n";
    }
    ifs.close();
    TabBar->setCurrentPage(0);
    scriptEdit->setText(ScriptText.c_str());
    return true;
}

void CSqlScript::new_script()
{
    ScriptText = "";
    ResultText = "";
    ErrorText = "";
    m_FileName = "";
    TabBar->setCurrentPage(0);
    scriptEdit->setText(ScriptText.c_str());
    m_recentFiles->setCurrentItem(-1);
}

void CSqlScript::append_message(const std::string&message)
{
    ErrorText+="\n";
    ErrorText+=message;
}

void CSqlScript::setStatusText(const char*text,unsigned int timeout)
{
    unsigned int iTimer = timeout;
    if (iTimer == 0)
        iTimer = 2000;
    if (!status_Timer) {
        status_Timer = new QTimer(this);
        connect( status_Timer, SIGNAL(timeout()), SLOT(statusTimeout()) );
    }
    if (text && strlen(text)>0)
        StatusText->setText(text);
    status_Timer->start(iTimer,TRUE);
}

void CSqlScript::statusTimeout()
{
    StatusText->setText(GET_TEXT(136));
}

void CSqlScript::saveResult()
{
    TabBar->setCurrentPage(1);
    int form = 1;
    if (rich_text_set) {
        ResultText=resultEdit->text().latin1();
        form = 2;
    }
    save_string(ResultText,form);
}

void CSqlScript::searchText()
{
    CTextInput textdlg(this);
    QString title = GET_TEXT(125);
    title+=GET_TEXT(143);
    textdlg.setCaption(title);
    textdlg.set_label_text(GET_TEXT(144));
    if (textdlg.exec()) {
        title = textdlg.get_text();
        if (title.isEmpty()) {
            return;
        }
        search_text = title.latin1();
        search_forward();
    }
}

void CSqlScript::searchAgain()
{
    if (search_text.size() == 0)
        return;
    search_forward();
}

void CSqlScript::search_forward()
{
    int i;
    CEdit * curEdit = currentWindow();
    if (!curEdit)
        return;
    if (rich_text_set && curEdit == resultEdit) {
        if (curEdit->find(search_text.c_str(),false,false)==TRUE){
        } else {
        }
        return;
    }
    if (curEdit->lines() <=1)
        return;

    int current_line, current_pos;

    QRegExp reg(search_text.c_str(),FALSE);

    curEdit->getCursorPosition(&current_line,&current_pos);
    int pos,length;
    pos = 0;
    int lines = curEdit->lines();
    string _search;
    for (i = current_line; i < lines; ++i) {
        _search = curEdit->text(i).latin1();
        pos = reg.match(_search.c_str(),current_pos,&length);
        current_pos = 0;
        if (pos > -1)
            break;
    }
    if (pos != -1) {
        curEdit->setSelection(i,pos,i,pos+search_text.size());
    }
    set_cursor_info();
}

void CSqlScript::keyPressEvent(QKeyEvent*e)
{
    CSqlScriptData::keyPressEvent(e);
    set_cursor_info();
}

void CSqlScript::set_cursor_info()
{
    int line,col;
    CEdit * curEdit = currentWindow();
    if (!curEdit)
        return;
    curEdit->getCursorPosition(&line,&col);
    QString text;
    text.sprintf("Line: %i Col: %i",line,col);
    CursorPosText->setText(text);
}

CEdit*CSqlScript::currentWindow()
{
    int i = TabBar->currentPageIndex();
    switch (i) {
        case 0:
            return scriptEdit;
        break;
        case 1:
            return resultEdit;
        break;
        case 2:
            return errorEdit;
        break;
        default:
            return 0;
    }
    return 0;
}

void CSqlScript::FixFontChanged()
{
    QFont font = GlobalSettings.get_fixed_font();
#ifndef NO_SQL_HIGHLIGHT
    if (SQLSyntax) SQLSyntax->setDefaultFont(font);
#endif
    resultEdit->setFont(font);
    errorEdit->setFont(font);
    scriptEdit->setFont(font);
}

void CSqlScript::save_script()
{
    if (m_FileName.size() < 1) {
        return save_script_as();
    }
    ScriptText = scriptEdit->text().latin1();
    ofstream outfile(m_FileName.c_str());
    if (!outfile) {
        KMessageBox::error(this,GET_TEXT(83),GET_TEXT(88));
        return;
    }
    outfile<<ScriptText.c_str();
    outfile.close();
    ScriptText.resize(0);
}

void CSqlScript::save_script_as()
{
    ScriptText = scriptEdit->text().latin1();
    save_string(ScriptText,0);
    return;
}

std::string CSqlScript::displayRichResult(const std::string&command, 
                                          const list_vector&target,
                                          const stringlist&headers)
{
    stringstream temp_result("");
    string t;
    unsigned int c,d;
    size_t pos;

    temp_result << "<font color=red>"<<command<<":</font><br>\n";
    if (target.size()==0) {
        temp_result << "Statement had an empty result set.\n";
        return temp_result.str();
    }
    temp_result<<"<table border=\"1\"><tr>";
    for (c=0; c < headers.size();++c) {
        temp_result<<"<th>"<<headers[c]<<"</th>";
    }
    temp_result<<"</tr>";
    for (c=0; c < target.size();++c) {
        temp_result<<"<tr>";
        for (d = 0; d<target[c].size();++d) {
            t = target[c][d];
            pos = 0;
            while (  (pos=t.find("\n",pos))!=string::npos) {
                t.replace(pos,1,"<br>\n");
                pos = t.find("\n",pos)+1;
            }
            temp_result<<"<td>"<<t<<"</td>\n";
        }
        temp_result<<"</td></tr>\n";
    }
    temp_result<<"</table>\n";
    return temp_result.str();
}

void CSqlScript::toggle_show_rich()
{
    qDebug("toggle show rich");
    rich_text_set = !rich_text_set;
    GlobalSettings.ScriptOutputAsRich(rich_text_set);
#if 0
    settings_menu->setItemChecked(rich_text_id,rich_text_set);
#endif
    if (rich_text_set) {
        resultEdit->setTextFormat(Qt::RichText);
    } else {
        resultEdit->setTextFormat(Qt::PlainText);
    }
}

void CSqlScript::toggle_use_highlight()
{
#ifndef NO_SQL_HIGHLIGHT
    use_highlight=switchHighlight->isChecked();
    GlobalSettings.SyntaxHighlight(use_highlight);
    if (!SQLSyntax) {
        setupSyntaxObject();
    } else {
        SQLSyntax->real_parse(use_highlight);
    }
    if (SQLSyntax) {
        SQLSyntax->rehighlight();
        if (!use_highlight) {
            delete SQLSyntax;
            SQLSyntax = 0;
        }
    }
#endif
}

void CSqlScript::setup_colors()
{
#ifndef NO_SQL_HIGHLIGHT
    SetupScriptcolor dlg;
    if (dlg.exec()) {
        setupSyntaxObject();
    }
#else
#endif
}

void CSqlScript::setupSyntaxObject()
{
#ifndef NO_SQL_HIGHLIGHT
    bool rep = false;
    if (!SQLSyntax && use_highlight) {
        SQLSyntax = new sqlsyntax(scriptEdit);
    } else {
        rep = true;
    }
    if (!SQLSyntax) return;
    SQLSyntax->setDefaultFont(GlobalSettings.get_fixed_font());

    SQLSyntax->setStatementColor(GlobalSettings.getScriptColor(sqlsyntax::STATEMENT,QColor(255,0,0)));
    SQLSyntax->setKeyColor(GlobalSettings.getScriptColor(sqlsyntax::KEYWORD,QColor(0,200,0)));
    SQLSyntax->setCommentColor(GlobalSettings.getScriptColor(sqlsyntax::COMMENT,QColor(120,120,120)));
    SQLSyntax->setStringColor(GlobalSettings.getScriptColor(sqlsyntax::STRING,QColor(0,0,255)));
    SQLSyntax->setDatatypesColor(GlobalSettings.getScriptColor(sqlsyntax::DATATYPE,QColor(0,0,200)));

    SQLSyntax->real_parse(use_highlight);
    bool bold,it;
    bold = GlobalSettings.getScriptbold(sqlsyntax::STATEMENT,true);
    SQLSyntax->statementBold(bold);
    bold = GlobalSettings.getScriptbold(sqlsyntax::KEYWORD,false);
    SQLSyntax->keywordBold(bold);
    bold = GlobalSettings.getScriptbold(sqlsyntax::COMMENT,false);
    SQLSyntax->commentBold(bold);
    bold = GlobalSettings.getScriptbold(sqlsyntax::DATATYPE,false);
    SQLSyntax->datatypeBold(bold);
    bold = GlobalSettings.getScriptbold(sqlsyntax::STRING,false);
    SQLSyntax->stringBold(bold);

    it = GlobalSettings.getScriptit(sqlsyntax::STATEMENT,false);
    SQLSyntax->statementItalic(bold);
    it = GlobalSettings.getScriptit(sqlsyntax::KEYWORD,false);
    SQLSyntax->keywordItalic(it);
    it = GlobalSettings.getScriptit(sqlsyntax::COMMENT,false);
    SQLSyntax->commentItalic(it);
    it = GlobalSettings.getScriptit(sqlsyntax::DATATYPE,false);
    SQLSyntax->datatypeItalic(it);
    it = GlobalSettings.getScriptit(sqlsyntax::STRING,false);
    SQLSyntax->stringItalic(it);

    SQLSyntax->real_parse(use_highlight);
    if (rep) {
        SQLSyntax->rehighlight();
    }
#endif
}

void CSqlScript::slotOpen(const KURL&aURL)
{
    if (aURL.isLocalFile()) {
        if (!load_script(aURL.path())) {
            m_recentFiles->removeURL(aURL);
            save_state();
            new_script();
        }
    }
}

void CSqlScript::save_state()
{
    KConfig * k = KGlobal::config();
    m_recentFiles->saveEntries(k,"recent_scripts");
}
