// -*-Mode: C++;-*-
/*
 * TableDescriptor - Class
 * it will be used to wrap the sql-entries
 * into a class which can use with various forms of sql-server
 */

#ifndef table_descr_inc
#define table_descr_inc

#include "kmysqladmin/helpers/stringlist.h"
#include "kmysqladmin/helpers/pairs.h"

typedef std::vector<string_int_pair> pairIlist;

class CKeyDescriptor
{
public:
    enum Types {NONE,PRIMARY,UNIQUE,INDEX,FOREIGN};
private:
    std::string name;
    pairIlist ColumnsList;
    Types type;
    bool compound;
public:
    CKeyDescriptor(){type = NONE;compound = false;}
    CKeyDescriptor(const CKeyDescriptor&);
    virtual ~CKeyDescriptor(){};

    //compares name against a string
    const int operator == (const char*what)const;
    const int operator == (const std::string&what)const;
    const int operator == (const unsigned char*what)const;

    //compares against another descriptor
    const int operator == (const CKeyDescriptor&)const;
    CKeyDescriptor&operator= (const CKeyDescriptor&old);

    //required for some stl-implementations
    const int operator < (const CKeyDescriptor&)const;

    void set_name(const std::string&n_name){name = n_name;}
    const char*get_name()const{return name.c_str();}

    void setType(Types nType){type = nType;}
    Types getType()const{return type;}

    bool is_UniqueKey(){return (type==PRIMARY||type==UNIQUE);}

    int add_column_name(const std::string&column,const unsigned int size=0);
    void remove_column_name(const std::string&column);
    bool contains_column_name(const std::string&column);
    unsigned int column_size(const std::string&column);

    unsigned int column_count(){return ColumnsList.size();}

    const pairIlist& get_ColList()const{return ColumnsList;}
    const bool is_compound()const{return compound;}
    void set_compound(bool com = false){compound = com;}

};

inline const int CKeyDescriptor::operator ==(const std::string & what) const
{
    return Caseequ()(name,what);
}

inline const int CKeyDescriptor::operator ==(const char*what)const
{
    if (what==0) {
        if (name.size()==0) {
            return true;
        } else {
            return false;
        }
    }
    return Caseequ()(name,what);
}

inline const int CKeyDescriptor::operator < (const CKeyDescriptor&what)const
{
    return Casecmp()(name,what.name);
}

inline const int CKeyDescriptor::operator ==(const CKeyDescriptor&what)const
{
    return Caseequ()(name, what.name);
}

typedef std::vector<CKeyDescriptor> KeyList;
typedef KeyList::iterator KeyList_iterator;

class CColumnDescriptor
{
    std::string name;
    std::string Def;
    std::string table;

    int FieldType;
    int MaxLength;
    int MaxDecimals;

    bool AutoIncrement;
    bool PrimaryField;
    bool Binary;
    bool TimeStamp;
    bool ZeroFill;
    bool NotNull;
    bool Blob;
    bool Text;
    bool PartOfMultiple;
    bool Numeric;
    bool UniqueValue;
    bool Unsigned;
    bool Set;

    stringIlist Enums;

public:
    CColumnDescriptor();
    virtual ~CColumnDescriptor(){}
    CColumnDescriptor(const CColumnDescriptor&old);
    CColumnDescriptor&operator=(const CColumnDescriptor&old);

    void set_name(const std::string&Name){name=Name;}
    const std::string&get_name()const{return name;}

    void set_default(const std::string&def){Def = def;}
    const char*get_default(){return Def.c_str();}

    void set_table(const std::string&t){table=t;}
    const char*get_table(){return table.c_str();}

    void set_FieldType(int type){FieldType = type;}
    int get_FieldType(){return FieldType;}

    const stringIlist&enum_list(){return Enums;}
    void enum_list(const stringIlist&list){Enums = list;}
    void empty_enum_list(){Enums.resize(0);}
    void set_is_set(bool aSet){Set = aSet;}
    bool get_is_set()const{return Set;}

    bool contains_enum(std::string&what){return Enums.find(what)!=Enums.end();}
    void insert_enum(std::string&what){if (!contains_enum(what))Enums.push_back(what);}
    void remove_enum(const std::string&what);

    void set_Unsigned(bool how){Unsigned = how;}
    bool is_Unsigned(){return Unsigned;}
    bool is_AutoIncrement(){return AutoIncrement;}
    void set_AutoIncrement(bool how){AutoIncrement = how;}

    bool is_KeyField(){return (PrimaryField||UniqueValue||PartOfMultiple);}
    bool is_UniqueKey(){return (PrimaryField||UniqueValue);}

    bool is_Binary(){return Binary;}
    void set_Binary(bool how){Binary = how;}
    bool is_TimeStamp(){return TimeStamp;}
    void set_TimeStamp(bool how){TimeStamp = how;}
    bool is_ZeroFill(){return ZeroFill;}
    void set_ZeroFill(bool how){ZeroFill = how;}
    bool is_NotNull(){return NotNull;}
    void set_NotNull(bool how){NotNull = how;}
    bool is_Blob(){return Blob;}
    void set_Blob(bool how){Blob = how;}
    bool is_Text(){return Text;}
    void set_Text(bool how){Text = how;}

    bool is_PartOfMultiKey(){return PartOfMultiple;}
    void set_PartOfMultiKey(bool how){PartOfMultiple = how;}
    bool is_Numeric(){return Numeric;}
    void set_Numeric(bool how){Numeric = how;}

    bool is_Primary(){return PrimaryField;}
    void set_Primary(bool how){PrimaryField = how;}
    bool is_Unique(){return UniqueValue;}
    void set_Unique(bool how){UniqueValue = how;}

    int get_MaxLength(){return MaxLength;}
    void set_MaxLength(int Length){MaxLength = Length;}
    int get_MaxDecimals(){return MaxDecimals;}
    void set_MaxDecimals(int Dec){MaxDecimals = Dec;}

    //compares name against a string
    const int operator == (const char*what)const;
    const int operator == (const std::string&what)const;
    //compares against another descriptor
    const int operator == (const CColumnDescriptor&what)const;

    int operator != (const CColumnDescriptor&what){return !(*this==what);}

    //required for some stl-implementations
    const int operator < (const CColumnDescriptor&old)const{return name < old.name;}
protected:
    void copy_old(const CColumnDescriptor*old);
};

inline const int CColumnDescriptor::operator ==(const std::string&what)const
{
    return Caseequ()(name,what);
}

inline const int CColumnDescriptor::operator ==(const char*what)const
{
    return what?Caseequ()(name,what):0;
}

inline const int CColumnDescriptor::operator ==(const CColumnDescriptor&what)const
{

    return Caseequ()(name,what.name);
}

typedef std::vector<CColumnDescriptor> ColumnList;
typedef ColumnList::iterator ColumnList_iterator;

#endif
